/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.wizard;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class NewProcessDefinitionWizardPage
extends WizardPage {
    private Text containerText;
    private Text processText;
    private Button browseButton;
    private IWorkspaceRoot workspaceRoot;
    private String containerName;

    public NewProcessDefinitionWizardPage() {
        super("Process Definition");
        this.setTitle("Create Process Definition");
        this.setDescription("Create a new process definition");
        this.workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    }

    public void init(IStructuredSelection selection) {
        IContainer container = null;
        if (selection != null && !selection.isEmpty()) {
            Object object = selection.getFirstElement();
            if (IFile.class.isInstance(object) && !IContainer.class.isInstance(object)) {
                container = ((IFile)object).getParent();
            } else if (IContainer.class.isInstance(object)) {
                container = (IContainer)object;
            }
        }
        this.initContainerName(container);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = this.createClientArea(parent);
        this.createLabel(composite);
        this.createContainerField(composite);
        this.createProcessField(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        this.setPageComplete(false);
    }

    private void createLabel(Composite composite) {
        Label label = new Label(composite, 64);
        label.setText("Choose a source folder and a process definition name.");
        GridData gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
    }

    private Composite createClientArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        return composite;
    }

    private void createContainerField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Source folder : ");
        this.containerText = new Text(parent, 2048);
        this.containerText.setText(this.containerName);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewProcessDefinitionWizardPage.this.verifyContentsValid();
            }
        });
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.browseButton = new Button(parent, 8);
        this.browseButton.setText("Browse...");
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewProcessDefinitionWizardPage.this.chooseContainer();
            }
        });
        gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(15);
        this.browseButton.setLayoutData((Object)gd);
    }

    private void createProcessField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Process name : ");
        this.processText = new Text(parent, 2048);
        this.processText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewProcessDefinitionWizardPage.this.verifyContentsValid();
            }
        });
        GridData gd = new GridData(768);
        this.processText.setLayoutData((Object)gd);
    }

    private void chooseContainer() {
        WorkbenchContentProvider provider = new WorkbenchContentProvider();
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setTitle("Folder Selection");
        dialog.setMessage("Choose a folder");
        dialog.setInput((Object)ResourcesPlugin.getWorkspace());
        dialog.addFilter(this.createViewerFilter());
        dialog.open();
        this.initContainerName((IContainer)dialog.getFirstResult());
        this.containerText.setText(this.containerName);
    }

    private ViewerFilter createViewerFilter() {
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                return IFolder.class.isInstance(element) || IProject.class.isInstance(element);
            }
        };
        return filter;
    }

    private void initContainerName(IContainer elem) {
        this.containerName = elem == null ? "" : elem.getFullPath().makeRelative().toString();
    }

    private void verifyContentsValid() {
        if (!this.checkContainerPathValid()) {
            this.setErrorMessage("The folder does not exist.");
            this.setPageComplete(false);
        } else if (this.isProcessNameEmpty()) {
            this.setErrorMessage("Enter a name for the process.");
            this.setPageComplete(false);
        } else if (this.processExists()) {
            this.setErrorMessage("A process with this name already exists.");
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    private boolean processExists() {
        IPath path = new Path(this.containerText.getText()).append(this.getProcessName());
        return this.workspaceRoot.getFolder(path).exists();
    }

    private boolean isProcessNameEmpty() {
        String str = this.processText.getText();
        return str == null || "".equals(str);
    }

    private boolean checkContainerPathValid() {
        if ("".equals(this.containerText.getText())) {
            return false;
        }
        Path path = new Path(this.containerText.getText());
        return this.workspaceRoot.getFolder((IPath)path).exists();
    }

    private String getProcessName() {
        return this.processText.getText();
    }

    public IFolder getProcessFolder() {
        IPath path = new Path(this.containerText.getText()).append(this.getProcessName());
        return this.workspaceRoot.getFolder(path);
    }
}

