/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.xml;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.jbpm.gd.jpdl.model.Assignment;
import org.jbpm.gd.jpdl.model.Controller;
import org.jbpm.gd.jpdl.model.Description;
import org.jbpm.gd.jpdl.model.Event;
import org.jbpm.gd.jpdl.model.Reminder;
import org.jbpm.gd.jpdl.model.Task;
import org.jbpm.gd.jpdl.model.Timer;

public class TaskDomAdapter
extends XmlAdapter {
    private static final String[] CHILD_ELEMENTS = new String[]{"description", "assignment", "controller", "event", "timer", "reminder"};
    private static HashMap NODE_TYPES = null;

    protected String[] getChildElements() {
        return CHILD_ELEMENTS;
    }

    protected Map getNodeTypes() {
        if (NODE_TYPES == null) {
            NODE_TYPES = new HashMap();
            NODE_TYPES.put("description", "description");
            NODE_TYPES.put("assignment", "assignment");
            NODE_TYPES.put("controller", "controller");
            NODE_TYPES.put("event", "event");
            NODE_TYPES.put("timer", "timer");
            NODE_TYPES.put("reminder", "reminder");
        }
        return NODE_TYPES;
    }

    protected String getDefaultValue(String attributeName) {
        if ("blocking".equals(attributeName)) {
            return "false";
        }
        if ("signalling".equals(attributeName)) {
            return "true";
        }
        if ("notify".equals(attributeName)) {
            return "false";
        }
        if ("priority".equals(attributeName)) {
            return "normal";
        }
        return super.getDefaultValue(attributeName);
    }

    protected void initialize() {
        super.initialize();
        Task task = (Task)this.getSemanticElement();
        if (task != null) {
            Map properties = task.getProperties();
            for (String key : properties.keySet()) {
                this.setAttribute(key, (String)properties.get(key));
            }
            this.setAttribute("name", task.getName());
            this.setAttribute("blocking", task.getBlocking());
            this.setAttribute("signalling", task.getSignalling());
            this.setAttribute("duedate", task.getDueDate());
            this.setAttribute("swimlane", task.getSwimlane());
            this.setAttribute("priority", task.getPriority());
            this.setAttribute("notify", task.getNotify());
            this.addElement(task.getDescription());
            this.addElement(task.getAssignment());
            this.addElement(task.getController());
            this.addElements(task.getEvents());
            this.addElements(task.getTimers());
            this.addElement(task.getReminder());
        }
    }

    public void initialize(SemanticElement jpdlElement) {
        super.initialize(jpdlElement);
        Task task = (Task)jpdlElement;
        task.addPropertyChangeListener(this);
        Map map = this.getAttributes();
        for (String next : map.keySet()) {
            if ("name".equals(next)) {
                task.setName(this.getAttribute("name"));
            } else if ("blocking".equals(next)) {
                task.setBlocking(this.getAttribute("blocking"));
            } else if ("signalling".equals(next)) {
                task.setSignalling(this.getAttribute("signalling"));
            } else if ("duedate".equals(next)) {
                task.setDueDate(this.getAttribute("duedate"));
            } else if ("swimlane".equals(next)) {
                task.setSwimlane(this.getAttribute("swimlane"));
            } else if ("priority".equals(next)) {
                task.setPriority(this.getAttribute("priority"));
            } else if ("notify".equals(next)) {
                task.setNotify(this.getAttribute("notify"));
            }
            task.setProperty(next, (String)map.get(next));
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("assignment".equals(evt.getPropertyName())) {
            this.setElement("assignment", (SemanticElement)evt.getOldValue(), (SemanticElement)evt.getNewValue());
        } else if ("controller".equals(evt.getPropertyName())) {
            this.setElement("controller", (SemanticElement)evt.getOldValue(), (SemanticElement)evt.getNewValue());
        } else if ("description".equals(evt.getPropertyName())) {
            this.setElement("description", (SemanticElement)evt.getOldValue(), (Description)evt.getNewValue());
        } else if ("eventAdd".equals(evt.getPropertyName())) {
            this.addElement((Event)evt.getNewValue());
        } else if ("eventRemove".equals(evt.getPropertyName())) {
            this.removeElement((Event)evt.getOldValue());
        } else if ("timerAdd".equals(evt.getPropertyName())) {
            this.addElement((Timer)evt.getNewValue());
        } else if ("timerRemove".equals(evt.getPropertyName())) {
            this.removeElement((Timer)evt.getOldValue());
        } else if ("reminder".equals(evt.getPropertyName())) {
            this.setElement("reminder", (SemanticElement)evt.getOldValue(), (SemanticElement)evt.getNewValue());
        } else if ("name".equals(evt.getPropertyName())) {
            this.setAttribute("name", (String)evt.getNewValue());
        } else if ("blocking".equals(evt.getPropertyName())) {
            this.setAttribute("blocking", (String)evt.getNewValue());
        } else if ("signalling".equals(evt.getPropertyName())) {
            this.setAttribute("signalling", (String)evt.getNewValue());
        } else if ("notify".equals(evt.getPropertyName())) {
            this.setAttribute("notify", (String)evt.getNewValue());
        } else if ("duedate".equals(evt.getPropertyName())) {
            this.setAttribute("duedate", (String)evt.getNewValue());
        } else if ("swimlane".equals(evt.getPropertyName())) {
            this.setAttribute("swimlane", (String)evt.getNewValue());
        } else if ("priority".equals(evt.getPropertyName())) {
            this.setAttribute("priority", (String)evt.getNewValue());
        } else if ("custom".equals(evt.getPropertyName())) {
            String name = ((String[])evt.getNewValue())[0];
            String newValue = ((String[])evt.getNewValue())[1];
            this.setAttribute(name, newValue);
        }
    }

    protected void doModelUpdate(String name, String newValue) {
        Task task = (Task)this.getSemanticElement();
        if ("name".equals(name)) {
            task.setName(newValue);
        } else if ("blocking".equals(name)) {
            task.setBlocking(newValue);
        } else if ("signalling".equals(name)) {
            task.setSignalling(newValue);
        } else if ("notify".equals(name)) {
            task.setNotify(newValue);
        } else if ("duedate".equals(name)) {
            task.setDueDate(newValue);
        } else if ("swimlane".equals(name)) {
            task.setSwimlane(newValue);
        } else if ("priority".equals(name)) {
            task.setPriority(newValue);
        }
    }

    protected void doModelAdd(XmlAdapter child) {
        String type = child.getElementType();
        SemanticElement jpdlElement = this.createSemanticElementFor(child);
        child.initialize(jpdlElement);
        Task task = (Task)this.getSemanticElement();
        if ("assignment".equals(type)) {
            task.setAssignment((Assignment)jpdlElement);
        } else if ("controller".equals(type)) {
            task.setController((Controller)jpdlElement);
        } else if ("event".equals(type)) {
            task.addEvent((Event)jpdlElement);
        } else if ("timer".equals(type)) {
            task.addTimer((Timer)jpdlElement);
        } else if ("description".equals(type)) {
            task.setDescription((Description)jpdlElement);
        } else if ("reminder".equals(type)) {
            task.setReminder((Reminder)jpdlElement);
        }
    }

    protected void doModelRemove(XmlAdapter child) {
        String type = child.getElementType();
        Task task = (Task)this.getSemanticElement();
        if ("assignment".equals(type)) {
            task.setAssignment(null);
        } else if ("controller".equals(type)) {
            task.setController(null);
        } else if ("event".equals(type)) {
            task.removeEvent((Event)child.getSemanticElement());
        } else if ("timer".equals(type)) {
            task.removeTimer((Timer)child.getSemanticElement());
        } else if ("description".equals(type)) {
            task.setDescription(null);
        } else if ("reminder".equals(type)) {
            task.setReminder(null);
        }
    }
}

