/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.pf.wizard;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.jbpm.gd.pf.wizard.NewPageFlowWizardPage;

public class NewPageFlowWizard
extends Wizard
implements INewWizard {
    private IStructuredSelection selection;
    private NewPageFlowWizardPage page;

    public NewPageFlowWizard() {
        this.setWindowTitle("New Page Flow");
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.selection = currentSelection;
    }

    public void addPages() {
        this.page = new NewPageFlowWizardPage();
        this.addPage((IWizardPage)this.page);
        this.page.init(this.selection);
    }

    public boolean performFinish() {
        try {
            IContainer folder = this.page.getProcessFolder();
            IFile pageFlowFile = this.page.getPageFlowFile();
            pageFlowFile.create((InputStream)this.createInitialPageFlow(), true, null);
            IFile gpdFile = folder.getFile((IPath)new Path(".gpd." + pageFlowFile.getName()));
            gpdFile.create((InputStream)this.createInitialGpdInfo(), true, null);
            IDE.openEditor((IWorkbenchPage)this.getActivePage(), (IFile)pageFlowFile);
            BasicNewResourceWizard.selectAndReveal((IResource)pageFlowFile, (IWorkbenchWindow)this.getActiveWorkbenchWindow());
            return true;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    private IWorkbenchPage getActivePage() {
        return this.getActiveWorkbenchWindow().getActivePage();
    }

    private IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    private ByteArrayInputStream createInitialPageFlow() throws JavaModelException {
        String name = this.page.getPageFlowFile().getName();
        int index = name.lastIndexOf(".xml");
        name = name.substring(0, index);
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buffer.append("\n");
        buffer.append("\n");
        buffer.append("<pageflow-definition\n  name=\"" + name + "\">\n" + "</pageflow-definition>");
        return new ByteArrayInputStream(buffer.toString().getBytes());
    }

    private ByteArrayInputStream createInitialGpdInfo() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buffer.append("\n");
        buffer.append("\n");
        buffer.append("<root-container />");
        return new ByteArrayInputStream(buffer.toString().getBytes());
    }
}

