/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.config.JacORBConfiguration;
import org.jacorb.config.LogKitLoggerFactory;
import org.jacorb.config.LoggerFactory;
import org.jacorb.util.ObjectUtil;

public class LogUtil {
    private static final LoggerFactory sLoggerFactory = LogUtil.newLoggerFactory();

    private static LoggerFactory newLoggerFactory() {
        try {
            org.jacorb.config.Configuration configuration = JacORBConfiguration.getConfiguration(new Properties(), null, false);
            LoggerFactory loggerFactory = LogUtil.newLog4jLoggerFactory(configuration);
            if (loggerFactory == null) {
                loggerFactory = LogUtil.newLogKitFactory(configuration);
            }
            if (loggerFactory == null) {
                throw new RuntimeException();
            }
            return loggerFactory;
        }
        catch (ConfigurationException configurationException) {
            throw new RuntimeException("unable to create LoggerFactory for class " + LogUtil.class.getName());
        }
    }

    private static LoggerFactory newLog4jLoggerFactory(org.jacorb.config.Configuration configuration) {
        String string = "org.jboss.util.Log4jLoggerFactory";
        try {
            ObjectUtil.classForName("org.apache.log4j.Level");
            Class clazz = ObjectUtil.classForName(string);
            Constructor constructor = clazz.getConstructor(new Class[0]);
            LoggerFactory loggerFactory = (LoggerFactory)constructor.newInstance(new Object[0]);
            loggerFactory.configure(configuration);
            return loggerFactory;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
        catch (ConfigurationException configurationException) {
            return null;
        }
    }

    private static LoggerFactory newLogKitFactory(org.jacorb.config.Configuration configuration) {
        try {
            LogKitLoggerFactory logKitLoggerFactory = new LogKitLoggerFactory();
            logKitLoggerFactory.configure(configuration);
            return logKitLoggerFactory;
        }
        catch (ConfigurationException configurationException) {
            throw new RuntimeException();
        }
    }

    public static Logger getLogger(Configuration configuration, String string) {
        try {
            return ((org.jacorb.config.Configuration)configuration).getNamedLogger(string);
        }
        catch (ClassCastException classCastException) {
            return LogUtil.getLogger(string);
        }
    }

    public static Logger getLogger(String string) {
        return sLoggerFactory.getNamedLogger(string);
    }
}

