/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.util.ResourceManager;

public final class IoUtil {
    private static final String PACKAGE_NAME = "org.java.plugin.util";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        if (!file.isFile()) {
            throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "notAFile", file));
        }
        if (file2.isDirectory()) {
            throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "isFolder", file2));
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2, false));
            try {
                IoUtil.copyStream(bufferedInputStream, bufferedOutputStream, 1024);
            }
            finally {
                bufferedOutputStream.close();
            }
        }
        finally {
            bufferedInputStream.close();
        }
        file2.setLastModified(file.lastModified());
    }

    public static void copyFolder(File file, File file2) throws IOException {
        IoUtil.copyFolder(file, file2, true, false, null);
    }

    public static void copyFolder(File file, File file2, boolean bl) throws IOException {
        IoUtil.copyFolder(file, file2, bl, false, null);
    }

    public static void copyFolder(File file, File file2, boolean bl, boolean bl2) throws IOException {
        IoUtil.copyFolder(file, file2, bl, bl2, null);
    }

    public static void copyFolder(File file, File file2, boolean bl, boolean bl2, FileFilter fileFilter) throws IOException {
        if (!file.isDirectory()) {
            throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "notAFolder", file));
        }
        if (file2.isFile()) {
            throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "isFile", file2));
        }
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "cantMakeFolder", file2));
        }
        File[] fileArray = fileFilter != null ? file.listFiles(fileFilter) : file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file3 = fileArray[i];
            if (file3.isDirectory()) {
                if (!bl) continue;
                IoUtil.copyFolder(file3, new File(file2, file3.getName()), bl, bl2, fileFilter);
                continue;
            }
            File file4 = new File(file2, file3.getName());
            if (bl2 && file4.isFile() && file4.lastModified() > file3.lastModified()) continue;
            IoUtil.copyFile(file3, file4);
        }
        file2.setLastModified(file.lastModified());
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
        }
    }

    public static boolean emptyFolder(File file) {
        if (!file.isDirectory()) {
            return true;
        }
        File[] fileArray = file.listFiles();
        boolean bl = true;
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                if (IoUtil.emptyFolder(file2)) {
                    bl &= file2.delete();
                    continue;
                }
                bl = false;
                continue;
            }
            bl &= file2.delete();
        }
        return bl;
    }

    public static boolean compareFiles(File file, File file2) {
        if (!file.isFile() || !file2.isFile()) {
            return false;
        }
        if (!file.getName().equals(file2.getName())) {
            return false;
        }
        if (file.length() != file2.length()) {
            return false;
        }
        return IoUtil.compareFileDates(new Date(file.lastModified()), new Date(file2.lastModified()));
    }

    public static boolean compareFileDates(Date date, Date date2) {
        if (date == null || date2 == null) {
            return false;
        }
        Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
        calendar.setTime(date);
        calendar.set(14, 0);
        long l = calendar.getTimeInMillis();
        calendar.setTime(date2);
        calendar.set(14, 0);
        long l2 = calendar.getTimeInMillis();
        return l == l2;
    }

    public static void synchronizeFolders(File file, File file2) throws IOException {
        IoUtil.synchronizeFolders(file, file2, null);
    }

    public static void synchronizeFolders(File file, File file2, FileFilter fileFilter) throws IOException {
        File[] fileArray;
        if (!file.isDirectory()) {
            throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "notAFolder", file));
        }
        if (file2.isFile()) {
            throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "isFile", file2));
        }
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "cantMakeFolder", file2));
        }
        for (File file3 : fileArray = fileFilter != null ? file.listFiles(fileFilter) : file.listFiles()) {
            File file4 = new File(file2, file3.getName());
            if (file3.isDirectory()) {
                if (file4.isFile() && !file4.delete()) {
                    throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "cantDeleteFile", file4));
                }
                IoUtil.synchronizeFolders(file3, file4, fileFilter);
                continue;
            }
            if (IoUtil.compareFiles(file3, file4)) continue;
            IoUtil.copyFile(file3, file4);
        }
        File[] fileArray2 = file2.listFiles();
        for (int i = 0; i < fileArray2.length; ++i) {
            File file3;
            File file5 = fileArray2[i];
            file3 = new File(file, file5.getName());
            if (fileFilter != null && fileFilter.accept(file5) && file3.exists() || fileFilter == null && file3.exists()) continue;
            if (file5.isDirectory() && !IoUtil.emptyFolder(file5)) {
                throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "cantEmptyFolder", file5));
            }
            if (file5.delete()) continue;
            throw new IOException(ResourceManager.getMessage(PACKAGE_NAME, "cantDeleteFile", file5));
        }
        file2.setLastModified(file.lastModified());
    }

    public static boolean isResourceExists(URL uRL) {
        File file = IoUtil.url2file(uRL);
        if (file != null) {
            return file.canRead();
        }
        if ("jar".equalsIgnoreCase(uRL.getProtocol())) {
            return IoUtil.isJarResourceExists(uRL);
        }
        return IoUtil.isUrlResourceExists(uRL);
    }

    private static boolean isUrlResourceExists(URL uRL) {
        try {
            InputStream inputStream = uRL.openStream();
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isJarResourceExists(URL uRL) {
        boolean bl;
        String string = uRL.toExternalForm();
        int n = string.indexOf("!/");
        if (n == -1) {
            return false;
        }
        URL uRL2 = new URL(string.substring(4, n));
        File file = IoUtil.url2file(uRL2);
        if (file == null) {
            return IoUtil.isUrlResourceExists(uRL);
        }
        if (!file.canRead()) {
            return false;
        }
        if (n == string.length() - 2) {
            return true;
        }
        JarFile jarFile = new JarFile(file);
        try {
            bl = jarFile.getEntry(string.substring(n + 2)) != null;
        }
        catch (Throwable throwable) {
            try {
                jarFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        jarFile.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getResourceInputStream(URL uRL) throws IOException {
        File file = IoUtil.url2file(uRL);
        if (file != null) {
            return new BufferedInputStream(new FileInputStream(file));
        }
        if (!"jar".equalsIgnoreCase(uRL.getProtocol())) {
            return uRL.openStream();
        }
        String string = uRL.toExternalForm();
        if (string.endsWith("!/")) {
            throw new FileNotFoundException(uRL.toExternalForm());
        }
        int n = string.indexOf("!/");
        if (n == -1) {
            throw new MalformedURLException(uRL.toExternalForm());
        }
        String string2 = string.substring(n + 2);
        file = IoUtil.url2file(new URL(string.substring(4, n)));
        if (file == null) {
            return uRL.openStream();
        }
        JarFile jarFile = new JarFile(file);
        try {
            ByteArrayInputStream byteArrayInputStream;
            ZipEntry zipEntry = jarFile.getEntry(string2);
            if (zipEntry == null) {
                throw new FileNotFoundException(uRL.toExternalForm());
            }
            InputStream inputStream = jarFile.getInputStream(zipEntry);
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                IoUtil.copyStream(inputStream, byteArrayOutputStream, 1024);
                byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            }
            catch (Throwable throwable) {
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return byteArrayInputStream;
        }
        finally {
            jarFile.close();
        }
    }

    public static File url2file(URL uRL) {
        String string = uRL.getProtocol();
        if ("jar".equalsIgnoreCase(string)) {
            if (uRL.getFile().endsWith("!/")) {
                String string2 = uRL.toExternalForm();
                try {
                    return IoUtil.url2file(new URL(string2.substring(4, string2.length() - 2)));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return null;
        }
        if (!"file".equalsIgnoreCase(string)) {
            return null;
        }
        try {
            return new File(uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            LogFactory.getLog(IoUtil.class).warn((Object)("failed converting URL to a file " + uRL), (Throwable)uRISyntaxException);
            return null;
        }
    }

    public static URL file2url(File file) throws MalformedURLException {
        try {
            return file.getCanonicalFile().toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw malformedURLException;
        }
        catch (IOException iOException) {
            throw new MalformedURLException(ResourceManager.getMessage(PACKAGE_NAME, "file2urlFailed", new Object[]{file, iOException}));
        }
    }

    private IoUtil() {
    }
}

