package com.tandbergtv.neptune.ui.framework.client;

import java.util.List;
import java.util.Map;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Value object that contains the map which has all the server info that needs
 * to be passed to all components and any error messages got from any providers
 * in that process.
 * 
 * @author spuranik
 * 
 */
public class ServerInfo implements IsSerializable {

	private Map<String, String> infoMap;
	private List<String> errorMsgs;

	public ServerInfo() {
	}

	public ServerInfo(Map<String, String> info, List<String> errorMsgs) {
		super();
		this.infoMap = info;
		this.errorMsgs = errorMsgs;
	}

	/**
	 * @return the info
	 */
	public Map<String, String> getInfoMap() {
		return infoMap;
	}

	/**
	 * @param info
	 *            the info to set
	 */
	public void setInfoMap(Map<String, String> info) {
		this.infoMap = info;
	}

	/**
	 * @return the errorMsgs
	 */
	public List<String> getErrorMsgs() {
		return errorMsgs;
	}

	/**
	 * @param errorMsgs
	 *            the errorMsgs to set
	 */
	public void setErrorMsgs(List<String> errorMsgs) {
		this.errorMsgs = errorMsgs;
	}
}
