package com.tandbergtv.neptune.ui.framework.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.jboss.web.tomcat.security.login.WebAuthentication;

import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.neptune.ui.framework.client.Credentials;
import com.tandbergtv.neptune.ui.framework.client.LoginUiService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.security.AuthenticationException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;

public class LoginUiServiceImpl implements LoginUiService,
		NeptuneRemoteService, Constants {
	private static final long serialVersionUID = 1L;
	Logger logger = Logger.getLogger(LoginUiServiceImpl.class); 
	private IAuthorizationService authorizationService = InjectionUtil
			.injectInstance("cms/AuthorizationService/local",
					IAuthorizationService.class);

	private HttpSession httpSession;

	public void setHttpSession(HttpSession httpSession) {
		this.httpSession = httpSession;
	}

	@Override
	public String getRelativePath() {
		return "service/loginService";
	}

	@Override
	public Class<?> getServiceImplementation() {
		return getClass();
	}

	private List<String> getRoles() throws NeptuneException {
		if (getWebAuthentication() == null)
			throw new AuthenticationException();
		List<String> roles = new ArrayList<String>();
		roles.addAll(authorizationService.getAuthorizedRoles());
		return roles;
	}

	private WebAuthentication getWebAuthentication() {
		return (WebAuthentication) httpSession
				.getAttribute(Constants.WEB_AUTHENTICATION);
	}

	private void setWebAuthentication(WebAuthentication webAuthentication) {
		httpSession.setAttribute(Constants.WEB_AUTHENTICATION,
				webAuthentication);
	}
	
	private void setUsername(String username) {
		httpSession.setAttribute(Constants.USERNAME, username);
	}

	public List<String> login(String username, String password)
			throws NeptuneException {
		invalidateHttpSession();
		WebAuthentication webAuthentication = new WebAuthentication();
		if (!webAuthentication.login(username, password)) {
			logger.warn("Login failed for " + username + ", on " + new Date());
			throw new AuthenticationException();
		}
		setWebAuthentication(webAuthentication);
		//set the username to the session, so it's known at the time of logout
		setUsername(username);
		logger.info("Successful login for " + username + ", on " + new Date());
		return getRoles();
	}

	private void invalidateHttpSession() {
		// on logout just invalidate the session so that WebAuthentication
		// performs the actual logout from the system, this is the best approach
		// since the same exact code path will be taken on session timeout
		if (getWebAuthentication() != null) {
			//			
			// removeWebAuthentication().logout();
			httpSession.invalidate();			
		}		
	}
	public void logout() {
		String username = (String) httpSession.getAttribute(Constants.USERNAME);
		invalidateHttpSession();
		if (username != null)
			logger.info("Successful logout for " + username + ", on " + new Date());
		else 
			logger.info("User has already been logged out.");
	}

	@Override
	public Credentials getCredentials() throws NeptuneException {
		if (getWebAuthentication() == null)
			throw new AuthenticationException();
		List<String> roles = new ArrayList<String>();
		roles.addAll(authorizationService.getAuthorizedRoles());
		String username = authorizationService.getUserName();
		return new Credentials(username, roles);
	}
}
