package com.tandbergtv.neptune.ui.home.client;

import java.util.List;

import com.google.gwt.user.client.ui.Composite;
import com.gwtext.client.widgets.layout.ColumnLayoutData;
import com.gwtext.client.widgets.portal.Portal;
import com.gwtext.client.widgets.portal.PortalColumn;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

public class HomeTabPanel extends Composite {
	private final SimpleContainer mainContainer;
	private final List<PortletFactory> portletFactories;
	private Portal portal;
	private PortalColumn col1;
	private PortalColumn col2;

	private int i = 0;

	public HomeTabPanel(NeptuneSecurity neptuneSecurity, List<PortletFactory> portletFactories) {
		mainContainer = new SimpleContainer();
		this.portletFactories = portletFactories;
		portal = createPortal();
		portal.setSize("100%", "100%");

		mainContainer.setWidget(portal);
		mainContainer.getElement().setId("portalMainContainerPanel");
		portal.doLayout();
		
		initWidget(mainContainer);
	}

	private Portal createPortal() {
		Portal portal = new MyPortal();

		portal.setBorder(true);

		ColumnLayoutData layoutData = new ColumnLayoutData(.5);
		col1 = createColumn();
		col2 = createColumn();

		portal.add(col1, layoutData);
		portal.add(col2, layoutData);

		for (PortletFactory portletFactory : portletFactories)
			addPortlet(portletFactory);
				
		return portal;
	}

	private void addPortlet(PortletFactory portletFactory) {
		Portlet portlet = portletFactory.getInstance();
		getColumn(i++).add(portlet);
	}

	private PortalColumn getColumn(int i) {
		switch (i % 2) {
			case 0:
				return col1;
			case 1:
				return col2;
			default:
				return col1;
		}
	}

	private PortalColumn createColumn() {
		PortalColumn col = new PortalColumn();
		col.setSize("100%", "100%");
		col.setPaddings(10, 10, 0, 10);
		return col;
	}

	private class MyPortal extends Portal {
		@Override
		protected void onAttach() {
			doLayout();
			super.onAttach();
		}
	}
}
