/**
 * 
 */
package com.tandbergtv.neptune.ui.realm.client.tab.role;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;

final class ModulePanel extends Composite {
	private Grid grid;
	private final Map<Long, CheckBoxWidget> map;

	public ModulePanel(List<UiModule> model) {
		map = new HashMap<Long, CheckBoxWidget>();
		
		//find maximum permissions count across all modules
		int maxPermissionsCount = 0;
		for(UiModule module : model) {
			int permissionsCount = module.getPermissions().size();
			if(permissionsCount > maxPermissionsCount)
				maxPermissionsCount = permissionsCount;
		}
		
		grid = new Grid(model.size(), maxPermissionsCount + 1);

		int rowCount = 0;
		for (UiModule module : model) {
			//add module name cell
			grid.setWidget(rowCount, 0, new LabelWidget(module.getDisplayName() + ":"));
			
			//add cells for permissions
			int columnCount = 1;
			for (UiPermission permission : module.getPermissions()) {
				CheckBoxWidget checkBox = new CheckBoxWidget(permission.getDisplayName(), false);
				grid.setWidget(rowCount, columnCount, checkBox);
				map.put(permission.getId(), checkBox);
				columnCount++;
			}
			
			rowCount++;
		}
		
		initWidget(grid);
	}

	public void setData(Collection<Long> data) {
		// reset to false
		for (CheckBoxWidget checkBox : map.values())
			checkBox.setValue(false);

		// set the checked ones
		for (Long permissionId : data)
			map.get(permissionId).setValue(true);
	}

	public Collection<Long> getData() {
		Collection<Long> checked = new ArrayList<Long>();
		for (Long key : map.keySet())
			if (map.get(key).getValue())
				checked.add(key);
		return checked;
	}

	final class PermissionPanel extends HorizontalPanel {
		private Map<Long, CheckBox> idToCheckBox;

		public PermissionPanel(UiModule module) {
			super.setSpacing(3);
		}

		public Map<Long, CheckBox> getIdToCheckBoxMap() {
			return idToCheckBox;
		}
	}
}
