/*
 * Created on Sep 15, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.ui.realm.client.tab.role;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;

/**
 * Anchor change listener for the role menu item
 */
class RoleMenuAnchorChangeListener implements AnchorChangeListener {

	private final RoleTableProvider tableProvider;
	
	/**
     * Constructor 
     */
    public RoleMenuAnchorChangeListener(RoleTableProvider tableProvider) {
	    this.tableProvider = tableProvider;
    }
	
	@Override
	public void anchorChanged(final String anchor) {
		tableProvider.getTable().initialize(new AsyncCallback<Void>() {
			@Override
			public void onFailure(Throwable caught) {
				Window.alert(caught.getLocalizedMessage());
			}

			@Override
			public void onSuccess(Void result) {
				handleAnchorChange(anchor);
			}
		});
	}

	private void handleAnchorChange(String anchor) {
		tableProvider.getTable().setAnchor(anchor);
	}
}
