/*
 * Created on Jan 25, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.ui.realm.client.tab.role;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Stores a Role Key
 * @author Vijay Silva
 */
public class UiRoleKey implements IsSerializable {

	private static final String ENTRY_SEPARATOR = ":::";

	private Long id;
	private String externalKey;

	/**
	 * Default Constructor
	 */
	public UiRoleKey() {
	}

	/**
	 * Constructs a UiUserKey with the given ID and external key
	 * 
	 * @param id The role ID
	 * @param externalKey The external key
	 */
	public UiRoleKey(Long id, String externalKey) {
		this.id = id;
		this.externalKey = externalKey;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getExternalKey() {
		return externalKey;
	}

	public void setExternalKey(String externalKey) {
		this.externalKey = externalKey;
	}

	public boolean isValueAssigned() {
		return (externalKey != null || id != null);
	}

	/*
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		int result = 0;
		if (externalKey != null) {
			result = externalKey.hashCode() + 17;
		} else if (id != null) {
			result = id.hashCode() + 19;
		} else {
			result = super.hashCode();
		}

		return result;
	}

	/*
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (!(obj instanceof UiRoleKey))
			return false;

		UiRoleKey other = (UiRoleKey) obj;
		if (externalKey != null) {
			/* check if both external keys are equal and not null */
			return externalKey.equals(other.externalKey);
		} else if (other.externalKey != null) {
			/* external keys are not equal */
			return false;
		} else if (id != null) {
			/* external keys are both null, compare IDs */
			return id.equals(other.id);
		} else if (other.id != null) {
			/* external keys and both null, but IDs are not equal */
			return false;
		} else {
			/* external keys and IDs are all null */
			return super.equals(obj);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder value = new StringBuilder();

		if (this.id != null) {
			value.append(id.toString());
		}
		value.append(ENTRY_SEPARATOR);

		if (this.externalKey != null)
			value.append(externalKey);

		return value.toString();
	}

	/**
	 * Parse the string generated from the toString() method of UiUserKey to a UiUserKey object.
	 * 
	 * @param roleKey String representation of a UiUserKey
	 * @return The UiUserKey object parsed from the string
	 */
	public static UiRoleKey parse(String roleKey) {
		UiRoleKey result = new UiRoleKey();

		if (roleKey == null)
			throw new RuntimeException("Cannot parse null string to UiUserKey.");

		String[] entries = roleKey.split(ENTRY_SEPARATOR, 2);
		if (entries.length != 2) {
			throw new RuntimeException("Cannot parse string to UiUserKey: " + roleKey);
		}
		String idValue = entries[0].trim();
		String externalKeyValue = entries[1].trim();

		if (idValue.length() > 0)
			result.id = Long.parseLong(idValue);

		if (externalKeyValue.length() > 0)
			result.externalKey = externalKeyValue;

		return result;
	}
}
