package com.tandbergtv.neptune.ui.realm.client.tab.user;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.tandbergtv.neptune.ui.realm.client.i18n.RealmConstants;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;

class UserMenuAnchorChangeListener implements AnchorChangeListener {
	
	private final UserTableProvider tableProvider;
	private static final String USER_NAME_ANCHOR = "Edit?userName=";
	private final UserUiServiceAsync userService = GWT.create(UserUiService.class);
	private RealmConstants constants = GWT.create(RealmConstants.class);
	
	public UserMenuAnchorChangeListener(UserTableProvider tableProvider) {
		this.tableProvider = tableProvider;
	}

	@Override
	public void anchorChanged(final String anchor) {
		Table<UiUserKey, UserRecord> table = tableProvider.getTable();
		
		/* Ensure that the table is initialized before making calls to the table */
		table.initialize(new NeptuneAsyncCallback<Void>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				Window.alert(caught.getLocalizedMessage());
			}

			@Override
			public void onNeptuneSuccess(Void result) {
				handleAnchorChange(anchor);
			}
		});
	}
	
	private void handleAnchorChange(String anchor) {
		/* Check for anchor with user name */
		if (anchor != null && anchor.startsWith(USER_NAME_ANCHOR)) {
			tableProvider.getTable().reset();
			final String userName = anchor.substring(USER_NAME_ANCHOR.length());
			userService.getUser(userName, new NeptuneAsyncCallback<UiUser>() {
				public void onNeptuneFailure(Throwable caught) {
					if (caught instanceof UserNotFoundException)
						Window.alert(constants.userNotFoundForUserName() + userName);
					else
						Window.alert(caught.getLocalizedMessage());
				}

				public void onNeptuneSuccess(UiUser result) {
					tableProvider.getTable().showDetailView(new UserRecord(result));
				}
			});
		} else {
			tableProvider.getTable().setAnchor(anchor);
		}
	}
}
