/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.neptune.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.workflow.neptune.client.IWOStatus;
import com.tandbergtv.workflow.neptune.client.IWOStatusAsync;
import com.tandbergtv.workflow.neptune.client.PortletConstants;
import com.tandbergtv.workflow.neptune.client.WOState;
import java.util.Map;
import java.util.TreeMap;

public class WOStatusPortlet
extends Portlet {
    private NeptuneSecurity security;
    private FlexTableContainer table;
    private IWOStatusAsync service;
    private PortletConstants constants;

    public WOStatusPortlet(NeptuneSecurity security, int refreshTimeMillis) {
        this.security = security;
        this.service = (IWOStatusAsync)GWT.create(IWOStatus.class);
        this.constants = (PortletConstants)GWT.create(PortletConstants.class);
        this.setTitle(this.constants.woTitle());
        this.table = new FlexTableContainer();
        this.table.setStyleName("portlet-woStatus-table");
        this.add((Widget)this.table);
        new Timer(){

            public void run() {
                WOStatusPortlet.this.reload();
            }
        }.scheduleRepeating(refreshTimeMillis);
    }

    public void reload() {
        this.service.getStatus((AsyncCallback<Map<WOState, Integer>>)new NeptuneAsyncCallback<Map<WOState, Integer>>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(Map<WOState, Integer> result) {
                WOStatusPortlet.this.table.clear();
                int rowCount = 0;
                TreeMap<WOState, Integer> sorted = new TreeMap<WOState, Integer>(result);
                for (Map.Entry statusEntry : sorted.entrySet()) {
                    WOStatusPortlet.this.table.setWidget(rowCount, 0, (Widget)WOStatusPortlet.this.getImage((WOState)((Object)statusEntry.getKey())));
                    WOStatusPortlet.this.table.getCellFormatter().setStyleName(rowCount, 0, "portlet-woStatus-imgCol");
                    if (WOStatusPortlet.this.security.isUserInRole("WorkOrderManagement_View")) {
                        WOStatusPortlet.this.table.setWidget(rowCount, 1, (Widget)new HyperlinkWidget(WOStatusPortlet.this.getLocalizedStateName((WOState)((Object)statusEntry.getKey())), "Work Orders.Search.Status=" + statusEntry.getKey()));
                    } else {
                        WOStatusPortlet.this.table.setWidget(rowCount, 1, (Widget)new LabelWidget(WOStatusPortlet.this.getLocalizedStateName((WOState)((Object)statusEntry.getKey()))));
                    }
                    WOStatusPortlet.this.table.getCellFormatter().setStyleName(rowCount, 1, "portlet-woStatus-nameCol");
                    WOStatusPortlet.this.table.setWidget(rowCount, 2, (Widget)new LabelWidget(String.valueOf(statusEntry.getValue())));
                    WOStatusPortlet.this.table.getCellFormatter().setStyleName(rowCount, 2, "portlet-woStatus-countCol");
                    ++rowCount;
                }
            }
        });
    }

    private ImageWidget getImage(WOState state) {
        ImageWidget image = new ImageWidget("images/icon_rect_" + state.name() + ".gif");
        image.setTitle(this.getLocalizedStateName(state));
        return image;
    }

    private String getLocalizedStateName(WOState state) {
        return this.constants.getString("wo" + state.name());
    }
}

