/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.neptune.server;

import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.security.InsufficientRolesException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.neptune.client.IListResourceGroupQueues;
import com.tandbergtv.workflow.neptune.client.Queue;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroupQueue;
import java.util.ArrayList;
import java.util.List;

public class ListResourceGroupQueuesImpl
implements IListResourceGroupQueues,
NeptuneRemoteService {
    private IAuthorizationService authService = (IAuthorizationService)InjectionUtil.injectInstance((String)"cms/AuthorizationService/local", IAuthorizationService.class);

    public String getRelativePath() {
        return "service/watchpoint/IListResourceGroupQueues";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    private void verifyAuthority() throws InsufficientRolesException {
        if (!this.authService.isAuthorized("Home", "Dashboard")) {
            throw new InsufficientRolesException();
        }
    }

    @Override
    public List<Queue> getResourceGroupQueues() throws NeptuneException {
        this.verifyAuthority();
        ArrayList<Queue> queues = new ArrayList<Queue>();
        ResourceManagement resMgr = (ResourceManagement)ServiceRegistry.getDefault().lookup(ResourceManagement.class);
        for (ResourceGroup rg : resMgr.getAllResourceGroups()) {
            if (!rg.isVisible()) continue;
            Queue q = new Queue();
            q.setId(rg.getId());
            q.setName(rg.getName());
            ResourceGroupQueue wq = rg.getQueue();
            q.setNumItemsInQueue(wq != null ? wq.size() : 0);
            queues.add(q);
        }
        return queues;
    }
}

