/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.command;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.command.AbstractCommand;
import com.tandbergtv.workflow.message.event.WorkflowMessageLogEvent;
import com.tandbergtv.workflow.messageprocessor.templateselector.IPrioritySelector;
import com.tandbergtv.workflow.messageprocessor.templateselector.ITemplateSelector;
import com.tandbergtv.workflow.messageprocessor.templateselector.SelectorOutput;
import com.tandbergtv.workflow.messageprocessor.templateselector.TemplateSelectionException;
import com.tandbergtv.workflow.messageprocessor.templateselector.internal.TemplateSelectorFactory;
import com.tandbergtv.workflow.util.ApplicationProperties;
import com.tandbergtv.workflow.util.ClientExtensionClassLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.Token;

public class CreateCommand
extends AbstractCommand {
    private static final Logger logger = Logger.getLogger(CreateCommand.class);
    private static final String NEW_LINE = System.getProperty("line.separator");

    public CreateCommand(WorkflowMessage message) {
        super(message);
    }

    @Override
    public WorkflowMessage execute() {
        if (this.message.getCommand().getParameterValue("_template") != null) {
            return this.create();
        }
        TemplateSelectorFactory factory = TemplateSelectorFactory.createInstance();
        String className = this.message.getCommand().getParameterValue("selector");
        List<SelectorOutput> selections = null;
        try {
            ITemplateSelector selector = factory.getTemplateSelector(className);
            logger.debug((Object)("Template selector class name: " + selector.getClass().getName()));
            selections = selector.selectTemplates(this.message);
            if (selections == null) {
                throw new TemplateSelectionException("No templates were selected");
            }
        }
        catch (TemplateSelectionException e) {
            logger.error((Object)("Failed to instantiate Work Order for message [" + this.message.getMessageUID() + "]"), (Throwable)e);
            return this.createErrorResponse("Failed to create work order(s): " + e.getMessage());
        }
        String errors = "Failed to create work order for key(s):" + NEW_LINE;
        boolean failed = false;
        for (SelectorOutput selection : selections) {
            try {
                this.create(selection);
            }
            catch (Exception t) {
                failed = true;
                errors = errors + selection.getSelectionKey() + " - " + t.getMessage() + NEW_LINE;
                logger.error((Object)("Failed to instantiate Work Order for message [" + this.message.getMessageUID() + "]"), (Throwable)t);
            }
        }
        if (failed) {
            return this.createErrorResponse(errors);
        }
        WorkflowMessage response = this.createSuccessResponse();
        response.setPayload(this.message.getPayload());
        return response;
    }

    private void create(SelectorOutput selection) throws Exception {
        String key = selection.getSelectionKey();
        if (key == null) {
            throw new TemplateSelectionException("Template selector did not specify a key");
        }
        logger.debug((Object)("Selection key: " + key));
        ServiceRegistry registry = ServiceRegistry.getDefault();
        IProcessManagerService service = (IProcessManagerService)registry.lookup(IProcessManagerService.class);
        WorkflowTemplate definition = ((ITemplateLoaderService)registry.lookup(ITemplateLoaderService.class)).getTemplateBySelectorKey(key);
        ProcessPriority priority = this.getPriority(selection);
        Map<String, Object> variables = selection.getTemplateVariables();
        CustomToken token = service.create((ProcessDefinition)definition, priority, variables);
        logger.info((Object)("Auto-started Work Order " + token + " for template selection key: " + key));
        DefaultMediator.getInstance().send((WorkflowEvent)new WorkflowMessageLogEvent((Token)token, definition.getStartState(), true, this.message));
        service.start(token);
    }

    private WorkflowMessage create() {
        WorkflowMessage response = null;
        try {
            ProcessPriority priority = this.getPriority();
            if (priority == null) {
                priority = ProcessPriority.NORMAL;
            }
            WorkflowTemplate template = this.getTemplate();
            Map<String, Object> variables = this.getVariables();
            ServiceRegistry registry = ServiceRegistry.getDefault();
            IProcessManagerService service = (IProcessManagerService)registry.lookup(IProcessManagerService.class);
            CustomToken token = service.create((ProcessDefinition)template, priority, variables);
            logger.info((Object)(token + ", template " + template.getName()));
            DefaultMediator.getInstance().send((WorkflowEvent)new WorkflowMessageLogEvent((Token)token, template.getStartState(), true, this.message));
            service.start(token);
            response = this.createSuccessResponse();
            response.setPayload(this.message.getPayload());
        }
        catch (Exception e) {
            logger.error((Object)("Failed to instantiate Work Order for message [" + this.message.getMessageUID() + "]"), (Throwable)e);
            response = this.createErrorResponse("Failed to create work order: " + e.getMessage());
        }
        return response;
    }

    private ProcessPriority getPriority(SelectorOutput selection) {
        ProcessPriority priority = null;
        String priorityValue = this.message.getCommand().getParameterValue("priority");
        String className = this.message.getCommand().getParameterValue("prioritySelector");
        logger.debug((Object)("Priority value from message: " + priorityValue));
        logger.debug((Object)("Priority selector class name: " + className));
        if (priorityValue != null && !priorityValue.trim().equals("")) {
            try {
                priority = ProcessPriority.valueOf((String)priorityValue.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                logger.warn((Object)("Failed to get priority - " + priorityValue + " is not a valid priority"));
            }
        } else if (className != null && !className.trim().equals("")) {
            try {
                priority = this.getPrioritySelector(className).getPriority(selection, this.message);
                logger.debug((Object)("Priority selected by " + className + ": " + priority));
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to get priority - " + e.getMessage()), (Throwable)e);
            }
        }
        if (priority == null) {
            logger.debug((Object)"Defaulting to normal priority");
            priority = ProcessPriority.NORMAL;
        }
        return priority;
    }

    private IPrioritySelector getPrioritySelector(String className) throws Exception {
        String dir = ApplicationProperties.getInstance().getProperty("clientClassesDirectory");
        ClientExtensionClassLoader loader = new ClientExtensionClassLoader(dir, this.getClass().getClassLoader());
        Class<?> clazz = loader.loadClass(className);
        Object obj = clazz.newInstance();
        return (IPrioritySelector)obj;
    }

    private ProcessPriority getPriority() {
        ProcessPriority priority = null;
        String priorityValue = this.message.getCommand().getParameterValue("priority");
        if (priorityValue == null || priorityValue.length() == 0) {
            return priority;
        }
        try {
            priority = ProcessPriority.valueOf((String)priorityValue.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            logger.warn((Object)("Failed to get priority - " + priorityValue + " is not a valid priority"));
        }
        return priority;
    }

    private WorkflowTemplate getTemplate() {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        String templateName = this.message.getCommand().getParameterValue("_template");
        WorkflowTemplate template = ((ITemplateLoaderService)registry.lookup(ITemplateLoaderService.class)).getTemplateByName(templateName);
        if (template == null) {
            throw new RuntimeException("Template not found - " + templateName);
        }
        return template;
    }

    private Map<String, Object> getVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        Map parameters = this.message.getPayload().getAll();
        for (String key : parameters.keySet()) {
            variables.put(key, parameters.get(key));
        }
        return variables;
    }
}

