/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template.watch;

import com.tandbergtv.watchpoint.watchfolder.core.FileInfo;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.template.watch.AbstractFileListener;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.message.command.ICommandExecutor;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class TemplateListener
extends AbstractFileListener {
    @Override
    public void fileCreated(FileInfo fileInfo) {
        File file = new File(fileInfo.getAbsolutePath());
        String dir = file.getParentFile().getParentFile() + File.separator;
        String time = new SimpleDateFormat("yyyy-MM-dd-HHmmSS").format(new Date());
        String name = File.separator + file.getName().replace(".", "-") + "-" + time + ".xml";
        this.preCreate(file);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("filePath", fileInfo.getAbsolutePath());
        parameters.put("path", fileInfo.getAbsolutePath());
        parameters.put("imported", dir + "imported" + name);
        parameters.put("rejected", dir + "rejected" + name);
        WorkflowMessage message = this.createMessage("Template Watcher", parameters);
        ICommandExecutor executor = (ICommandExecutor)ServiceRegistry.getDefault().lookup(ICommandExecutor.class);
        try {
            executor.execute(message);
        }
        catch (Throwable e) {
            throw new RuntimeException("Message send failed", e);
        }
    }

    private WorkflowMessage createMessage(String templateName, Map<String, Object> variables) {
        WorkflowMessage message = WorkflowMessageFactory.createControlMessage((String)"120106");
        WPCLCommand command = new WPCLCommand("create");
        command.addParameter("_template", templateName);
        message.setCommand(command);
        WorkflowPayload payload = message.getPayload();
        for (String name : variables.keySet()) {
            String value = variables.get(name).toString();
            payload.putValue(name, value);
        }
        return message;
    }

    @Override
    public void fileDeleted(FileInfo fileInfo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fileUpdated(FileInfo fileInfo) {
        this.fileCreated(fileInfo);
    }

    @Override
    protected WorkflowTemplate read(File file) {
        throw new UnsupportedOperationException();
    }
}

