/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.hibernate;

import com.tandbergtv.workflow.dao.HibernateDAO;
import com.tandbergtv.workflow.log.IWorkflowNodeLogDAO;
import com.tandbergtv.workflow.log.entities.WorkflowNodeLog;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.Token;

public class WorkflowNodeLogHDAO
extends HibernateDAO<WorkflowNodeLog, Long>
implements IWorkflowNodeLogDAO {
    private static final Logger logger = Logger.getLogger(WorkflowNodeLogHDAO.class);

    public WorkflowNodeLogHDAO(Session session) {
        super(WorkflowNodeLog.class, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkflowNodeLog findCurrentByTokenAndNode(Token token, Node node) {
        WorkflowNodeLog log = null;
        Session session = this.getSession();
        logger.debug((Object)("Retreiving the current workflow node log for tokenId: " + token.getId() + " nodeId: " + node.getId()));
        try {
            Query nlQuery = session.createQuery(this.buildLatestJBPMNodeLogQuery(node, token));
            Object obj = nlQuery.uniqueResult();
            long nodeLogID = obj != null ? (Long)obj : -1L;
            Query wnlQuery = session.createQuery(this.buildFindCurrentByTokenAndNodeQuery(node, token, nodeLogID));
            obj = wnlQuery.uniqueResult();
            if (obj != null) {
                log = new WorkflowNodeLog((Long)obj);
            }
            logger.debug((Object)(token + ", log id " + obj));
        }
        catch (Exception ex) {
            logger.error((Object)("Could not get the current workflow node log for tokenId: " + token.getId() + " nodeId: " + node.getId()), (Throwable)ex);
        }
        finally {
            session.close();
        }
        return log;
    }

    private String buildFindCurrentByTokenAndNodeQuery(Node node, Token token, long nodeLogID) {
        String query = "select max(wnl.id) from WorkflowNodeLog wnl where wnl.node.id = " + node.getId() + " and wnl.token.id = " + token.getId() + " and wnl.id > " + nodeLogID;
        return query;
    }

    private String buildLatestJBPMNodeLogQuery(Node node, Token token) {
        String query = "select max(nl.id) from NodeLog nl where nl.node.id = " + node.getId() + " and nl.token.id = " + token.getId();
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkflowNodeLog store(WorkflowNodeLog entity) {
        WorkflowNodeLog newEntity = null;
        Session session = this.getSession();
        try {
            session.beginTransaction();
            newEntity = entity.getId() > 0L ? super.update(entity) : super.create(entity);
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            logger.error((Object)"Could not store the WorkflowNodeLog", (Throwable)ex);
            session.getTransaction().rollback();
        }
        finally {
            session.close();
        }
        return newEntity;
    }
}

