/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.loggers;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.driver.event.ProcessLogEvent;
import com.tandbergtv.workflow.log.loggers.IWorkflowLogger;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.jbpm.logging.log.ProcessLog;

public class ProcessLogLogger
implements IWorkflowLogger {
    private SessionFactory sessionFactory;
    private static final Logger logger = Logger.getLogger(ProcessLogLogger.class);

    public ProcessLogLogger(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public boolean match(Object logEvent) {
        return logEvent instanceof ProcessLogEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Object eventObj) {
        if (!(eventObj instanceof ProcessLogEvent)) {
            logger.debug((Object)"Not a ProcessLogEvent object. Ignored.");
            return;
        }
        ProcessLog processLog = ((ProcessLogEvent)eventObj).getLog();
        CustomToken token = (CustomToken)CustomToken.class.cast(processLog.getToken());
        if (!token.isTrace()) {
            logger.debug((Object)(token + " is not being traced, ignored"));
            return;
        }
        logger.debug((Object)("Storing process log to database. Process Log: " + processLog));
        Session session = this.sessionFactory.openSession();
        try {
            session.beginTransaction();
            session.saveOrUpdate((Object)processLog);
            session.getTransaction().commit();
            logger.debug((Object)("Stored process log to database. Process Log: " + processLog));
        }
        catch (Exception ex) {
            logger.error((Object)"Could not store the ProcessLog", (Throwable)ex);
            session.getTransaction().rollback();
        }
        finally {
            session.close();
        }
    }
}

