/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.driver.template.IArchivalStrategy;
import org.apache.log4j.Logger;

public class VersionBasedArchivalStrategy
implements IArchivalStrategy {
    private static final Logger logger = Logger.getLogger(VersionBasedArchivalStrategy.class);
    private ITemplateLoaderService loader;
    private IProcessSearchService search;

    public VersionBasedArchivalStrategy(ITemplateLoaderService loader, IProcessSearchService search) {
        this.loader = loader;
        this.search = search;
    }

    @Override
    public void archive() {
        for (WorkflowTemplate template : this.loader.getLatestTemplates()) {
            this.archive(template);
        }
    }

    @Override
    public void archive(WorkflowTemplate template) {
        logger.info((Object)("Trying to delete older versions of template " + template));
        for (WorkflowTemplate previous : this.loader.getPreviousVersions(template)) {
            int count = this.search.count(previous, ProcessStatus.PAUSED, ProcessStatus.BUSY, ProcessStatus.RUNNING, ProcessStatus.CREATED, ProcessStatus.QUEUED, ProcessStatus.ERROR, ProcessStatus.BRANCHED);
            logger.info((Object)("Found " + count + " process(es) of template " + previous));
            try {
                if (count != 0) continue;
                this.loader.delete(previous);
            }
            catch (DriverException e) {
                logger.warn((Object)("Failed to delete older versions of template " + template), (Throwable)e);
            }
        }
    }
}

