/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.realm.persist;

import com.tandbergtv.neptune.realm.persist.Permission;
import com.tandbergtv.neptune.realm.persist.RoleKey;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Formula;

@Entity
@Table(name="CMS_ROLE", uniqueConstraints={@UniqueConstraint(columnNames={"ROLE_NAME"})})
@NamedQueries(value={@NamedQuery(name="Role.FindAll", query="SELECT target FROM Role target"), @NamedQuery(name="Role.FindByExternalKey", query="SELECT role FROM Role role WHERE role.externalKey = :externalKey"), @NamedQuery(name="Role.FindByName", query="SELECT role FROM Role role WHERE role.name = :roleName"), @NamedQuery(name="Role.FindByPermissionId", query="SELECT role FROM Role role, IN(role.permissions) permission WHERE permission.id = :permissionId")})
public class Role
implements Serializable {
    private static final long serialVersionUID = -5280419703149451624L;
    private Long id;
    private String externalKey;
    private String name;
    private String description;
    private Integer userCount;
    private Set<Permission> permissions;
    private Set<Permission> inheritedPermissions;

    public Role() {
        this(null, null, null);
    }

    public Role(String name, String description) {
        this(name, description, null);
    }

    public Role(String name, String description, Set<Permission> permissions) {
        this.setName(name);
        this.setDescription(description);
        this.setPermissions(permissions);
        this.setInheritedPermissions(null);
    }

    @Id
    @Column(name="ROLEID")
    @SequenceGenerator(name="RoleID Sequence Generator", sequenceName="CMS_ROLE_SEQ", allocationSize=20)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="RoleID Sequence Generator")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="EXTERNALKEY")
    public String getExternalKey() {
        return this.externalKey;
    }

    public void setExternalKey(String externalKey) {
        this.externalKey = externalKey;
    }

    @Transient
    public RoleKey getRoleKey() {
        return new RoleKey(this.id, this.externalKey);
    }

    @Column(name="ROLE_NAME", unique=true, nullable=false)
    @Basic(optional=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="DESCRIPTION")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Formula(value="(SELECT COUNT(1) FROM CMS_USERROLES userRole WHERE userRole.ROLEID = ROLEID)")
    public Integer getUserCount() {
        return this.userCount;
    }

    public void setUserCount(Integer userCount) {
        this.userCount = userCount;
    }

    @ManyToMany
    @JoinTable(name="CMS_ROLEPERMISSIONS", joinColumns={@JoinColumn(name="ROLEID", nullable=false)}, inverseJoinColumns={@JoinColumn(name="PERMISSIONID", nullable=false)})
    public Set<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<Permission> permissions) {
        if (permissions == null) {
            permissions = new HashSet<Permission>();
        }
        this.permissions = permissions;
    }

    @Transient
    public Set<Permission> getInheritedPermissions() {
        return this.inheritedPermissions;
    }

    public void setInheritedPermissions(Set<Permission> permissions) {
        if (permissions == null) {
            permissions = new HashSet<Permission>();
        }
        this.inheritedPermissions = permissions;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = this.id == null ? super.hashCode() : this.id.hashCode() * 5 + 233;
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Role)) {
            return false;
        }
        Role other = (Role)obj;
        if (this.id == null && other.id == null) {
            return super.equals(obj);
        }
        return this.id.equals(other.id);
    }
}

