/*
 * Created on May 15, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.basic;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.RootPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;

/**
 * The toolkit widget extension for the GWT {@link Anchor} widget.
 * 
 * @see com.google.gwt.user.client.ui.Anchor
 * @author Vijay Silva
 */
public class AnchorWidget extends Anchor implements INeptuneWidget {

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.Anchor#Anchor()
	 */
	public AnchorWidget() {
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.Anchor#Anchor(String)
	 */
	public AnchorWidget(String text) {
		super(text);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.Anchor#Anchor(String, String)
	 */
	public AnchorWidget(String text, String href) {
		super(text, href);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.Anchor#Anchor(String, String, String)
	 */
	public AnchorWidget(String text, String href, String target) {
		super(text, href, target);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.Anchor#Anchor(String, boolean)
	 */
	public AnchorWidget(String text, boolean asHtml) {
		super(text, asHtml);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.Anchor#Anchor(String, boolean, String)
	 */
	public AnchorWidget(String text, boolean asHTML, String href) {
		super(text, asHTML, href);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.Anchor#Anchor(String, boolean, String, String)
	 */
	public AnchorWidget(String text, boolean asHtml, String href, String target) {
		super(text, asHtml, href, target);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.Anchor#Anchor(Element)
	 */
	protected AnchorWidget(Element element) {
		super(element);
		initializeWidget();
	}

	/*
	 * Perform any initialization of the widget at the end of construction.
	 */
	private void initializeWidget() {
	}

	/**
	 * Builds a widget wrapping the input element
	 * 
	 * @see com.google.gwt.user.client.ui.Anchor#wrap(Element)
	 */
	public static AnchorWidget wrap(Element element) {
		assert Document.get().getBody().isOrHasChild(element);
		AnchorWidget widget = new AnchorWidget(element);
		widget.onAttach();
		RootPanel.detachOnWindowClose(widget);
		return widget;
	}
}
