/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.neptune.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.workflow.neptune.client.IListUserTasks;
import com.tandbergtv.workflow.neptune.client.IListUserTasksAsync;
import com.tandbergtv.workflow.neptune.client.PortletConstants;
import com.tandbergtv.workflow.neptune.client.UserTask;
import com.tandbergtv.workflow.neptune.client.UserTaskList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class UserTaskListPortlet
extends Portlet {
    private NeptuneSecurity security;
    private VerticalContainer container;
    private IListUserTasksAsync service;
    private PortletConstants constants;

    public UserTaskListPortlet(NeptuneSecurity security, int refreshTimeMillis) {
        this.security = security;
        this.service = (IListUserTasksAsync)GWT.create(IListUserTasks.class);
        this.constants = (PortletConstants)GWT.create(PortletConstants.class);
        this.setTitle(this.constants.userTaskTitle());
        this.container = new VerticalContainer();
        this.add((Widget)this.container);
        new Timer(){

            public void run() {
                UserTaskListPortlet.this.reload();
            }
        }.scheduleRepeating(refreshTimeMillis);
    }

    public void reload() {
        this.service.getUserTasks((AsyncCallback<UserTaskList>)new NeptuneAsyncCallback<UserTaskList>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(UserTaskList userTaskList) {
                UserTaskListPortlet.this.container.clear();
                UserTaskListPortlet.this.setTitle(UserTaskListPortlet.this.constants.userTaskTitle() + " (" + userTaskList.getNumUserTasks() + "/" + userTaskList.getTotalNumUserTasks() + ")");
                List<UserTask> userTasks = userTaskList.getUserTasks();
                Collections.sort(userTasks, new Comparator<UserTask>(){

                    @Override
                    public int compare(UserTask t1, UserTask t2) {
                        return t1.getName().compareTo(t2.getName());
                    }
                });
                for (UserTask userTask : userTasks) {
                    if (userTask.hasEnded()) continue;
                    if (UserTaskListPortlet.this.security.isUserInRole("UserTasks_PerformTask")) {
                        String historyToken = "User Tasks.Perform?id=" + userTask.getProcessId() + ":" + userTask.getTaskInstanceId();
                        HyperlinkWidget link = new HyperlinkWidget(userTask.getName(), historyToken);
                        link.setStyleName("portlet-userTasks-link");
                        UserTaskListPortlet.this.container.add((Widget)link);
                        continue;
                    }
                    LabelWidget label = new LabelWidget(userTask.getName());
                    label.setStyleName("portlet-userTasks-text");
                    UserTaskListPortlet.this.container.add((Widget)label);
                }
            }
        });
    }
}

