/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.neptune.client;

import com.google.gwt.user.client.Random;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.component.ComponentBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.GroupMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemProxy;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.FrameWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.workflow.neptune.client.ResourceGroupQueueListPortlet;
import com.tandbergtv.workflow.neptune.client.ResourceListPortlet;
import com.tandbergtv.workflow.neptune.client.UserTaskListPortlet;
import com.tandbergtv.workflow.neptune.client.WOStatusPortlet;
import java.util.ArrayList;
import java.util.List;

public class WorkflowComponent
extends ComponentBase {
    public List<PortletFactory> listPortlets(final NeptuneSecurity security) {
        if (!security.isUserInRole("Home_Dashboard")) {
            return null;
        }
        ArrayList<PortletFactory> portletFactories = new ArrayList<PortletFactory>();
        int confRefreshTimeMillis = -1;
        try {
            confRefreshTimeMillis = Integer.parseInt((String)this.info.get("workflow.portlets.refreshTime"));
        }
        catch (Exception e) {
            // empty catch block
        }
        final int refreshTimeMillis = confRefreshTimeMillis != -1 ? confRefreshTimeMillis : 10000;
        portletFactories.add(new PortletFactory(){
            UserTaskListPortlet portlet;
            {
                this.portlet = new UserTaskListPortlet(security, refreshTimeMillis);
            }

            public Portlet getInstance() {
                this.portlet.reload();
                return this.portlet;
            }

            public void release(Portlet portlet) {
            }
        });
        portletFactories.add(new PortletFactory(){
            WOStatusPortlet portlet;
            {
                this.portlet = new WOStatusPortlet(security, refreshTimeMillis);
            }

            public Portlet getInstance() {
                this.portlet.reload();
                return this.portlet;
            }

            public void release(Portlet portlet) {
            }
        });
        portletFactories.add(new PortletFactory(){
            ResourceListPortlet portlet;
            {
                this.portlet = new ResourceListPortlet(security, refreshTimeMillis);
            }

            public Portlet getInstance() {
                this.portlet.reload();
                return this.portlet;
            }

            public void release(Portlet portlet) {
            }
        });
        portletFactories.add(new PortletFactory(){
            ResourceGroupQueueListPortlet portlet;
            {
                this.portlet = new ResourceGroupQueueListPortlet(security, refreshTimeMillis);
            }

            public Portlet getInstance() {
                this.portlet.reload();
                return this.portlet;
            }

            public void release(Portlet portlet) {
            }
        });
        return portletFactories;
    }

    public <E extends Service> List<E> listServices(Class<E> clazz, NeptuneSecurity security) {
        return new ArrayList();
    }

    public List<MenuItemBase> listTabs(NeptuneSecurity security) {
        ArrayList<MenuItemBase> menuitems = new ArrayList<MenuItemBase>();
        if (security.isUserInRole("Home_Dashboard")) {
            menuitems.add(this.getDashboardMenu(security));
        }
        if (security.isUserInRole("WorkOrderManagement_Create") || security.isUserInRole("WorkOrderManagement_View")) {
            menuitems.add(this.getWorkOrdersMenu(security));
        }
        if (security.isUserInRole("ResourceManagement_Create") || security.isUserInRole("ResourceManagement_View")) {
            menuitems.add(this.getResourcesMenu(security));
        }
        if (security.isUserInRole("Monitoring_Create") || security.isUserInRole("Monitoring_View")) {
            menuitems.add(this.getMonitoringMenu(security));
        }
        if (security.isUserInRole("Monitoring_Create") || security.isUserInRole("Monitoring_View")) {
            menuitems.add(this.getAdminMenu(security));
        }
        if (security.isUserInRole("UserTasks_PerformTask") || security.isUserInRole("UserTasks_PerformOthersTasks")) {
            menuitems.add(this.getUserTasksMenu(security));
        }
        if (security.isUserInRole("Reporting_View")) {
            menuitems.add(this.getReportsMenu(security));
        }
        return menuitems;
    }

    private MenuItemBase getDashboardMenu(NeptuneSecurity security) {
        return this.createMenuItem("/workflow/dashboardview.do?method=getDashBoard", "Dashboard");
    }

    private MenuItemBase getWorkOrdersMenu(NeptuneSecurity security) {
        ArrayList<Object> menuitems = new ArrayList<Object>();
        if (security.isUserInRole("WorkOrderManagement_Create")) {
            menuitems.add(this.createMenuItem("/workflow/wfsprocess.do?method=createWorkOrderSetup", "Create"));
        }
        if (security.isUserInRole("WorkOrderManagement_View")) {
            final SimpleContainer panel = new SimpleContainer();
            panel.setSize("100%", "100%");
            WidgetMenuItem.AnchorChangeListener listener = new WidgetMenuItem.AnchorChangeListener(){

                public void anchorChanged(String anchor) {
                    if (anchor.startsWith("Status")) {
                        String url = "/workflow/workOrderDetailsAction.do?method=getWorkOrdersBySearch&sourcePage=dashBoard&status=" + anchor.substring("Status".length() + 1);
                        WorkflowComponent.this.showFrame((Panel)panel, url);
                    } else {
                        WorkflowComponent.this.showFrame((Panel)panel, "/workflow/workOrderSearch.do?method=getWorkOrderSearchPage");
                    }
                }
            };
            menuitems.add(this.createMenuItem("Search", (Widget)panel, listener));
            if (security.isUserInRole("WorkOrderManagement_Modify")) {
                menuitems.add(this.createMenuItem("/workflow/pauseResumeAction.do?method=goToLogin", "Pause All/Resume All"));
            }
            ArrayList<MenuItemBase> submenuitems = new ArrayList<MenuItemBase>();
            submenuitems.add(this.createMenuItem("/workflow/viewtemplate.do?method=selectTemplateDetails", "View"));
            submenuitems.add(this.createMenuItem("/workflow/viewselectorkeys.do?method=getSelectorKeyDetails", "View Selector Keys"));
            menuitems.add(new GroupMenuItem("Templates", submenuitems));
        }
        return new GroupMenuItem("Work Orders", menuitems);
    }

    private MenuItemBase getResourcesMenu(NeptuneSecurity security) {
        ArrayList<Object> menuitems = new ArrayList<Object>();
        if (security.isUserInRole("ResourceManagement_View")) {
            final SimpleContainer panel = new SimpleContainer();
            panel.setSize("100%", "100%");
            WidgetMenuItem.AnchorChangeListener listener = new WidgetMenuItem.AnchorChangeListener(){

                public void anchorChanged(String anchor) {
                    if (anchor.startsWith("Modify")) {
                        WorkflowComponent.this.showFrame((Panel)panel, "/workflow/resourceManagement.do?method=getResourceDetails&" + anchor.substring(7));
                    } else if (anchor.startsWith("Queue")) {
                        WorkflowComponent.this.showFrame((Panel)panel, "/workflow/resourceGroupQueueManagement.do?method=getResourceGroupQueue&" + anchor.substring(6));
                    } else {
                        WorkflowComponent.this.showFrame((Panel)panel, "/workflow/resourcesListManagement.do?method=getResourcesList");
                    }
                }
            };
            menuitems.add(this.createMenuItem("View", (Widget)panel, listener));
        }
        if (security.isUserInRole("ResourceManagement_Create")) {
            menuitems.add(this.createMenuItem("/workflow/resourceManagement.do?method=getResourceTypeDetails", "Create"));
        }
        if (security.isUserInRole("Plugins_View")) {
            ArrayList<MenuItemBase> items = new ArrayList<MenuItemBase>();
            items.add(this.createMenuItem("/workflow/plugins.do?method=getResourceTypePlugins", "View"));
            menuitems.add(new GroupMenuItem("Types", new ArrayList(items)));
            items.clear();
            items.add(this.createMenuItem("/workflow/plugins.do?method=getResourceGroupPlugins", "View"));
            menuitems.add(new GroupMenuItem("Groups", items));
        }
        return new GroupMenuItem("Resources", menuitems);
    }

    private MenuItemBase getAdminMenu(NeptuneSecurity security) {
        ArrayList<GroupMenuItem> menuitems = new ArrayList<GroupMenuItem>();
        ArrayList<MenuItemBase> submenuitems = new ArrayList<MenuItemBase>();
        if (security.isUserInRole("Monitoring_View")) {
            submenuitems.add(this.createMenuItem("/workflow/toModule.do?prefix=/sysmonui&page=/checkAlertServerStatus.do?method=toListAlerts", "View"));
        }
        if (security.isUserInRole("Monitoring_Create")) {
            submenuitems.add(this.createMenuItem("/workflow/toModule.do?prefix=/sysmonui&page=/checkAlertServerStatus.do?method=toCreateAlert", "Create"));
        }
        menuitems.add(new GroupMenuItem("Alerts", new ArrayList(submenuitems)));
        submenuitems.clear();
        if (security.isUserInRole("Monitoring_View")) {
            submenuitems.add(this.createMenuItem("/workflow/toModule.do?prefix=/sysmonui&page=/checkAlertServerStatus.do?method=toListAlertPatterns", "View"));
        }
        if (security.isUserInRole("Monitoring_Create")) {
            submenuitems.add(this.createMenuItem("/workflow/toModule.do?prefix=/sysmonui&page=/checkAlertServerStatus.do?method=toCreateAlertPattern", "Create"));
        }
        menuitems.add(new GroupMenuItem("Alert Patterns", new ArrayList(submenuitems)));
        return new MenuItemProxy("Admin", menuitems);
    }

    private MenuItemBase getMonitoringMenu(NeptuneSecurity security) {
        ArrayList<MenuItemBase> menuitems = new ArrayList<MenuItemBase>();
        if (security.isUserInRole("Monitoring_View")) {
            menuitems.add(this.createMenuItem("/workflow/toModule.do?prefix=/sysmonui&page=/checkAlertServerStatus.do?method=toListAlertHistory", "View Alert History"));
            menuitems.add(this.createMenuItem("/workflow/repositoryBrowsing.do?method=getRepository", "Repository Browser"));
        }
        return new GroupMenuItem("Monitoring", menuitems);
    }

    private MenuItemBase getUserTasksMenu(NeptuneSecurity security) {
        final SimpleContainer panel = new SimpleContainer();
        panel.setSize("100%", "100%");
        WidgetMenuItem.AnchorChangeListener listener = new WidgetMenuItem.AnchorChangeListener(){

            public void anchorChanged(String anchor) {
                if (anchor.startsWith("Perform")) {
                    WorkflowComponent.this.showFrame((Panel)panel, "/workflow/wfstask.do?method=selectTaskInstance&task=" + anchor.substring("Perform?id=".length()));
                } else {
                    WorkflowComponent.this.showFrame((Panel)panel, "/workflow/userTasksAction.do?method=getUserTasks");
                }
            }
        };
        return this.createMenuItem("User Tasks", (Widget)panel, listener);
    }

    private String getRandom() {
        return String.valueOf(Random.nextDouble());
    }

    private MenuItemBase getReportsMenu(NeptuneSecurity security) {
        return this.createMenuItem("/workflow/reports.do?method=getReportsList", "Reports");
    }

    private MenuItemBase createMenuItem(final String url, String name) {
        final SimpleContainer panel = new SimpleContainer();
        panel.setSize("100%", "100%");
        return new WidgetMenuItem(name, (Widget)panel, new WidgetMenuItem.AnchorChangeListener(){

            public void anchorChanged(String anchor) {
                WorkflowComponent.this.showFrame((Panel)panel, url);
            }
        });
    }

    private MenuItemBase createMenuItem(String name, Widget frame, WidgetMenuItem.AnchorChangeListener listener) {
        return new WidgetMenuItem(name, frame, listener);
    }

    private void showFrame(Panel frameHolder, String frameURL) {
        frameHolder.clear();
        FrameWidget frame = new FrameWidget();
        frame.getElement().setAttribute("frameBorder", "0");
        String randomizer = "&random=" + this.getRandom();
        frameURL = frameURL.contains("?") ? frameURL + randomizer : frameURL + "?" + randomizer;
        frame.setUrl(frameURL);
        frameHolder.add((Widget)frame);
    }
}

