/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.neptune.server;

import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.security.InsufficientRolesException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.neptune.client.IListResources;
import com.tandbergtv.workflow.neptune.client.Resource;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import java.util.ArrayList;
import java.util.List;

public class ListResourcesImpl
implements IListResources,
NeptuneRemoteService {
    private IAuthorizationService authService = (IAuthorizationService)InjectionUtil.injectInstance((String)"cms/AuthorizationService/local", IAuthorizationService.class);

    public String getRelativePath() {
        return "service/watchpoint/IListResources";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    private void verifyAuthority() throws InsufficientRolesException {
        if (!this.authService.isAuthorized("Home", "Dashboard")) {
            throw new InsufficientRolesException();
        }
    }

    @Override
    public List<com.tandbergtv.workflow.neptune.client.Resource> getResources() throws NeptuneException {
        this.verifyAuthority();
        ArrayList<com.tandbergtv.workflow.neptune.client.Resource> resources = new ArrayList<com.tandbergtv.workflow.neptune.client.Resource>();
        ResourceManagement resMgr = (ResourceManagement)ServiceRegistry.getDefault().lookup(ResourceManagement.class);
        List workflowResources = resMgr.getAllResources();
        for (Resource wr : workflowResources) {
            com.tandbergtv.workflow.neptune.client.Resource r = new com.tandbergtv.workflow.neptune.client.Resource(wr.getId(), wr.getName());
            r.setState(Resource.State.valueOf(wr.getOperationalState().name()));
            r.setCurrentlyUsed(wr.getUserCount() > 0);
            resources.add(r);
        }
        return resources;
    }
}

