/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.page;

import com.tandbergtv.workflow.web.page.Field;
import com.tandbergtv.workflow.web.page.ISearchFieldDataProvider;
import com.tandbergtv.workflow.web.page.Page;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class PageConfig
implements Serializable {
    private static final long serialVersionUID = -4093319842848673616L;
    private static final Logger logger = Logger.getLogger(PageConfig.class);
    private static String PAGE_TAG_NAME = "page";
    private static String PAGE_NAME = "name";
    private HashMap<String, Page> pages = new HashMap();

    public Page getPage(String pageName, File configFile) throws Exception {
        this.getPages(configFile);
        return this.pages.get(pageName);
    }

    private void getPages(File configFile) throws Exception {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(configFile);
        Element element = doc.getDocumentElement();
        NodeList pageNodeList = element.getElementsByTagName(PAGE_TAG_NAME);
        Page page = null;
        ArrayList<Field> fields = null;
        HashMap<String, Field> fieldsMap = null;
        for (int i = 0; i < pageNodeList.getLength(); ++i) {
            page = new Page();
            page.setName(pageNodeList.item(i).getAttributes().getNamedItem(PAGE_NAME).getNodeValue());
            logger.debug((Object)("Page name " + page.getName()));
            fields = new ArrayList<Field>();
            fieldsMap = new HashMap<String, Field>();
            if (pageNodeList.item(i).hasChildNodes()) {
                NodeList fieldNodeList = pageNodeList.item(i).getChildNodes();
                if (fieldNodeList != null) {
                    logger.debug((Object)("Found " + fieldNodeList.getLength() + " fields"));
                }
                Field field = null;
                HashMap<String, String> hmFieldAttributes = new HashMap<String, String>();
                Map<String, String> hmOptions = null;
                for (int j = 0; j < fieldNodeList.getLength(); ++j) {
                    NamedNodeMap fieldAttributesMap;
                    Node fieldNode = fieldNodeList.item(j);
                    if (!fieldNode.getNodeName().equals("field")) continue;
                    field = new Field();
                    NamedNodeMap namedNodeMap = fieldAttributesMap = fieldNode == null ? null : fieldNode.getAttributes();
                    if (field == null || fieldAttributesMap == null) continue;
                    hmFieldAttributes = new HashMap();
                    for (int m = 0; m < fieldAttributesMap.getLength(); ++m) {
                        hmFieldAttributes.put(fieldAttributesMap.item(m).getNodeName(), fieldAttributesMap.item(m).getNodeValue());
                    }
                    field.setAttributesMap(hmFieldAttributes);
                    logger.debug((Object)("Reading field " + field.getName()));
                    if (fieldAttributesMap.getNamedItem("type").getNodeValue().equals("dropdown") || fieldAttributesMap.getNamedItem("type").getNodeValue().equals("list")) {
                        hmOptions = new LinkedHashMap<String, String>();
                        String source = fieldAttributesMap.getNamedItem("source").getNodeValue();
                        if (source.equals("xml")) {
                            NodeList optionsNodeList = fieldNode.getChildNodes();
                            for (int n = 0; n < optionsNodeList.getLength(); ++n) {
                                if (!optionsNodeList.item(n).getNodeName().equals("option")) continue;
                                hmOptions.put(optionsNodeList.item(n).getAttributes().getNamedItem("value").getNodeValue(), optionsNodeList.item(n).getAttributes().getNamedItem("text").getNodeValue());
                            }
                            field.setValuesMap(hmOptions);
                        } else if (fieldAttributesMap.getNamedItem("source").getNodeValue().equals("db")) {
                            hmOptions = this.getOptionsMap(fieldAttributesMap.getNamedItem("name").getNodeValue().trim());
                            field.setValuesMap(hmOptions);
                        } else if (source.equals("class")) {
                            String className = fieldAttributesMap.getNamedItem("provider-class").getNodeValue();
                            hmOptions = this.getFieldValues(field, className);
                            field.setValuesMap(hmOptions);
                        }
                    }
                    fields.add(field);
                    fieldsMap.put(fieldAttributesMap.getNamedItem("name").getNodeValue().trim(), field);
                }
                page.setFields(fields);
                page.setFieldsMap(fieldsMap);
            }
            this.pages.put(page.getName(), page);
        }
        for (Map.Entry<String, Page> entry : this.pages.entrySet()) {
            logger.debug((Object)("Page Name-->" + entry.getKey()));
            for (Field element1 : this.pages.get(entry.getKey()).getFields()) {
                logger.debug((Object)("Attributes maps-->" + element1.getAttributesMap()));
                logger.debug((Object)("Option Values Map-->" + element1.getValuesMap()));
            }
        }
    }

    protected abstract Map<String, String> getOptionsMap(String var1);

    private Map<String, String> getFieldValues(Field field, String className) throws Exception {
        logger.debug((Object)("Loading field provider class " + className));
        ClassLoader loader = this.getClass().getClassLoader();
        Class<?> clazz = loader.loadClass(className);
        ISearchFieldDataProvider provider = (ISearchFieldDataProvider)clazz.newInstance();
        return provider.getData();
    }
}

