set echo on
set serveroutput on


CREATE TABLE TEMP_REC_RULES 
 (	RECORDING_ID NUMBER, 
	PROGRAM_TITLE NVARCHAR2(1000), 
	PROGRAM_DESCRIPTION NVARCHAR2(2000), 
	OFFSET_START_TIME NUMBER(22,0), 
	OFFSET_END_TIME NUMBER(22,0), 
	RECORDING_MODE NVARCHAR2(50), 
	PRIORITY NUMBER(2,0), 
	PROVIDER_QA_CONTACT NVARCHAR2(128), 
	CATALOG_ENTRY NUMBER(1,0), 
	BILLING_ID NVARCHAR2(5), 
	MPAA_RATING NVARCHAR2(1000), 
	TV_RATING NVARCHAR2(1000), 
	PROVIDER_ID NVARCHAR2(20), 
	PROVIDER_NAME NVARCHAR2(128), 
	PRODUCT NVARCHAR2(20), 
	CATEGORY NVARCHAR2(256), 
	AUDIO_TYPE NVARCHAR2(14), 
	MAX_COPIES NUMBER(10,0), 
	PREVIEW_PERIOD NUMBER(10,0), 
	LICENCE_START_DATE TIMESTAMP (9) WITH TIME ZONE, 
	LICENSE_END_DATE TIMESTAMP (9) WITH TIME ZONE, 
	REPEAT NVARCHAR2(1), 
	CREATED_BY CHAR(6), 
	UPDATED_BY CHAR(6), 
	CREATE_DATE DATE, 
	UPDATE_DATE DATE, 
	SCHEDULE_ID NUMBER(19,0), 
	HEADEND_ID NVARCHAR2(100), 
	RM_ID NUMBER(19,0), 
	STATION_ID NVARCHAR2(100), 
	RIGHT_ID NUMBER(19,0), 
	RULE_ID NUMBER(19,0), 
	RULE_CREATE_DATE TIMESTAMP (6),
  RIGHT_CREATE_DATE timestamp(6),
	EPISODE_TITLE NVARCHAR2(1000), 
	PROGRAM_ID NVARCHAR2(100), 
	HD_TV NVARCHAR2(1), 
	CC NVARCHAR2(1), 
	SCHEDULE_START_TIME TIMESTAMP (0) WITH TIME ZONE, 
	SCHEDULE_END_TIME TIMESTAMP (0) WITH TIME ZONE, 
	SCHEDULE_DURATION NUMBER(10,0), 
	CONTRACT_ID NUMBER(19,0), 
	YEAR_PROGRAM NVARCHAR2(100), 
	RL_STATION_OFFSET NUMBER(10,0)
 );
 

CREATE INDEX TRR_RECORDING_ID ON TEMP_REC_RULES (RECORDING_ID) ;
 
CREATE TABLE "TEMP_RECORDING_LOG" 
   (	"RECORDING_LOG_ID" NUMBER(19,0), 
		"RECORDING_ID" NUMBER,
  		"SCHEDULE_ID" NUMBER(19,0),
  		"HEADEND_ID" NVARCHAR2(100),
	"POOL_ID" NUMBER(19,0), 
	"LOG_MESSAGE" NVARCHAR2(2000),
	"CREATED_BY" NVARCHAR2(50), 
	"UPDATED_BY" NVARCHAR2(50), 
	"CREATE_DATE" TIMESTAMP (0) WITH TIME ZONE, 
	"UPDATE_DATE" TIMESTAMP (0) WITH TIME ZONE, 
	"OLDRECORDINGID" NUMBER(19,0)
   );
 

CREATE TABLE ALARM_ACTIVITYLOG 
    ( 
    ID          	NUMBER(19,0) NOT NULL,
    TYPE        	NUMBER(2,0) NOT NULL,
    SEVERITY    	NUMBER(2,0) NOT NULL,
    COMPONENT   	NVARCHAR2(64) NOT NULL,
    DESCRIPTION 	NVARCHAR2(2000) NOT NULL,
    REFERENCE_ID	NUMBER(19,0) NULL,
    EVENT_NAME  	NVARCHAR2(100) NULL,
    CREATED_BY  	NVARCHAR2(50) NOT NULL,
    UPDATED_BY  	NVARCHAR2(50) NOT NULL,
    CREATE_DATE 	TIMESTAMP(0) WITH TIME ZONE NOT NULL,
    UPDATE_DATE 	TIMESTAMP(0) WITH TIME ZONE NOT NULL,
    ERROR_CODE  	NUMBER(10,0) 
    )  
/



ALTER TABLE ALARM_ACTIVITYLOG ADD CONSTRAINT PK_ALARM_ACTIVITYLOG PRIMARY KEY ( ID )
/

CREATE INDEX IDX_AAL_COMPONENT ON ALARM_ACTIVITYLOG(COMPONENT)
/
    
CREATE INDEX IDX_AAL_EVENTNAME ON ALARM_ACTIVITYLOG(EVENT_NAME)
/


CREATE TABLE RIGHT_RM_MAP 
    ( 
     RIGHT_ID NUMBER(19,0)  NOT NULL , 
     RM_ID NUMBER(19,0)  NOT NULL , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL 
    )
/




ALTER TABLE RIGHT_RM_MAP 
    ADD CONSTRAINT PK_RIGHT_RM_MAP PRIMARY KEY ( RIGHT_ID, RM_ID ) 
/


CREATE TABLE RIGHT_EXCLUDED_RM_MAP 
    ( 
     RIGHT_ID NUMBER(19,0)  NOT NULL , 
     RM_ID NUMBER(19,0)  NOT NULL , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL 
    )
/

ALTER TABLE RIGHT_EXCLUDED_RM_MAP 
    ADD CONSTRAINT PK_RIGHT_EXCLUDED_RM_MAP PRIMARY KEY ( RIGHT_ID, RM_ID ) 
/



CREATE TABLE PROGRAM 
    ( 
     PROGRAM_ID NVARCHAR2 (100)  NOT NULL , 
     LANGUAGE NVARCHAR2 (100) NOT NULL , 
     TITLE NVARCHAR2 (1000) NOT NULL , 
     REDUCED_TITLE1 NVARCHAR2 (1000) NOT NULL , 
     REDUCED_TITLE2 NVARCHAR2 (1000) , 
     REDUCED_TITLE3 NVARCHAR2 (1000) , 
     REDUCED_TITLE4 NVARCHAR2 (1000) , 
     ALT_TITLE NVARCHAR2 (1000) , 
     REDUCED_DESCRIPTION1 NVARCHAR2 (1000) , 
     REDUCED_DESCRIPTION2 NVARCHAR2 (1000) , 
     REDUCED_DESCRIPTION3 NVARCHAR2 (1000) , 
     REDUCED_DESCRIPTION4 NVARCHAR2 (1000) , 
     ADVISORY_DESC1 NVARCHAR2 (100) , 
     ADVISORY_DESC2 NVARCHAR2 (100) , 
     ADVISORY_DESC3 NVARCHAR2 (100) , 
     ADVISORY_DESC4 NVARCHAR2 (100) , 
     ADVISORY_DESC5 NVARCHAR2 (100) , 
     ADVISORY_DESC6 NVARCHAR2 (100) , 
     GENRE_DESC1 NVARCHAR2 (100) , 
     GENRE_DESC2 NVARCHAR2 (100) , 
     GENRE_DESC3 NVARCHAR2 (100) , 
     GENRE_DESC4 NVARCHAR2 (100) , 
     GENRE_DESC5 NVARCHAR2 (100) , 
     GENRE_DESC6 NVARCHAR2 (100) , 
     DESCRIPTION1 NVARCHAR2 (2000) NOT NULL , 
     DESCRIPTION2 NVARCHAR2 (2000) , 
     YEAR_PROGRAM NVARCHAR2 (100) NOT NULL , 
     MPAA_RATING NVARCHAR2 (1000) NOT NULL , 
     STAR_RATING NVARCHAR2 (1000) , 
     RUN_TIME VARCHAR2 (100) , 
     COLOR_CODE NVARCHAR2 (100) , 
     PROGRAM_LANGUAGE NVARCHAR2 (100) , 
     COUNTRY_OF_ORIGIN NVARCHAR2 (100) , 
     MADE_FOR_TV NVARCHAR2 (1) , 
     SOURCE_TYPE NVARCHAR2 (100) , 
     SHOW_TYPE NVARCHAR2 (200) , 
     HOLIDAY NVARCHAR2 (100) , 
     SYNDICATE_EPISODE_NUM NVARCHAR2 (100) , 
     ALT_SYNDICATE_EPI_NUM NVARCHAR2 (100) , 
     EPISODE_TITLE NVARCHAR2 (1000) NOT NULL , 
     NET_SYN_SOURCE NVARCHAR2 (100) , 
     NET_SYN_TYPE NVARCHAR2 (100) , 
     ORG_STUDIO NVARCHAR2 (100) NOT NULL , 
     GAME_DATETIME TIMESTAMP , 
     GAME_TIMEZONE NVARCHAR2 (100) , 
     ORG_AIR_DATE TIMESTAMP , 
     UNIQUE_ID NVARCHAR2 (100) , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL 
    )  
/



ALTER TABLE PROGRAM 
    ADD CONSTRAINT PK_PROGRAM PRIMARY KEY ( PROGRAM_ID )
/


CREATE TABLE CONFIG_SETTING 
    ( 
     KEY NVARCHAR2 (1024)  NOT NULL , 
     VALUE NVARCHAR2 (1024) , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL 
    )  
/



ALTER TABLE CONFIG_SETTING  ADD CONSTRAINT PK_CONFIG_SETTING PRIMARY KEY ( KEY ) 
/


CREATE TABLE REC_RULES_STATION_MAP 
    ( 
     RULE_ID NUMBER (19,0)  NOT NULL , 
     STATION_ID NVARCHAR2 (100)  NOT NULL , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL 
    )  
/



ALTER TABLE REC_RULES_STATION_MAP ADD CONSTRAINT REC_RULES_STATION_MAP_PK PRIMARY KEY ( RULE_ID, STATION_ID ) 
/


CREATE TABLE RIGHT_SERIES_MAP 
    ( 
     RIGHT_ID NUMBER(19,0)  NOT NULL , 
     SERIES_ID NVARCHAR2 (100)  NOT NULL , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL 
    )  
/


ALTER TABLE RIGHT_SERIES_MAP     ADD CONSTRAINT RIGHT_SERIES_MAPPING_PK PRIMARY KEY ( SERIES_ID, RIGHT_ID )
/


CREATE TABLE RM_LINEUP 
    ( 
     RM_ID NUMBER(19,0)  NOT NULL , 
     STATION_ID NVARCHAR2 (100)  NOT NULL , 
     HEADEND_ID NVARCHAR2(100) NOT NULL , 
     LINEUP_ID NUMBER(19,0)  NOT NULL , 
     MULTICAST_IP_ADDRESS NVARCHAR2 (100)  NOT NULL , 
     MULTICAST_PORT NUMBER (5,0)  NOT NULL , 
     OFFSET NUMBER (10,0) DEFAULT 0  NOT NULL , 
     SD_MIN_BITRATE NUMBER (10,0) DEFAULT 0  NOT NULL , 
     SD_MAX_BITRATE NUMBER (10,0) DEFAULT 0  NOT NULL , 
     HD_MIN_BITRATE NUMBER (10,0) DEFAULT 0  NOT NULL , 
     HD_MAX_BITRATE NUMBER (10,0) DEFAULT 0  NOT NULL , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL 
    )  
/



ALTER TABLE RM_LINEUP     ADD CONSTRAINT PK_RM_LINEUP PRIMARY KEY ( RM_ID, STATION_ID, HEADEND_ID ) 
/


CREATE TABLE ADI_XML_SITE 
    ( 
     ADI_XML_SITE_ID NUMBER (19,0) NOT NULL , 
     NAME NVARCHAR2 (100)  NOT NULL , 
     URL NVARCHAR2 (1000)  NOT NULL , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL , 
     RM_ID NUMBER(19,0)  NOT NULL 
    )  
/



ALTER TABLE ADI_XML_SITE     ADD CONSTRAINT ADI_XML_SITE_PK PRIMARY KEY ( ADI_XML_SITE_ID ) 
/

ALTER TABLE ADI_XML_SITE     ADD CONSTRAINT XML_SITE_NAME_UNIQUE UNIQUE(RM_ID,NAME)
/


CREATE TABLE RIGHT 
    ( 
     RIGHT_ID NUMBER (19,0)  NOT NULL , 
     STATE NUMBER (1, 0) DEFAULT 1  NOT NULL , 
     NAME NVARCHAR2 (250)  NOT NULL , 
     START_DATE  TIMESTAMP(0) WITH TIME ZONE , 
     END_DATE  TIMESTAMP(0) WITH TIME ZONE , 
     DAY_OF_WEEK NVARCHAR2 (100) , 
     AUTO_APPROVE NUMBER (1, 0) DEFAULT 0  NOT NULL , 
     REPEAT NVARCHAR2(1)  , 
     HD  NVARCHAR2(1) , 
     LIVE  NVARCHAR2(100) , 
     RECORDING_MODE NVARCHAR2 (50)  NOT NULL , 
     OFFSET_START_TIME NUMBER(22,0) DEFAULT 0  NOT NULL , 
     OFFSET_END_TIME NUMBER(22,0) DEFAULT 0  NOT NULL , 
     PRIORITY NUMBER (2, 0)  NOT NULL , 
     PROVIDER_QA_CONTACT NVARCHAR2 (128) , 
     CATALOG_ENTRY NUMBER (1, 0) DEFAULT 0  NOT NULL , 
     BILLING_ID NVARCHAR2 (5) DEFAULT '0'  NOT NULL , 
     MPAA_RATING NVARCHAR2 (1000)  NOT NULL , 
     TV_RATING NVARCHAR2 (1000)  NOT NULL , 
     PROVIDER_ID NVARCHAR2 (20)  NOT NULL , 
     PROVIDER_NAME NVARCHAR2 (128)  NOT NULL,
     PRODUCT NVARCHAR2 (20)  NOT NULL , 
     CATEGORY NVARCHAR2 (256)  NOT NULL , 
     AUDIO_TYPE NVARCHAR2 (14) ,
	 MAX_COPIES NUMBER (10, 0),
	 PREVIEW_PERIOD NUMBER(10, 0),
	 LICENSE_RELATIVE_START NUMBER(19,0) NOT NULL,
	 LICENSE_RELATIVE_DURATION NUMBER(19,0) NOT NULL,
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL , 
     CONTRACT_ID NUMBER(19,0) NOT NULL 
    )  
/



ALTER TABLE RIGHT     ADD CONSTRAINT PK_RIGHT PRIMARY KEY ( RIGHT_ID ) 
/

CREATE INDEX IDX_R_STARTDT_ENDDT ON RIGHT(START_DATE,END_DATE)
/

CREATE INDEX IDX_R_AUTOAPPROVE ON RIGHT(AUTO_APPROVE)
/

CREATE TABLE LINEUP 
    ( 
     LINEUP_ID NUMBER(19,0) NOT NULL , 
     DEVICE NVARCHAR2 (2) , 
     TMS_CHANNEL NVARCHAR2 (20) NOT NULL , 
     SERVICE_TIER NVARCHAR2 (1) NOT NULL , 
     EFFECTIVE_DATE TIMESTAMP(0) WITH TIME ZONE , 
     EXPIRATION_DATE TIMESTAMP(0) WITH TIME ZONE , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL , 
     HEADEND_ID NVARCHAR2(100) NOT NULL , 
     STATION_ID NVARCHAR2 (100)  NOT NULL 
    )  
/



ALTER TABLE LINEUP ADD CONSTRAINT PK_LINEUP PRIMARY KEY ( LINEUP_ID, HEADEND_ID, STATION_ID ) 
/

CREATE INDEX IDX_L_STATIONID_HEADENDID ON LINEUP(STATION_ID,HEADEND_ID)
/

CREATE TABLE RECORDING_REC_RULES_MAP 
    ( 
     RECORDING_ID NUMBER(19,0) NOT NULL , 
     RULE_ID NUMBER (19,0) NOT NULL , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL 
    )  
/



ALTER TABLE RECORDING_REC_RULES_MAP     ADD CONSTRAINT RECORDING_REC_RULES_MAP_PK PRIMARY KEY ( RECORDING_ID, RULE_ID )
/


CREATE TABLE CONTRACT 
    ( 
     CONTRACT_ID NUMBER(19,0)  NOT NULL , 
     TITLE NVARCHAR2 (500)  NOT NULL , 
     STATUS NUMBER (1,0) DEFAULT 1  NOT NULL , 
     EFFECTIVE_DATE TIMESTAMP (0) WITH TIME ZONE  NOT NULL , 
     EXPIRY_DATE TIMESTAMP (0) WITH TIME ZONE  NOT NULL , 
     NOTES NVARCHAR2 (2000) , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL , 
     COPYRIGHT_HOLDER_ID NUMBER(19,0) NOT NULL 
    )  
/



ALTER TABLE CONTRACT     ADD CONSTRAINT PK_CONTRACT PRIMARY KEY ( CONTRACT_ID ) 
/
    
CREATE INDEX IDX_CONTRACT_EFFECT_EXPIRY_DT ON CONTRACT(EFFECTIVE_DATE,EXPIRY_DATE)
/

CREATE TABLE RTC 
    ( 
     RTC_ID NUMBER (19,0)  NOT NULL , 
     NAME NVARCHAR2 (64)  NOT NULL , 
     IP_ADDRESS NVARCHAR2 (16)  NOT NULL , 
     PORT NUMBER (10,0)  NOT NULL , 
     CAPACITY NUMBER (3,0) DEFAULT 50 NOT NULL , 
     MAXIMUM_BAND_WIDTH NUMBER (10,0) , 
     MAXIMUM_STORAGE NUMBER (10,0) , 
     OPERATIONAL_STATE NUMBER (1,0) DEFAULT 0  NOT NULL , 
     REQUESTED_STATE NUMBER (1,0) DEFAULT 0  NOT NULL , 
     SERVICE_NAME NVARCHAR2 (500)  NOT NULL , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL , 
     POOL_ID NUMBER(19,0) NOT NULL 
    )  
/


ALTER TABLE RTC     ADD CONSTRAINT PK_RTC PRIMARY KEY ( RTC_ID ) 
/
    

ALTER TABLE RTC  ADD CONSTRAINT RTC_NAME_UNIQUE UNIQUE( POOL_ID , NAME) 
/
    
    

CREATE TABLE SCHEDULE 
    ( 
     SCHEDULE_ID NUMBER(19,0) NOT NULL , 
     SCHEDULE_LANGUAGE NVARCHAR2 (100) NOT NULL , 
     STATION_ID NVARCHAR2 (100)  NOT NULL , 
     PROGRAM_ID NVARCHAR2 (100)  NOT NULL , 
     START_TIME TIMESTAMP (0) WITH TIME ZONE  NOT NULL , 
     END_TIME TIMESTAMP (0) WITH TIME ZONE , 
     DURATION NUMBER (10,0) NOT NULL ,
     DAY_OF_WEEK AS (trim((to_char(start_time,'DAY')))),
     RECORDABLE NUMBER (1,0) DEFAULT 0 , 
     TV_RATING NVARCHAR2 (1000) NOT NULL , 
     HD_TV NVARCHAR2 (1) , 
     PART_NUMBER NUMBER (10,0) , 
     NO_OF_PARTS NUMBER (10,0) , 
     CC NVARCHAR2 (1) NOT NULL , 
     STEREO NVARCHAR2 (1) , 
     LIVE_TAPE_DELAY NVARCHAR2 (100) , 
     SUBTITLED NVARCHAR2 (1) , 
     PREMIERE_FINALE NVARCHAR2 (100) , 
     JOINED_IN_PROGRESS NVARCHAR2 (1) , 
     CABLE_IN_CLASSROOM NVARCHAR2 (1) , 
     SAP NVARCHAR2 (1) , 
     SEX_RATING NVARCHAR2 (1) , 
     VIOLENCE_RATING NVARCHAR2 (1) , 
     LANGUAGE_RATING NVARCHAR2 (1) , 
     DIALOG_RATING NVARCHAR2 (1) , 
     FV_RATING NVARCHAR2 (1) , 
     ENHANCED NVARCHAR2 (1) , 
     THREE_D NVARCHAR2 (1) , 
     LETTERBOX NVARCHAR2 (1) , 
     DVS NVARCHAR2 (1) , 
     REPEAT NVARCHAR2 (1) , 
     BLACKOUT NVARCHAR2 (1) , 
     DOLBY NVARCHAR2 (100) , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL 
    )  
/



ALTER TABLE SCHEDULE     ADD CONSTRAINT PK_SCHEDULE PRIMARY KEY ( SCHEDULE_ID )
/

COMMENT ON COLUMN SCHEDULE.DURATION IS 'Duration in seconds' 
/

CREATE UNIQUE INDEX IDX_SCHED_UNIQ_IND ON SCHEDULE (PROGRAM_ID,STATION_ID,START_TIME)
/

CREATE INDEX IDX_SCHED_START_END_TIME ON SCHEDULE (START_TIME,END_TIME)
/

CREATE INDEX IDX_SCHED_RECORDABLE ON SCHEDULE (RECORDABLE,START_TIME)
/


CREATE TABLE RTC_POOL 
    ( 
     POOL_ID NUMBER(19,0) NOT NULL , 
     NAME NVARCHAR2 (50) , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL , 
     RM_ID NUMBER(19,0) NOT NULL 
    )  
/



ALTER TABLE RTC_POOL     ADD CONSTRAINT PK_RTC_POOL PRIMARY KEY ( POOL_ID ) 
/

CREATE INDEX IDX_RTCPOOL_RMID ON RTC_POOL(RM_ID)
/

CREATE TABLE REC_RULES_PROGRAM_MAP 
    ( 
     RULE_ID NUMBER (19,0)  NOT NULL , 
     PROGRAM_ID NVARCHAR2 (100)  NOT NULL , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL 
    )  
/



ALTER TABLE REC_RULES_PROGRAM_MAP     ADD CONSTRAINT REC_RULES_PROGRAM_MAP_PK PRIMARY KEY ( RULE_ID, PROGRAM_ID )
/


CREATE TABLE CONTACT 
    ( 
     CONTACT_ID NUMBER(19,0) NOT NULL , 
     NAME NVARCHAR2 (250)  NOT NULL , 
     OFFICE_PHONE NVARCHAR2 (50) , 
     HOME_PHONE NVARCHAR2 (50) , 
     CELL_PHONE NVARCHAR2 (50) , 
     FAX NVARCHAR2 (50) , 
     EMAIL NVARCHAR2 (50) , 
     NOTES NVARCHAR2 (2000) , 
     PRIMARY_CONTACT NUMBER (1,0) DEFAULT 0 , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL , 
     COPYRIGHT_HOLDER_ID NUMBER(19,0) 
    )  
/



ALTER TABLE CONTACT     ADD CONSTRAINT PK_CONTACT PRIMARY KEY ( CONTACT_ID )
/

CREATE INDEX IDX_CONTACT_COPYRGHTID ON CONTACT(COPYRIGHT_HOLDER_ID)
/


CREATE TABLE EPG_PROVIDER_CONFIG 
    ( 
     EPG_PROVIDER_ID NUMBER (19,0) NOT NULL , 
     NAME NVARCHAR2 (250)  UNIQUE NOT NULL , 
     PATH NVARCHAR2 (250)  NOT NULL , 
     EPG_READ_FREQUENCY NUMBER(10,0) NOT NULL , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL 
    )  
/



ALTER TABLE EPG_PROVIDER_CONFIG     ADD CONSTRAINT PK_EPG_PROVIDER_CONFIG PRIMARY KEY ( EPG_PROVIDER_ID ) 
/
    



CREATE TABLE CAST_CREDITS 
    ( 
     CAST_CREDITS_ID NUMBER (19,0) NOT NULL , 
     PROGRAM_ID NVARCHAR2 (100)  NOT NULL , 
     FIRST_NAME NVARCHAR2 (100) , 
     LAST_NAME NVARCHAR2 (100) , 
     DESCRIPTION NVARCHAR2 (100) , 
     TYPE NVARCHAR2 (100)  NOT NULL , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL 
    )  
/



ALTER TABLE CAST_CREDITS     ADD CONSTRAINT PK_CAST_CREDITS PRIMARY KEY ( CAST_CREDITS_ID )
/

CREATE INDEX IDX_CC_PROGRAMID ON CAST_CREDITS(PROGRAM_ID)
/

CREATE TABLE COPYRIGHT_HOLDER 
    ( 
     COPYRIGHT_HOLDER_ID NUMBER (19,0) NOT NULL , 
     NAME NVARCHAR2 (250)   NOT NULL , 
     COMPANY_NAME NVARCHAR2 (250)  NOT NULL , 
     ADDRESS NVARCHAR2 (250) , 
     CITY NVARCHAR2 (50) , 
     STATE NVARCHAR2 (50) ,
     STATUS NUMBER(1,0) DEFAULT 1 NOT NULL, 
     ZIPCODE NVARCHAR2 (50) , 
     COUNTRY NVARCHAR2 (50) , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL 
    )  
/



ALTER TABLE COPYRIGHT_HOLDER     ADD CONSTRAINT PK_COPYRIGHT_HOLDER PRIMARY KEY ( COPYRIGHT_HOLDER_ID ) 
/
    
CREATE INDEX IDX_CH_NAME_STATUS ON COPYRIGHT_HOLDER(NAME,STATUS)
/

CREATE TABLE CONTRACT_DOCUEMENT 
    ( 
     CONTRACT_DOCUMENT_ID NUMBER (19,0)  NOT NULL , 
     CONTRACT_FILE_NAME NVARCHAR2 (250)  NOT NULL , 
     CONTRACT_FILE BLOB  NOT NULL , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL , 
     CONTRACT_ID NUMBER(19,0) NOT NULL 
    )  
/


ALTER TABLE CONTRACT_DOCUEMENT     ADD CONSTRAINT PK_CONTRACT_DOCUMENT PRIMARY KEY ( CONTRACT_DOCUMENT_ID )
/

ALTER TABLE CONTRACT_DOCUEMENT     ADD CONSTRAINT FILE_NAME_UNIQUE UNIQUE ( CONTRACT_ID, CONTRACT_FILE_NAME ) 
/


CREATE TABLE RIGHT_PROGRAM_MAP 
    ( 
     RIGHT_ID NUMBER(19,0) NOT NULL , 
     PROGRAM_ID NVARCHAR2 (100)  NOT NULL , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL 
    )  
/



ALTER TABLE RIGHT_PROGRAM_MAP     ADD CONSTRAINT RIGHT_PROGRAM_MAPPING_PK PRIMARY KEY ( PROGRAM_ID, RIGHT_ID ) 
/


CREATE TABLE RECORDING 
    ( 
     RECORDING_ID NUMBER(19,0) NOT NULL , 
     PROGRAM_TITLE NVARCHAR2 (1000) , 
     PROGRAM_DESCRIPTION NVARCHAR2 (2000) , 
     OFFSET_START_TIME NUMBER(22,0) , 
     OFFSET_END_TIME NUMBER(22,0) , 
     RECORDING_MODE NVARCHAR2 (50) , 
     PRIORITY NUMBER (2,0) , 
     PROVIDER_QA_CONTACT NVARCHAR2 (128) , 
     CATALOG_ENTRY NUMBER (1,0) , 
     BILLING_ID NVARCHAR2 (5)  NOT NULL , 
     MPAA_RATING NVARCHAR2 (1000)  NOT NULL , 
     TV_RATING NVARCHAR2 (1000)  NOT NULL , 
     PROVIDER_ID NVARCHAR2 (20)  NOT NULL , 
     PROVIDER_NAME NVARCHAR2 (128)  NOT NULL ,
     PRODUCT NVARCHAR2 (20)  NOT NULL , 
     "CATEGORY" NVARCHAR2 (256)  NOT NULL ,
     STATUS NUMBER(2,0) DEFAULT 3 NOT NULL , 
     AUDIO_TYPE NVARCHAR2 (14)  NOT NULL , 
     MAX_COPIES NUMBER (10,0) ,
     PREVIEW_PERIOD NUMBER(10,0),
     LICENCE_START_DATE TIMESTAMP (0) WITH TIME ZONE , 
     LICENSE_END_DATE TIMESTAMP (0) WITH TIME ZONE  NOT NULL ,
     APPROVAL_TYPE NVARCHAR2(100) DEFAULT 'AUTO' NOT NULL, 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL , 
     SCHEDULE_ID NUMBER(19,0) NOT NULL,
     HEADEND_ID NVARCHAR2(100) NOT NULL 
    )  
/



ALTER TABLE RECORDING     ADD CONSTRAINT PK_RECORDING PRIMARY KEY ( RECORDING_ID ) 
/

ALTER TABLE RECORDING     ADD CONSTRAINT RECORDING_UK0 UNIQUE ( SCHEDULE_ID, HEADEND_ID ) 
/

CREATE TABLE RECORDING_QUEUE 
    (
     RECORDING_QUEUE_ID NUMBER(19,0) NOT NULL,
     RECORDING_ID NUMBER(19,0) NOT NULL , 
     SCHEDULE_ID NUMBER(19,0) NOT NULL , 
     POOL_ID NUMBER(19,0) NOT NULL , 
     RM_ID NUMBER(19,0) NOT NULL ,
     SCHEDULE_START_TIME TIMESTAMP (0) WITH TIME ZONE  NOT NULL , 
     SCHEDULE_END_TIME TIMESTAMP (0) WITH TIME ZONE , 
     SCHEDULE_DURATION NUMBER (10,0) ,
     STATION_ID NVARCHAR2 (100)  NOT NULL , 
     PROGRAM_ID NVARCHAR2 (100)  NOT NULL , 
     HD_TV NVARCHAR2 (1) , 
     CC NVARCHAR2 (1) , 
     REPEAT NVARCHAR2 (1) ,
     RM_NAME NVARCHAR2 (64) NOT NULL , 
     RM_IP_ADDRESS NVARCHAR2 (16)  NOT NULL , 
     RM_PORT NUMBER (10,0)  NOT NULL ,
     EPISODE_TITLE NVARCHAR2 (1000) ,
     STATION_OFFSET NUMBER (10,0) DEFAULT 0  NOT NULL ,
     HEADEND_NAME NVARCHAR2 (1000) ,
     CONTRACT_ID NUMBER(19,0) NOT NULL ,
     YEAR_PROGRAM NVARCHAR2 (100) ,
     ASSET_ID NVARCHAR2 (100)  NOT NULL ,
     TITLE_ASSET_ID NVARCHAR2 (100)  NOT NULL ,
     MOVIE_ASSET_ID NVARCHAR2 (100)  NOT NULL ,
     PROGRAM_TITLE NVARCHAR2 (1000) , 
     PROGRAM_DESCRIPTION NVARCHAR2 (2000) , 
     OFFSET_START_TIME NUMBER(22,0) , 
     OFFSET_END_TIME NUMBER(22,0) , 
     RECORDING_MODE NVARCHAR2 (50) , 
     PRIORITY NUMBER (2,0) ,
     STATE NUMBER (2,0) DEFAULT 0  NOT NULL ,  
     PROVIDER_QA_CONTACT NVARCHAR2 (128) , 
     CATALOG_ENTRY NUMBER (1,0) , 
     BILLING_ID NVARCHAR2 (5) , 
     MPAA_RATING NVARCHAR2 (1000) , 
     TV_RATING NVARCHAR2 (1000) , 
     PROVIDER_ID NVARCHAR2 (20) NOT NULL , 
     PROVIDER_NAME NVARCHAR2 (128) NOT NULL,
     PRODUCT NVARCHAR2 (20) , 
     CATEGORY NVARCHAR2 (256) , 
     AUDIO_TYPE NVARCHAR2 (14) , 
     MAX_COPIES NUMBER (10,0) ,
     PREVIEW_PERIOD NUMBER(10,0),
     LICENCE_START_DATE TIMESTAMP (0) WITH TIME ZONE , 
     LICENSE_END_DATE TIMESTAMP (0) WITH TIME ZONE ,
     REQUEST_TYPE NUMBER (2,0) NOT NULL, 
     VOD_START_TIME NUMBER (10,0) , 
     VOD_DURATION NUMBER (10,0) , 
     VOD_RESTRICTIONS NVARCHAR2 (100) ,
     RTI_START_TIME NUMBER (10,0) , 
     RTI_DURATION NUMBER (10,0) , 
     RTI_RESTRICTIONS NVARCHAR2 (100) ,
     QC_START_TIME NUMBER (10,0) , 
     QC_DURATION NUMBER (10,0) , 
     QC_RESTRICTIONS NVARCHAR2 (100) ,  
     ADVISORIES	NVARCHAR2 (1024) ,   
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE DATE  NOT NULL , 
     UPDATE_DATE DATE  NOT NULL 
    ) LOGGING 
/

ALTER TABLE RECORDING_QUEUE 
    ADD CONSTRAINT PK_RECORDING_QUEUE PRIMARY KEY ( RECORDING_QUEUE_ID ) 
/

CREATE TABLE ERROR_CODE 
    ( 
     ERROR_CODE NUMBER (5,0)  NOT NULL , 
     DESCRIPTION NVARCHAR2 (250)  NOT NULL , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL 
    )  
/



ALTER TABLE ERROR_CODE     ADD CONSTRAINT ERROR_CODE_PK PRIMARY KEY ( ERROR_CODE ) 
/


CREATE TABLE RECORDABLE_RIGHTS_MAP 
    ( 
     SCHEDULE_ID NUMBER(19,0) NOT NULL , 
     RIGHT_ID NUMBER(19,0) NOT NULL , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL 
    )  
/



ALTER TABLE RECORDABLE_RIGHTS_MAP     ADD CONSTRAINT RECORDABLE_RIGHTS_MAP_PK PRIMARY KEY ( SCHEDULE_ID, RIGHT_ID ) 
/


CREATE TABLE RECORDING_LOG 
    ( 
    RECORDING_LOG_ID	NUMBER(19,0) NOT NULL,
    RECORDING_ID    	NUMBER(19,0) NOT NULL,
    POOL_ID         	NUMBER(19,0),
    LOG_MESSAGE     	NVARCHAR2(2000) NOT NULL,
    CREATED_BY      	NVARCHAR2(50) NOT NULL,
    UPDATED_BY      	NVARCHAR2(50) NOT NULL,
    CREATE_DATE     	TIMESTAMP(0) WITH TIME ZONE  NOT NULL,
    UPDATE_DATE     	TIMESTAMP(0) WITH TIME ZONE  NOT NULL
    )  
/


ALTER TABLE RECORDING_LOG     ADD CONSTRAINT PK_RECORDING_LOG PRIMARY KEY ( RECORDING_LOG_ID ) 
/

CREATE INDEX IDX_RECORDLOG_RECORDINGID ON RECORDING_LOG(RECORDING_ID)
/

CREATE TABLE RM 
    ( 
     RM_ID NUMBER (19,0)  NOT NULL , 
     NAME NVARCHAR2 (64) UNIQUE NOT NULL , 
     IP_ADDRESS NVARCHAR2 (16)  NOT NULL , 
     PORT NUMBER (10, 0)  NOT NULL , 
     BACK_OFFICE_IP_ADDRESS NVARCHAR2(16)  NOT NULL , 
     BACK_OFFICE_PORT NUMBER (5, 0)  NOT NULL , 
     EXPORT_ATTEMPTS NUMBER (2, 0)  NOT NULL , 
     EXPORT_ATTEMPTS_INTERVAL NUMBER(10, 0)  NOT NULL , 
     OPERATIONAL_STATE NUMBER (1,0) DEFAULT 0  NOT NULL , 
     REQUESTED_STATE NUMBER (1,0) DEFAULT 0 , 
     PACKAGER_URL NVARCHAR2 (250) ,
     RM_TYPE NVARCHAR2 (50)  NOT NULL ,
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL , 
     HEADEND_ID NVARCHAR2(100) NOT NULL 
    )  
/



ALTER TABLE RM     ADD CONSTRAINT PK_RTM PRIMARY KEY ( RM_ID ) 
/

CREATE INDEX IDX_RM_HEADENDID ON RM(HEADEND_ID)
/


CREATE TABLE HEADEND 
    ( 
     HEADEND_ID NVARCHAR2(100) NOT NULL , 
     COMMUNITY_NAME NVARCHAR2 (200) , 
     COUNTY_NAME NVARCHAR2 (200) , 
     COUNTY_SIZE NVARCHAR2 (1) , 
     ST_COUNTY_CODE NVARCHAR2 (100) , 
     STATE NVARCHAR2 (64) , 
     ZIPCODE NVARCHAR2 (100), 
     DMA_CODE NVARCHAR2 (100) , 
     DMA_NAME NVARCHAR2 (300) , 
     MSO_CODE NUMBER(22,0) , 
     DMA_RANK NVARCHAR2 (10) , 
     HEADEND_NAME NVARCHAR2 (1000) , 
     HEADEND_LOCATION NVARCHAR2 (100) NOT NULL , 
     MSO_NAME NVARCHAR2 (200) NOT NULL , 
     TIME_ZONE NVARCHAR2 (100) NOT NULL , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL 
    )  
/


ALTER TABLE HEADEND     ADD CONSTRAINT PK_HEADEND PRIMARY KEY ( HEADEND_ID ) 
/


CREATE TABLE RECORDING_RTC_POOL_MAP 
    ( 
     RECORDING_ID NUMBER(19,0) NOT NULL , 
     POOL_ID NUMBER(19,0) NOT NULL , 
     ASSET_ID NVARCHAR2 (100)  NOT NULL ,
     TITLE_ASSET_ID NVARCHAR2 (100)  NOT NULL ,
     MOVIE_ASSET_ID NVARCHAR2 (100)  NOT NULL ,
     STATUS_CODE      	NUMBER(10,0) NOT NULL,
     ADJUSTED_START_TIME TIMESTAMP (0) WITH TIME ZONE NOT NULL , 
     ADJUSTED_END_TIME TIMESTAMP (0) WITH TIME ZONE NOT NULL , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL 
    )  
/



ALTER TABLE RECORDING_RTC_POOL_MAP    ADD CONSTRAINT PK_REC_RTC_POOL_MAP PRIMARY KEY ( RECORDING_ID, POOL_ID ) 
/


CREATE TABLE PLAYBACK_WINDOW_RESTRICTIONS 
    ( 
     RESTRICTION_ID NUMBER (19,0) NOT NULL , 
     START_TIME NUMBER (10,0) DEFAULT 0  NOT NULL , 
     DURATION NUMBER (10,0) DEFAULT 0  NOT NULL , 
     RESTRICTIONS NVARCHAR2 (100) , 
     TYPE NVARCHAR2 (100)  NOT NULL , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL , 
     RIGHT_ID NUMBER(19,0) , 
     RECORDING_ID NUMBER(19,0) 
     )  
/

ALTER TABLE PLAYBACK_WINDOW_RESTRICTIONS     ADD CONSTRAINT PK_PLAYBACK_WINDOW_RESTR PRIMARY KEY ( RESTRICTION_ID ) 
/

CREATE INDEX IDX_PWR_RIGHTID ON PLAYBACK_WINDOW_RESTRICTIONS(RIGHT_ID)
/

CREATE INDEX IDX_PWR_RECORDINGID ON PLAYBACK_WINDOW_RESTRICTIONS(RECORDING_ID)
/


CREATE TABLE STATION 
    ( 
     STATION_ID NVARCHAR2 (100)  NOT NULL , 
     STATION_NAME NVARCHAR2 (100) , 
     TIME_ZONE NVARCHAR2 (100) , 
     CALL_SIGN NVARCHAR2 (100) NOT NULL , 
     CITY NVARCHAR2 (100) , 
     STATE NVARCHAR2 (100) , 
     ZIPCODE NVARCHAR2 (100) , 
     COUNTRY NVARCHAR2 (100) , 
     DMA_NAME NVARCHAR2 (100) , 
     DMA_NUMBER NVARCHAR2 (100) , 
     FCC_CHANNEL_NUM NVARCHAR2 (100) , 
     AFFILIATION NVARCHAR2 (100) NOT NULL ,
     STATION_LOCKED NVARCHAR2(1) DEFAULT 'N',
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL 
    )  
/

ALTER TABLE STATION     ADD CONSTRAINT PK_STATION PRIMARY KEY ( STATION_ID ) 
/

CREATE INDEX IDX_STATION_CALLSIGN ON STATION(CALL_SIGN)
/

CREATE INDEX IDX_STATION_STATIONNAME ON STATION(STATION_NAME)
/


CREATE TABLE REC_RULES_SERIES_MAP 
    ( 
     RULE_ID NUMBER (19,0)  NOT NULL , 
     SERIES_ID NVARCHAR2 (100)  NOT NULL , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL 
    )  
/



ALTER TABLE REC_RULES_SERIES_MAP     ADD CONSTRAINT REC_RULES_SERIES_MAP_PK PRIMARY KEY ( RULE_ID, SERIES_ID ) 
/




CREATE TABLE SERIES 
    ( 
     SERIES_ID NVARCHAR2 (100)  NOT NULL , 
     TITLE NVARCHAR2 (250) , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL 
    )  
/



ALTER TABLE SERIES     ADD CONSTRAINT PK_SERIES PRIMARY KEY ( SERIES_ID ) 
/


CREATE TABLE RECORDING_RULES 
    ( 
     RULE_ID NUMBER (19,0)  NOT NULL , 
     NAME NVARCHAR2 (250)  NOT NULL , 
     START_TIME TIMESTAMP(0) WITH TIME ZONE , 
     END_TIME TIMESTAMP(0) WITH TIME ZONE , 
     DAY_OF_WEEK NVARCHAR2 (100) , 
     STATE NUMBER (1,0) DEFAULT 1  NOT NULL , 
     REPEAT NVARCHAR2(1)  , 
     HD  NVARCHAR2(1) , 
     LIVE  NVARCHAR2(100) , 
     BILLING_ID NVARCHAR2(5) DEFAULT 0  NOT NULL , 
     MPAA_RATING NVARCHAR2 (1000)  NOT NULL , 
     OFFSET_START_TIME NUMBER (22,0) , 
     OFFSET_END_TIME NUMBER (22,0) , 
     PRIORITY NUMBER (2,0)  NOT NULL , 
     TV_RATING NVARCHAR2 (1000)  NOT NULL , 
     CATEGORY NVARCHAR2 (256)  NOT NULL , 
     PRODUCT NVARCHAR2 (20) , 
     PROVIDER_ID NVARCHAR2 (20)  NOT NULL , 
     PROVIDER_NAME NVARCHAR2 (128) NOT NULL ,
     AUDIO_TYPE NVARCHAR2 (14) , 
     PROVIDER_QA_CONTACT NVARCHAR2 (128) , 
     MAX_COPIES NUMBER (10,0) , 
     PREVIEW_PERIOD NUMBER(10,0),
     CATALOG_ENTRY NUMBER (1,0) DEFAULT 0  NOT NULL , 
     AUTO_APPROVE NUMBER (1,0) DEFAULT 0  NOT NULL , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL 
    )  
/



ALTER TABLE RECORDING_RULES     ADD CONSTRAINT RECORDING_RULES_PK PRIMARY KEY ( RULE_ID ) 
/

CREATE INDEX IDX_RR_STATE_STTM_EDTM ON RECORDING_RULES(STATE,START_TIME,END_TIME)
/

CREATE TABLE RIGHT_STATION_MAP 
    ( 
     RIGHT_ID NUMBER(19,0) NOT NULL , 
     STATION_ID NVARCHAR2 (100)  NOT NULL , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL 
    )  
/



ALTER TABLE RIGHT_STATION_MAP     ADD CONSTRAINT PK_RIGHT_STATION_MAP PRIMARY KEY ( RIGHT_ID, STATION_ID ) 
/


CREATE TABLE SERIES_PROGRAM_MAP 
    ( 
     SERIES_ID NVARCHAR2 (100)  NOT NULL , 
     PROGRAM_ID NVARCHAR2 (100)  NOT NULL , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL 
    )  
/



ALTER TABLE SERIES_PROGRAM_MAP     ADD CONSTRAINT PK_SERIES_PRG_MAP PRIMARY KEY ( SERIES_ID, PROGRAM_ID ) 
/


CREATE TABLE TSTV_USER 
    ( 
     USER_ID NUMBER (19,0)  NOT NULL , 
     TELEPHONE_NUMBER NVARCHAR2 (16) , 
     EMAIL NVARCHAR2 (16) , 
     USER_NAME NVARCHAR2 (16) , 
     FIRST_NAME NVARCHAR2 (16) , 
     PASSWORD NVARCHAR2 (16) , 
     LAST_NAME NVARCHAR2 (16) , 
     USER_ROLE NUMBER (10,0) , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP  NOT NULL , 
     UPDATE_DATE TIMESTAMP  NOT NULL 
    )  
/



ALTER TABLE TSTV_USER     ADD CONSTRAINT PK_TSTV_USER PRIMARY KEY ( USER_ID ) 
/

ALTER TABLE TSTV_USER     ADD CONSTRAINT TSTV_USER_UK0 UNIQUE ( USER_NAME ) 
/


CREATE TABLE METADATA_CONFIG
	(
     ID_ NVARCHAR2 (1024) NOT NULL , 
     NAME NVARCHAR2 (1024) NOT NULL , 
     TYPE NVARCHAR2 (100) NOT NULL , 
     CREATED_BY NVARCHAR2 (50)  NOT NULL , 
     UPDATED_BY NVARCHAR2 (50)  NOT NULL , 
     CREATE_DATE TIMESTAMP(0)  NOT NULL , 
     UPDATE_DATE TIMESTAMP(0)  NOT NULL 
	)
/

ALTER TABLE METADATA_CONFIG     ADD CONSTRAINT PK_METADATA_CONFIG PRIMARY KEY ("ID_", "NAME", "TYPE" ) 
/


ALTER TABLE RM 
    ADD CONSTRAINT FK_RM_HE FOREIGN KEY 
    ( 
     HEADEND_ID
    ) 
    REFERENCES HEADEND 
    ( 
     HEADEND_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE LINEUP 
    ADD CONSTRAINT FK_LINEUP_STATION FOREIGN KEY 
    ( 
     STATION_ID
    ) 
    REFERENCES STATION 
    ( 
     STATION_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE ADI_XML_SITE 
    ADD CONSTRAINT ADI_XML_SITE_RM_FK FOREIGN KEY 
    ( 
     RM_ID
    ) 
    REFERENCES RM 
    ( 
     RM_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE ALARM_ACTIVITYLOG 
    ADD CONSTRAINT ALARM_ERR_CODE_FK FOREIGN KEY 
    ( 
     ERROR_CODE
    ) 
    REFERENCES ERROR_CODE 
    ( 
     ERROR_CODE
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE RECORDING_RTC_POOL_MAP 
    ADD CONSTRAINT FK_REC_RTC_POOL_MAP_RTC_POOL FOREIGN KEY 
    ( 
     POOL_ID
    ) 
    REFERENCES RTC_POOL 
    ( 
     POOL_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE PLAYBACK_WINDOW_RESTRICTIONS 
    ADD CONSTRAINT FK_PLAYBACK_RESTR_RIGHT FOREIGN KEY 
    ( 
     RIGHT_ID
    ) 
    REFERENCES RIGHT 
    ( 
     RIGHT_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE CONTRACT 
    ADD CONSTRAINT FK_CONTRACT_CPYRGHT_HLDR FOREIGN KEY 
    ( 
     COPYRIGHT_HOLDER_ID
    ) 
    REFERENCES COPYRIGHT_HOLDER 
    ( 
     COPYRIGHT_HOLDER_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE CONTRACT_DOCUEMENT 
    ADD CONSTRAINT FK_CONTRACT_DOCUMENT_CONTRACT FOREIGN KEY 
    ( 
     CONTRACT_ID
    ) 
    REFERENCES CONTRACT 
    ( 
     CONTRACT_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE REC_RULES_SERIES_MAP 
    ADD CONSTRAINT REC_RULES_SERIES_MAP_FK FOREIGN KEY 
    ( 
     RULE_ID
    ) 
    REFERENCES RECORDING_RULES 
    ( 
     RULE_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE RIGHT_SERIES_MAP 
    ADD CONSTRAINT RIGHT_SERIES_MAPPING_RIGHT_FK FOREIGN KEY 
    ( 
     RIGHT_ID
    ) 
    REFERENCES RIGHT 
    ( 
     RIGHT_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE RM_LINEUP 
    ADD CONSTRAINT FK_RM_LINEUP_LINEUP FOREIGN KEY 
    ( 
     LINEUP_ID,
     HEADEND_ID,
     STATION_ID
    ) 
    REFERENCES LINEUP 
    ( 
     LINEUP_ID,
     HEADEND_ID,
     STATION_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE RIGHT_RM_MAP 
    ADD CONSTRAINT FK_RIGHT_RM_MAP_RM FOREIGN KEY 
    ( 
     RM_ID
    ) 
    REFERENCES RM 
    ( 
     RM_ID
    ) 
    NOT DEFERRABLE 
/

ALTER TABLE RIGHT_EXCLUDED_RM_MAP 
    ADD CONSTRAINT FK_RIGHT_EXCLUDED_RM_MAP_RM FOREIGN KEY 
    ( 
     RM_ID
    ) 
    REFERENCES RM 
    ( 
     RM_ID
    ) 
    NOT DEFERRABLE 
/

ALTER TABLE RIGHT 
    ADD CONSTRAINT FK_RIGHT_CONTRACT FOREIGN KEY 
    ( 
     CONTRACT_ID
    ) 
    REFERENCES CONTRACT 
    ( 
     CONTRACT_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE ALARM_ACTIVITYLOG 
    ADD CONSTRAINT FK_ALARM_SELF FOREIGN KEY 
    ( 
     REFERENCE_ID
    ) 
    REFERENCES ALARM_ACTIVITYLOG 
    ( 
     ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE RIGHT_STATION_MAP 
    ADD CONSTRAINT RIGHT_STATN_MAP_STATN_FK FOREIGN KEY 
    ( 
     STATION_ID
    ) 
    REFERENCES STATION 
    ( 
     STATION_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE REC_RULES_SERIES_MAP 
    ADD CONSTRAINT REC_RULES_SERIES_MAP_SERIES_FK FOREIGN KEY 
    ( 
     SERIES_ID
    ) 
    REFERENCES SERIES 
    ( 
     SERIES_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE LINEUP 
    ADD CONSTRAINT FK_HEADEND_LINEUP FOREIGN KEY 
    ( 
     HEADEND_ID
    ) 
    REFERENCES HEADEND 
    ( 
     HEADEND_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE CONTACT 
    ADD CONSTRAINT FK_CONTACT_COPYRIGHT_HOLDER FOREIGN KEY 
    ( 
     COPYRIGHT_HOLDER_ID
    ) 
    REFERENCES COPYRIGHT_HOLDER 
    ( 
     COPYRIGHT_HOLDER_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE RTC_POOL 
    ADD CONSTRAINT FK_RTC_POOL_RM FOREIGN KEY 
    ( 
     RM_ID
    ) 
    REFERENCES RM 
    ( 
     RM_ID
    ) 
    NOT DEFERRABLE 
/




ALTER TABLE PLAYBACK_WINDOW_RESTRICTIONS 
    ADD CONSTRAINT FK_PLAYBACK_RESTR_REC FOREIGN KEY 
    ( 
     RECORDING_ID
    ) 
    REFERENCES RECORDING 
    ( 
     RECORDING_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE SERIES_PROGRAM_MAP 
    ADD CONSTRAINT FK_SERIES_PRG_MAP_SERIES FOREIGN KEY 
    ( 
     SERIES_ID
    ) 
    REFERENCES SERIES 
    ( 
     SERIES_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE RIGHT_PROGRAM_MAP 
    ADD CONSTRAINT RIGHT_PRG_MAP_RIGHT_FK FOREIGN KEY 
    ( 
     RIGHT_ID
    ) 
    REFERENCES RIGHT 
    ( 
     RIGHT_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE RM_LINEUP 
    ADD CONSTRAINT FK_RM_LINEUP_RM FOREIGN KEY 
    ( 
     RM_ID
    ) 
    REFERENCES RM 
    ( 
     RM_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE REC_RULES_PROGRAM_MAP 
    ADD CONSTRAINT REC_RULES_PRG_MAP_FK FOREIGN KEY 
    ( 
     RULE_ID
    ) 
    REFERENCES RECORDING_RULES 
    ( 
     RULE_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE RECORDING_LOG 
    ADD CONSTRAINT FK_REC_LOG_REC_RTC_POOL_MAP FOREIGN KEY 
    ( 
     RECORDING_ID,
     POOL_ID
    ) 
    REFERENCES RECORDING_RTC_POOL_MAP 
    ( 
     RECORDING_ID,
     POOL_ID
    ) 
    NOT DEFERRABLE 
/

ALTER TABLE RIGHT_PROGRAM_MAP 
    ADD CONSTRAINT RIGHT_PRG_MAP_PRG_FK FOREIGN KEY 
    ( 
     PROGRAM_ID
    ) 
    REFERENCES PROGRAM 
    ( 
     PROGRAM_ID
    ) 
    NOT DEFERRABLE 
/



ALTER TABLE RECORDING_RTC_POOL_MAP 
    ADD CONSTRAINT FK_REC_RTC_POOL_MAP_RECORDING FOREIGN KEY 
    ( 
     RECORDING_ID
    ) 
    REFERENCES RECORDING 
    ( 
     RECORDING_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE SCHEDULE 
    ADD CONSTRAINT FK_STATION_SCHEDULE FOREIGN KEY 
    ( 
     STATION_ID
    ) 
    REFERENCES STATION 
    ( 
     STATION_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE REC_RULES_PROGRAM_MAP 
    ADD CONSTRAINT REC_RULES_PRG_MAP_PRG_FK FOREIGN KEY 
    ( 
     PROGRAM_ID
    ) 
    REFERENCES PROGRAM 
    ( 
     PROGRAM_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE RECORDING 
    ADD CONSTRAINT FK_RECORDING_SCHEDULE FOREIGN KEY 
    ( 
     SCHEDULE_ID
    ) 
    REFERENCES SCHEDULE 
    ( 
     SCHEDULE_ID
    ) 
    NOT DEFERRABLE 
/

ALTER TABLE RECORDING ADD CONSTRAINT FK_RECORDING_HEADENDID FOREIGN KEY(HEADEND_ID) 
    REFERENCES HEADEND ( HEADEND_ID) 
    NOT DEFERRABLE 
/


ALTER TABLE RIGHT_SERIES_MAP 
    ADD CONSTRAINT RIGHT_SERIES_MAPPING_SERIES_FK FOREIGN KEY 
    ( 
     SERIES_ID
    ) 
    REFERENCES SERIES 
    ( 
     SERIES_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE RECORDABLE_RIGHTS_MAP 
    ADD CONSTRAINT FK_REC_RIGHTS_MAP_SCH FOREIGN KEY 
    ( 
     SCHEDULE_ID
    ) 
    REFERENCES SCHEDULE 
    ( 
     SCHEDULE_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE RIGHT_RM_MAP 
    ADD CONSTRAINT FK_RIGHT_RM_MAP_RIGHT FOREIGN KEY 
    ( 
     RIGHT_ID
    ) 
    REFERENCES RIGHT 
    ( 
     RIGHT_ID
    ) 
    NOT DEFERRABLE 
/
ALTER TABLE RIGHT_EXCLUDED_RM_MAP 
    ADD CONSTRAINT FK_RIGHT_EXCL_RM_MAP_RIGHT FOREIGN KEY 
    ( 
     RIGHT_ID
    ) 
    REFERENCES RIGHT 
    ( 
     RIGHT_ID
    ) 
    NOT DEFERRABLE 
/

ALTER TABLE REC_RULES_STATION_MAP 
    ADD CONSTRAINT REC_RULES_STATION_MAP_FK FOREIGN KEY 
    ( 
     STATION_ID
    ) 
    REFERENCES STATION 
    ( 
     STATION_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE RECORDING_REC_RULES_MAP 
    ADD CONSTRAINT FK_REC_REC_RULES_MAP FOREIGN KEY 
    ( 
     RECORDING_ID
    ) 
    REFERENCES RECORDING 
    ( 
     RECORDING_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE RIGHT_STATION_MAP 
    ADD CONSTRAINT FK_RIGHT_STATION_MAP_RIGHT FOREIGN KEY 
    ( 
     RIGHT_ID
    ) 
    REFERENCES RIGHT 
    ( 
     RIGHT_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE REC_RULES_STATION_MAP 
    ADD CONSTRAINT REC_RULES_FK FOREIGN KEY 
    ( 
     RULE_ID
    ) 
    REFERENCES RECORDING_RULES 
    ( 
     RULE_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE RECORDABLE_RIGHTS_MAP 
    ADD CONSTRAINT FK_REC_RIGHTS_MAP_RIGHT FOREIGN KEY 
    ( 
     RIGHT_ID
    ) 
    REFERENCES RIGHT 
    ( 
     RIGHT_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE SERIES_PROGRAM_MAP 
    ADD CONSTRAINT FK_SERIES_PRG_MAP_PRG FOREIGN KEY 
    ( 
     PROGRAM_ID
    ) 
    REFERENCES PROGRAM 
    ( 
     PROGRAM_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE CAST_CREDITS 
    ADD CONSTRAINT FK_PROGRAM_CAST_CREW FOREIGN KEY 
    ( 
     PROGRAM_ID
    ) 
    REFERENCES PROGRAM 
    ( 
     PROGRAM_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE RECORDING_REC_RULES_MAP 
    ADD CONSTRAINT FK_REC_RULES_MAP_REC_RULES_FK FOREIGN KEY 
    ( 
     RULE_ID
    ) 
    REFERENCES RECORDING_RULES 
    ( 
     RULE_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE SCHEDULE 
    ADD CONSTRAINT FK_SCHEDULE_PROGRAM FOREIGN KEY 
    ( 
     PROGRAM_ID
    ) 
    REFERENCES PROGRAM 
    ( 
     PROGRAM_ID
    ) 
    NOT DEFERRABLE 
/


ALTER TABLE RTC 
    ADD CONSTRAINT FK_RTC_RTC_POOL FOREIGN KEY 
    ( 
     POOL_ID
    ) 
    REFERENCES RTC_POOL 
    ( 
     POOL_ID
    ) 
    NOT DEFERRABLE 
/

CREATE SEQUENCE CONTACT_SEQ
	MINVALUE 1
	MAXVALUE 9223372036854775806
	START WITH 1
    INCREMENT BY 1
    CYCLE
/

CREATE SEQUENCE CONTRACT_SEQ 
	MINVALUE 1
	MAXVALUE 9223372036854775806
	START WITH 1
    INCREMENT BY 1
    CYCLE
/


CREATE SEQUENCE RIGHT_SEQ 
	MINVALUE 1
	MAXVALUE 9223372036854775806
	START WITH 1
    INCREMENT BY 1
    CYCLE
/

CREATE SEQUENCE RTC_SEQ 
	MINVALUE 1
	MAXVALUE 9223372036854775806
	START WITH 1
    INCREMENT BY 1
    CYCLE
/

CREATE SEQUENCE RM_SEQ 
	MINVALUE 1
	MAXVALUE 9223372036854775806
	START WITH 1
    INCREMENT BY 1
    CYCLE
/

CREATE SEQUENCE CONTRACT_DOCUMENT_SEQ 
	MINVALUE 1
	MAXVALUE 9223372036854775806
	START WITH 1
    INCREMENT BY 1
    CYCLE
/

CREATE SEQUENCE RECORDING_SEQ 
	MINVALUE 1
	MAXVALUE 9223372036854775806
	START WITH 1
    INCREMENT BY 1
    CYCLE
/

CREATE SEQUENCE RECORDING_QUEUE_SEQ
	MINVALUE 1
	MAXVALUE 9223372036854775806
	START WITH 1
    INCREMENT BY 1
    CYCLE
/

CREATE SEQUENCE RTC_POOL_SEQ 
	MINVALUE 1
	MAXVALUE 9223372036854775806
	START WITH 1
    INCREMENT BY 1
    CYCLE
/

CREATE SEQUENCE TSTV_USER_SEQ 
	MINVALUE 1
	MAXVALUE 9223372036854775806
	START WITH 1
    INCREMENT BY 1
    CYCLE
/

CREATE SEQUENCE SCHEDULE_SEQ 
	MINVALUE 1
	MAXVALUE 9223372036854775806
	START WITH 1
    INCREMENT BY 1
    CYCLE
/

CREATE SEQUENCE CAST_CREDITS_SEQ 
	MINVALUE 1
	MAXVALUE 9223372036854775806
	START WITH 1
    INCREMENT BY 1
    CYCLE
/

CREATE SEQUENCE RECORDING_RULES_SEQ 
	MINVALUE 1
	MAXVALUE 9223372036854775806
	START WITH 1
    INCREMENT BY 1
    CYCLE
/

CREATE SEQUENCE EPG_PROVIDER_CONFIG_SEQ 
	MINVALUE 1
	MAXVALUE 9223372036854775806
	START WITH 1
    INCREMENT BY 1
    CYCLE
/

CREATE SEQUENCE PLAYBACK_WINDOW_RESTR_SEQ 
	MINVALUE 1
	MAXVALUE 9223372036854775806
	START WITH 1
    INCREMENT BY 1
    CYCLE
/

CREATE SEQUENCE ADI_XML_SITE_SEQ 
	MINVALUE 1
	MAXVALUE 9223372036854775806
	START WITH 1
    INCREMENT BY 1
    CYCLE
/

CREATE SEQUENCE COPYRIGHT_HOLDER_SEQ 
	MINVALUE 1
	MAXVALUE 9223372036854775806
	START WITH 1
    INCREMENT BY 1
    CYCLE
/

CREATE SEQUENCE ALARM_ACTIVITYLOG_SEQ 
	MINVALUE 1
	MAXVALUE 9223372036854775806
	START WITH 1
    INCREMENT BY 1
    CYCLE
/
CREATE SEQUENCE RECORDING_LOG_SEQ 
	MINVALUE 1
	MAXVALUE 9223372036854775806
	START WITH 1
    INCREMENT BY 1
    CYCLE
/

-- Inserting Error codes and description with user as system
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(0, 'Recording_Invalid', 'System', 'System', current_timestamp, current_timestamp)
/
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(200, 'Recording_Pending', 'System', 'System', current_timestamp, current_timestamp)
/
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(201, 'Recording_Locked', 'System', 'System', current_timestamp, current_timestamp)
/
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(202, 'Recording_Capturing', 'System', 'System', current_timestamp, current_timestamp)
/
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(203, 'Recording_Capture_Complete', 'System', 'System', current_timestamp, current_timestamp)
/
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(204, 'Recording_Archived', 'System', 'System', current_timestamp, current_timestamp)
/
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(205, 'Recording_Capture_Failed', 'System', 'System', current_timestamp, current_timestamp)
/
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(206, 'Recording_Capture_Pending', 'System', 'System', current_timestamp, current_timestamp)
/
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(207, 'Recording_Provisioning', 'System', 'System', current_timestamp, current_timestamp)
/
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(208, 'Recording_Provisioned', 'System', 'System', current_timestamp, current_timestamp)
/
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(209, 'Recording_RtiWaitingForFtpContentPushToComplete', 'System', 'System', current_timestamp, current_timestamp)
/
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(210, 'Recording_RtiFtpContentPushCompleted', 'System', 'System', current_timestamp, current_timestamp)
/
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(211, 'Recording_Completed', 'System', 'System', current_timestamp, current_timestamp)
/
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(300, 'Recording_Cancelled', 'System', 'System', current_timestamp, current_timestamp)
/
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(301, 'Recording_Stopped', 'System', 'System', current_timestamp, current_timestamp)
/
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(400, 'Recording_DistributionFailure', 'System', 'System', current_timestamp, current_timestamp)
/
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(401, 'Recording_SourceFailure', 'System', 'System', current_timestamp, current_timestamp)
/
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(402, 'Recording_SetupFailure', 'System', 'System', current_timestamp, current_timestamp)
/
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(500, 'Recording_SendFailed', 'System', 'System', current_timestamp, current_timestamp)
/
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(501, 'Recording_CaptureScheduleRequestFailed', 'System', 'System', current_timestamp, current_timestamp)
/
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(505, 'Recording_CaptureExtendRequestFailed', 'System', 'System', current_timestamp, current_timestamp)
/
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(506, 'Recording_CaptureDeleteRequestFailed', 'System', 'System', current_timestamp, current_timestamp)
/
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(507, 'Recording_RtiFtpContentPushFailed', 'System', 'System', current_timestamp, current_timestamp)
/
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(502, 'Recording_ProvisioningRequestFailed', 'System', 'System', current_timestamp, current_timestamp)
/
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(503, 'Recording_CapacityOverflow', 'System', 'System', current_timestamp, current_timestamp)
/
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(504, 'Recording_PoolCapacityOverflow', 'System', 'System', current_timestamp, current_timestamp)
/
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(509, 'Recording_AdiXmlSiteFailed', 'System', 'System', current_timestamp, current_timestamp)
/
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(600, 'Recording_TimedOut', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(1, 'EPG_Download_Error', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(10, 'EPG_XMLSCHEMA_VALIDATE_FAILED', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(11, 'EPG_DOWNLOAD_ABNORMAL_ERROR', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(12, 'EPG_SCHEDULE_CHANGE', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(13, 'EPG_PROGRAM_CHANGE', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(14, 'EPG_RECORDING_OFFSET_ERROR', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(15, 'RESOURCE_LOCKING_FAILED', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(50, 'Recording_Queue_System_Failed', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(51, 'Recording_Send_To_RM_Failed', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(1400, 'Recording_Invalid_Request_Format', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(1403, 'Recording_Invalid_Adi_Format', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(1404, 'Recording_INVALID_SOURCE_ID', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(1409, 'Recording_INVALID_RECORD_TIME_FORMAT', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(1410, 'Recording_UNDEFINED', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(1411, 'Recording_RESOURCE_CONSTRAINT', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(1412, 'Recording_TIME_CONSTRAINT', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(1413, 'Recording_INVALID_ASSET_ID', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(1414, 'Recording_INVALID_FORMATTING', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(1451, 'Recording_UNSUPPORTED_DISTRIBUTION_METHOD', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(1500, 'Recording_INTERNAL_SERVER_ERROR', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(1501, 'RM_Status_Changed_To_Offline', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(1502, 'RTC_Status_Changed_To_Offline', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(1503, 'RM_Id_Not_Matching_With_RM_Status_Response', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(1504, 'RM_Status_Servlet_Request_Failed', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(2000, 'CopyrightHolder_CreateFailed', 'System', 'System', current_timestamp, current_timestamp)
/
		
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(2001, 'CopyrightHolder_UpdateFailed', 'System', 'System', current_timestamp, current_timestamp)
/   
    
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(2002, 'CopyrightHolder_DeleteFailed', 'System', 'System', current_timestamp, current_timestamp)
/


INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(2020, 'Contract_CreateFailed', 'System', 'System', current_timestamp, current_timestamp)
/
		
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(2021, 'Contract_UpdateFailed', 'System', 'System', current_timestamp, current_timestamp)
/   
    
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(2022, 'Contract_DeleteFailed', 'System', 'System', current_timestamp, current_timestamp)
/	


INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(2040, 'Right_CreateFailed', 'System', 'System', current_timestamp, current_timestamp)
/
		
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(2041, 'Right_UpdateFailed', 'System', 'System', current_timestamp, current_timestamp)
/   
    
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(2042, 'Right_DeleteFailed', 'System', 'System', current_timestamp, current_timestamp)
/


INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(2060, 'RecordingRule_CreateFailed', 'System', 'System', current_timestamp, current_timestamp)
/
		
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(2061, 'RecordingRule_UpdateFailed', 'System', 'System', current_timestamp, current_timestamp)
/   
    
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(2062, 'RecordingRule_DeleteFailed', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(2080, 'Recording_QuickApproveFailed', 'System', 'System', current_timestamp, current_timestamp)
/
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(2081, 'Recording_DeleteFailed', 'System', 'System', current_timestamp, current_timestamp)
/
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(2082, 'Recording_StopFailed', 'System', 'System', current_timestamp, current_timestamp)
/
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(2083, 'Recording_ApproveFailed', 'System', 'System', current_timestamp, current_timestamp)
/
		
INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(6001, 'rm_CreateFailed', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(6002, 'rm_UpdateFailed', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(6003, 'rm_DeleteFailed', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(6004, 'rm_DownstreamDeleteFailed', 'System', 'System', current_timestamp, current_timestamp)		
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(6005, 'epg_CreateFailed', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(6006, 'epg_DeleteFailed', 'System', 'System', current_timestamp, current_timestamp)
/		

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(6007, 'epg_DeleteFailed', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(6008, 'rtcRemote_CreateFailed', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(6009, 'rtc_CreateFailed', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(6010, 'rtcRemote_DeleteFailed', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(6011, 'rtc_DeleteFailed', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(6012, 'rtcRemote_UpdateFailed', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(6013, 'rtc_UpdateFailed', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(6014, 'rmRemote_CreateFailed', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(6015, 'rmRemote_UpdateFailed', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(6016, 'rmRemote_DeleteFailed', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(6017, 'channelRemote_CreateFailed', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(6018, 'channelRemote_UpdateFailed', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(6019, 'channel_CreateFailed', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(6020, 'channel_UpdateFailed', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(6021, 'channel_DeleteFailed', 'System', 'System', current_timestamp, current_timestamp)
/

INSERT INTO ERROR_CODE(ERROR_CODE, DESCRIPTION, CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE) 
    VALUES(6022, 'channelRemote_DeleteFailed', 'System', 'System', current_timestamp, current_timestamp)    
/

--Insert into config_setting
insert into config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
VALUES('EPG_Download_Processing', 'N', 'System', 'System', current_timestamp, current_timestamp)
/

insert into config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
VALUES('EPG_Schedule_Delay_Secs', '60', 'System', 'System', current_timestamp, current_timestamp)
/

insert into tstv_user(USER_ID,TELEPHONE_NUMBER,EMAIL,USER_NAME,FIRST_NAME,PASSWORD,LAST_NAME,USER_ROLE,CREATED_BY,UPDATED_BY,CREATE_DATE,UPDATE_DATE)
values (tstv_user_seq.nextval,null,null,'admin','admin','admin','admin','1','System','System',	current_timestamp, current_timestamp)
/

insert into config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
VALUES('APPLICATION_TIMEZONE_KEY', 'GMT', 'System', 'System', current_timestamp, current_timestamp)
/
insert into config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
VALUES('APPLICATION_DB_SERVER_TIMEZONE_KEY', 'America/Los_Angeles', 'System', 'System', current_timestamp, current_timestamp)
/

insert into config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
VALUES('RECORDING_CLEANER_THRESHOLD', '120', 'System', 'System', current_timestamp, current_timestamp)
/

--Version information will be updated by installer.
insert into config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
VALUES('version', '@RCSWeb.version@', 'System', 'System', current_timestamp, current_timestamp)
/

--Version information will be updated by installer.
insert into config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
VALUES('EPG_AUTOCREATE_RECORDING_SPAN', '86400', 'System', 'System', current_timestamp, current_timestamp)
/

--Recordables Resource Lock to serialize all recordable operations in the system
insert into config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
VALUES('RECORDABLES_RESOURCE_LOCK', 'SERIALIZE_TRANSACTION', 'System', 'System', current_timestamp, current_timestamp)
/

--Recordings Resource Lock to serialize all recording operations in the system
insert into config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
VALUES('RECORDINGS_RESOURCE_LOCK', 'SERIALIZE_TRANSACTION', 'System', 'System', current_timestamp, current_timestamp)
/

--Timeout for Recordables and Recordings resource lock
insert into config_setting (key,value,CREATED_BY, UPDATED_BY, CREATE_DATE, UPDATE_DATE)
VALUES('RESOURCE_TIMEOUT_SECS', '120', 'System', 'System', current_timestamp, current_timestamp)
/

commit;

CREATE OR REPLACE
TRIGGER rcs_after_logon_trigger
AFTER LOGON ON RCS.SCHEMA 
declare
  vtimezone varchar2(2000);
BEGIN
  begin
    select value 
    into vtimezone
    from config_setting c, v$timezone_names tn
    where c.key = 'APPLICATION_DB_SERVER_TIMEZONE_KEY'
    and tn.tzname = c.value
    group by value;
  execute immediate 'alter session set time_zone = '''||vtimezone||'''';
  exception
    when others then
      null;
  end;
  
END;
/

CREATE OR REPLACE FORCE VIEW "REC_RULES_VIEW" ("CONTRACT_TITLE", "SCHEDULE_ID", "RULE_ID", "SCHEDULE_START_TIME", "SCHEDULE_END_TIME", "PROGRAM_TITLE", "STATION_CALL_SIGN", "RM_ID","HEADEND_ID") AS 
select distinct contract_title, schedule_id,rule_id,sstart_time,send_time,program_title,station_call_sign,rm_id,headend_id
from 
      (select rm.rm_id as rm_id, rm.headend_id as headend_id,
      c.title as contract_title,s.schedule_id as schedule_id,rr.rule_id as rule_id,s.station_id as sstation_id,
      sta.call_sign as station_call_sign,s.program_id as sprogram_id, p.title as program_title,
      s.start_time as sstart_time, s.end_time as send_time,
      upper(s.hd_tv) as shd_tv, upper(s.repeat) as srepeat, 
      case when upper(s.live_tape_delay) = 'DELAY' then cast('TAPE' as nvarchar2(100)) else upper(s.live_tape_delay) end  as slive,
      upper(trim(s.day_of_week)) as sdayofweek,
      rr.start_time as rstart_date, rr.end_time as rend_date,upper(nvl(trim(rr.day_of_week),trim(s.day_of_week))) as rdayofweek,
      upper(rr.repeat) as rrepeat, upper(rr.hd) as rhd_tv, upper(rr.live) as rlive,
      nvl(rpm.program_id,s.program_id) as rpmprogram_id,
      nvl(rserm.program_id,s.program_id) as rsermprogram_id,
      nvl(rstam.station_id,s.station_id) as rstamstation_id
      from schedule s 
      join contract c on (c.status = 1 and s.recordable=1 and s.start_time >= current_timestamp and s.start_time >= c.effective_date and s.end_time <= c.expiry_date)
      join recording_rules rr on (rr.state =1 and ((s.start_time >= rr.start_time and s.end_time <= rr.end_time) OR (rr.start_time is null and rr.end_time is null)))
      join program p on (s.program_id = p.program_id)
      join station sta on (sta.station_id = s.station_id)
      join recordable_rights_map rrm on (rrm.schedule_id = s.schedule_id)
      join right_rm_map rightrm on (rightrm.right_id = rrm.right_id)
      join rm on (rm.rm_id = rightrm.rm_id)
      join rm_lineup rl on (rl.rm_id = rm.rm_id and rl.station_id=sta.station_id and rl.headend_id = rm.headend_id)
      left outer join rec_rules_program_map rpm on (rr.rule_id = rpm.rule_id )
      left outer join (select rserm_inner.series_id as series_id, rserm_inner.rule_id as rule_id, spm.program_id as program_id 
          from rec_rules_series_map rserm_inner join series_program_map spm on (spm.series_id = rserm_inner.series_id)) rserm 
          on (rr.rule_id = rserm.rule_id)
      left outer join rec_rules_station_map rstam on (rr.rule_id = rstam.rule_id)
      ) recinnerview
where sstation_id = rstamstation_id
and sprogram_id = rpmprogram_id
and sprogram_id = rsermprogram_id
and  rdayofweek like '%'||sdayofweek||'%'
and (srepeat = rrepeat or rrepeat is null)
and (shd_tv = rhd_tv or rhd_tv is null)
and (slive = rlive or rlive is null)
and not exists (select 1 from recording r where r.schedule_id = recinnerview.schedule_id and r.headend_id = recinnerview.headend_id);

CREATE OR REPLACE FORCE VIEW "REC_RULES_SCHEDULECHK_VIEW" ("RECORDING_ID","RULE_ID") AS 
select distinct recording_id, rule_id
from 
      (select r.recording_id,s.schedule_id as schedule_id,rr.rule_id as rule_id,s.station_id as sstation_id,
      s.program_id as sprogram_id,
      s.start_time as sstart_time, s.end_time as send_time,
      upper(s.hd_tv) as shd_tv, upper(s.repeat) as srepeat, 
      case when upper(s.live_tape_delay) = 'DELAY' then cast('TAPE' as nvarchar2(100)) else upper(s.live_tape_delay) end  as slive,
      upper(trim(s.day_of_week)) as sdayofweek,
      rr.start_time as rstart_date, rr.end_time as rend_date,upper(nvl(trim(rr.day_of_week),trim(s.day_of_week))) as rdayofweek,
      upper(rr.repeat) as rrepeat, upper(rr.hd) as rhd_tv, upper(rr.live) as rlive,
      nvl(rpm.program_id,s.program_id) as rpmprogram_id,
      nvl(rserm.program_id,s.program_id) as rsermprogram_id,
      nvl(rstam.station_id,s.station_id) as rstamstation_id
      from schedule s 
      join contract c on (c.status = 1 and s.recordable=1 and s.start_time >= c.effective_date and s.end_time <= c.expiry_date)
      join recording r on (r.schedule_id = s.schedule_id)
      join recording_rules rr on (rr.state =1 and ((s.start_time >= rr.start_time and s.end_time <= rr.end_time) OR (rr.start_time is null and rr.end_time is null)))
      left outer join rec_rules_program_map rpm on (rr.rule_id = rpm.rule_id )
      left outer join (select rserm_inner.series_id as series_id, rserm_inner.rule_id as rule_id, spm.program_id as program_id 
          from rec_rules_series_map rserm_inner join series_program_map spm on (spm.series_id = rserm_inner.series_id)) rserm 
          on (rr.rule_id = rserm.rule_id)
      left outer join rec_rules_station_map rstam on (rr.rule_id = rstam.rule_id)
      )
where sstation_id = rstamstation_id
and sprogram_id = rpmprogram_id
and sprogram_id = rsermprogram_id
and  rdayofweek like '%'||sdayofweek||'%'
and (srepeat = rrepeat or rrepeat is null)
and (shd_tv = rhd_tv or rhd_tv is null)
and (slive = rlive or rlive is null);

create or replace view rights_edit_chk_view(schedule_id) as
     select s.schedule_id
     from schedule s
     where s.recordable = 1
     and s.start_time >= current_timestamp
     minus
     select distinct sschedule_id from 
        (select s.schedule_id as sschedule_id,s.station_id as sstation_id,s.program_id as sprogram_id,s.start_time as sstart_time, s.end_time as send_time,
        upper(s.hd_tv) as shd_tv, upper(s.repeat) as srepeat, 
        case when upper(s.live_tape_delay) = 'DELAY' then cast('TAPE' as nvarchar2(100)) else upper(s.live_tape_delay) end  as slive,
        upper(trim(s.day_of_week)) as sdayofweek,
        nvl(r.start_date,c.effective_date) as rstart_date, nvl(r.end_date,c.expiry_date) as rend_date,upper(nvl(trim(r.day_of_week),trim(s.day_of_week))) as rdayofweek,
        upper(r.repeat) as rrepeat, upper(r.hd) as rhd_tv, upper(r.live) as rlive,
        nvl(rpm.program_id,s.program_id) as rpmprogram_id,
        nvl(rserm.program_id,s.program_id) as rsermprogram_id,
        nvl(rstam.station_id,s.station_id) as rstamstation_id
        from schedule s join contract c on (  s.start_time >= current_timestamp and c.status =1 /*Active Contracts*/ and s.start_time >= c.effective_date and s.end_time <= c.expiry_date)
        join right r on (r.contract_id = c.contract_id and r.state = 1 /* Active Right */)
        left outer join right_program_map rpm on (r.right_id = rpm.right_id)
        left outer join (select rserm_inner.series_id as series_id, rserm_inner.right_id as right_id, spm.program_id as program_id 
            from right_series_map rserm_inner join series_program_map spm on (spm.series_id = rserm_inner.series_id)) rserm 
            on (r.right_id = rserm.right_id)
        left outer join right_station_map rstam on (r.right_id = rstam.right_id)
        )
      where sstation_id = rstamstation_id
      and sprogram_id = rpmprogram_id
      and sprogram_id = rsermprogram_id
      and sstart_time >= rstart_date
      and send_time <= rend_date
      and  rdayofweek like '%'||sdayofweek||'%'
      and (srepeat = rrepeat or rrepeat is null)
      and (shd_tv = rhd_tv or rhd_tv is null)
      and (slive = rlive or rlive is null);

CREATE OR REPLACE FORCE VIEW rules_edit_chk_view ("SCHEDULE_ID") AS 
select s.schedule_id
from schedule s, recording r,recording_rec_rules_map rrrm 
where s.schedule_id = r.schedule_id
and s.recordable=1
and s.start_time >= current_timestamp
and rrrm.recording_id= r.recording_id
minus
select distinct schedule_id
from 
      (select s.schedule_id as schedule_id,s.station_id as sstation_id,
      s.program_id as sprogram_id, 
      s.start_time as sstart_time, s.end_time as send_time,
      upper(s.hd_tv) as shd_tv, upper(s.repeat) as srepeat, 
      case when upper(s.live_tape_delay) = 'DELAY' then cast('TAPE' as nvarchar2(100)) else upper(s.live_tape_delay) end  as slive,
      upper(trim(s.day_of_week)) as sdayofweek,
      upper(nvl(trim(rr.day_of_week),trim(s.day_of_week))) as rdayofweek,
      upper(rr.repeat) as rrepeat, upper(rr.hd) as rhd_tv, upper(rr.live) as rlive,
      nvl(rpm.program_id,s.program_id) as rpmprogram_id,
      nvl(rserm.program_id,s.program_id) as rsermprogram_id,
      nvl(rstam.station_id,s.station_id) as rstamstation_id
      from schedule s 
      join contract c on (c.status = 1 and s.recordable=1 and s.start_time >= current_timestamp and s.start_time >= c.effective_date and s.end_time <= c.expiry_date)
      join recording_rules rr on (rr.state =1 and ((s.start_time >= rr.start_time and s.end_time <= rr.end_time) OR (rr.start_time is null and rr.end_time is null)))
      left outer join rec_rules_program_map rpm on (rr.rule_id = rpm.rule_id )
      left outer join (select rserm_inner.series_id as series_id, rserm_inner.rule_id as rule_id, spm.program_id as program_id 
          from rec_rules_series_map rserm_inner join series_program_map spm on (spm.series_id = rserm_inner.series_id)) rserm 
          on (rr.rule_id = rserm.rule_id)
      left outer join rec_rules_station_map rstam on (rr.rule_id = rstam.rule_id)
      ) recinnerview
where sstation_id = rstamstation_id
and sprogram_id = rpmprogram_id
and sprogram_id = rsermprogram_id
and  rdayofweek like '%'||sdayofweek||'%'
and (srepeat = rrepeat or rrepeat is null)
and (shd_tv = rhd_tv or rhd_tv is null)
and (slive = rlive or rlive is null);


create or replace TRIGGER rcs_after_logon_trigger
AFTER LOGON ON RCS.SCHEMA 
declare
  vtimezone varchar2(2000);
BEGIN
  begin
    select value 
    into vtimezone
    from config_setting c, v$timezone_names tn
    where c.key = 'APPLICATION_DB_SERVER_TIMEZONE_KEY'
    and tn.tzname = c.value
    group by value;
  execute immediate 'alter session set time_zone = '''||vtimezone||'''';
  exception
    when others then
      null;
  end;
  
END;
/

CREATE OR REPLACE PACKAGE TSTVDB AS
  procedure installtstv;
  procedure droptstv;
END TSTVDB;
/

create or replace
PACKAGE BODY TSTVDB AS
/*
create user rcs identified by rcs default tablespace tstv_rcs;
grant connect,resource,CREATE SESSION,create any view,CREATE TABLE,CREATE TRIGGER,CREATE TYPE,ALTER SESSION,xdbadmin,CREATE SEQUENCE to rcs;
grant all on dbms_xmlschema to rcs;
grant all on dbms_errlog to rcs;

--conn rcs/rcs

BEGIN
      DBMS_XMLSCHEMA.registerSchema(
        SCHEMAURL => 'SlicerGuideData.xsd',
        SCHEMADOC => bfilename('XMLDIR','ttv_ept_1_0.xsd')
        ,CSID => nls_charset_id('AL32UTF8')
        );
END;

*/
   /* Procedure: CreateObject. Executes a dynamic SQL statement and logs error in install_table*/
  PROCEDURE CREATEOBJECT(vsql varchar2,errmsg varchar2, mask varchar2 default 'N') IS
    verrmsg varchar2(32000);
  BEGIN
    execute immediate vsql;
  exception
    when others then
          verrmsg := errmsg ||' '||sqlerrm;
          select cast(verrmsg as varchar2(4000)) 
          into verrmsg
          from dual;
      if upper(mask) != 'Y' then
          execute immediate 'INSERT INTO install_table values('''||sysdate||''','''||replace(verrmsg,'''')||''')';
          commit;
          raise;
      end if;
  END CREATEOBJECT;
  
  procedure droptstv is
    vsql varchar2(32767);    
  begin
    vsql := 'drop table stg_schedule';
    CREATEOBJECT(vsql,'Drop table stg_schedule','Y');

    vsql := 'drop table stg_program';
    CREATEOBJECT(vsql,'Drop table stg_program','Y');

    vsql := 'drop table stg_program';
    CREATEOBJECT(vsql,'Drop table stg_program','Y');

  end;
  
/* Procedure: CreateUpdTimeTRG. Updates the UpdateTime column with the current date and time when any
              update statement is issued against the table.*/
  PROCEDURE CREATEUPDATETRG(vtabname varchar2) IS
    vcount number := 0;
    vsql varchar2(32000);
  BEGIN
    select count(*)
    into vcount
    from user_tables dt, user_tab_columns dtc
    where dt.table_name = dtc.table_name
    and dt.table_name=upper(vtabname)
    and dtc.column_name = 'UPDATE_DATE';
    
	  if ( vcount > 0 ) then
      vsql := 'CREATE OR REPLACE TRIGGER rcs.'||vtabname||'UPD BEFORE UPDATE ON rcs.'||vtabname||' FOR EACH ROW
            DECLARE
              vcurrent_timestamp timestamp with time zone;
            BEGIN
              
                select current_timestamp into vcurrent_timestamp from dual;
                :new.update_date := vcurrent_timestamp;
              
            END;';
      CREATEOBJECT(vsql,'Create Trigger '||vtabname||'UPD');
    end if;

    select count(*)
    into vcount
    from user_tables dt, user_tab_columns dtc
    where dt.table_name = dtc.table_name
    and dt.table_name=upper(vtabname)
    and dtc.column_name = 'CREATE_DATE';
    
	  if ( vcount > 0 ) then
      vsql := 'CREATE OR REPLACE TRIGGER rcs.'||vtabname||'CRT BEFORE INSERT ON rcs.'||vtabname||' FOR EACH ROW
            DECLARE
              vcurrent_timestamp timestamp with time zone;
            BEGIN
              if (:old.create_date is null or :old.update_date is null) then
                select current_timestamp into vcurrent_timestamp from dual;
                :new.create_date := vcurrent_timestamp;
                :new.update_date := vcurrent_timestamp;
              end if;
            END;';
      CREATEOBJECT(vsql,'Create Trigger '||vtabname||'UPD');
    end if;

   END CREATEUPDATETRG;

  procedure installtstv IS 
    vsql varchar2(32767);    
  BEGIN
    --drop table epgxmlfiles
    vsql := 'drop table epgxmlfiles purge';
    CREATEOBJECT(vsql,'Drop table epgxmlfiles','Y');
/*    
    --Delete Schema Doc
    vsql := 'BEGIN
      DBMS_XMLSCHEMA.deleteSchema(
        SCHEMAURL => ''SlicerGuideData.xsd'',
        DELETE_OPTION => DBMS_XMLSCHEMA.DELETE_CASCADE_FORCE);
    END;';
  CREATEOBJECT(vsql,'Delete schema SlicerGuideData.xsd','Y');
  
  
    --Register Schema Doc
    BEGIN
      DBMS_XMLSCHEMA.registerSchema(
        SCHEMAURL => 'SlicerGuideData.xsd',
        SCHEMADOC => bfilename('XMLDIR','ttv_ept_1_0.xsd')
        ,CSID => nls_charset_id('AL32UTF8')
        );
    END;
*/
    --Create install_table for logging errors
    vsql := 'CREATE TABLE install_Table( msgdate date default sysdate,install_message varchar2(4000))';
    CREATEOBJECT(vsql,'Create table install_table','Y');

    --Create table to store EPG xml files
    vsql := 'CREATE TABLE epgxmlfiles 
      (fileid number not null,filename varchar2(4000), filecontent  XMLType,createdate timestamp default systimestamp,processstarttime timestamp(0),processendtime timestamp(0)) 
      xmltype filecontent STORE AS OBJECT RELATIONAL XMLSCHEMA "TTV_EPG.xsd"  ELEMENT "GuideData"';
    CREATEOBJECT(vsql,'Create table epgxmlfiles');
      
    --Staging Program rows
    vsql := 'create or replace view stg_program_view as 
    SELECT epgxmlfiles.filename,epgxmlfiles.processendtime,
    xmlcolumns.*
    FROM epgxmlfiles,
    XMLTABLE(''/GuideData/SlicerGuideData/PROGRAM/row''
    PASSING epgxmlfiles.filecontent
    COLUMNS 
    DATABASE_KEY nvarchar2(100) PATH ''DATABASE_KEY'',
    LANGUAGE nvarchar2(100) PATH ''LANGUAGE'',
    TITLE nvarchar2(1000) PATH ''TITLE'',
    REDUCED_TITLE1 nvarchar2(1000) PATH ''REDUCED_TITLE[1]'',
    REDUCED_TITLE2 nvarchar2(1000) PATH ''REDUCED_TITLE[2]'',
    REDUCED_TITLE3 nvarchar2(1000) PATH ''REDUCED_TITLE[3]'',
    REDUCED_TITLE4 nvarchar2(1000) PATH ''REDUCED_TITLE[4]'',
    ALT_TITLE nvarchar2(1000) PATH ''ALT_TITLE'',
    REDUCED_DESC1 nvarchar2(1000) PATH ''REDUCED_DESC[1]'',
    REDUCED_DESC2 nvarchar2(1000) PATH ''REDUCED_DESC[2]'',
    REDUCED_DESC3 nvarchar2(1000) PATH ''REDUCED_DESC[3]'',
    REDUCED_DESC4 nvarchar2(1000) PATH ''REDUCED_DESC[4]'',
    ADVISORY_DESC1 nvarchar2(100) PATH ''ADVISORY_DESC[1]'',
    ADVISORY_DESC2 nvarchar2(100) PATH ''ADVISORY_DESC[2]'',
    ADVISORY_DESC3 nvarchar2(100) PATH ''ADVISORY_DESC[3]'',
    ADVISORY_DESC4 nvarchar2(100) PATH ''ADVISORY_DESC[4]'',
    ADVISORY_DESC5 nvarchar2(100) PATH ''ADVISORY_DESC[5]'',
    ADVISORY_DESC6 nvarchar2(100) PATH ''ADVISORY_DESC[6]'',
    /* CAST_CREDITS*/
    CAST_NAME_ROLE xmltype PATH ''CAST_NAME_ROLE'',
    /* CAST_CREDITS*/
    CREDITS_NAME_ROLE xmltype PATH ''CREDITS_NAME_ROLE'',
    GENRE_DESC1 nvarchar2(100) PATH ''GENRE_DESC[1]'',
    GENRE_DESC2 nvarchar2(100) PATH ''GENRE_DESC[2]'',
    GENRE_DESC3 nvarchar2(100) PATH ''GENRE_DESC[3]'',
    GENRE_DESC4 nvarchar2(100) PATH ''GENRE_DESC[4]'',
    GENRE_DESC5 nvarchar2(100) PATH ''GENRE_DESC[5]'',
    GENRE_DESC6 nvarchar2(100) PATH ''GENRE_DESC[6]'',
    DESCRIPTION1 nvarchar2(2000) PATH ''DESC[1]'',
    DESCRIPTION2 nvarchar2(2000) PATH ''DESC[2]'',
    YEAR_PROGRAM nvarchar2(100) PATH ''YEAR'',
    MPAA_RATING nvarchar2(1000) PATH ''MPAA_RATING'',
    STAR_RATING nvarchar2(1000) PATH ''STAR_RATING'',
    PROGRAM_RATING xmltype PATH ''PROGRAM_RATING'',
    RUN_TIME varchar2(100) PATH ''RUN_TIME'',
    COLOR_CODE nvarchar2(100) PATH ''COLOR_CODE'',
    PROGRAM_LANGUAGE nvarchar2(100) PATH ''PROGRAM_LANGUAGE'',
    AUDIO_COMPONENT xmltype PATH ''AUDIO_COMPONENT'',
    SUBTITLE_COMPONENT xmltype PATH ''SUBTITLE_COMPONENT'',
    ORG_COUNTRY nvarchar2(100) PATH ''ORG_COUNTRY'',
    MADE_FOR_TV nvarchar2(1) PATH ''MADE_FOR_TV'',
    SOURCE_TYPE nvarchar2(100) PATH ''SOURCE_TYPE'',
    SHOW_TYPE nvarchar2(200) PATH ''SHOW_TYPE'',
    HOLIDAY nvarchar2(100) PATH ''HOLIDAY'',
    SYN_EPI_NUM nvarchar2(100) PATH ''SYN_EPI_NUM'',
    ALT_SYN_EPI_NUM nvarchar2(100) PATH ''ALT_SYN_EPI_NUM'',
    EPI_TITLE nvarchar2(2000) PATH ''EPI_TITLE'',
    NET_SYN_SOURCE nvarchar2(100) PATH ''NET_SYN_SOURCE'',
    NET_SYN_TYPE nvarchar2(100) PATH ''NET_SYN_TYPE'',
    ORG_STUDIO nvarchar2(100) PATH ''ORG_STUDIO'',
    /* GAME_DATETIME stores all game date,time,hhmmss */
    GAME_DATE varchar2(100) PATH ''GAME_DATE'',
    GAME_TIMEZONE varchar2(100) PATH ''GAME_TIME_ZONE'',
    ORG_AIR_DATE varchar2(100) PATH ''ORG_AIR_DATE'',
    UNIQUE_ID  nvarchar2(100) PATH ''UNIQUE_ID'',
    USER_DATA	xmltype  PATH ''USER_DATA'',
    PROGRAM_GENERIC  xmltype PATH ''PROGRAM_GENERIC''
    ) xmlcolumns';
    CREATEOBJECT(vsql,'create view stg_program_view');

    --Staging HEADEND row
    vsql := 'create or replace view stg_HEADEND_view as
    SELECT epgxmlfiles.filename,epgxmlfiles.processendtime,
    xmlcolumns.*
    FROM epgxmlfiles,
    XMLTABLE(''/GuideData/SlicerGuideData/HEADEND/row''
    PASSING epgxmlfiles.filecontent
    COLUMNS 
    HE_HEADEND_ID	nvarchar2(100) PATH ''HE_HEADEND_ID'',
    HE_COMMUNITY_NAME		nvarchar2(200) PATH ''HE_COMMUNITY_NAME'',
    HE_COUNTY_NAME		nvarchar2(200)  PATH ''HE_COUNTY_NAME'',
    HE_COUNTY_SIZE		nvarchar2(1) PATH ''HE_COUNTY_SIZE'',
    HE_ST_COUNTY_CODE		nvarchar2(100) PATH ''HE_ST_COUNTY_CODE'',
    HE_STATE_SERVED		nvarchar2(2) PATH ''HE_STATE_SERVED'',
    HE_ZIP_CODE		nvarchar2(100) PATH ''HE_ZIP_CODE'',
    HE_DMA_CODE		nvarchar2(100) PATH ''HE_DMA_CODE'',
    HE_DMA_NAME		nvarchar2(300) PATH ''HE_DMA_NAME'',
    HE_MSO_CODE		number PATH ''HE_MSO_CODE'',
    HE_DMA_RANK		nvarchar2(10) PATH ''HE_DMA_RANK'',
    HE_HEADEND_NAME		nvarchar2(1000) PATH ''HE_HEADEND_NAME'',
    HE_HEADEND_LOCATION		nvarchar2(100)  PATH ''HE_HEADEND_LOCATION'',
    HE_MSO_NAME		nvarchar2(200) PATH ''HE_MSO_NAME'',
    HE_TIME_ZONE_CODE		nvarchar2(100)  PATH ''HE_TIME_ZONE_CODE'') xmlcolumns';
    CREATEOBJECT(vsql,'create view stg_headend_view');
    
    --Get LINEUP rows
    vsql := 'create or replace view stg_LINEUP_view as
    SELECT epgxmlfiles.filename,epgxmlfiles.processendtime,
    xmlcolumns.*
    FROM epgxmlfiles,
    XMLTABLE(''/GuideData/SlicerGuideData/LINEUP/row''
    PASSING epgxmlfiles.filecontent
    COLUMNS 
    CL_ROW_ID	number PATH ''CL_ROW_ID'',
    CL_STATION_NUM	nvarchar2(100) PATH ''CL_STATION_NUM'',
    CL_HEADEND_ID	nvarchar2(100) PATH ''CL_HEADEND_ID'',
    CL_DEVICE		nvarchar2(2) PATH ''CL_DEVICE'',
    CL_TMS_CHAN		nvarchar2(20) PATH ''CL_TMS_CHAN'',
    CL_SERVICE_TIER		nvarchar2(1) PATH ''CL_SERVICE_TIER'',
    CL_EFFECTIVE_DATE	varchar2(100) PATH ''CL_EFFECTIVE_DATE'',
    CL_EXPIRATION_DATE		varchar2(100) PATH ''CL_EXPIRATION_DATE'') xmlcolumns';
    CREATEOBJECT(vsql,'create view stg_lineup_view');

    vsql := 'create or replace view stg_SCHEDULE_view as
    SELECT epgxmlfiles.filename,epgxmlfiles.processendtime,
    xmlcolumns.*
    FROM epgxmlfiles,
    XMLTABLE(''/GuideData/SlicerGuideData/SCHEDULE/row''
    PASSING epgxmlfiles.filecontent
    COLUMNS 
    STATION_NUM 	number PATH ''STATION_NUM'',
    DATABASE_KEY 	nvarchar2(100) PATH ''DATABASE_KEY'',
    SCHEDULE_LANGUAGE		nvarchar2(100) PATH ''LANGUAGE'',
    AIR_DATE 	varchar2(200) PATH ''AIR_DATE'',
    DURATION 		varchar2(100) PATH ''DURATION'',
    EVENT_ID		xmltype PATH ''EVENT_ID'',
    PART_NUM 		number PATH ''PART_NUM'',
    NUM_OF_PARTS 		number PATH ''NUM_OF_PARTS'',
    SERIES_LINK			xmltype PATH ''SERIES_LINK'',
    CC varchar2(1) PATH ''CC'',
    STEREO 		varchar2(1) PATH ''STEREO'',
    REPEAT 		varchar2(1) PATH ''REPEAT'',
    LIVE_TAPE_DELAY 	varchar2(100) PATH ''LIVE_TAPE_DELAY'',
    SUBTITLED varchar2(1) PATH ''SUBTITLED'',		
    PREMIERE_FINALE 	varchar2(100)  PATH ''PREMIERE_FINALE'',
    JOINED_IN_PROGRESS 		varchar2(1)  PATH ''JOINED_IN_PROGRESS'',
    CABLE_IN_THE_CLASSROOM 		varchar2(1) PATH ''CABLE_IN_THE_CLASSROOM'',
    TV_RATING 		varchar2(1000)  PATH ''TV_RATING'',
    SAP varchar2(1) PATH ''SAP'',
    BLACKOUT varchar2(1) PATH ''BLACKOUT'',
    SEX_RATING varchar2(1) PATH ''SEX_RATING'',
    VIOLENCE_RATING varchar2(1) PATH ''VIOLENCE_RATING'',
    LANGUAGE_RATING varchar2(1) PATH ''LANGUAGE_RATING'',
    DIALOG_RATING varchar2(1)  PATH ''DIALOG_RATING'',
    FV_RATING varchar2(1)  PATH ''FV_RATING'',
    ENHANCED varchar2(1) PATH ''ENHANCED'',
    THREE_D varchar2(1) PATH ''THREE_D'',
    LETTERBOX varchar2(1) PATH ''LETTERBOX'',
    HDTV varchar2(1) PATH ''HDTV'',
    DOLBY nvarchar2(100) PATH ''DOLBY'',
    DVS varchar2(1) PATH ''DVS'',
    USER_DATA	xmltype PATH ''USER_DATA'',
    SCHEDULE_GENERIC xmltype PATH ''SCHEDULE_GENERIC'') xmlcolumns';
    CREATEOBJECT(vsql,'create view stg_schedule_view');

    vsql := 'create or replace view stg_STATION_view as
    SELECT epgxmlfiles.filename,epgxmlfiles.processendtime,
    xmlcolumns.*
    FROM epgxmlfiles,
    XMLTABLE(''/GuideData/SlicerGuideData/STATION/row''
    PASSING epgxmlfiles.filecontent
    COLUMNS 
    STATION_NUM 	nvarchar2(100) PATH ''STATION_NUM'',
    STATION_TIME_ZONE nvarchar2(100) PATH ''STATION_TIME_ZONE'',
    STATION_NAME nvarchar2(100) PATH ''STATION_NAME'',
    STATION_CALL_SIGN nvarchar2(100) PATH ''STATION_CALL_SIGN'',
    STATION_AFFIL nvarchar2(100) PATH ''STATION_AFFIL'',
    STATION_CITY nvarchar2(100) PATH ''STATION_CITY'',
    STATION_STATE nvarchar2(100) PATH ''STATION_STATE'',
    STATION_ZIP_CODE nvarchar2(100) PATH ''STATION_ZIP_CODE'',
    STATION_COUNTRY nvarchar2(100) PATH ''STATION_COUNTRY'',
    DMA_NAME nvarchar2(100) PATH ''DMA_NAME'',
    DMA_NUM nvarchar2(100) PATH ''DMA_NUM'',
    FCC_CHANNEL_NUM nvarchar2(100) PATH ''FCC_CHANNEL_NUM'') xmlcolumns';
    CREATEOBJECT(vsql,'create view stg_station_view');

    vsql := 'DROP TABLE "STG_HEADEND" PURGE';
    CREATEOBJECT(vsql,'Drop table stg_headend','Y');
    
    vsql := 'CREATE TABLE "STG_HEADEND" 
    (	"FILENAME" VARCHAR2(4000 BYTE), 
    "HE_HEADEND_ID" NVARCHAR2(100), 
    "HE_COMMUNITY_NAME" NVARCHAR2(200), 
    "HE_COUNTY_NAME" NVARCHAR2(200), 
    "HE_COUNTY_SIZE" NVARCHAR2(1), 
    "HE_ST_COUNTY_CODE" NVARCHAR2(100), 
    "HE_STATE_SERVED" NVARCHAR2(2), 
    "HE_ZIP_CODE" NVARCHAR2(100), 
    "HE_DMA_CODE" NVARCHAR2(100), 
    "HE_DMA_NAME" NVARCHAR2(300), 
    "HE_MSO_CODE" NUMBER, 
    "HE_DMA_RANK" NVARCHAR2(10), 
    "HE_HEADEND_NAME" NVARCHAR2(1000), 
    "HE_HEADEND_LOCATION" NVARCHAR2(100), 
    "HE_MSO_NAME" NVARCHAR2(200), 
    "HE_TIME_ZONE_CODE" NVARCHAR2(100)
    ) nologging';
    CREATEOBJECT(vsql,'create table stg_headend');

    vsql := 'DROP TABLE "ERR$_STG_HEADEND" PURGE';
    CREATEOBJECT(vsql,'Drop table err$_stg_headend','Y');
    
    vsql := 'BEGIN
                DBMS_ERRLOG.create_error_log (dml_table_name => ''STG_HEADEND'');
             END;';
    CREATEOBJECT(vsql,'create table err$_stg_headend');

    vsql := 'DROP TABLE "STG_LINEUP" PURGE';
    CREATEOBJECT(vsql,'Drop table STG_LINEUP','Y');
    
    vsql := 'CREATE TABLE "STG_LINEUP" 
    (	"FILENAME" VARCHAR2(4000 BYTE), 
    "CL_ROW_ID" NUMBER, 
    "CL_STATION_NUM" nvarchar2(100), 
    "CL_HEADEND_ID" nvarchar2(100), 
    "CL_DEVICE" NVARCHAR2(2), 
    "CL_TMS_CHAN" NVARCHAR2(20), 
    "CL_SERVICE_TIER" NVARCHAR2(1), 
    "CL_EFFECTIVE_DATE" TIMESTAMP (0), 
    "CL_EXPIRATION_DATE" TIMESTAMP (0)
    ) nologging'; 
    CREATEOBJECT(vsql,'create table stg_lineup');

    vsql := 'DROP TABLE "ERR$_STG_LINEUP" PURGE';
    CREATEOBJECT(vsql,'Drop table err$_STG_LINEUP','Y');
    
    vsql := 'BEGIN
      DBMS_ERRLOG.create_error_log (dml_table_name => ''STG_LINEUP'');
    END;';    
    CREATEOBJECT(vsql,'create table err$_stg_lineup');

    vsql := 'DROP TABLE "STG_STATION" PURGE';
    CREATEOBJECT(vsql,'Drop table STG_STATION','Y');
    
    vsql := 'CREATE TABLE "STG_STATION" 
    (	"FILENAME" VARCHAR2(4000 BYTE), 
    "STATION_NUM" NVARCHAR2(100), 
    "STATION_TIME_ZONE" NVARCHAR2(100), 
    "STATION_NAME" NVARCHAR2(100), 
    "STATION_CALL_SIGN" NVARCHAR2(100), 
    "STATION_AFFIL" NVARCHAR2(100), 
    "STATION_CITY" NVARCHAR2(100), 
    "STATION_STATE" NVARCHAR2(100), 
    "STATION_ZIP_CODE" NVARCHAR2(100), 
    "STATION_COUNTRY" NVARCHAR2(100), 
    "DMA_NAME" NVARCHAR2(100), 
    "DMA_NUM" NUMBER, 
    "FCC_CHANNEL_NUM" NUMBER
     ) nologging';
    CREATEOBJECT(vsql,'create table stg_station');

    vsql := 'DROP TABLE "ERR$_STG_STATION" PURGE';
    CREATEOBJECT(vsql,'Drop table ERR$_STG_STATION','Y');
    
    vsql := 'BEGIN
      DBMS_ERRLOG.create_error_log (dml_table_name => ''STG_STATION'');
    END;';
    CREATEOBJECT(vsql,'create table err$_stg_station');
    
    vsql := 'DROP TABLE "STG_PROGRAM" PURGE';
    CREATEOBJECT(vsql,'Drop table STG_PROGRAM','Y');
    
    vsql := 'CREATE TABLE "STG_PROGRAM" 
    (	"FILENAME" VARCHAR2(4000 BYTE), 
      "DATABASE_KEY" NVARCHAR2(100), 
      "LANGUAGE" NVARCHAR2(100), 
      "TITLE" NVARCHAR2(1000), 
      "REDUCED_TITLE1" NVARCHAR2(1000), 
      "REDUCED_TITLE2" NVARCHAR2(1000), 
      "REDUCED_TITLE3" NVARCHAR2(1000), 
      "REDUCED_TITLE4" NVARCHAR2(1000), 
      "ALT_TITLE" NVARCHAR2(1000), 
      "REDUCED_DESCRIPTION1" NVARCHAR2(1000), 
      "REDUCED_DESCRIPTION2" NVARCHAR2(1000), 
      "REDUCED_DESCRIPTION3" NVARCHAR2(1000), 
      "REDUCED_DESCRIPTION4" NVARCHAR2(1000), 
      "ADVISORY_DESC1" NVARCHAR2(100), 
      "ADVISORY_DESC2" NVARCHAR2(100), 
      "ADVISORY_DESC3" NVARCHAR2(100), 
      "ADVISORY_DESC4" NVARCHAR2(100), 
      "ADVISORY_DESC5" NVARCHAR2(100), 
      "ADVISORY_DESC6" NVARCHAR2(100), 
      "GENRE_DESC1" NVARCHAR2(100), 
      "GENRE_DESC2" NVARCHAR2(100), 
      "GENRE_DESC3" NVARCHAR2(100), 
      "GENRE_DESC4" NVARCHAR2(100), 
      "GENRE_DESC5" NVARCHAR2(100), 
      "GENRE_DESC6" NVARCHAR2(100), 
      "DESCRIPTION1" NVARCHAR2(2000), 
      "DESCRIPTION2" NVARCHAR2(2000), 
      "YEAR_PROGRAM" NVARCHAR2(100), 
      "MPAA_RATING" NVARCHAR2(1000), 
      "STAR_RATING" NVARCHAR2(1000),
      "RUN_TIME" VARCHAR2(100), 
      "COLOR_CODE" NVARCHAR2(100), 
      "PROGRAM_LANGUAGE" NVARCHAR2(100), 
      "COUNTRY_OF_ORIGIN" NVARCHAR2(100), 
      "MADE_FOR_TV" NVARCHAR2(1), 
      "SOURCE_TYPE" NVARCHAR2(100), 
      "SHOW_TYPE" NVARCHAR2(200), 
      "HOLIDAY" NVARCHAR2(100), 
      "SYNDICATE_EPISODE_NUM" NVARCHAR2(100), 
      "ALT_SYNDICATE_EPI_NUM" NVARCHAR2(100), 
      "EPISODE_TITLE" NVARCHAR2(1000), 
      "NET_SYN_SOURCE" NVARCHAR2(100), 
      "NET_SYN_TYPE" NVARCHAR2(100), 
      "ORG_STUDIO" NVARCHAR2(100), 
      "GAME_DATETIME" TIMESTAMP (6),
      "GAME_TIMEZONE" NVARCHAR2(100), 
      "ORG_AIR_DATE" TIMESTAMP (6), 
      "UNIQUE_ID" NVARCHAR2(100),
      "USER_DATA" XMLTYPE,
      "PROGRAM_GENERIC" XMLTYPE,
      "CAST_NAME_ROLE" XMLTYPE,
      "CREDITS_NAME_ROLE" XMLTYPE,
      "PROGRAM_RATING" XMLTYPE,
      "AUDIO_COMPONENT"	XMLTYPE,
      "SUBTITLE_COMPONENT"	XMLTYPE
    ) nologging';
    CREATEOBJECT(vsql,'create table STG_PROGRAM');

    vsql := 'DROP TABLE "ERR$_STG_PROGRAM" PURGE';
    CREATEOBJECT(vsql,'Drop table ERR$_STG_PROGRAM','Y');
    
    vsql := 'BEGIN
      DBMS_ERRLOG.create_error_log (dml_table_name => ''STG_PROGRAM'',skip_unsupported=>TRUE);
    END;';
    CREATEOBJECT(vsql,'create table err$_STG_PROGRAM');

/*    vsql := 'CREATE INDEX "IDX_STGPRG_PRGID" ON STG_PROGRAM(DATABASE_KEY)';
    CREATEOBJECT(vsql,'Create Index IDX_STGPRG_PRGID','Y');
*/
    vsql := 'DROP TABLE "STG_SCHEDULE" PURGE';
    CREATEOBJECT(vsql,'Drop table STG_SCHEDULE','Y');
    
    vsql := 'CREATE TABLE "STG_SCHEDULE" 
       (	"FILENAME" VARCHAR2(4000 BYTE), 
      "STATION_NUM" NUMBER, 
      "DATABASE_KEY" NVARCHAR2(100), 
      "SCHEDULE_LANGUAGE" NVARCHAR2(100), 
      "AIR_DATE" TIMESTAMP(0) with time zone, 
      "DURATION" NUMBER, 
      "PART_NUM" NUMBER, 
      "NUM_OF_PARTS" NUMBER,  
      "CC" NVARCHAR2(1), 
      "STEREO" NVARCHAR2(1), 
      "REPEAT" NVARCHAR2(1), 
      "LIVE_TAPE_DELAY" NVARCHAR2(100), 
      "SUBTITLED" NVARCHAR2(1), 
      "PREMIERE_FINALE" NVARCHAR2(100), 
      "JOINED_IN_PROGRESS" NVARCHAR2(1), 
      "CABLE_IN_THE_CLASSROOM" NVARCHAR2(1), 
      "TV_RATING" NVARCHAR2(1000), 
      "SAP" NVARCHAR2(1), 
      "BLACKOUT" NVARCHAR2(1), 
      "SEX_RATING" NVARCHAR2(1), 
      "VIOLENCE_RATING" NVARCHAR2(1), 
      "LANGUAGE_RATING" NVARCHAR2(1), 
      "DIALOG_RATING" NVARCHAR2(1), 
      "FV_RATING" NVARCHAR2(1), 
      "ENHANCED" NVARCHAR2(1), 
      "THREE_D" NVARCHAR2(1), 
      "LETTERBOX" NVARCHAR2(1), 
      "HD_TV" NVARCHAR2(1), 
      "DOLBY" NVARCHAR2(100), 
      "DVS" NVARCHAR2(1),
      "EVENT_ID" XMLTYPE,
      "SERIES_LINK" XMLTYPE,
      "USER_DATA"	XMLTYPE,
      "SCHEDULE_GENERIC"	XMLTYPE
       ) nologging';
    CREATEOBJECT(vsql,'create table STG_SCHEDULE');

    vsql := 'DROP TABLE "ERR$_STG_SCHEDULE" PURGE';
    CREATEOBJECT(vsql,'Drop table ERR$_STG_SCHEDULE','Y');
    
    vsql := 'BEGIN
              DBMS_ERRLOG.create_error_log (dml_table_name => ''STG_SCHEDULE'',skip_unsupported=>TRUE);
            END;';
    CREATEOBJECT(vsql,'create table err$_STG_SCHEDULE');
/*
    vsql := 'CREATE INDEX "IDX_STGSCH_PK" ON STG_SCHEDULE(STATION_NUM,DATABASE_KEY,AIR_DATE)';
    CREATEOBJECT(vsql,'Create Index IDX_STGSCH_PK','Y');
*/    
    vsql := 'DROP TABLE "STG_CASTCREDITS" PURGE';
    CREATEOBJECT(vsql,'Drop table STG_CASTCREDITS','Y');
    
    vsql := 'CREATE TABLE "STG_CASTCREDITS" 
       (	"FILENAME" VARCHAR2(4000), 
          "DATABASE_KEY" NVARCHAR2(100), 
          "TYPE" NVARCHAR2(100), 
          "FIRST_NAME" NVARCHAR2(100), 
          "LAST_NAME" NVARCHAR2(100), 
          "ROLE_DESC" NVARCHAR2(100) 
       ) nologging';
    CREATEOBJECT(vsql,'create table STG_SCHEDULE');

    vsql := 'DROP TABLE "ERR$_STG_CASTCREDITS" PURGE';
    CREATEOBJECT(vsql,'Drop table ERR$_STG_CASTCREDITS','Y');
    
    vsql := 'BEGIN
              DBMS_ERRLOG.create_error_log (dml_table_name => ''STG_CASTCREDITS'');
            END;';
    CREATEOBJECT(vsql,'create table err$_stg_castcredits','Y');

    vsql := 'DROP TABLE "STG_SERIES" PURGE';
    CREATEOBJECT(vsql,'Drop table STG_SERIES','Y');
    
    vsql := 'CREATE TABLE STG_SERIES(FILENAME VARCHAR2(4000 BYTE),
              PROGRAM_ID NVARCHAR2(100),
              SERIES_ID NVARCHAR2(100)) nologging';
    CREATEOBJECT(vsql,'create table STG_SERIES');
    
    vsql := 'DROP TABLE epgguidedata_log PURGE';
    CREATEOBJECT(vsql,'Drop table epgguidedata_log','Y');
    
    vsql := 'CREATE TABLE epgguidedata_log(logdatetime timestamp default localtimestamp,
              description clob)';
    CREATEOBJECT(vsql,'create table epgguidedata_log');
    
    vsql := 'DROP TABLE "ERR$_STG_SERIES" PURGE';
    CREATEOBJECT(vsql,'Drop table ERR$_STG_SERIES','Y');
    
    vsql := 'BEGIN
      DBMS_ERRLOG.create_error_log (dml_table_name => ''STG_SERIES'');
    END;';
    CREATEOBJECT(vsql,'create table err$_STG_SERIES');

    vsql := 'DROP TABLE "ERR$_STATION" PURGE';
    CREATEOBJECT(vsql,'Drop table ERR$_STATION','Y');
    
    vsql := 'BEGIN
      DBMS_ERRLOG.create_error_log (dml_table_name => ''STATION'');
    END;';
    CREATEOBJECT(vsql,'create table err$_STATION');

    vsql := 'DROP TABLE "ERR$_LINEUP" PURGE';
    CREATEOBJECT(vsql,'Drop table ERR$_LINEUP','Y');
    
    vsql := 'BEGIN
      DBMS_ERRLOG.create_error_log (dml_table_name => ''LINEUP'');
    END;';
    CREATEOBJECT(vsql,'create table err$_LINEUP');

    vsql := 'DROP SEQUENCE EPGXMLFILES_SEQ';
    CREATEOBJECT(vsql,'drop sequence epgxmlfiles_seq','Y');

    vsql := 'CREATE SEQUENCE EPGXMLFILES_SEQ START WITH 1 INCREMENT BY 1';
    CREATEOBJECT(vsql,'create sequence epgxmlfiles_seq');

    createupdatetrg('CONFIG_SETTING');
    createupdatetrg('HEADEND');
    createupdatetrg('LINEUP');
    createupdatetrg('SERIES');
    createupdatetrg('SERIES_PROGRAM_MAP');
    createupdatetrg('STATION');
    createupdatetrg('PROGRAM');
    createupdatetrg('SCHEDULE');
    createupdatetrg('RECORDING');
    createupdatetrg('RECORDING_QUEUE');
    createupdatetrg('CAST_CREDITS');    
    createupdatetrg('ALARM_ACTIVITYLOG');
    createupdatetrg('RECORDING_LOG');
    createupdatetrg('ERROR_CODE'); 
    --Insert data
    vsql := 'insert into config_setting(key,value,created_by,updated_by) values (''PROGRAM.METADATA'',''TITLE,DESCRIPTION1,MPAA_RATING,EPISODE_TITLE'',''SYSTEM'',''SYSTEM'')';
    CREATEOBJECT(vsql,'insert into config_setting PROGRAM METADATA','Y');

    vsql := 'insert into config_setting(key,value,created_by,updated_by) values (''SCHEDULE.METADATA'',''DURATION,REPEAT,CC,TV_RATING'',''SYSTEM'',''SYSTEM'')';
    CREATEOBJECT(vsql,'insert into config_setting SCHEDULE METADATA','Y');

    commit;
END installtstv;
  
END TSTVDB;
/

begin
 tstvdb.installtstv();
end;
/

exit



