/* 
==============================================================
Database name:  WFS   
Schema Name:    WFS
Version: @version $Id: createWFS.sql,v 1.3 2009/11/07 01:18:34 mhabib Exp $                                 
DBMS name:      ORACLE Version 10.1 or 10.2                       
Script purpose: Create the WFS user and all its
		corresponding objects: sequences
		tables and constraints			
Created by:     Murtaza Habib 09/22/2008
NOTE:		Must be logged on as sys user    
          Update: MH 10/13/08: By Vijay: ## Update the Menu Item: TabbedPMMTitlesModify_ to Titles View permission
                                UPDATE WFS.TTV_MENUITEM SET PERMISSIONID = '35' WHERE MENUITEMID = '59'
      Update: MH 10/22/2008: By Vlada: CreatePMM Module: PMM Inserts for mandatory TTV self partner 
      Branch for Neptune project: MH 03/02/2009
        Changes submitted by Raj: 
        1) Drop the foreign key FK_TTV_RESOURCE_USERDATA
        2) Drop the following tables:
              TTV_MODULE
              TTV_PERMISSION
              TTV_ACTION
              TTV_MENUITEM
              TTV_BIGROLEPERMISSION
              BIGROLEPERMISSION
              BIGROLE
              BIGROLE_ROLE
              USER_BIGROLE
              USER_DATA
              USERS_REALM
      NEPTUNE Changes. Version 2.9
      Update: MH 04/01/2009: By Suneeta: changes to PMM_PROGRESSITEM table
          alter table PMM_PROGRESSITEM add (titleRevision varchar2(25) not null)
          alter table PMM_PROGRESSITEM add (sourcecomponentname varchar2(25) not null)
          alter table PMM_PROGRESSITEM add (sourceEntityName varchar2(25))
          alter table PMM_PROGRESSITEM add (sourceId varchar2(100) not null)
          alter table PMM_PROGRESSITEM drop column processid
          alter table PMM_PROGRESSITEM drop column tokenid
      Update: MH 04/01/2009: By Raj/Suneeta: changes to PMM_PROGRESSITEM table
          1) Drop the table PMM_TITLEMETADATA
          2) Drop the following columns from table PMM_TITLE:
              TITLENAME
              SPECIFICATION
              PARENTID
              ROOTTITLEID
              INTERNALLOCATION
              METADATALOCATION
          3) alter table PMM_PROGRESSITEM rename column TITLEREVISION to TITLEVERSION
          4) ALTER TABLE PMM_TITLE ADD ASSET_ID NUMBER
          5) ALTER TABLE PMM_TITLE ADD CONSTRAINT PMM_TITLE_ASSET FOREIGN KEY (ASSET_ID) REFERENCES MDM_ASSET(ID)
          6) Update system_release and system_Settings = 2.9
      Update: MH 04/27/09. Found a bug!
        Moved the following statement to metadata create script due to cross product dependency
      5) ALTER TABLE PMM_TITLE ADD CONSTRAINT PMM_TITLE_ASSET FOREIGN KEY (ASSET_ID) REFERENCES MDM_ASSET(ID)
      Update: MH 5/12/2009
        Suneeta changes. ALTER TABLE PMM_TITLE DROP COLUMN ISACTIVE;
      Update: MH 5/14/2009
        Suneeta changes.  insert into PMM_TitleStatus (id_, description) values(0, DRAFT)
                          insert into PMM_TitleStatus (id_, description) values(1, 'COMMITTED')
                          insert into PMM_TitleStatus (id_, description) values(2, 'READY')
                          insert into PMM_TitleStatus (id_, description) values(3, 'APPROVED')
                          insert into PMM_TitleStatus (id_, description) values(4, 'RETIRED')
                          New table for Title-Asset version status info: PMM_TITLEASSETSTATUS
    Update: MH 05/29/09. By QA/Dipti
      alter table PMM_PROGRESSITEM modify (DESCRIPTION varchar2(1000));
    Update: MH 06/08/09 By Suneeta
      ALTER TABLE PMM_JOB MODIFY (TEMPLATENAME VARCHAR2(255) NULL)
      ALTER TABLE PMM_JOB MODIFY (PROCESSPRIORITYID NUMBER NULL)
    Update: MH 06/17/09 By Suneeta
      ALTER TABLE PMM_PROGRESSITEM MODIFY (name varchar(50))
    Update: MH 07/13/09 By Suneeta
      CREATE TABLE PMM_CONTAINER_PROPERTIES
    Update: MH 08/04/09 By Suneeta
      alter table PMM_PROGRESSITEM add "ISACTIVE" NUMBER(1,0) DEFAULT (1) not null;
      ALTER TABLE WFS.PMM_Title_TitleListXREF drop  constraint PK_PMM_TITLE_TITLELISTXREF;
      ALTER TABLE WFS.PMM_Title_TitleListXREF ADD ( CONSTRAINT PK_PMM_Title_TitleListXREF PRIMARY KEY (TitleListId, TitleId,ORDER_));
    Update: MH 10/28/      
=============================================================
*/
CREATE OR REPLACE PACKAGE SYS.createWFSDB AS
	PROCEDURE INSTALL_WFS;
	INSTALL_FAILED EXCEPTION;
  vschema varchar2(100) := 'WFS';

END;
/

CREATE OR REPLACE PACKAGE BODY SYS.createWFSDB AS
 
 /* Procedure: CreateObject. Executes a dynamic SQL statement and logs error in install_table*/
  PROCEDURE CREATEOBJECT(vsql varchar2,errmsg varchar2, mask varchar2 default 'N') IS
    verrmsg varchar2(32000);
  BEGIN
    execute immediate vsql;
  exception
    when others then
          verrmsg := substr(errmsg ||' '||sqlerrm,1,4000);
          --dbms_output.put_line(vsql);
      if upper(mask) != 'Y' then
          execute immediate 'INSERT INTO install_table values('''||sysdate||''','''||replace(verrmsg,'''')||''')';
          commit;
          raise;
      end if;
  END CREATEOBJECT;
  
/* Procedure: SetDbCreateFileDest. Sets the default directory for Oracle datafiles so the path
              need not be given when creating tablespaces. */
  PROCEDURE SETDBCREATEFILEDEST(vpath varchar2) IS
  BEGIN
    execute immediate 'alter system set db_create_file_dest='''||vpath||''' scope=both';
  END SETDBCREATEFILEDEST;

/* Procedure: CreateSeq. Creates a sequence on a primary key of a table.
              Sequence name is <tablename>SEQ.*/
  PROCEDURE CREATESEQ(vtabname varchar2, vstartwith number default 1) IS
    vcolname dba_cons_columns.column_name%type;
    vsql varchar2(32000);
  BEGIN
    select dcc.column_name 
    into vcolname
    from dba_constraints dc, dba_cons_columns dcc
    where dc.owner='WFS'
    and dc.owner = dcc.owner
    and dc.table_name = dcc.table_name
    and dc.table_name=upper(vtabname)
    and dc.constraint_type='P'
    and dc.constraint_name = dcc.constraint_name
    and rownum < 2;
    
		-- Create Sequence for Table
      vsql :=  'CREATE SEQUENCE wfs.'||vtabname||'_SEQ INCREMENT BY 1 START WITH '||vstartwith||' NOCACHE';
      CREATEOBJECT(vsql,'Create Sequence'||vtabname||'_SEQ','Y');

    -- Create before insert trigger to populate the PK column  
      vsql := 'CREATE OR REPLACE TRIGGER wfs.'||vtabname||'TRG BEFORE INSERT ON wfs.'||vtabname||' FOR EACH ROW
            DECLARE
              vseq number;
            BEGIN
              if (:new.'||vcolname||' is null) then
                select wfs.'||vtabname||'_SEQ.nextval into vseq from dual;
                :new.'||vcolname||' := vseq;
              end if;
            END;';
      CREATEOBJECT(vsql,'Create Trigger '||vtabname||'TRG');
   END CREATESEQ;

/* Procedure: CreateUpdTimeTRG. Updates the UpdateTime column with the current date and time when any
              update statement is issued against the table.*/
  PROCEDURE CREATEUPDATETRG(vtabname varchar2) IS
    vcount number := 0;
    vsql varchar2(32000);
  BEGIN
    select count(*)
    into vcount
    from dba_tables dt, dba_tab_columns dtc
    where dt.owner='WFS'
    and dt.owner = dtc.owner
    and dt.table_name = dtc.table_name
    and dt.table_name=upper(vtabname)
    and dtc.column_name = 'UPDATEDATE';
    
	  if ( vcount > 0 ) then
      vsql := 'CREATE OR REPLACE TRIGGER wfs.'||vtabname||'UPD BEFORE UPDATE ON wfs.'||vtabname||' FOR EACH ROW
            DECLARE
              vsysdate timestamp;
            BEGIN
              select systimestamp into vsysdate from dual;
              :new.updatedate := vsysdate;
            END;';
      CREATEOBJECT(vsql,'Create Trigger '||vtabname||'UPD');
    end if;

   END CREATEUPDATETRG;

  PROCEDURE createWFS IS
  /*  
          Created By:  	Larry Roberts 12/14/2006
          Create Reason: 	Create WFS tables, sequences,triggers,views,etc
                          To create all objects in another schema beside WFS change 
                          WFS to another schema name prior to compiling and 
                          executing this procedure
          Note:		When run, this procedure will log any error message into the 
                          install_table and exit.
          Updated By:     Chris Scherlacher 8/15/2007
          Update Reason:  Updated create procedure for the WP 2.5 changes
          Updated By: 	  Daniel Weiner 6/27/2008
          Update Reason:  Added in better error handling, starting integration of PMM with the rest
          					  of the WFS scripts.
          Updated By: 	  Murtaza Habib 09/22/2008
          Update Reason:  Made the script more readable by creating modular functions/procedures.
          
  */
  
          vsql varchar2(32000);
          wk_database_path	varchar2(100);
          wk_message		varchar2(500);
          err_msg		varchar2(500);
          wk_count		number := 0;
          wk_instancename	v$instance.instance_name%type;
  
  BEGIN
          wk_message := '';
  
  /* 
  ------------------------------------
      CREATE USERS
  ------------------------------------
  */
  
    -- Drop the install_table
    vsql:='Drop table sys.install_table';
		CREATEOBJECT(vsql,'DROP INSTALL_TABLE','Y');
      
    
    -- Create Install_table
    vsql:='CREATE TABLE sys.install_table (msgdate date default sysdate, install_message varchar2(4000))';
		CREATEOBJECT(vsql,'CREATE SYS.INSTALL_TABLE');
--  
--      EXECUTE IMMEDIATE 'CREATE TABLE install_table (install_message varchar2(500))';
/*      
      -- Verify the WFS user does not exist
    BEGIN
    
      SELECT count(*)
      INTO wk_count
      FROM all_users
      WHERE username = 'WFS';
      
    END;
    
    IF wk_count < 20 THEN
    
      wk_message := 'ERROR';
      EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (sysdate,''error in installing of application database objects:  
            The WFS user already exists.'')';
  		EXECUTE IMMEDIATE 'INSERT INTO install_table values (sysdate,'''||err_msg||''')';
      GOTO bypass_install;
     
    END IF; 
*/  
    /* ------ DATAREADERROLE Role ----- */
  
    --- Create the DATAREADERROLE
	
	DECLARE
		readerRoleExists NUMBER;
    BEGIN		
	  --EXECUTE IMMEDIATE 'CREATE ROLE DATAREADERROLE NOT IDENTIFIED';
      SELECT COUNT(*) INTO readerRoleExists  FROM DBA_Roles WHERE ROLE = 'DATAREADERROLE';
      IF (readerRoleExists<1) THEN
        vsql:='CREATE ROLE DATAREADERROLE';
        CREATEOBJECT(vsql,'Unable to create the DATAREADERFOLE');
      END IF;
    END;
  
    vsql:='GRANT CONNECT TO DATAREADERROLE';
    CREATEOBJECT(vsql,'Unable to grant CONNECT to the DATAREADERROLE role.');

    vsql:='GRANT CREATE SESSION TO DATAREADERROLE';
    CREATEOBJECT(vsql,'Unable to grant SESSION to the DATAREADERROLE.');
    
    vsql:='GRANT SELECT ANY TABLE TO DATAREADERROLE';
    CREATEOBJECT(vsql,'Unable to grant SELECT ANY TABLE to the DATAREADERROLE');
  
    --- Create the DATAWRITERROLE
	DECLARE
      writerRoleExists NUMBER;
    BEGIN
       SELECT COUNT(*) INTO writerRoleExists  FROM DBA_Roles WHERE ROLE = 'DATAWRITERROLE';
      IF (writerRoleExists<1) THEN
        vsql:='CREATE ROLE DATAWRITERROLE';
        CREATEOBJECT(vsql,'Unable to create the DATAWRITERROLE');
      END IF;
    END;
  
    vsql:='GRANT CONNECT TO DATAWRITERROLE';
    CREATEOBJECT(vsql,'Unable to grant CONNECT to the DATAWRITERROLE role');
  
    vsql:='GRANT CREATE SESSION TO DATAWRITERROLE';
    CREATEOBJECT(vsql,'Unable to grant SESSION to the DATAWRITERROLE role');

    vsql:='GRANT DELETE ANY TABLE TO DATAWRITERROLE';
    CREATEOBJECT(vsql,'Unable to grant DELETE ANY TABLE to the DATAWRITERROLE role');
  
    vsql:='GRANT INSERT ANY TABLE TO DATAWRITERROLE';
    CREATEOBJECT(vsql,'Unable to grant INSERT ANY TABLE to the DATAWRITERROLE role');
    
    vsql:='GRANT UPDATE ANY TABLE TO DATAWRITERROLE';
    CREATEOBJECT(vsql,'Unable to grant UPDATE ANY TABLE to the DATAWRITERROLE role');

    /*
		--------------------------------------------------------------------
		CREATE WFS USER AND TABLESPACES
		--------------------------------------------------------------------
		*/
		
		SELECT INSTANCE_NAME INTO wk_instancename FROM V$INSTANCE;
    
    -- Set db_create_file_dest to default directory
    
    select substr(file_name,1,instr(file_name,'/',-1) -1)
    INTO vsql
    from dba_data_files
    WHERE tablespace_name = 'SYSTEM';
    
    SETDBCREATEFILEDEST(vsql);
		
     -- Drop WFS_data tablespace
      vsql :='drop tablespace WFS_data including contents and datafiles';
			CREATEOBJECT(vsql,'DROP TABLESPACE WFS_data','Y');

      -- Creating WFS_data tablespace
      vsql :='create tablespace WFS_data datafile size 500M AUTOEXTEND ON NEXT 250M MAXSIZE UNLIMITED EXTENT MANAGEMENT LOCAL AUTOALLOCATE SEGMENT SPACE MANAGEMENT AUTO';
			CREATEOBJECT(vsql,'CREATE TABLESPACE WFS_data');
		
		-- Set Default temp tablespace to temp
      vsql :=  'ALTER DATABASE DEFAULT TEMPORARY TABLESPACE temp';
      CREATEOBJECT(vsql,'Default Tablespace temp','Y');

		--DROP WFS USER
      vsql :=  'drop user WFS cascade';
      CREATEOBJECT(vsql,'DROP USER WFS','Y');

		--CREATE WFS USER
      vsql :=  'create user WFS identified by Wf$1234 default tablespace wfs_data';
      CREATEOBJECT(vsql,'CREATE USER wfs');
      
		--Grant privs to WFS user
      vsql :=  'grant resource, connect, create session to WFS';
      CREATEOBJECT(vsql,'Unable to grant dbs, resource, connect, and create session to the WFS user.');

    /* ---------- WFSDW User ---------- */
  
		--DROP WFSDW USER
      vsql :=  'drop user WFSDW cascade';
      CREATEOBJECT(vsql,'DROP USER WFSDW','Y');

		--CREATE WFS USER
      vsql :=  'create user WFSDW identified by WFSDW default tablespace WFS_data';
      CREATEOBJECT(vsql,'CREATE USER wfsdw');

		--Grant privs to WFSDW user
      vsql :=  'grant DataReaderRole, DataWriterRole,connect,resource to WFSDW';
      CREATEOBJECT(vsql,'Unable to grant DataReaderRole and DataWriterRole to the WFSDW user');

  /*
  -----------------------------------------
   CREATING ALL SEQUENCES 
  -----------------------------------------
  */
  
      vsql :=  'CREATE SEQUENCE WFS.ALERTS_HIST_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.ALERTS_HIST_ID');

/*      vsql :=  'CREATE SEQUENCE WFS.JBPM_ACTION_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.JBPM_ACTION_SEQ');
  
      vsql :=  'CREATE SEQUENCE WFS.JBPM_BYTEARRAY_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.JBPM_BYTEARRAY_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.JBPM_COMMENT_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.JBPM_COMMENT_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.JBPM_DELEGATION_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.JBPM_DELEGATION_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.JBPM_EVENT_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.JBPM_EVENT_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.JBPM_EXCEPTIONHANDLER_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.JBPM_EXCEPTIONHANDLER_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.JBPM_ID_GROUP_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.JBPM_ID_GROUP_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.JBPM_ID_MEMBERSHIP_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.JBPM_ID_MEMBERSHIP_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.JBPM_ID_USER_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.JBPM_ID_USER_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.JBPM_LOG_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.JBPM_LOG_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.JBPM_MESSAGE_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.JBPM_MESSAGE_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.JBPM_MODULEDEFINITION_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.JBPM_MODULEDEFINITION_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.JBPM_MODULEINSTANCE_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.JBPM_MODULEINSTANCE_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.JBPM_NODE_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.JBPM_NODE_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.JBPM_POOLEDACTOR_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.JBPM_POOLEDACTOR_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.JBPM_PROCESSDEFINITION_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.JBPM_PROCESSDEFINITION_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.JBPM_PROCESSINSTANCE_SEQ INCREMENT BY 1 START WITH 3 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.JBPM_PROCESSINSTANCE_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.JBPM_RUNTIMEACTION_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.JBPM_RUNTIMEACTION_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.JBPM_SWIMLANEINSTANCE_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.JBPM_SWIMLANEINSTANCE_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.JBPM_SWIMLANE_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.JBPM_SWIMLANE_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.JBPM_TASKCONTROLLER_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.JBPM_TASKCONTROLLER_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.JBPM_TASKINSTANCE_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.JBPM_TASKINSTANCE_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.JBPM_TASK_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.JBPM_TASK_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.JBPM_TIMER_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.JBPM_TIMER_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.JBPM_TOKENVARIABLEMAP_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.JBPM_TOKENVARIABLEMAP_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.JBPM_TOKEN_SEQ INCREMENT BY 1 START WITH 3 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.JBPM_TOKEN_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.JBPM_TRANSITION_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.JBPM_TRANSITION_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.JBPM_VARIABLEACCESS_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.JBPM_VARIABLEACCESS_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.JBPM_VARIABLEINSTANCE_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.JBPM_VARIABLEINSTANCE_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.TTV_ACCESSLEVEL_SEQ INCREMENT BY 1 START WITH 3 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.TTV_ACCESSLEVEL_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.TTV_ACTION_SEQ INCREMENT BY 1 START WITH 88 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.TTV_ACTION_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.TTV_BIGROLEPERMISSION_SEQ INCREMENT BY 1 START WITH 442 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.TTV_BIGROLEPERMISSION_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.TTV_CONNECTIONTYPE_SEQ INCREMENT BY 1 START WITH 4 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.TTV_CONNECTIONTYPE_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.TTV_DATATYPE_SEQ INCREMENT BY 1 START WITH 8 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.TTV_DATATYPE_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.TTV_MENUITEM_SEQ INCREMENT BY 1 START WITH 43 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.TTV_MENUITEM_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.TTV_MESSAGELOG_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.TTV_MESSAGELOG_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.TTV_MODULE_SEQ INCREMENT BY 1 START WITH 9 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.TTV_MODULE_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.TTV_MONITOREDDRIVEHISTORY_SEQ INCREMENT BY 1 START WITH 9 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.TTV_MONITOREDDRIVEHISTORY_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.TTV_MONITOREDDRIVESTATUS_SEQ INCREMENT BY 1 START WITH 3 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.TTV_MONITOREDDRIVESTATUS_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.TTV_MONITOREDDRIVE_SEQ INCREMENT BY 1 START WITH 3 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.TTV_MONITOREDDRIVE_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.TTV_PERMISSION_SEQ INCREMENT BY 1 START WITH 25 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.TTV_PERMISSION_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.TTV_PROCESSDEFINITIONTYPE_SEQ INCREMENT BY 1 START WITH 4 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.TTV_PROCESSDEFINITIONTYPE_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.TTV_PROCESSINSTANCENOTE_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.TTV_PROCESSINSTANCENOTE_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.TTV_PROCESSINSTANCETYPE_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.TTV_PROCESSINSTANCETYPE_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.TTV_PROCESSPRIORITY_SEQ INCREMENT BY 1 START WITH 5 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.TTV_PROCESSINSTANCETYPE_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.TTV_PROCESSSTATUS_SEQ INCREMENT BY 1 START WITH 8 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.TTV_PROCESSSTATUS_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.TTV_RESOURCEGROUPQUEUEITEM_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.TTV_RESOURCEGROUPQUEUEITEM_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.TTV_RESOURCEGROUP_SEQ INCREMENT BY 1 START WITH 115 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.TTV_RESOURCEGROUP_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.TTV_RESOURCESTATUS_SEQ INCREMENT BY 1 START WITH 7 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.TTV_RESOURCESTATUS_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.TTV_RESOURCETYPE_SEQ INCREMENT BY 1 START WITH 34 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.TTV_RESOURCETYPE_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.TTV_RESOURCEUSAGEHISTORY_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.TTV_RESOURCEUSAGEHISTORY_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.TTV_RESOURCE_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.TTV_RESOURCE_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.TTV_STRATEGYCLASSTYPE_SEQ INCREMENT BY 1 START WITH 4 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.TTV_STRATEGYCLASSTYPE_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.TTV_STRATEGYCLASS_SEQ INCREMENT BY 1 START WITH 10 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.TTV_STRATEGYCLASS_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.TTV_TOKENTYPE_SEQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.TTV_TOKENTYPE_SEQ');

      vsql :=  'CREATE SEQUENCE WFS.TTV_VARIABLEACCESSTYPE_SEQ INCREMENT BY 1 START WITH 3 NOMAXVALUE NOMINVALUE NOCYCLE ORDER';
      CREATEOBJECT(vsql,'Unable to create sequence WFS.TTV_VARIABLEACCESSTYPE_SEQ');
*/
  /*
  -----------------------------------------
   CREATING ALL TABLES AND PRIMARY KEYS
  -----------------------------------------
  */

    -- creating table SYSTEM_SETTINGS
      vsql :=  'CREATE TABLE WFS.SYSTEM_SETTINGS (SETTING_TYPE  VARCHAR2(25), SETTING_VALUE VARCHAR2(1024))';
      CREATEOBJECT(vsql,'Unable to create table SYSTEM_SETTINGS');

    -- creating table ALERTS
      vsql :=  'CREATE TABLE WFS.ALERTS ( 
          IDENTIFIER  	VARCHAR2(32) NOT NULL,
          ALERT_NAME  	VARCHAR2(64) NOT NULL,
          THRESH_COUNT	NUMBER NULL,
          THRESH_SECS 	NUMBER NULL,
          FREQ_COUNT  	NUMBER NULL,
          FREQ_SECS   	NUMBER NULL,
          TYPE        	VARCHAR2(16) NULL,
          CONSTRAINT PK_ALERTS PRIMARY KEY (IDENTIFIER)
          )';
      CREATEOBJECT(vsql,'Unable to create table ALERTS');

    -- creating table ALERTS_HIST
      vsql :=  'CREATE TABLE WFS.ALERTS_HIST ( 
          HIST_KEY  	NUMBER NOT NULL,
          TIME_KEY  	DATE NULL,
          IDENTIFIER	VARCHAR2(32) NOT NULL,
          ALERT_NAME	VARCHAR2(64) NULL,
          ALERT_TYPE	VARCHAR2(64) NULL,
          MSG       	VARCHAR2(4000) NULL,
          CONSTRAINT PK_ALERTS_HIST PRIMARY KEY (HIST_KEY))';
      CREATEOBJECT(vsql,'Unable to create table ALERTS_HIST');

    -- creating table ALERT_ACTIONS
       vsql :=  'CREATE TABLE WFS.ALERT_ACTIONS ( 
          IDENTIFIER 	VARCHAR2(32) NOT NULL,
          ACTION_TYPE	NUMBER NULL,
          DETAIL     	VARCHAR2(64) NULL 
          ) ';
      CREATEOBJECT(vsql,'Unable to create table ALERT_ACTIONS');
  
    -- creating table ALERT_ACTIONS_HIST
       vsql :=  'CREATE TABLE WFS.ALERT_ACTIONS_HIST(
                  HIST_KEY     NUMERIC(19,0)           NOT NULL,
                  ACTION_TYPE  NUMERIC(19,0),
                  DETAIL       VARCHAR2(64)) ';
      CREATEOBJECT(vsql,'Unable to create table ALERT_ACTIONS_HIST');

    -- creating table ALERT_NAMES
       vsql :=  'CREATE TABLE WFS.ALERT_NAMES(
                  ALERT_NAME  VARCHAR2(64)                 NOT NULL,
                  PATTERN     VARCHAR2(64)                 NOT NULL,
                  CONSTRAINT PK_ALERT_NAMES PRIMARY KEY (ALERT_NAME)
                  )';
      CREATEOBJECT(vsql,'Unable to create table ALERT_NAMES');

    -- creating table JBPM_ACTION
       vsql :=  'CREATE TABLE WFS.JBPM_ACTION ( 
          ID_                   	NUMBER(19,0) NOT NULL,
          CLASS                 	CHAR(1) NOT NULL,
          NAME_                 	VARCHAR2(255) NULL,
          ISPROPAGATIONALLOWED_ 	NUMBER NULL,
          ACTIONEXPRESSION_     	VARCHAR2(255) NULL,
          ISASYNC_              	NUMBER NULL,
          REFERENCEDACTION_     	NUMBER(19,0) NULL,
          ACTIONDELEGATION_     	NUMBER(19,0) NULL,
          EVENT_                	NUMBER(19,0) NULL,
          PROCESSDEFINITION_    	NUMBER(19,0) NULL,
          TIMERNAME_            	VARCHAR2(255) NULL,
          DUEDATE_              	VARCHAR2(255) NULL,
          REPEAT_               	VARCHAR2(255) NULL,
          TRANSITIONNAME_       	VARCHAR2(255) NULL,
          TIMERACTION_          	NUMBER(19,0) NULL,
          EXPRESSION_           	VARCHAR2(4000) NULL,
          EVENTINDEX_           	NUMBER NULL,
          EXCEPTIONHANDLER_     	NUMBER(19,0) NULL,
          EXCEPTIONHANDLERINDEX_	NUMBER NULL,
          CREATEDATE            	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE            	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_ACTION PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_ACTION');
      CREATESEQ('JBPM_ACTION');
      CREATEUPDATETRG('JBPM_ACTION');
      
    -- Creating index IDX_JBPMACTION_REFERENCEACTION
       vsql :=  'CREATE INDEX WFS.IDX_JBPMACTION_REFERENCEACTION ON WFS.JBPM_ACTION(REFERENCEDACTION_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPMACTION_REFERENCEACTION');      
      
    -- creating table JBPM_BYTEARRAY
       vsql :=  'CREATE TABLE WFS.JBPM_BYTEARRAY ( 
          ID_            	NUMBER(19,0) NOT NULL,
          NAME_          	VARCHAR2(255) NULL,
          FILEDEFINITION_	NUMBER(19,0) NULL,
          CREATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_BYTEARRAY PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_BYTEARRAY');
      CREATESEQ('JBPM_BYTEARRAY');
      CREATEUPDATETRG('JBPM_BYTEARRAY');
      
    -- creating table JBPM_BYTEBLOCK
       vsql :=  'CREATE TABLE WFS.JBPM_BYTEBLOCK ( 
          PROCESSFILE_	NUMBER(19,0) NOT NULL,
          BYTES_      	RAW(1024) NULL,
          INDEX_      	NUMBER NOT NULL,
          CREATEDATE  	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE  	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_BYTEBLOCK PRIMARY KEY (PROCESSFILE_, INDEX_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_BYTEBLOCK');
      CREATEUPDATETRG('JBPM_BYTEBLOCK');
      
    -- creating table JBPM_COMMENT
       vsql :=  'CREATE TABLE WFS.JBPM_COMMENT ( 
          ID_               	NUMBER(19,0) NOT NULL,
          VERSION_          	NUMBER NOT NULL,
          ACTORID_          	VARCHAR2(255) NULL,
          TIME_             	TIMESTAMP(6) NULL,
          MESSAGE_          	VARCHAR2(4000) NULL,
          TOKEN_            	NUMBER(19,0) NULL,
          TASKINSTANCE_     	NUMBER(19,0) NULL,
          TOKENINDEX_       	NUMBER NULL,
          TASKINSTANCEINDEX_	NUMBER NULL,
          CREATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_COMMENT PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_COMMENT');
      CREATESEQ('JBPM_COMMENT');
      CREATEUPDATETRG('JBPM_COMMENT');
      
    -- Creating index IDX_JBPM_COMMENT_01
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_COMMENT_01 ON WFS.JBPM_COMMENT(TOKEN_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_COMMENT_01');

    -- Creating index IDX_JBPM_COMMENT_02
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_COMMENT_02 ON WFS.JBPM_COMMENT (TASKINSTANCE_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_COMMENT_02');

    -- creating table JBPM_DECISIONCONDITIONS
       vsql :=  'CREATE TABLE WFS.JBPM_DECISIONCONDITIONS ( 
          DECISION_      	NUMBER(19,0) NOT NULL,
          TRANSITIONNAME_	VARCHAR2(255) NULL,
          EXPRESSION_    	VARCHAR2(255) NULL,
          INDEX_         	NUMBER NOT NULL,
          CREATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_DECISIONCONDITIONS PRIMARY KEY (DECISION_, INDEX_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_DECISIONCONDITIONS');
      CREATEUPDATETRG('JBPM_DECISIONCONDITIONS');
      
    -- creating table JBPM_DELEGATION
       vsql :=  'CREATE TABLE WFS.JBPM_DELEGATION ( 
          ID_               	NUMBER(19,0) NOT NULL,
          CLASSNAME_        	VARCHAR2(4000) NULL,
          CONFIGURATION_    	VARCHAR2(4000) NULL,
          CONFIGTYPE_       	VARCHAR2(255) NULL,
          PROCESSDEFINITION_	NUMBER(19,0) NULL,
          CREATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_DELEGATION PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_DELEGATION');
      CREATESEQ('JBPM_DELEGATION');
      CREATEUPDATETRG('JBPM_DELEGATION');

    -- creating table JBPM_EVENT
       vsql :=  'CREATE TABLE WFS.JBPM_EVENT ( 
          ID_               	NUMBER(19,0) NOT NULL,
          EVENTTYPE_        	VARCHAR2(255) NULL,
          TYPE_             	CHAR(1) NULL,
          GRAPHELEMENT_     	NUMBER(19,0) NULL,
          PROCESSDEFINITION_	NUMBER(19,0) NULL,
          NODE_             	NUMBER(19,0) NULL,
          TRANSITION_       	NUMBER(19,0) NULL,
          TASK_             	NUMBER(19,0) NULL,
          CREATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_EVENT PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_EVENT');
      CREATESEQ('JBPM_EVENT');
      CREATEUPDATETRG('JBPM_EVENT');
      
   -- Create index IDX_JBPMEVENT_TRANSITION
       vsql :=  'CREATE INDEX WFS.IDX_JBPMEVENT_TRANSITION ON WFS.JBPM_EVENT(TRANSITION_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPMEVENT_TRANSITION on JBPM_EVENT table');      
      
    -- creating table JBPM_EXCEPTIONHANDLER
       vsql :=  'CREATE TABLE WFS.JBPM_EXCEPTIONHANDLER ( 
          ID_                	NUMBER(19,0) NOT NULL,
          EXCEPTIONCLASSNAME_	VARCHAR2(4000) NULL,
          TYPE_              	CHAR(1) NULL,
          GRAPHELEMENT_      	NUMBER(19,0) NULL,
          PROCESSDEFINITION_ 	NUMBER(19,0) NULL,
          GRAPHELEMENTINDEX_ 	NUMBER NULL,
          NODE_              	NUMBER(19,0) NULL,
          TRANSITION_        	NUMBER(19,0) NULL,
          TASK_              	NUMBER(19,0) NULL,
          CREATEDATE         	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE         	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_EXCEPTIONHANDLER PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_EXCEPTIONHANDLER');
      CREATESEQ('JBPM_EXCEPTIONHANDLER');
      CREATEUPDATETRG('JBPM_EXCEPTIONHANDLER');
      
    -- creating table JBPM_ID_GROUP
       vsql :=  'CREATE TABLE WFS.JBPM_ID_GROUP ( 
          ID_       	NUMBER(19,0) NOT NULL,
          CLASS_    	CHAR(1) NOT NULL,
          NAME_     	VARCHAR2(255) NULL,
          TYPE_     	VARCHAR2(255) NULL,
          PARENT_   	NUMBER(19,0) NULL,
          CREATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_ID_GROUP PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_ID_GROUP');
       CREATESEQ('JBPM_ID_GROUP');
      CREATEUPDATETRG('JBPM_ID_GROUP');
      
    -- creating table JBPM_ID_MEMBERSHIP
       vsql :=  'CREATE TABLE WFS.JBPM_ID_MEMBERSHIP ( 
          ID_       	NUMBER(19,0) NOT NULL,
          CLASS_    	CHAR(1) NOT NULL,
          NAME_     	VARCHAR2(255) NULL,
          ROLE_     	VARCHAR2(255) NULL,
          USER_     	NUMBER(19,0) NULL,
          GROUP_    	NUMBER(19,0) NULL,
          CREATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_ID_MEMBERSHIP PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_ID_MEMBERSHIP');
      CREATESEQ('JBPM_ID_MEMBERSHIP');
      CREATEUPDATETRG('JBPM_ID_MEMBERSHIP');

    -- creating table JBPM_ID_PERMISSIONS
       vsql :=  'CREATE TABLE WFS.JBPM_ID_PERMISSIONS ( 
          ENTITY_   	NUMBER(19,0) NOT NULL,
          CLASS_    	VARCHAR2(255) NULL,
          NAME_     	VARCHAR2(255) NULL,
          ACTION_   	VARCHAR2(255) NULL,
          CREATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_ID_PERMISSIONS');
  
    -- creating table JBPM_ID_USER
       vsql :=  'CREATE TABLE WFS.JBPM_ID_USER ( 
          ID_       	NUMBER(19,0) NOT NULL,
          CLASS_    	CHAR(1) NOT NULL,
          NAME_     	VARCHAR2(255) NULL,
          EMAIL_    	VARCHAR2(255) NULL,
          PASSWORD_ 	VARCHAR2(255) NULL,
          CREATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_ID_USER PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_ID_USER');
      CREATESEQ('JBPM_ID_USER');
      CREATEUPDATETRG('JBPM_ID_USER');

    -- creating table JBPM_LOG
       vsql :=  'CREATE TABLE WFS.JBPM_LOG ( 
          ID_                   	NUMBER(19,0) NOT NULL,
          CLASS_                	CHAR(1) NOT NULL,
          INDEX_                	NUMBER NULL,
          DATE_                 	TIMESTAMP(6) NULL,
          TOKEN_                	NUMBER(19,0) NULL,
          PARENT_               	NUMBER(19,0) NULL,
          MESSAGE_              	VARCHAR2(4000) NULL,
          EXCEPTION_            	VARCHAR2(4000) NULL,
          ACTION_               	NUMBER(19,0) NULL,
          NODE_                 	NUMBER(19,0) NULL,
          ENTER_                	TIMESTAMP(6) NULL,
          LEAVE_                	TIMESTAMP(6) NULL,
          DURATION_             	NUMBER(19,0) NULL,
          TRANSITION_           	NUMBER(19,0) NULL,
          CHILD_                	NUMBER(19,0) NULL,
          SOURCENODE_           	NUMBER(19,0) NULL,
          DESTINATIONNODE_      	NUMBER(19,0) NULL,
          VARIABLEINSTANCE_     	NUMBER(19,0) NULL,
          OLDBYTEARRAY_         	NUMBER(19,0) NULL,
          NEWBYTEARRAY_         	NUMBER(19,0) NULL,
          OLDDATEVALUE_         	TIMESTAMP(6) NULL,
          NEWDATEVALUE_         	TIMESTAMP(6) NULL,
          OLDDOUBLEVALUE_       	FLOAT NULL,
          NEWDOUBLEVALUE_       	FLOAT NULL,
          OLDLONGIDCLASS_       	VARCHAR2(255) NULL,
          OLDLONGIDVALUE_       	NUMBER(19,0) NULL,
          NEWLONGIDCLASS_       	VARCHAR2(255) NULL,
          NEWLONGIDVALUE_       	NUMBER(19,0) NULL,
          OLDSTRINGIDCLASS_     	VARCHAR2(255) NULL,
          OLDSTRINGIDVALUE_     	VARCHAR2(255) NULL,
          NEWSTRINGIDCLASS_     	VARCHAR2(255) NULL,
          NEWSTRINGIDVALUE_     	VARCHAR2(255) NULL,
          OLDLONGVALUE_         	NUMBER(19,0) NULL,
          NEWLONGVALUE_         	NUMBER(19,0) NULL,
          OLDSTRINGVALUE_       	VARCHAR2(4000) NULL,
          NEWSTRINGVALUE_       	VARCHAR2(4000) NULL,
          TASKINSTANCE_         	NUMBER(19,0) NULL,
          TASKACTORID_          	VARCHAR2(255) NULL,
          TASKOLDACTORID_       	VARCHAR2(255) NULL,
          SWIMLANEINSTANCE_     	NUMBER(19,0) NULL,
          CREATEDATE            	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE            	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          RESOURCEGROUPID       	NUMBER NULL,
          RESOURCEID            	NUMBER NULL,
          OPERATIONALSTATUSID   	NUMBER NULL,
          ADMINISTRATIVESTATUSID	NUMBER NULL,
          CONSTRAINT PK_JBPM_LOG PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_LOG');
      CREATESEQ('JBPM_LOG');
      CREATEUPDATETRG('JBPM_LOG');

   -- Create index IDX_JBPM_LOG_01
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_LOG_01 ON WFS.JBPM_LOG (CLASS_, NODE_, TOKEN_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_LOG_01 on JBPM_LOG table');

    -- creating table JBPM_MESSAGE
       vsql :=  'CREATE TABLE WFS.JBPM_MESSAGE ( 
          ID_            	NUMBER(19,0) NOT NULL,
          CLASS_         	CHAR(1) NOT NULL,
          DESTINATION_   	VARCHAR2(255) NULL,
          EXCEPTION_     	VARCHAR2(255) NULL,
          ISSUSPENDED_   	NUMBER NULL,
          TOKEN_         	NUMBER(19,0) NULL,
          TEXT_          	VARCHAR2(255) NULL,
          ACTION_        	NUMBER(19,0) NULL,
          NODE_          	NUMBER(19,0) NULL,
          TRANSITIONNAME_	VARCHAR2(255) NULL,
          TASKINSTANCE_  	NUMBER(19,0) NULL,
          CREATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_MESSAGE PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_MESSAGE');


    -- creating table JBPM_MODULEDEFINITION
       vsql :=  'CREATE TABLE WFS.JBPM_MODULEDEFINITION ( 
          ID_               	NUMBER(19,0) NOT NULL,
          CLASS_            	CHAR(1) NOT NULL,
          NAME_             	VARCHAR2(4000) NULL,
          PROCESSDEFINITION_	NUMBER(19,0) NULL,
          STARTTASK_        	NUMBER(19,0) NULL,
          CREATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_MODULEDEFINITION PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_MODULEDEFINITION');
      CREATESEQ('JBPM_MODULEDEFINITION');
      CREATEUPDATETRG('JBPM_MODULEDEFINITION');
      
    -- creating table JBPM_MODULEINSTANCE
       vsql :=  'CREATE TABLE WFS.JBPM_MODULEINSTANCE ( 
          ID_                	NUMBER(19,0) NOT NULL,
          CLASS_             	CHAR(1) NOT NULL,
          PROCESSINSTANCE_   	NUMBER(19,0) NULL,
          TASKMGMTDEFINITION_	NUMBER(19,0) NULL,
          NAME_              	VARCHAR2(255) NULL,
          CREATEDATE         	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE         	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_MODULEINSTANCE PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_MODULEINSTANCE');
      CREATESEQ('JBPM_MODULEINSTANCE');
      CREATEUPDATETRG('JBPM_MODULEINSTANCE');

    -- Creating index IDX_JBPM_MODULEINSTANCE_01
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_MODULEINSTANCE_01 ON WFS.JBPM_MODULEINSTANCE(PROCESSINSTANCE_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_MODULEINSTANCE_01');

    -- creating table JBPM_NODE
       vsql :=  'CREATE TABLE WFS.JBPM_NODE ( 
          ID_                  	NUMBER(19,0) NOT NULL,
          CLASS_               	CHAR(1) NOT NULL,
          NAME_                	VARCHAR2(255) NULL,
          PROCESSDEFINITION_   	NUMBER(19,0) NULL,
          ISASYNC_             	NUMBER NULL,
          ACTION_              	NUMBER(19,0) NULL,
          SUPERSTATE_          	NUMBER(19,0) NULL,
          SUBPROCESSDEFINITION_	NUMBER(19,0) NULL,
          DECISIONEXPRESSION_  	VARCHAR2(255) NULL,
          DECISIONDELEGATION   	NUMBER(19,0) NULL,
          SIGNAL_              	NUMBER NULL,
          CREATETASKS_         	NUMBER NULL,
          ENDTASKS_            	NUMBER NULL,
          NODECOLLECTIONINDEX_ 	NUMBER NULL,
          RESOURCEGROUPID      	NUMBER NULL,
          DURATION             	VARCHAR2(500) NULL,
          CREATEDATE           	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE           	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          DURATIONDESCRIPTION  	VARCHAR2(500) NULL,
          CONSTRAINT PK_JBPM_NODE PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_NODE');
      CREATESEQ('JBPM_NODE');
      CREATEUPDATETRG('JBPM_NODE');
    
    -- Creating Index IDX_JBPM_NODE_01
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_NODE_01 ON WFS.JBPM_NODE(PROCESSDEFINITION_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_NODE_01');

    -- creating table JBPM_POOLEDACTOR
       vsql :=  'CREATE TABLE WFS.JBPM_POOLEDACTOR ( 
          ID_              	NUMBER(19,0) NOT NULL,
          ACTORID_         	VARCHAR2(255) NULL,
          SWIMLANEINSTANCE_	NUMBER(19,0) NULL,
          CREATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_POOLEDACTOR PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_POOLEDACTOR');
      CREATESEQ('JBPM_POOLEDACTOR');
      CREATEUPDATETRG('JBPM_POOLEDACTOR');

    -- Creating index IX_JBPM_POOLEDACTOR_1
       vsql :=  'CREATE INDEX WFS.IDX_PLDACTR_ACTID ON WFS.JBPM_POOLEDACTOR(ACTORID_)';
      CREATEOBJECT(vsql,'Unable to create index IX_JBPM_POOLEDACTOR_1');

    -- creating table JBPM_PROCESSDEFINITION
       vsql :=  'CREATE TABLE WFS.JBPM_PROCESSDEFINITION ( 
          ID_                    	NUMBER(19,0) NOT NULL,
          NAME_                  	VARCHAR2(255) NULL,
          VERSION_               	NUMBER NULL,
          ISTERMINATIONIMPLICIT_ 	NUMBER NULL,
          STARTSTATE_            	NUMBER(19,0) NULL,
          CREATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          PROCESSDEFINITIONTYPEID	NUMBER DEFAULT (1) NOT NULL,
          CONSTRAINT PK_JBPM_PROCESSDEFINITION PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_PROCESSDEFINITION');
      CREATESEQ('JBPM_PROCESSDEFINITION');
      CREATEUPDATETRG('JBPM_PROCESSDEFINITION');

    -- Creating index IDX_JBPM_PROCESSDEFINITION_01
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_PROCESSDEFINITION_01 ON WFS.JBPM_PROCESSDEFINITION (NAME_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_PROCESSDEFINITION_01 on JBPM_PROCESSDEFINITION table');

    -- Create index IDX_JBPM_PROCESSDEFINITION_02
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_PROCESSDEFINITION_02 ON WFS.JBPM_PROCESSDEFINITION(PROCESSDEFINITIONTYPEID)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_PROCESSDEFINITION_02 on JPBM_PROCESSDEFINITION table');

    -- creating table JBPM_PROCESSINSTANCE
       vsql :=  'CREATE TABLE WFS.JBPM_PROCESSINSTANCE ( 
          ID_                          	NUMBER(19,0) NOT NULL,
          VERSION_                     	NUMBER NOT NULL,
          START_                       	TIMESTAMP(6) NULL,
          END_                         	TIMESTAMP(6) NULL,
          ISSUSPENDED_                 	NUMBER NULL,
          PROCESSDEFINITION_           	NUMBER(19,0) NULL,
          ROOTTOKEN_                   	NUMBER(19,0) NULL,
          SUPERPROCESSTOKEN_           	NUMBER(19,0) NULL,
          ADMINISTRATIVEPROCESSSTATUSID	NUMBER NOT NULL,
          OPERATIONALPROCESSSTATUSID   	NUMBER NOT NULL,
          PROCESSINSTANCETYPEID        	NUMBER NOT NULL,
          CREATEDATE                   	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE                   	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          PROCESSPRIORITYID            	NUMBER NULL,
          ISACTIVE                     	NUMBER(1,0) DEFAULT (1) NOT NULL,
          CONSTRAINT PK_JBPM_PROCESSINSTANCE PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_PROCESSINSTANCE');
      CREATESEQ('JBPM_PROCESSINSTANCE',3);
      CREATEUPDATETRG('JBPM_PROCESSINSTANCE');
    
    -- Creating index IDX_JBPM_PROCESSINSTANCE_01
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_PROCESSINSTANCE_01 ON WFS.JBPM_PROCESSINSTANCE(PROCESSDEFINITION_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_PROCESSINSTANCE_01');
      
    -- Creating index  IDX_PI_OPERATIONALSTATUSID
       vsql :=  'CREATE INDEX WFS.IDX_PI_OPERATIONALSTATUSID ON WFS.JBPM_PROCESSINSTANCE(OPERATIONALPROCESSSTATUSID)';
      CREATEOBJECT(vsql,'Unable to create index IDX_PI_OPERATIONALSTATUSID');


    -- creating table JBPM_RUNTIMEACTION
       vsql :=  'CREATE TABLE WFS.JBPM_RUNTIMEACTION ( 
          ID_                  	NUMBER(19,0) NOT NULL,
          VERSION_             	NUMBER NOT NULL,
          EVENTTYPE_           	VARCHAR2(255) NULL,
          TYPE_                	CHAR(1) NULL,
          GRAPHELEMENT_        	NUMBER(19,0) NULL,
          PROCESSINSTANCE_     	NUMBER(19,0) NULL,
          ACTION_              	NUMBER(19,0) NULL,
          PROCESSINSTANCEINDEX_	NUMBER NULL,
          CREATEDATE           	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE           	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_RUNTIMEACTION PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_RUNTIMEACTION');
      CREATESEQ('JBPM_RUNTIMEACTION');
      CREATEUPDATETRG('JBPM_RUNTIMEACTION');

    -- Creating index IDX_RUNTIMEACTION_01
       vsql :=  'CREATE INDEX WFS.IDX_RUNTIMEACTION_01 ON WFS.JBPM_RUNTIMEACTION(PROCESSINSTANCE_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_RUNTIMEACTION_01');

    -- creating table JBPM_SWIMLANE
       vsql :=  'CREATE TABLE WFS.JBPM_SWIMLANE ( 
          ID_                    	NUMBER(19,0) NOT NULL,
          NAME_                  	VARCHAR2(255) NULL,
          ACTORIDEXPRESSION_     	VARCHAR2(255) NULL,
          POOLEDACTORSEXPRESSION_	VARCHAR2(255) NULL,
          ASSIGNMENTDELEGATION_  	NUMBER(19,0) NULL,
          TASKMGMTDEFINITION_    	NUMBER(19,0) NULL,
          CREATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_SWIMLANE PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_SWIMLANE');
      CREATESEQ('JBPM_SWIMLANE');
      CREATEUPDATETRG('JBPM_SWIMLANE');

    -- creating table JBPM_SWIMLANEINSTANCE
       vsql :=  'CREATE TABLE WFS.JBPM_SWIMLANEINSTANCE ( 
          ID_              	NUMBER(19,0) NOT NULL,
          NAME_            	VARCHAR2(255) NULL,
          ACTORID_         	VARCHAR2(255) NULL,
          SWIMLANE_        	NUMBER(19,0) NULL,
          TASKMGMTINSTANCE_	NUMBER(19,0) NULL,
          CREATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_SWIMLANEINSTANCE PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_SWIMLANEINSTANCE');
      CREATESEQ('JBPM_SWIMLANEINSTANCE');
      CREATEUPDATETRG('JBPM_SWIMLANEINSTANCE');

    -- Creating Index IDX_JBPM_SWIMLANEINSTANCE_01
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_SWIMLANEINSTANCE_01 ON WFS.JBPM_SWIMLANEINSTANCE(TASKMGMTINSTANCE_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_SWIMLANEINSTANCE_01');

    -- creating table JBPM_TASK
       vsql :=  'CREATE TABLE WFS.JBPM_TASK ( 
          ID_                    	NUMBER(19,0) NOT NULL,
          NAME_                  	VARCHAR2(255) NULL,
          PROCESSDEFINITION_     	NUMBER(19,0) NULL,
          DESCRIPTION_           	VARCHAR2(4000) NULL,
          ISBLOCKING_            	NUMBER NULL,
          ISSIGNALLING_          	NUMBER NULL,
          DUEDATE_               	VARCHAR2(255) NULL,
          ACTORIDEXPRESSION_     	VARCHAR2(255) NULL,
          POOLEDACTORSEXPRESSION_	VARCHAR2(255) NULL,
          TASKMGMTDEFINITION_    	NUMBER(19,0) NULL,
          TASKNODE_              	NUMBER(19,0) NULL,
          STARTSTATE_            	NUMBER(19,0) NULL,
          ASSIGNMENTDELEGATION_  	NUMBER(19,0) NULL,
          SWIMLANE_              	NUMBER(19,0) NULL,
          TASKCONTROLLER_        	NUMBER(19,0) NULL,
          CREATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_TASK PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_TASK');
      CREATESEQ('JBPM_TASK');
      CREATEUPDATETRG('JBPM_TASK');

    -- Creating index IDX_JBPM_TASK_01
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_TASK_01 ON WFS.JBPM_TASK(TASKNODE_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_TASK_01');

    -- Creating index IDX_JBPM_TASK_02
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_TASK_02 ON WFS.JBPM_TASK(STARTSTATE_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_TASK_02');

    -- creating table JBPM_TASKACTORPOOL
       vsql :=  'CREATE TABLE WFS.JBPM_TASKACTORPOOL ( 
          TASKINSTANCE_	NUMBER(19,0) NOT NULL,
          POOLEDACTOR_ 	NUMBER(19,0) NOT NULL,
          CREATEDATE   	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE   	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_TASKACTORPOOL');
      CREATEUPDATETRG('JBPM_TASKACTORPOOL');
      
    -- Creating Primary Key on JBPM_TASKACTORPOOL
       vsql :=  'ALTER TABLE WFS.JBPM_TASKACTORPOOL ADD ( CONSTRAINT PK_JBPM_TASKACTORPOOL PRIMARY KEY (TASKINSTANCE_, POOLEDACTOR_))';
      CREATEOBJECT(vsql,'Unable to create Primary Key for JBPM_TASKACTORPOOL');

    -- creating table JBPM_TASKCONTROLLER
       vsql :=  'CREATE TABLE WFS.JBPM_TASKCONTROLLER ( 
          ID_                      	NUMBER(19,0) NOT NULL,
          TASKCONTROLLERDELEGATION_	NUMBER(19,0) NULL,
          CREATEDATE               	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE               	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_TASKCONTROLLER PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_TASKCONTROLLER');
      CREATESEQ('JBPM_TASKCONTROLLER');
      CREATEUPDATETRG('JBPM_TASKCONTROLLER');
      
    -- creating table JBPM_TASKINSTANCE
       vsql :=  'CREATE TABLE WFS.JBPM_TASKINSTANCE ( 
          ID_              	NUMBER(19,0) NOT NULL,
          CLASS_           	CHAR(1) NOT NULL,
          NAME_            	VARCHAR2(255) NULL,
          DESCRIPTION_     	VARCHAR2(4000) NULL,
          ACTORID_         	VARCHAR2(255) NULL,
          CREATE_          	TIMESTAMP(6) NULL,
          START_           	TIMESTAMP(6) NULL,
          END_             	TIMESTAMP(6) NULL,
          DUEDATE_         	TIMESTAMP(6) NULL,
          PRIORITY_        	NUMBER NULL,
          ISCANCELLED_     	NUMBER NULL,
          ISSUSPENDED_     	NUMBER NULL,
          ISOPEN_          	NUMBER NULL,
          ISSIGNALLING_    	NUMBER NULL,
          ISBLOCKING_      	NUMBER NULL,
          TASK_            	NUMBER(19,0) NULL,
          TOKEN_           	NUMBER(19,0) NULL,
          SWIMLANINSTANCE_ 	NUMBER(19,0) NULL,
          TASKMGMTINSTANCE_	NUMBER(19,0) NULL,
          CREATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_TASKINSTANCE PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_TASKINSTANCE');
      CREATESEQ('JBPM_TASKINSTANCE');
      CREATEUPDATETRG('JBPM_TASKINSTANCE');

    -- Creating index IX_JBPM_TASKINSTANCE_1
       vsql :=  'CREATE INDEX WFS.IX_JBPM_TASKINSTANCE_1 ON WFS.JBPM_TASKINSTANCE(ACTORID_)';
      CREATEOBJECT(vsql,'Unable to create index IX_JBPM_TASKINSTANCE_1');
    
    -- Creating index IDX_JBPM_TASKINSTANCE_02
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_TASKINSTANCE_02 ON WFS.JBPM_TASKINSTANCE(TASKMGMTINSTANCE_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_TASKINSTANCE_02');
  
    -- creating table JBPM_TIMER
       vsql :=  'CREATE TABLE WFS.JBPM_TIMER ( 
          ID_              	NUMBER(19,0) NOT NULL,
          NAME_            	VARCHAR2(255) NULL,
          DUEDATE_         	TIMESTAMP(6) NULL,
          REPEAT_          	VARCHAR2(255) NULL,
          TRANSITIONNAME_  	VARCHAR2(255) NULL,
          EXCEPTION_       	VARCHAR2(4000) NULL,
          ISSUSPENDED_     	NUMBER NULL,
          ACTION_          	NUMBER(19,0) NULL,
          TOKEN_           	NUMBER(19,0) NULL,
          PROCESSINSTANCE_ 	NUMBER(19,0) NULL,
          TASKINSTANCE_    	NUMBER(19,0) NULL,
          GRAPHELEMENTTYPE_	VARCHAR2(255) NULL,
          GRAPHELEMENT_    	NUMBER(19,0) NULL,
          CREATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_TIMER PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_TIMER');
      CREATESEQ('JBPM_TIMER');
      CREATEUPDATETRG('JBPM_TIMER');

    -- creating table JBPM_TOKEN
       vsql :=  'CREATE TABLE WFS.JBPM_TOKEN ( 
          ID_                      	NUMBER(19,0) NOT NULL,
          VERSION_                 	NUMBER NOT NULL,
          NAME_                    	VARCHAR2(255) NULL,
          START_                   	TIMESTAMP(6) NULL,
          END_                     	TIMESTAMP(6) NULL,
          NODEENTER_               	TIMESTAMP(6) NULL,
          NEXTLOGINDEX_            	NUMBER NULL,
          ISABLETOREACTIVATEPARENT_	NUMBER NULL,
          ISTERMINATIONIMPLICIT_   	NUMBER NULL,
          ISSUSPENDED_             	NUMBER NULL,
          NODE_                    	NUMBER(19,0) NULL,
          PROCESSINSTANCE_         	NUMBER(19,0) NULL,
          PARENT_                  	NUMBER(19,0) NULL,
          SUBPROCESSINSTANCE_      	NUMBER(19,0) NULL,
          TOKENTYPEID              	NUMBER NOT NULL,
          OPERATIONALSTATUS      	NUMBER(19,0) NULL,
           ADMINISTRATIVESTATUS   	NUMBER(19,0) NULL,
          CREATEDATE               	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE               	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_TOKEN PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_TOKEN');
      CREATESEQ('JBPM_TOKEN',3);
      CREATEUPDATETRG('JBPM_TOKEN');

    -- Creating Index IDX_JBPM_TOKEN_01
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_TOKEN_01 ON WFS.JBPM_TOKEN(PARENT_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_TOKEN_01');

    -- Creating Index IDX_JBPM_TOKEN_02
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_TOKEN_02 ON WFS.JBPM_TOKEN(NODE_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_TOKEN_02');

    -- creating table JBPM_TOKENVARIABLEMAP
       vsql :=  'CREATE TABLE WFS.JBPM_TOKENVARIABLEMAP ( 
          ID_             	NUMBER(19,0) NOT NULL,
          TOKEN_          	NUMBER(19,0) NULL,
          CONTEXTINSTANCE_	NUMBER(19,0) NULL,
          CREATEDATE      	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE      	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_TOKENVARIABLEMAP PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_TOKENVARIABLEMAP');
      CREATESEQ('JBPM_TOKENVARIABLEMAP');
      CREATEUPDATETRG('JBPM_TOKENVARIABLEMAP');
      
    -- Creating index IDX_JBPM_TOKENVARIABLEMAP_01
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_TOKENVARIABLEMAP_01 ON WFS.JBPM_TOKENVARIABLEMAP(CONTEXTINSTANCE_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_TOKENVARIABLEMAP_01');

    -- creating table JBPM_TRANSITION
       vsql :=  'CREATE TABLE WFS.JBPM_TRANSITION ( 
          ID_               	NUMBER(19,0) NOT NULL,
          NAME_             	VARCHAR2(255) NULL,
          PROCESSDEFINITION_	NUMBER(19,0) NULL,
          FROM_             	NUMBER(19,0) NULL,
          TO_               	NUMBER(19,0) NULL,
          FROMINDEX_        	NUMBER NULL,
          TRANSITIONTYPEID		NUMBER DEFAULT(2) NOT NULL, 
          CREATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE        	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_TRANSITION PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_TRANSITION');
      CREATESEQ('JBPM_TRANSITION');
      CREATEUPDATETRG('JBPM_TRANSITION');
      
    -- Creating index IDX_JBPMTRANS_PROCDEFINITION
       vsql :=  'CREATE INDEX WFS.IDX_JBPMTRANS_PROCDEFINITION ON WFS.JBPM_TRANSITION(PROCESSDEFINITION_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPMTRANS_PROCDEFINITION');       
      
    -- creating table JBPM_VARIABLEACCESS
       vsql :=  'CREATE TABLE WFS.JBPM_VARIABLEACCESS ( 
          ID_                 	NUMBER(19,0) NOT NULL,
          VARIABLENAME_       	VARCHAR2(255) NULL,
          ACCESS_             	VARCHAR2(255) NULL,
          MAPPEDNAME_         	VARCHAR2(255) NULL,
          PROCESSSTATE_       	NUMBER(19,0) NULL,
          TASKCONTROLLER_     	NUMBER(19,0) NULL,
          INDEX_              	NUMBER NULL,
          SCRIPT_             	NUMBER(19,0) NULL,
          DATATYPEID          	NUMBER DEFAULT (2) NOT NULL,
          CREATEDATE          	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE          	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          VARIABLEACCESSTYPEID	NUMBER DEFAULT (2) NOT NULL,
          CONSTRAINT PK_JBPM_VARIABLEACCESS PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_VARIABLEACCESS');
      CREATESEQ('JBPM_VARIABLEACCESS');
      CREATEUPDATETRG('JBPM_VARIABLEACCESS');

    -- creating table JBPM_VARIABLEINSTANCE
       vsql :=  'CREATE TABLE WFS.JBPM_VARIABLEINSTANCE ( 
          ID_              	NUMBER(19,0) NOT NULL,
          CLASS_           	CHAR(1) NOT NULL,
          NAME_            	VARCHAR2(255) NULL,
          CONVERTER_       	CHAR(1) NULL,
          TOKEN_           	NUMBER(19,0) NULL,
          TOKENVARIABLEMAP_	NUMBER(19,0) NULL,
          PROCESSINSTANCE_ 	NUMBER(19,0) NULL,
          BYTEARRAYVALUE_  	NUMBER(19,0) NULL,
          DATEVALUE_       	TIMESTAMP(6) NULL,
          DOUBLEVALUE_     	FLOAT NULL,
          LONGIDCLASS_     	VARCHAR2(255) NULL,
          LONGVALUE_       	NUMBER(19,0) NULL,
          STRINGIDCLASS_   	VARCHAR2(255) NULL,
          STRINGVALUE_     	VARCHAR2(4000) NULL,
          TASKINSTANCE_    	NUMBER(19,0) NULL,
          CREATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_JBPM_VARIABLEINSTANCE PRIMARY KEY (ID_)
          )';
      CREATEOBJECT(vsql,'Unable to create table JBPM_VARIABLEINSTANCE');
      CREATESEQ('JBPM_VARIABLEINSTANCE');
      CREATEUPDATETRG('JBPM_VARIABLEINSTANCE');

    -- Create Index IDX_JBPM_VARIABLEINSTANCE_01 on JBPM_VARIABLEINSTANCE
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_VARIABLEINSTANCE_01 ON WFS.JBPM_VARIABLEINSTANCE (NAME_, STRINGVALUE_)';
      CREATEOBJECT(vsql,'Unable to index IDX_JBPM_VARIABLEINSTANCE_01 on JBPM_VARIABLEINSTANCE');

    -- Create Index IDX_JBPM_VARIABLEINSTANCE_02 on JBPM_VARIABLEINSTANCE
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_VARIABLEINSTANCE_02 ON WFS.JBPM_VARIABLEINSTANCE (PROCESSINSTANCE_, NAME_, STRINGVALUE_, TOKENVARIABLEMAP_, CLASS_)';
      CREATEOBJECT(vsql,'Unable to index IDX_JBPM_VARIABLEINSTANCE_02 on JBPM_VARIABLEINSTANCE');

    -- Create Index IDX_JBPM_VARIABLEINSTANCE_03 on JBPM_VARIABLEINSTANCE
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_VARIABLEINSTANCE_03 ON WFS.JBPM_VARIABLEINSTANCE(TASKINSTANCE_)';
      CREATEOBJECT(vsql,'Unable to index IDX_JBPM_VARIABLEINSTANCE_03 on JBPM_VARIABLEINSTANCE');

    -- Create Index IDX_JBPM_VARIABLEINSTANCE_04 on JBPM_VARIABLEINSTANCE
       vsql :=  'CREATE INDEX WFS.IDX_JBPM_VARIABLEINSTANCE_04 ON WFS.JBPM_VARIABLEINSTANCE(TOKENVARIABLEMAP_)';
      CREATEOBJECT(vsql,'Unable to create index IDX_JBPM_VARIABLEINSTANCE_04 on JBPM_VARIABLEINSTANCE');

    -- Creating Table SYSTEM_RELEASE
       vsql :=  'create table WFS.SYSTEM_RELEASE(
                  SETTING_TYPE        	VARCHAR(50)  	 	not null,
                  SETTING_VALUE        	VARCHAR(1024)
                  )';
      CREATEOBJECT(vsql,'Unable to create table SYSTEM_RELEASE');

    -- Creating Primary Key on SYSTEM_RELEASE
       vsql :=  'alter table WFS.SYSTEM_RELEASE add constraint PK_SYSTEM_RELEASE primary key (SETTING_TYPE)';
      CREATEOBJECT(vsql,'Unable to create Primary Key for SYSTEM_RELEASE');

    -- creating table TTV_ACCESSLEVEL
       vsql :=  'CREATE TABLE WFS.TTV_ACCESSLEVEL ( 
          ACCESSLEVELID	NUMBER NOT NULL,
          NAME         	VARCHAR2(50) NOT NULL,
          CREATEDATE   	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE   	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_ACCESSLEVEL PRIMARY KEY (ACCESSLEVELID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_ACCESSLEVEL');
      CREATESEQ('TTV_ACCESSLEVEL',3);
      CREATEUPDATETRG('TTV_ACCESSLEVEL');
      
    -- creating table TTV_CONNECTIONTYPE
       vsql :=  'CREATE TABLE WFS.TTV_CONNECTIONTYPE ( 
          CONNECTIONTYPEID	NUMBER NOT NULL,
          NAME            	VARCHAR2(30) NOT NULL,
          CREATEDATE      	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE      	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_CONNECTIONTYPE PRIMARY KEY (CONNECTIONTYPEID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_CONNECTIONTYPE');
      CREATESEQ('TTV_CONNECTIONTYPE',4);
      CREATEUPDATETRG('TTV_CONNECTIONTYPE');
      
    -- creating table TTV_DATATYPE
       vsql :=  'CREATE TABLE WFS.TTV_DATATYPE ( 
          DATATYPEID  	NUMBER NOT NULL,
          DATATYPENAME	VARCHAR2(30) NOT NULL,
          CREATEDATE  	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE  	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_DATATYPE PRIMARY KEY (DATATYPEID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_DATATYPE');
      CREATESEQ('TTV_DATATYPE',8);
      CREATEUPDATETRG('TTV_DATATYPE');

    -- creating table TTV_MESSAGELOG
       vsql :=  'CREATE TABLE WFS.TTV_MESSAGELOG ( 
          MESSAGELOGID   	NUMBER(19,0) NOT NULL,
          LOGID          	NUMBER(19,0) NOT NULL,
          TYPE           	VARCHAR2(16) NOT NULL,
          MESSAGEUID     	VARCHAR2(16) NOT NULL,
          NAME           	VARCHAR2(64) NULL,
          ISINCOMING     	NUMBER(1,0) NOT NULL,
          MESSAGE        	VARCHAR2(4000) NOT NULL,
          RESOURCEID     	NUMBER NULL,
          MESSAGEDATETIME	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CREATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_MESSAGELOG PRIMARY KEY (MESSAGELOGID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_MESSAGELOG');
      CREATESEQ('TTV_MESSAGELOG');
      CREATEUPDATETRG('TTV_MESSAGELOG');

    -- Creating Index on TTV_MESSAGELOG (LOGID)
       vsql :=  'CREATE INDEX WFS.IDX_TTV_MESSAGELOG_01 ON WFS.TTV_MESSAGELOG (LOGID ASC)';
      CREATEOBJECT(vsql,'Unable to create Index on TTV_MESSAGELOG');

    -- creating table TTV_MONITOREDDRIVE
       vsql :=  'CREATE TABLE WFS.TTV_MONITOREDDRIVE (
          MONITOREDDRIVEID       	NUMBER NOT NULL,
          NAME                   	VARCHAR2(500) NOT NULL,
          DESCRIPTION            	VARCHAR2(500) DEFAULT ('''') NOT NULL,
          PATH                   	VARCHAR2(1000) NOT NULL,
          RESOURCEID             	NUMBER NULL,
          INTERNALDRIVEID        	NUMBER NOT NULL,
          TOTALCAPACITY          	NUMBER(19,0) NOT NULL,
          WARNINGTHRESHOLDPERCENT	NUMBER NOT NULL,
          ERRORTHRESHOLDPERCENT  	NUMBER NOT NULL,
          CURRENTBYTESUSED       	NUMBER(19,0) DEFAULT (0) NULL,
          CURRENTDRIVESTATUSID   	NUMBER DEFAULT (0) NOT NULL,
          LASTSAMPLEDATETIME     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CREATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_MONITOREDDRIVE PRIMARY KEY (MONITOREDDRIVEID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_MONITOREDDRIVE');
      CREATESEQ('TTV_MONITOREDDRIVE',3);
      CREATEUPDATETRG('TTV_MONITOREDDRIVE');
      
    -- Creating index IX_TTV_MONITOREDDRIVE_1
       vsql :=  'create index WFS.IX_TTV_MONITOREDDRIVE_1 ON WFS.TTV_MONITOREDDRIVE (RESOURCEID,INTERNALDRIVEID)';
      CREATEOBJECT(vsql,'Unable to create index IX_TTV_MONITOREDDRIVE_1');

    -- creating table TTV_MONITOREDDRIVEHISTORY
       vsql :=  'CREATE TABLE WFS.TTV_MONITOREDDRIVEHISTORY ( 
          MONITOREDDRIVEHISTORYID	NUMBER(19,0) NOT NULL,
          MONITOREDDRIVEID       	NUMBER NOT NULL,
          CURRENTBYTESUSED       	NUMBER(19,0) NOT NULL,
          TOTALCAPACITY          	NUMBER(19,0) NOT NULL,
          WARNINGTHRESHOLDPERCENT	NUMBER NOT NULL,
          ERRORTHRESHOLDPERCENT  	NUMBER NOT NULL,
          CURRENTDRIVESTATUSID   	NUMBER NOT NULL,
          SAMPLEDATETIME         	TIMESTAMP(6) NOT NULL,
          CREATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_MONITOREDDRIVEHISTORY PRIMARY KEY (MONITOREDDRIVEHISTORYID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_MONITOREDDRIVEHISTORY');
      CREATESEQ('TTV_MONITOREDDRIVEHISTORY',9);

    -- creating table TTV_MONITOREDDRIVESTATUS
       vsql :=  'CREATE TABLE WFS.TTV_MONITOREDDRIVESTATUS ( 
          MONITOREDDRIVESTATUSID	NUMBER NOT NULL,
          NAME                  	VARCHAR2(50) NOT NULL,
          CREATEDATE            	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE            	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_MONITOREDDRIVESTATUS PRIMARY KEY (MONITOREDDRIVESTATUSID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_MONITOREDDRIVESTATUS');
      CREATESEQ('TTV_MONITOREDDRIVESTATUS',3);
      CREATEUPDATETRG('TTV_MONITOREDDRIVESTATUS');
      
    -- creating table TTV_PROCDEFACCESSLEVEL
       vsql :=  'CREATE TABLE WFS.TTV_PROCDEFACCESSLEVEL ( 
          PROCESSDEFINITIONID	NUMBER(19,0) NOT NULL,
          ACCESSLEVELID      	NUMBER NOT NULL,
          CREATEDATE         	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_PROCDEFACCESSLEVEL');

    -- Creating Primary Key on TTV_PROCDEFACCESSLEVEL
       vsql :=  'ALTER TABLE WFS.TTV_PROCDEFACCESSLEVEL ADD ( CONSTRAINT PK_TTV_PROCDEFACCESSLEVEL PRIMARY KEY (PROCESSDEFINITIONID, ACCESSLEVELID))';
      CREATEOBJECT(vsql,'Unable to create Primary Key for TTV_PROCDEFACCESSLEVEL');
   
    -- creating table TTV_PROCESSDEFINITIONTYPE
       vsql :=  'CREATE TABLE WFS.TTV_PROCESSDEFINITIONTYPE ( 
          PROCESSDEFINITIONTYPEID	NUMBER NOT NULL,
          NAME                   	VARCHAR2(50) NOT NULL,
          CREATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE             	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_PROCESSDEFINITIONTYPE PRIMARY KEY (PROCESSDEFINITIONTYPEID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_PROCESSDEFINITIONTYPE');
      CREATESEQ('TTV_PROCESSDEFINITIONTYPE',4);
      CREATEUPDATETRG('TTV_PROCESSDEFINITIONTYPE');

    -- creating table TTV_PROCESSINSTANCENOTE
       vsql :=  'CREATE TABLE WFS.TTV_PROCESSINSTANCENOTE ( 
          PROCESSINSTANCENOTEID	NUMBER NOT NULL,
          PROCESSINSTANCEID    	NUMBER NOT NULL,
          NOTE                 	VARCHAR2(4000) NOT NULL,
          CREATEDATE           	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE           	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_PROCESSINSTANCENOTE PRIMARY KEY (PROCESSINSTANCENOTEID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_PROCESSINSTANCENOTE');
      CREATESEQ('TTV_PROCESSINSTANCENOTE');
      CREATEUPDATETRG('TTV_PROCESSINSTANCENOTE');

    -- Creating Index IDX_TTV_PROCESSINSTANCENOTE_01
       vsql :=  'CREATE INDEX WFS.IDX_TTV_PROCESSINSTANCENOTE_01 ON WFS.TTV_PROCESSINSTANCENOTE(PROCESSINSTANCEID)';
      CREATEOBJECT(vsql,'Unable to create index IDX_TTV_PROCESSINSTANCENOTE_01');

    -- creating table TTV_PROCESSINSTANCETYPE
       vsql :=  'CREATE TABLE WFS.TTV_PROCESSINSTANCETYPE ( 
          PROCESSINSTANCETYPEID	NUMBER NOT NULL,
          NAME                 	VARCHAR2(50) NOT NULL,
          CREATEDATE           	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE           	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_PROCESSINSTANCETYPE PRIMARY KEY (PROCESSINSTANCETYPEID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_PROCESSINSTANCETYPE');
      CREATESEQ('TTV_PROCESSINSTANCETYPE');
      CREATEUPDATETRG('TTV_PROCESSINSTANCETYPE');

    -- creating table TTV_PROCESSPRIORITY
       vsql :=  'CREATE TABLE WFS.TTV_PROCESSPRIORITY ( 
          PROCESSPRIORITYID	NUMBER NOT NULL,
          NAME             	VARCHAR2(50) NOT NULL,
          CREATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE       	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_PROCESSPRIORITY PRIMARY KEY (PROCESSPRIORITYID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_PROCESSPRIORITY');
      CREATESEQ('TTV_PROCESSPRIORITY',5);
      CREATEUPDATETRG('TTV_PROCESSPRIORITY');

    -- creating table TTV_PROCESSSTATUS
       vsql :=  'CREATE TABLE WFS.TTV_PROCESSSTATUS ( 
          PROCESSSTATUSID	NUMBER NOT NULL,
          NAME           	VARCHAR2(50) NOT NULL,
          CREATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_PROCESSSTATUS PRIMARY KEY (PROCESSSTATUSID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_PROCESSSTATUS');
      CREATESEQ('TTV_PROCESSSTATUS',8);
      CREATEUPDATETRG('TTV_PROCESSSTATUS');

    -- creating table TTV_RESOURCE
       vsql :=  'CREATE TABLE WFS.TTV_RESOURCE ( 
          RESOURCEID                    	NUMBER NOT NULL,
          NAME                          	VARCHAR2(50) NOT NULL,
          CONNECTIONSTRING              	VARCHAR2(255) NOT NULL,
          RESOURCETYPEID                	NUMBER NOT NULL,
          MAXCONCURRENTUSERS            	NUMBER NOT NULL,
          ADMINISTRATIVERESOURCESTATUSID	NUMBER NOT NULL,
          OPERATIONALRESOURCESTATUSID   	NUMBER NOT NULL,
          HEARTBEATCONNECTIONSTRING     	VARCHAR2(255) NULL,
          HEARTBEATFREQUENCY            	NUMBER NULL,
          ISACTIVE                      	NUMBER(1,0) NOT NULL,
          FUNCTIONALTYPE 			VARCHAR2(1024) NULL,
          CREATEDATE                    	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE                    	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          USER_NAME                     	VARCHAR2(96) NULL,
          CONSTRAINT PK_TTV_RESOURCE PRIMARY KEY (RESOURCEID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_RESOURCE');
      CREATESEQ('TTV_RESOURCE');
      CREATEUPDATETRG('TTV_RESOURCE');
      
    -- creating table TTV_RESOURCEGROUP
       vsql :=  'CREATE TABLE WFS.TTV_RESOURCEGROUP ( 
          RESOURCEGROUPID          	NUMBER NOT NULL,
          NAME                     	VARCHAR2(50) NOT NULL,
          RESOURCETYPEID           	NUMBER NOT NULL,
          ISINTERNALLYACQUIRED     	NUMBER(1,0) NOT NULL,
          ALLOCATIONSTRATEGYCLASSID	NUMBER NULL,
          ACCESSLEVELID            	NUMBER DEFAULT (0) NOT NULL, 
          FUNCTIONALTYPE 		        VARCHAR2(1024)  NULL,
          ISVISIBLE      		        NUMBER(1) DEFAULT(0) NOT NULL,  
          IMAGEPATH      		        VARCHAR2(4000)  NULL,
          CREATEDATE               	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE               	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_RESOURCEGROUP PRIMARY KEY (RESOURCEGROUPID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_RESOURCEGROUP');
      CREATESEQ('TTV_RESOURCEGROUP',115);
      CREATEUPDATETRG('TTV_RESOURCEGROUP');
      
    -- creating table TTV_RESOURCEGROUPMEMBERSHIP
       vsql :=  'CREATE TABLE WFS.TTV_RESOURCEGROUPMEMBERSHIP ( 
          RESOURCEID     	NUMBER NOT NULL,
          RESOURCEGROUPID	NUMBER NOT NULL,
          CREATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE     	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_RESOURCEGROUPMEMBERSHIP');
  
    -- Creating Primary Key on TTV_RESOURCEGROUP
       vsql :=  'ALTER TABLE WFS.TTV_RESOURCEGROUPMEMBERSHIP
          ADD ( CONSTRAINT PK_TTV_RESOURCEGROUPMEMBERSHIP
          PRIMARY KEY (RESOURCEID, RESOURCEGROUPID)
          )';
      CREATEOBJECT(vsql,'Unable to create Primary Key for TTV_RESOURCEGROUPMEMBERSHIP');

    -- creating table TTV_RESOURCEGROUPQUEUEITEM
       vsql :=  'CREATE TABLE WFS.TTV_RESOURCEGROUPQUEUEITEM ( 
          RESOURCEGROUPQUEUEITEMID	NUMBER NOT NULL,
          RESOURCEGROUPID         	NUMBER NOT NULL,
          QUEUEORDER              	NUMBER NOT NULL,
          TOKENID                 	NUMBER(19,0) NOT NULL,
          ALLOCATIONKEY 				VARCHAR2(255) NULL,
          CREATEDATE              	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE              	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_RESOURCEGROUPQUEUEITEM PRIMARY KEY (RESOURCEGROUPQUEUEITEMID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_RESOURCEGROUPQUEUEITEM');
      CREATESEQ('TTV_RESOURCEGROUPQUEUEITEM');
      CREATEUPDATETRG('TTV_RESOURCEGROUPQUEUEITEM');

    -- creating table TTV_RESOURCESTATUS
       vsql :=  'CREATE TABLE WFS.TTV_RESOURCESTATUS ( 
          RESOURCESTATUSID	NUMBER NOT NULL,
          NAME            	VARCHAR2(50) NOT NULL,
          CREATEDATE      	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE      	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_RESOURCESTATUS PRIMARY KEY (RESOURCESTATUSID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_RESOURCESTATUS');
      CREATESEQ('TTV_RESOURCESTATUS',7);
      CREATEUPDATETRG('TTV_RESOURCESTATUS');
      
    -- creating table TTV_RESOURCETYPE
       vsql :=  'CREATE TABLE WFS.TTV_RESOURCETYPE ( 
          RESOURCETYPEID               	NUMBER NOT NULL,
          NAME                         	VARCHAR2(50) NOT NULL,
          RESOURCECONNECTIONTYPEID     	NUMBER NOT NULL,
          INITIALIZATIONSTRATEGYCLASSID	NUMBER NULL,
          HEARTBEATSTRATEGYCLASSID     	NUMBER NULL,
          HEARTBEATCONNECTIONTYPEID    	NUMBER NULL,
          SYSTEMID       			VARCHAR2(4000)  NULL,
          CREATEDATE                   	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE                   	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_RESOURCETYPE PRIMARY KEY (RESOURCETYPEID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_RESOURCETYPE');
      CREATESEQ('TTV_RESOURCETYPE',34);
      CREATEUPDATETRG('TTV_RESOURCETYPE');
    
    -- Create Unique index on the SYSTEMID column of the TTV_RESOURCETYPE table.
       vsql :=  'CREATE UNIQUE INDEX WFS.IDX_TTV_RESOURCETYPE_UK ON WFS.TTV_RESOURCETYPE(SYSTEMID)';
      CREATEOBJECT(vsql,'Unable to create a Unique index on SYSTEMID.TTV_RESOURCETYPE');
       
    -- creating table TTV_RESOURCEUSAGEHISTORY
       vsql :=  'CREATE TABLE WFS.TTV_RESOURCEUSAGEHISTORY ( 
          RESOURCEUSAGEHISTORYID	NUMBER NOT NULL,
          RESOURCEID            	NUMBER NOT NULL,
          PROCESSINSTANCEID     	NUMBER(19,0) NOT NULL,
          NODEID                	NUMBER(19,0) NOT NULL,
          STARTDATETIME         	TIMESTAMP(6) NOT NULL,
          ENDDATETIME           	TIMESTAMP(6) NOT NULL,
          CREATEDATE            	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          RESOURCEGROUPID       	NUMBER NOT NULL,
          CONSTRAINT PK_TTV_RESOURCEUSAGEHISTORY PRIMARY KEY (RESOURCEUSAGEHISTORYID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_RESOURCEUSAGEHISTORY');
      CREATESEQ('TTV_RESOURCEUSAGEHISTORY');
      
    -- creating table TTV_STRATEGYCLASS
       vsql :=  'CREATE TABLE WFS.TTV_STRATEGYCLASS ( 
          STRATEGYCLASSID    	NUMBER NOT NULL,
          NAME               	VARCHAR2(50) NOT NULL,
          DESCRIPTION        	VARCHAR2(500) NOT NULL,
          CLASSNAME          	VARCHAR2(4000) NULL,
          STRATEGYCLASSTYPEID	NUMBER NOT NULL,
          CREATEDATE         	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE         	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_STRATEGYCLASS PRIMARY KEY (STRATEGYCLASSID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_STRATEGYCLASS');
       CREATESEQ('TTV_STRATEGYCLASS',10);
      CREATEUPDATETRG('TTV_STRATEGYCLASS');

    -- creating table TTV_STRATEGYCLASSTYPE
       vsql :=  'CREATE TABLE WFS.TTV_STRATEGYCLASSTYPE ( 
          STRATEGYCLASSTYPEID	NUMBER NOT NULL,
          NAME               	VARCHAR2(50) NOT NULL,
          CREATEDATE         	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE         	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_STRATEGYCLASSTYPE PRIMARY KEY (STRATEGYCLASSTYPEID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_STRATEGYCLASSTYPE');
      CREATESEQ('TTV_STRATEGYCLASSTYPE',4);
      CREATEUPDATETRG('TTV_STRATEGYCLASSTYPE');
      
    -- creating table TTV_TOKENRESOURCE
       vsql :=  'CREATE TABLE WFS.TTV_TOKENRESOURCE ( 
          TOKENID                   	NUMBER(19,0) NOT NULL,
          RESOURCEID                	NUMBER NOT NULL,
          RESOURCEUSAGESTARTDATETIME	TIMESTAMP(6) NOT NULL,
          CREATEDATE                	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE                	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          RESOURCEGROUPID           	NUMBER NOT NULL,
          CONSTRAINT PK_TTV_TOKENRESOURCE PRIMARY KEY (TOKENID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_TOKENRESOURCE');
      CREATEUPDATETRG('TTV_TOKENRESOURCE');
      
    -- creating table TTV_TOKENTYPE
       vsql :=  'CREATE TABLE WFS.TTV_TOKENTYPE ( 
          TOKENTYPEID	NUMBER NOT NULL,
          NAME       	VARCHAR2(50) NULL,
          CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_TOKENTYPE PRIMARY KEY (TOKENTYPEID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_TOKENTYPE');
      CREATESEQ('TTV_TOKENTYPE');
      CREATEUPDATETRG('TTV_TOKENTYPE');
      
    -- creating table TTV_VARIABLEACCESSTYPE
       vsql :=  'CREATE TABLE WFS.TTV_VARIABLEACCESSTYPE ( 
          VARIABLEACCESSTYPEID	NUMBER NOT NULL,
          NAME                	VARCHAR2(50) NOT NULL,
          CREATEDATE          	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          UPDATEDATE          	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          CONSTRAINT PK_TTV_VARIABLEACCESSTYPE PRIMARY KEY (VARIABLEACCESSTYPEID)
          )';
      CREATEOBJECT(vsql,'Unable to create table TTV_VARIABLEACCESSTYPE');
      CREATESEQ('TTV_VARIABLEACCESSTYPE',3);
      CREATEUPDATETRG('TTV_VARIABLEACCESSTYPE');

  
  -- Creating table UI_PROPERTIES
       vsql :=  'CREATE TABLE WFS.UI_PROPERTIES ( 
          NAME      	VARCHAR2(254) NOT NULL,
          VALUE     	VARCHAR2(254) NULL,
          CREATEDATE	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL 
          )';
      CREATEOBJECT(vsql,'Unable to create table UI_PROPERTIES');
  
      -- Create table TTV_SELECTOR
       vsql :=  'CREATE TABLE WFS.TTV_SELECTOR ( 
                                SELECTIONKEY		VARCHAR2(4000) 	NOT NULL,
                               PROCESSDEFINITIONID NUMBER(19,0)   	NULL,
                               CREATEDATE          DATE		NOT NULL,
                               UPDATEDATE          DATE   		NOT NULL
                              )';
      CREATEOBJECT(vsql,'Unable to create table TTV_SELECTOR');
      
      -- Create Primary Key for TTV_SELECTOR
       vsql :=  'ALTER TABLE WFS.TTV_SELECTOR ADD ( CONSTRAINT PK_TTV_SELECTOR PRIMARY KEY (SELECTIONKEY))';
      CREATEOBJECT(vsql,'Unable to create primary key for TTV_SELECTOR');
      
      -- Create table TTV_TRANSITIONTYPE
       vsql :=  'CREATE TABLE WFS.TTV_TRANSITIONTYPE (
                               TRANSITIONTYPEID    NUMBER NOT NULL,
                               NAME        VARCHAR2(50) NULL,
                               CREATEDATE  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                               UPDATEDATE  TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                               CONSTRAINT PK_TTV_TRANSITIONTYPE PRIMARY KEY (TRANSITIONTYPEID)
                              )';
      CREATEOBJECT(vsql,'Unable to create table TTV_TRANSITIONTYPE');
      CREATEUPDATETRG('TTV_TRANSITIONTYPE');
      
 /*
  -----------------------------------------
   CREATING ALL VIEWS
  -----------------------------------------
  */
  
  -- Creating View VDW_NODE
       vsql :=  'CREATE VIEW WFS.VDW_NODE ( NODEID, NODECLASS, NODENAME, PROCESSDEFINITIONID, PROCESSDEFINITIONNAME, NODEINDEX, TASKID, TASKNAME, ISSTARTNODE, RESOURCEGROUPID, RESOURCEGROUPNAME, RESOURCETYPEID, RESOURCETYPENAME, TASKCONTROLLERID, PROCESSDEFINITIONTYPEID, PROCESSDEFINITIONTYPENAME, CREATEDATE, UPDATEDATE )
                          AS
                          SELECT  n.ID_ NodeId,
                                  DECODE (n.CLASS_,       ''D'', ''DECISION'',
                                                      ''E'', ''END'',
                                                      ''R'', ''START'',
                                                      ''Y'', ''MANUAL'',
                                                      ''Z'', ''AUTOMATED'',
                                                      ''UNKNOWN'') NodeClass,
                                  n.NAME_ NodeName,
                                  n.PROCESSDEFINITION_ ProcessDefinitionId,
                                  d.NAME_ ProcessDefinitionName,
                                  n.NODECOLLECTIONINDEX_ NodeIndex,
                                  t.ID_ TaskId,
                                  t.NAME_ TaskName,
                                  DECODE (NVL (d.STARTSTATE_, -1), -1, 0, 1) IsStartNode,
                                  n.ResourceGroupId,
                                  NVL (g.Name, ''[N/A]'') ResourceGroupName,
                                  g.ResourceTypeId,
                                  NVL (ty.Name, ''[N/A]'') ResourceTypeName,
                                  TASKCONTROLLER_ TaskControllerId,
                                  d.ProcessDefinitionTypeId,
                                  dt.Name ProcessDefinitionTypeName,
                                  n.CreateDate,
                                  n.UpdateDate
                          FROM    WFS.JBPM_NODE n
                          JOIN    WFS.JBPM_PROCESSDEFINITION d
                          ON (    d.ID_ = n.PROCESSDEFINITION_)
                          JOIN    WFS.TTV_ProcessDefinitionType dt
                          ON (    dt.ProcessDefinitionTypeId = d.ProcessDefinitionTypeId)
                          LEFT JOIN WFS.TTV_ResourceGroup g
                          ON (    g.ResourceGroupId = n.ResourceGroupId)
                          LEFT JOIN WFS.TTV_ResourceType ty
                          ON (    ty.ResourceTypeId = g.ResourceTypeId)
                          LEFT JOIN WFS.JBPM_TASK t
                          ON (    t.TASKNODE_ = n.ID_
                          OR              t.STARTSTATE_ = n.ID_)';
      CREATEOBJECT(vsql,'Unable to create view VDW_NODE');
 
  -- Creating View VDW_PROCESSINSTANCE
       vsql :=  'CREATE VIEW WFS.VDW_PROCESSINSTANCE ( PROCESSINSTANCEID, LOCALSTARTDATE, LOCALENDDATE, ISSUSPENDED, PROCESSDEFINITIONID, PROCESSDEFINITIONNAME, ADMINSTATUSID, ADMINSTATUS, OPERSTATUSID, OPERSTATUS, PRIORITYID, PRIORITY, PROCESSDEFINITIONTYPEID, PROCESSDEFINITIONTYPENAME, CREATEDATE, UPDATEDATE )
                          AS
                          SELECT  I.ID_ PROCESSINSTANCEID,
                                  START_ LOCALSTARTDATE,
                                  END_ LOCALENDDATE,
                                  ISSUSPENDED_ ISSUSPENDED,
                                  PROCESSDEFINITION_ PROCESSDEFINITIONID,
                                  NAME_ PROCESSDEFINITIONNAME,
                                  ADMINISTRATIVEPROCESSSTATUSID ADMINSTATUSID,
                                  ADS.NAME ADMINSTATUS,
                                  OPERATIONALPROCESSSTATUSID OPERSTATUSID,
                                  OPS.NAME OPERSTATUS,
                                  I.PROCESSPRIORITYID PRIORITYID,
                                  NVL (P.NAME, ''[N/A]'') PRIORITY,
                                  d.ProcessDefinitionTypeId,
                                  dt.Name ProcessDefinitionTypeName,
                                  I.CREATEDATE,
                                  I.UPDATEDATE
                          FROM    WFS.JBPM_PROCESSINSTANCE I
                          JOIN    WFS.JBPM_PROCESSDEFINITION D
                          ON (    D.ID_ = PROCESSDEFINITION_)
                          JOIN    WFS.TTV_ProcessDefinitionType dt
                          ON (    dt.ProcessDefinitionTypeId = d.ProcessDefinitionTypeId)
                          LEFT JOIN WFS.TTV_PROCESSPRIORITY P
                          ON (    P.PROCESSPRIORITYID = I.PROCESSPRIORITYID)
                          JOIN    WFS.TTV_PROCESSSTATUS ADS
                          ON (    ADS.PROCESSSTATUSID = ADMINISTRATIVEPROCESSSTATUSID)
                          JOIN    WFS.TTV_PROCESSSTATUS OPS
                          ON (    OPS.PROCESSSTATUSID = OPERATIONALPROCESSSTATUSID)';
      CREATEOBJECT(vsql,'Unable to create view VDW_PROCESSINSTANCE');
 
  -- Creating View VDW_LOG
       vsql :=  'CREATE OR REPLACE VIEW WFS.VDW_LOG
                          AS 
                  SELECT	l.ID_ LogId,
                          l.CLASS_ LogClass,
                          DECODE (l.CLASS_,''N'', ''NODE'',
                                          ''7'', ''MESSAGE'',
                                          ''8'', ''USAGE'',
                                          ''9'', ''QUEUE'',							
                                          ''UNKNOWN'') LogClassName,
                          l.DATE_ LocalDate,
                          n.ProcessDefinitionId,
                          n.ProcessDefinitionName,
                          p.ProcessInstanceId,
                          p.ProcessDefinitionTypeId,
                          l.NODE_ NodeId,
                          n.NodeClass,
                          n.NodeName,
                          n.NodeIndex,
                          n.IsStartNode,
                          l.ENTER_ LocalEnterDate,
                          l.LEAVE_ LocalLeaveDate,
                          l.DURATION_ Duration,
                          l.ResourceGroupId,
                          NVL (g.Name, ''[N/A]'') ResourceGroupName,
                          g.ResourceTypeId,
                          NVL (ty.Name, ''[N/A]'') ResourceTypeName,
                          l.ResourceId,
                          NVL (r.Name, ''[N/A]'') ResourceName,
                          AdministrativeStatusId	AdminStatusId,
                          ads.Name AdminStatus,
                          OperationalStatusId	OperStatusId,
                          ops.Name OperStatus,
                          INDEX_,
                          l.TOKEN_ TokenId,
                          l.CreateDate,
                          l.UpdateDate
                    FROM	WFS.JBPM_LOG l
                          JOIN	WFS.vDW_NODE n
                          ON (	n.NodeId = l.NODE_)
                          JOIN	WFS.JBPM_TOKEN t
                          ON (	t.ID_ = l.TOKEN_)
                          JOIN	WFS.vDW_ProcessInstance p
                          ON (	p.ProcessInstanceId = t.PROCESSINSTANCE_)
                          LEFT JOIN WFS.TTV_ResourceGroup g
                          ON (	g.ResourceGroupId = l.ResourceGroupId)
                          LEFT JOIN WFS.TTV_ResourceType ty
                          ON (	ty.ResourceTypeId = g.ResourceTypeId)
                          LEFT JOIN WFS.TTV_Resource r
                          ON (	r.ResourceId = l.ResourceId)
                          LEFT JOIN WFS.TTV_ProcessStatus ads
                          ON (	ads.ProcessStatusId = l.AdministrativeStatusId)
                          LEFT JOIN WFS.TTV_ProcessStatus ops
                          ON (	ops.ProcessStatusId = l.OperationalStatusId)';
      CREATEOBJECT(vsql,'Unable to create view VDW_LOG');
 
  -- Creating View VDW_TASKINSTANCE
  
       vsql :=  'CREATE VIEW WFS.VDW_TASKINSTANCE ( TASKINSTANCEID, TASKINSTANCENAME, LOCALCREATEDATE, LOCALENDDATE, ISCANCELLED, ISSUSPENDED, ISOPEN, TASKID, NODEID, NODECLASS, NODENAME, PROCESSDEFINITIONID, PROCESSDEFINITIONNAME, NODEINDEX, TASKNAME, ISSTARTNODE, TASKCONTROLLERID, TOKENID, PROCESSINSTANCEID, CURRENTADMINSTATUSID, CURRENTADMINSTATUS, CURRENTOPERSTATUSID, CURRENTOPERSTATUS, PROCESSDEFINITIONTYPEID, PROCESSDEFINITIONTYPENAME, CREATEDATE, UPDATEDATE )
                          AS
                          SELECT	i.ID_ TaskInstanceId,
                                  i.NAME_ TaskInstanceName,
                                  i.CREATE_ LocalCreateDate,
                                  i.END_ LocalEndDate,
                                  i.ISCANCELLED_ IsCancelled,
                                  i.ISSUSPENDED_ IsSuspended,
                                  i.ISOPEN_ IsOpen,
                                  i.TASK_ TaskId,
                                  n.NodeId,
                                  n.NodeClass,
                                  n.NodeName,
                                  n.ProcessDefinitionId,
                                  n.ProcessDefinitionName,
                                  n.NodeIndex,
                                  n.TaskName,
                                  n.IsStartNode,
                                  n.TaskControllerId,
                                  i.TOKEN_ TokenId,
                                  p.ProcessInstanceId,
                                  p.AdminStatusId CurrentAdminStatusId,
                                  p.AdminStatus CurrentAdminStatus,
                                  p.OperStatusId CurrentOperStatusId,
                                  p.OperStatus CurrentOperStatus,
                                  n.ProcessDefinitionTypeId,
                                  n.ProcessDefinitionTypeName,
                                  i.CREATEDATE,
                                  i.UPDATEDATE
                          FROM	WFS.JBPM_TASKINSTANCE i
                          JOIN	WFS.vDW_NODE n
                          ON (	n.TaskId = i.TASK_)
                          JOIN	WFS.JBPM_TOKEN t
                          ON (	t.ID_ = i.TOKEN_)
                          JOIN	WFS.vDW_ProcessInstance p
                          ON (	p.ProcessInstanceId = t.PROCESSINSTANCE_)';
      CREATEOBJECT(vsql,'Unable to create view VDW_TASKINSTANCE');

  -- Creating View VDW_VARIABLEACCESS
       vsql :=  'CREATE VIEW WFS.VDW_VARIABLEACCESS ( VARIABLEACCESSID, VARIABLENAME, ACCESSTYPE, MAPPEDNAME, TASKCONTROLLERID, VARIABLEINDEX, DATATYPEID, DATATYPENAME, NODEID, NODENAME, PROCESSDEFINITIONID, PROCESSDEFINITIONNAME, NODEINDEX, TASKNAME, ISSTARTNODE, PROCESSDEFINITIONTYPEID, PROCESSDEFINITIONTYPENAME, CREATEDATE, UPDATEDATE )
                          AS
                          SELECT	v.ID_ VariableAccessId,
                                  VARIABLENAME_ VariableName,
                                  ACCESS_ AccessType,
                                  MAPPEDNAME_ MappedName,
                                  TASKCONTROLLER_ TaskControllerId,
                                  Index_ VariableIndex,
                                  v.DataTypeId,
                                  t.DataTypeName,
                                  NodeId,
                                  NodeName,
                                  ProcessDefinitionId,
                                  ProcessDefinitionName,
                                  NodeIndex,
                                  TaskName,
                                  IsStartNode,
                                  n.ProcessDefinitionTypeId,
                                  n.ProcessDefinitionTypeName,
                                  v.CreateDate,
                                  v.UpdateDate
                          FROM	WFS.JBPM_VARIABLEACCESS v
                          JOIN	WFS.TTV_DATATYPE t
                          ON (	t.DataTypeId = v.DataTypeId)
                          JOIN	WFS.vDW_Node n
                          ON (	n.TaskControllerId = v.TASKCONTROLLER_)';
      CREATEOBJECT(vsql,'Unable to create view VDW_VARIABLEACCESS');

  -- Creating View VDW_VARIABLEINSTANCE
       vsql :=  'CREATE VIEW WFS.VDW_VARIABLEINSTANCE ( VARIABLEINSTANCEID, CLASSCODE, CLASSNAME, VARIABLEINSTANCENAME, TOKENID, ISGLOBALVARIABLE, PROCESSINSTANCEID, PROCESSDEFINITIONID, PROCESSDEFINITIONNAME, NUMERICVALUE, STRINGVALUE, LONGVALUE_, STRINGVALUE_, DOUBLEVALUE_, TOKENVARIABLEMAP_, TASKINSTANCEID, TASKINSTANCENAME, TASKID, NODEID, NODECLASS, NODENAME, NODEINDEX, TASKNAME, PROCESSDEFINITIONTYPEID, PROCESSDEFINITIONTYPENAME, CREATEDATE, UPDATEDATE )
                          AS
                          SELECT	i.ID_	VariableInstanceId,
                                  i.CLASS_ ClassCode,
                                  DECODE (i.CLASS_, ''N'', ''NULL'', ''S'', ''STRING'', ''L'', ''LONG'', ''[UNKNOWN]'') ClassName,
                                  i.NAME_ VariableInstanceName,
                                  i.TOKEN_ TokenId,
                                  DECODE (NVL (i.TOKENVARIABLEMAP_, -1), -1, 0, 1) IsGlobalVariable,
                                  i.PROCESSINSTANCE_ ProcessInstanceId,
                                  p.ProcessDefinitionId,
                                  p.ProcessDefinitionName,
                                  DECODE (i.CLASS_, ''L'', NVL (i.LONGVALUE_, i.DOUBLEVALUE_), NULL) NumericValue,
                                  DECODE (i.CLASS_, ''L'', NULL, i.STRINGVALUE_) StringValue,
                                  i.LONGVALUE_,
                                  i.STRINGVALUE_,
                                  i.DOUBLEVALUE_,
                                  i.TOKENVARIABLEMAP_,
                                  i.TASKINSTANCE_ TaskInstanceId,
                                  t.TaskInstanceName,
                                  t.TaskId,
                                  t.NodeId,
                                  t.NodeClass,
                                  t.NodeName,
                                  t.NodeIndex,
                                  t.TaskName,
                                  p.ProcessDefinitionTypeId,
                                  p.ProcessDefinitionTypeName,
                                  i.CREATEDATE,
                                  i.UPDATEDATE
                          FROM	WFS.JBPM_VARIABLEINSTANCE i
                          JOIN	WFS.vDW_ProcessInstance p
                          ON (	p.ProcessInstanceId = i.PROCESSINSTANCE_)
                          LEFT JOIN WFS.vDW_TaskInstance t
                          ON (	t.TaskInstanceId = i.TASKINSTANCE_)';
      CREATEOBJECT(vsql,'Unable to create view VDW_VARIABLEINSTANCE');
  
  /*
  -----------------------------------------
   CREATING TRIGGERS ON TABLES
  -----------------------------------------
  */
  -- Create Trigger TRG_JBPM_ID_PERMISSIONS_UPD
       vsql :=  'CREATE TRIGGER WFS.TRG_JBPM_ID_PERMISSIONS_UPD
                              BEFORE UPDATE
                              ON WFS.JBPM_ID_PERMISSIONS
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              SELECT  SYSTIMESTAMP
                              INTO    updatedate
                              FROM    DUAL;
                              :NEW.UpdateDate := updatedate;
                              END;';
      CREATEOBJECT(vsql,'Unable to create trigger TRG_JBPM_ID_PERMISSION_UPD');  
  
      -- Create Trigger TRG_TTV_SELECTOR_SEQ
      
      BEGIN
      
        execute immediate  'CREATE OR REPLACE TRIGGER WFS.TRG_TTV_SELECTOR_SEQ
                              BEFORE INSERT ON WFS.TTV_SELECTOR
                              FOR EACH ROW
                              BEGIN
                                  
                                  :NEW.CreateDate := sysdate;
                                  :NEW.UpdateDate := sysdate;
  
                              END;';
                              
      EXCEPTION
        WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_SELECTOR_SEQ'')';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values ('''||err_msg||''')';
      GOTO bypass_install;
          
      END;
      
      -- Create Trigger TRG_TTV_SELECTOR_UPD   
      
      BEGIN
      
         execute immediate  'CREATE OR REPLACE TRIGGER WFS.TRG_TTV_SELECTOR_UPD
                              BEFORE UPDATE
                              ON WFS.TTV_SELECTOR
                              FOR EACH ROW
                              BEGIN
                                  :NEW.UpdateDate := sysdate;
                              END;';
                             
      EXCEPTION
        WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table values
           (''error in installing of application database objects:
             Unable to create trigger TRG_TTV_SELECTOR_UPD'')';
          EXECUTE IMMEDIATE 'INSERT INTO install_table values ('''||err_msg||''')';
      GOTO bypass_install;
          
      END;
      
  /*
  -----------------------------------------
   COMPILE PACKAGES AND PROCEDURES
  -----------------------------------------
  */
  
  -- Create Procedure SP_REINITIALIZESEQUENCE
  
                vsql :=  'CREATE OR REPLACE PROCEDURE WFS.SP_REINITIALIZESEQUENCE 
                              (tablename IN varchar2 , idcolumn IN varchar2 )
                              IS
                                  sequencename    varchar2 (100);
                                  maxsequence     INTEGER;
                                  sql_max         varchar2 (500);
                                  sql_createseq   varchar2 (500);
                                  sql_dropseq     varchar2 (500);
                                  varcount        INTEGER;
  
                              BEGIN
  
                                  -- DBMS_OUTPUT.PUT_LINE(''Working on: '' || tablename);
  
                                  sequencename := ''WFS.'' || tablename || ''_seq'';
  
                                  -- DBMS_OUTPUT.PUT_LINE(''Sequence:'' || sequencename);
  
                                  sql_max  := ''SELECT MAX('';
                                  sql_max  := sql_max || idcolumn;
                                  sql_max   := sql_max || '') FROM '' || tablename; 
  
                                  EXECUTE IMMEDIATE sql_max INTO varcount; 
  
                                  -- DBMS_OUTPUT.PUT_LINE(''Current Sequence Number:'');
  
                                  varcount := NVL(varcount,0) + 1;
                                  -- DBMS_OUTPUT.PUT_LINE (varcount);
  
                                  -- Drop the sequence
                                  sql_dropseq  := ''DROP SEQUENCE '' || sequencename;
                                  -- DBMS_OUTPUT.PUT_LINE (sql_dropseq);
                                  BEGIN
                                  EXECUTE IMMEDIATE sql_dropseq;
  
                                      EXCEPTION
                                         WHEN OTHERS THEN
                                              null;
                                 END;
  
                                  -- Recreate the sequence
                                  sql_createseq   := ''CREATE SEQUENCE '' || sequencename;
                                  sql_createseq   := sql_createseq || '' START WITH '' || varcount;
                                  sql_createseq   := sql_createseq || '' INCREMENT BY 1'';
  
                                  -- DBMS_OUTPUT.PUT_LINE (sql_createseq);
  
                                  BEGIN
                                  EXECUTE IMMEDIATE sql_createseq;
  
                                   EXCEPTION
                                   WHEN OTHERS THEN
                                    null;
  
                                  END;
  
                                  DBMS_OUTPUT.PUT_LINE(''Sequence '' || sequencename || '' updated to '' || varcount);
  
                                  END;';
  
         CREATEOBJECT(vsql,'Unable to create SP_REINITIALIZESEQUENCE Procedure');
          
          
  
  /*
  -----------------------------------------
   INSERTING DEFAULT DATA INTO TABLES
  -----------------------------------------
  */
  
    -- Inserting default SYSTEM_RELEASE data
    BEGIN
    
      EXECUTE IMMEDIATE 'INSERT INTO WFS.SYSTEM_RELEASE VALUES 
                  (''RELEASE'',''2.9.0.0'')';
                  
    EXCEPTION 
      WHEN OTHERS THEN
      
        wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
        EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into SYSTEM_RELEASE'')';
        EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
        
    END;
  
  -- Inserting default TTV_CONNECTIONTYPE data
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_CONNECTIONTYPE(CONNECTIONTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''URL'', TO_DATE(''15/06/2006 09:18:25 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 09:19:23 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_CONNECTIONTYPE(CONNECTIONTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''IP Address[:Port]'', TO_DATE(''15/06/2006 09:18:34 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 09:19:20 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_CONNECTIONTYPE(CONNECTIONTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(3, ''Email'', TO_DATE(''15/06/2006 09:18:41 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 09:18:41 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
    EXCEPTION
      WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into TTV_CONNECTIONTYPE'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
    END;
  
  -- Inserting default TTV_STRATEGYCLASSTYPE data
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASSTYPE(STRATEGYCLASSTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''Resource Initialization Strategy'', TO_DATE(''15/06/2006 05:39:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:39:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASSTYPE(STRATEGYCLASSTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''Resource HeartBeat Strategy'', TO_DATE(''15/06/2006 05:39:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:39:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASSTYPE(STRATEGYCLASSTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(3, ''Resource Allocation Strategy'', TO_DATE(''15/06/2006 05:39:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:39:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into TTV_STRATEGYCLASSTYPE'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
  -- Inserting default TTV_PROCESSPRIORITY data
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSPRIORITY(PROCESSPRIORITYID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(0, ''LOWEST'', TO_DATE(''28/07/2006 08:03:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/07/2006 08:03:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSPRIORITY(PROCESSPRIORITYID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''LOW'', TO_DATE(''28/07/2006 08:03:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/07/2006 08:03:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSPRIORITY(PROCESSPRIORITYID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''NORMAL'', TO_DATE(''28/07/2006 08:03:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/07/2006 08:03:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSPRIORITY(PROCESSPRIORITYID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(3, ''HIGH'', TO_DATE(''28/07/2006 08:03:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/07/2006 08:03:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSPRIORITY(PROCESSPRIORITYID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(4, ''HIGHEST'', TO_DATE(''28/07/2006 08:03:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''28/07/2006 08:03:46 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into TTV_PROCESSPRIORITY'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
  -- Inserting default TTV_PROCESSSTATUS data 
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(0, ''CREATED'', TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''RUNNING'', TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''ERROR'', TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(3, ''PAUSED'', TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(4, ''QUEUED'', TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(5, ''CANCELLED'', TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(6, ''STOPPED'', TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:52 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(7, ''BUSY'', TO_DATE(''21/06/2006 06:16:19 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''21/06/2006 06:16:19 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID,NAME,CREATEDATE,UPDATEDATE)
    VALUES(8, ''BRANCH'', sysdate, sysdate)';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into TTV_PROCESSSTATUS'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
  -- Inserting default PROCESSINSTANCETYPE data
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSINSTANCETYPE(PROCESSINSTANCETYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''Standard JBPM ProcessInstance'', TO_DATE(''15/06/2006 05:35:20 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:20 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSINSTANCETYPE(PROCESSINSTANCETYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''TTV ProcessInstance'', TO_DATE(''15/06/2006 05:35:20 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:20 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into TTV_PROCESSINSTANCETYPE'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
  -- Inserting default TTV_TOKENTYPE data 
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_TOKENTYPE(TOKENTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''Standard JBPM Token'', TO_DATE(''15/06/2006 05:39:36 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:39:36 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_TOKENTYPE(TOKENTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''TTV Token'', TO_DATE(''15/06/2006 05:39:36 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:39:36 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into TTV_TOKENTYPE'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
  -- Inserting default TTV_ACCESSLEVEL data 
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACCESSLEVEL(ACCESSLEVELID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(0, ''NON-ADULT'', TO_DATE(''11/08/2006 06:27:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''11/08/2006 06:27:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACCESSLEVEL(ACCESSLEVELID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''ADULT'', TO_DATE(''11/08/2006 06:27:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''11/08/2006 06:27:56 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_ACCESSLEVEL(ACCESSLEVELID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''COMMON'', TO_DATE(''11/09/2006 11:12:51 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''11/09/2006 11:12:51 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into TTV_ACCESSLEVEL'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
  -- Inserting default TTV_VARIABLEACCESSTYPE data
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_VARIABLEACCESSTYPE(VARIABLEACCESSTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''Standard JBPM VariableAccess'', TO_DATE(''14/09/2006 09:34:00 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''14/09/2006 09:34:51 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_VARIABLEACCESSTYPE(VARIABLEACCESSTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''TTV VariableAccess'', TO_DATE(''14/09/2006 09:34:00 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''14/09/2006 09:34:51 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into TTV_VARIABLEACCESSTYPE'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
      BEGIN
  
                  -- Reinitialize the TTV_VariableAccessType Sequence
          EXECUTE IMMEDIATE 'BEGIN WFS.SP_REINITIALIZESEQUENCE (''TTV_VariableAccessType'', ''VariableAccessTypeId''); END;';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Problem calling SP_REINITIALIZESEQUENCE for TTV_VariableAccessType'')';
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
  -- Inserting default TTV_MONITOREDDRIVESTATUS data 
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MONITOREDDRIVESTATUS(MONITOREDDRIVESTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(0, ''OK'', TO_DATE(''27/09/2006 11:07:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''27/09/2006 11:07:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MONITOREDDRIVESTATUS(MONITOREDDRIVESTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''WARNING'', TO_DATE(''27/09/2006 11:07:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''27/09/2006 11:07:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_MONITOREDDRIVESTATUS(MONITOREDDRIVESTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''ERROR'', TO_DATE(''27/09/2006 11:07:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''27/09/2006 11:07:09 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into TTV_MONITOREDDRIVESTATUS'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
  -- Inserting default TTV_DATATYPE data
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''int'', TO_DATE(''05/06/2006 11:09:26 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''05/06/2006 11:09:26 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''string'', TO_DATE(''05/06/2006 11:09:42 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''05/06/2006 11:09:42 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE)
    VALUES(3, ''boolean'', TO_DATE(''05/06/2006 11:09:45 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''05/06/2006 11:09:45 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE)
    VALUES(4, ''date'', TO_DATE(''19/08/2006 02:37:36 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''19/08/2006 02:37:36 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE)
    VALUES(5, ''file'', TO_DATE(''19/08/2006 02:37:36 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''19/08/2006 02:37:36 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE)
    VALUES(6, ''destination'', TO_DATE(''19/08/2006 02:37:36 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''19/08/2006 02:37:36 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE)
    VALUES(7, ''duration'', TO_DATE(''30/09/2006 03:57:41 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''30/09/2006 03:57:41 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
    
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_DATATYPE(DATATYPEID, DATATYPENAME, CREATEDATE, UPDATEDATE)
    VALUES(8, ''url'', TO_DATE(''15/08/2007 12:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/08/2007 12:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into TTV_DATATYPE'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
  -- Inserting default ALERTS data 
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE)
    VALUES(''Duplicate Parameters'', ''Duplicate Parameters For Workorder Pattern'', 1, 3600, 1, 3600, ''LOG'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE)
    VALUES(''Resource Initialization Failure'', ''Resource Initialization Failure Pattern'', 1, 3600, 1, 3600, ''LOG'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE)
    VALUES(''Protection Key Mismatch'', ''Protection Key Mismatch Pattern'', 1, 3600, 1, 3600, ''LOG'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE)
    VALUES(''Saving Workorder Failed'', ''Workorder Save Failed Pattern'', 1, 3600, 1, 3600, ''LOG'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE)
    VALUES(''Workorder Failed'', ''Workorder Failed Pattern'', 1, 3600, 1, 3600, ''LOG'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE)
    VALUES(''Resource Failed'', ''Resource Failed Pattern'', 1, 3600, 1, 3600, ''LOG'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE)
    VALUES(''Workorder Creation Failed'', ''Create Workorder Failed Pattern'', 1, 3600, 1, 3600, ''LOG'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE)
    VALUES(''Database Operation Failed'', ''Database Operation Failed Pattern'', 1, 3600, 1, 3600, ''LOG'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE) 
    VALUES (''Invalid Template License'', ''Invalid License for Templates Pattern'', 1,	3600, 1, 3600, ''LOG'')';

          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE)
	VALUES (''Template Ingest Failure'', ''Template Ingest Failure Pattern'', 1, 3600, 1, 3600, ''LOG'')';

        vsql := 'INSERT INTO '||vschema||'.ALERTS(IDENTIFIER,ALERT_NAME,THRESH_COUNT,THRESH_SECS,FREQ_COUNT,FREQ_SECS,TYPE) 
        VALUES (''Pitch Schedule Notification'',''Pitch Schedule Notification Pattern'',1,3600,1,3600,''LOG'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y');

        vsql := 'INSERT INTO '||vschema||'.ALERTS(IDENTIFIER,ALERT_NAME,THRESH_COUNT,THRESH_SECS,FREQ_COUNT,FREQ_SECS,TYPE) 
        VALUES (''Drive Status'',''Drive Status'',1,3600,1,3600,''LOG'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y');

        vsql := 'INSERT INTO '||vschema||'.ALERTS(IDENTIFIER,ALERT_NAME,THRESH_COUNT,THRESH_SECS,FREQ_COUNT,FREQ_SECS,TYPE) 
        VALUES (''Planner Notification'',''Planner Notification Pattern'',1,3600,1,3600,''LOG'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y');

        --Vlada on Oct 21 2009
        vsql := 'INSERT INTO '||vschema||'.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE) 
        VALUES(''Login Failed'', ''Login Failed Pattern'', 1, 3600, 1, 3600, ''LOG'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y');


      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into ALERTS'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
  -- Inserting default ALERT_ACTIONS
      BEGIN
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL)
    VALUES(''Resource Initialization Failure'', 1, ''7'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL)
    VALUES(''Protection Key Mismatch'', 1, ''5'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL)
    VALUES(''Workorder Creation Failed'', 1, ''9'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL)
    VALUES(''Workorder Failed'', 1, ''10'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL)
    VALUES(''Resource Failed'', 1, ''6'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL)
    VALUES(''Database Operation Failed'', 1, ''1'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL)
    VALUES(''Duplicate Parameters'', 1, ''2'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL)
    VALUES(''Saving Workorder Failed'', 1, ''8'')';

          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL) 
    VALUES (''Invalid Template License'', 1, ''11'')';

          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL)
    VALUES(''Template Ingest Failure'', 1, ''12'')';

    vsql := 'Insert into '||vschema||'.ALERT_ACTIONS (IDENTIFIER,ACTION_TYPE,DETAIL) values (''Planner Notification'',1,''13'')';
    CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y');

    vsql := 'Insert into '||vschema||'.ALERT_ACTIONS (IDENTIFIER,ACTION_TYPE,DETAIL) values (''Drive Status'',1,''14'')';
    CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y');

    vsql := 'Insert into '||vschema||'.ALERT_ACTIONS (IDENTIFIER,ACTION_TYPE,DETAIL) values (''Pitch Schedule Notification'',1,''13'')';
    CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y');

    --Vlada on Oct 21 2009
    vsql := 'INSERT INTO '||vschema||'.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL) VALUES(''Login Failed'', 1, ''4'')';
    CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y');    
    
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into ALERT_ACTIONS'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
  -- Inserting default ALERT_NAMES data 
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_NAMES(ALERT_NAME, PATTERN)
    VALUES(''Workorder Failed Pattern'', ''.*execution has failed.*'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_NAMES(ALERT_NAME, PATTERN)
    VALUES(''Duplicate Parameters For Workorder Pattern'', ''.*Workorder with same parameters already created in the past.*'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_NAMES(ALERT_NAME, PATTERN)
    VALUES(''Create Workorder Failed Pattern'', ''.*Failed to instantiate Work Order.*'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_NAMES(ALERT_NAME, PATTERN)
    VALUES(''Resource Failed Pattern'', ''.*Failure Event for Resource.*'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_NAMES(ALERT_NAME, PATTERN)
    VALUES(''Resource Initialization Failure Pattern'', ''.*Initialization Error.*'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_NAMES(ALERT_NAME, PATTERN)
    VALUES(''Workorder Save Failed Pattern'', ''.*Failed to save the process.*'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_NAMES(ALERT_NAME, PATTERN)
    VALUES(''Database Operation Failed Pattern'', ''.*SQLException.*'')';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_NAMES(ALERT_NAME, PATTERN)
    VALUES(''Protection Key Mismatch Pattern'', ''.*mismatching protection keys.*'')';

	  EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_NAMES(ALERT_NAME, PATTERN) 
    VALUES(''Invalid License for Templates Pattern'', ''.*License unavailable for template.*'')';

	  EXECUTE IMMEDIATE 'INSERT INTO WFS.ALERT_NAMES(ALERT_NAME, PATTERN)
    VALUES(''Template Ingest Failure Pattern'', ''.*Failed to ingest template.*'')';
    
     vsql := 'INSERT INTO '||vschema||'.ALERT_NAMES (ALERT_NAME,PATTERN) values (''Pitch Schedule Notification Pattern'',''.*titles did not achieve status.*'')';
     CREATEOBJECT(vsql,'Unable to insert into ALERT_NAMES','Y');

     vsql := 'INSERT INTO '||vschema||'.ALERT_NAMES (ALERT_NAME,PATTERN) values (''Drive Status'',''.*drive status.*'')';
     CREATEOBJECT(vsql,'Unable to insert into ALERT_NAMES','Y');

     vsql := 'INSERT INTO '||vschema||'.ALERT_NAMES (ALERT_NAME,PATTERN) values (''Planner Notification Pattern'',''.*assets for planner.*'')';
     CREATEOBJECT(vsql,'Unable to insert into ALERT_NAMES','Y');
    
    --Change by Vlada Oct 21 2009
    vsql := 'INSERT INTO '||vschema||'.ALERT_NAMES(ALERT_NAME, PATTERN) VALUES(''Login Failed Pattern'', ''.*Login failed for.*'')';
    CREATEOBJECT(vsql,'Unable to insert into ALERT_NAMES','Y');
    

      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into ALERT_NAMES'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
  -- Inserting default TTV_PROCESSDEFINITIONTYPE
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSDEFINITIONTYPE(PROCESSDEFINITIONTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''Standard JBPM ProcessDefinition'', TO_DATE(''15/06/2006 05:35:20 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:20 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSDEFINITIONTYPE(PROCESSDEFINITIONTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''TTV ProcessDefinition'', TO_DATE(''15/06/2006 05:35:20 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''15/06/2006 05:35:20 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_PROCESSDEFINITIONTYPE(PROCESSDEFINITIONTYPEID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(3, ''TTV Invisible ProcessDefinition'', TO_DATE(''03/10/2006 07:52:36 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''03/10/2006 07:52:36 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into TTV_PROCESSDEFINITIONTYPE'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
  
  
  -- Inserting default TTV_RESOURCESTATUSID data 
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_RESOURCESTATUS(RESOURCESTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(1, ''Initializing'', TO_DATE(''20/06/2006 01:14:40 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''20/06/2006 01:15:08 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_RESOURCESTATUS(RESOURCESTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(2, ''Online'', TO_DATE(''20/06/2006 01:14:45 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''20/06/2006 01:15:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_RESOURCESTATUS(RESOURCESTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(3, ''Offline'', TO_DATE(''20/06/2006 01:14:54 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''20/06/2006 01:14:54 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_RESOURCESTATUS(RESOURCESTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(4, ''Initialization Error'', TO_DATE(''20/06/2006 01:15:14 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''23/06/2006 04:12:45 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_RESOURCESTATUS(RESOURCESTATUSID, NAME, CREATEDATE, UPDATEDATE)
    VALUES(5, ''HeartBeat Error'', TO_DATE(''23/06/2006 04:12:50 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''23/06/2006 04:12:50 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_RESOURCESTATUS (RESOURCESTATUSID, NAME)
    VALUES (6, ''Error'')';
    
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_RESOURCESTATUS (RESOURCESTATUSID, NAME)
    VALUES (7, ''Inactive'')';
    
            EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_RESOURCESTATUS (RESOURCESTATUSID, NAME)
    VALUES (8, ''Invalid'')';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into TTV_RESOURCESTATUS'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
  -- Inserting default TTV_STRATEGYCLASS data
      BEGIN
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
    VALUES(1, ''XPort Initialization'', ''Initializes the XPort Subsystem'', ''com.tandbergtv.workflow.resourcemanager.mgmt.initialization.XPortInitializationStrategy'', 1, 
           TO_DATE(''15/06/2006 05:39:01 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''19/07/2006 01:46:37 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
    VALUES(2, ''VTPS Ping HeartBeat'', ''Sends periodic Ping messages to the VTPS Subsystem'', ''com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.VTPSHeartBeatStrategy'', 2, 
           TO_DATE(''15/06/2006 05:39:01 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''19/07/2006 01:47:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
    VALUES(3, ''Default Resource Allocation'', ''Allocates resources within the Resource Group'', ''com.tandbergtv.workflow.resourcemanager.mgmt.allocation.DefaultResourceAllocationStrategy'', 3, 
           TO_DATE(''15/06/2006 05:39:01 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''19/07/2006 01:47:29 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
          EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
    VALUES(5, ''Round Robin Resource Allocation'', ''Allocates resources within the Resource Group using Round Robin'', ''com.tandbergtv.workflow.resourcemanager.mgmt.allocation.RoundRobinResourceAllocationStrategy'', 3, 
           TO_DATE(''12/07/2006 11:49:07 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''19/07/2006 01:48:02 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
           EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
    VALUES(6, ''Anystream Transcode Initialization'', ''Initializes the Anystream Subsystem'', ''com.tandbergtv.workflow.resourcemanager.mgmt.initialization.AnystreamInitializationStrategy'', 1, 
           TO_DATE(''12/09/2006 11:05:31 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''22/09/2006 07:30:17 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
           EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
    VALUES(7, ''Webservice HeartBeat'', ''HeartBeats for any subsystem that interfaces with a Webservice'', ''com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.WebserviceHeartBeatStrategy'', 2, 
           TO_DATE(''22/09/2006 07:29:40 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''22/09/2006 07:29:40 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
           EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
    VALUES(8, ''XPort HeartBeat'', ''HeartBeats for XPort producer'', ''com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.XPortHeartBeatStrategy'', 2, 
           TO_DATE(''29/11/2006 07:29:40 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''22/09/2006 07:29:40 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
           EXECUTE IMMEDIATE 'INSERT INTO WFS.TTV_STRATEGYCLASS(STRATEGYCLASSID, NAME, DESCRIPTION, CLASSNAME, STRATEGYCLASSTYPEID, CREATEDATE, UPDATEDATE)
    VALUES(9, ''Anystream Heartbeat'', ''Heartbeats for Anystream Agility Transcoder'', ''com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.AnystreamHeartBeatStrategy'', 2, 
           TO_DATE(''29/11/2006 07:29:40 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''22/09/2006 07:29:40 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
  
      EXCEPTION
          WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into TTV_STRATEGYCLASS'')';
              EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
      END;
  
      -- Insert Default TTV_TRANSITIONTYPE   
      BEGIN
      
        EXECUTE IMMEDIATE 'Insert Into WFS.TTV_TRANSITIONTYPE(TRANSITIONTYPEID, NAME,CREATEDATE,UPDATEDATE)
          Values(1,''JBPM Standard Transition'',systimestamp,systimestamp)';
  
        EXECUTE IMMEDIATE 'Insert into WFS.TTV_TRANSITIONTYPE(TRANSITIONTYPEID, NAME,CREATEDATE,UPDATEDATE)
          Values(2,''TTV Transition'',systimestamp,systimestamp)';
          
      EXCEPTION
        WHEN OTHERS THEN
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''error in installing of application database objects:
             Unable to insert data into TTV_TRANSITIONTYPE'')';
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
          
      END;
      
      -- Inserting into table 'SYSTEM_SETTINGS'
      BEGIN
      
        EXECUTE IMMEDIATE 'INSERT INTO wfs.SYSTEM_SETTINGS values (''RELEASE'',''2.9'')';
        
      EXCEPTION 
        WHEN OTHERS THEN
        
          wk_message := 'ERROR';
		    err_msg :=SUBSTR(SQLERRM, 1, 500);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
             (''error inserting SYSTEM_SETTINGS data'')';
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
      GOTO bypass_install;
               
      END;
      
  /*
  -----------------------------------------
   CREATING FOREIGN KEY ON ALL TABLES
  -----------------------------------------
  */
  
    -- Creating Foreign Key on ALERTS
     vsql := 'ALTER TABLE WFS.ALERTS ADD (
                                      CONSTRAINT ALERTS#ALERT_NAMES
                                          FOREIGN KEY (ALERT_NAME) 
                                          REFERENCES WFS.ALERT_NAMES (ALERT_NAME))';
                                          
    CREATEOBJECT(vsql,'Unable to create foreign Keys for ALERTS');
  
    -- Creating Foreign Key on ALERT_ACTIONS

     vsql := 'ALTER TABLE WFS.ALERT_ACTIONS ADD (
                                      CONSTRAINT ALERT_ACTIONS#ALERTS 
                                          FOREIGN KEY (IDENTIFIER) 
                                          REFERENCES WFS.ALERTS (IDENTIFIER))';
                                          
    CREATEOBJECT(vsql,'Unable to create foreign Keys for ALERT_ACTIONS');    

  
    -- Creating Foreign Key on ALERT_ACTIONS_HIST
     vsql := 'ALTER TABLE WFS.ALERT_ACTIONS_HIST ADD (
                CONSTRAINT ALERT_ACTIONS_HIST#ALERTS_HIST 
                        FOREIGN KEY (HIST_KEY) 
                        REFERENCES WFS.ALERTS_HIST (HIST_KEY))';
                                          
    CREATEOBJECT(vsql,'Unable to create foreign Keys for ALERT_ACTIONS_HIST');
  
    -- Creating Foreign Key on JBPM_ACTION
     vsql := 'ALTER TABLE WFS.JBPM_ACTION ADD (
                                  CONSTRAINT JBPM_ACTION#JBPM_ACTION1
                                          FOREIGN KEY (TIMERACTION_) 
                                          REFERENCES WFS.JBPM_ACTION (ID_),
                                  CONSTRAINT JBPM_ACTION#JBPM_ACTION2 
                                          FOREIGN KEY (REFERENCEDACTION_) 
                                          REFERENCES WFS.JBPM_ACTION (ID_),
                                  CONSTRAINT JBPM_ACTION#JBPM_PDEFINITION 
                                          FOREIGN KEY (PROCESSDEFINITION_) 
                                          REFERENCES WFS.JBPM_PROCESSDEFINITION (ID_),
                                  CONSTRAINT JBPM_ACTION#JBPM_EHANDLER 
                                          FOREIGN KEY (EXCEPTIONHANDLER_) 
                                          REFERENCES WFS.JBPM_EXCEPTIONHANDLER (ID_),
                                  CONSTRAINT JBPM_ACTION#JBPM_EVENT 
                                          FOREIGN KEY (EVENT_) 
                                          REFERENCES WFS.JBPM_EVENT (ID_),
                                  CONSTRAINT JBPM_ACTION#JBPM_DELEGATION 
                                          FOREIGN KEY (ACTIONDELEGATION_) 
                                          REFERENCES WFS.JBPM_DELEGATION (ID_))';
                          
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_ACTION'); 
  
    -- Creating Foreign Key on JBPM_BYTEARRAY

     vsql :=  'ALTER TABLE WFS.JBPM_BYTEARRAY ADD (CONSTRAINT JBPM_BYTEARRAY#JBPM_MDEFINITN FOREIGN KEY (FILEDEFINITION_) REFERENCES WFS.JBPM_MODULEDEFINITION (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_BYTEARRAY'); 
  
    -- Creating Foreign Key on JBPM_BYTEBLOCK
     vsql :=  'ALTER TABLE WFS.JBPM_BYTEBLOCK ADD (CONSTRAINT JBPM_BYTEBLOCK#JBPM_BYTEARRAY  FOREIGN KEY (PROCESSFILE_) REFERENCES WFS.JBPM_BYTEARRAY (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_BYTEBLOCK');             
  
    -- Creating Foreign Key on JBPM_COMMENT

     vsql :=  'ALTER TABLE WFS.JBPM_COMMENT ADD (CONSTRAINT JBPM_COMMENT#JBPM_TASKINSTANCE FOREIGN KEY (TASKINSTANCE_) REFERENCES WFS.JBPM_TASKINSTANCE (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_COMMENT'); 
  
    -- Creating Foreign Key on JBPM_DELEGATION
     vsql :=  'ALTER TABLE WFS.JBPM_DELEGATION ADD (CONSTRAINT JBPM_DELEGATION#JBPM_PDEF  FOREIGN KEY (PROCESSDEFINITION_)  REFERENCES WFS.JBPM_PROCESSDEFINITION (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_DELEGATION'); 

    -- Creating Foreign Key on JBPM_EVENT
     vsql :=  'ALTER TABLE WFS.JBPM_EVENT ADD (
              CONSTRAINT JBPM_EVENT#JBPM_TRANSITION 
                      FOREIGN KEY (TRANSITION_) 
                      REFERENCES WFS.JBPM_TRANSITION (ID_),
              CONSTRAINT JBPM_EVENT#JBPM_TASK 
                      FOREIGN KEY (TASK_) 
                      REFERENCES WFS.JBPM_TASK (ID_),
              CONSTRAINT JBPM_EVENT#JBPM_PDEFINITION 
                      FOREIGN KEY (PROCESSDEFINITION_) 
                      REFERENCES WFS.JBPM_PROCESSDEFINITION (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_EVENT'); 

    -- Creating Foreign Key on JBPM_ID_GROUP
     vsql :=  'ALTER TABLE WFS.JBPM_ID_GROUP ADD (
                CONSTRAINT JBPM_ID_GROUP#JBPM_ID_GROUP 
                        FOREIGN KEY (PARENT_)
                        REFERENCES WFS.JBPM_ID_GROUP (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_ID_GROUP'); 

    -- Creating Foreign Key on JBPM_ID_MEMBERSHIP
     vsql :=  'ALTER TABLE WFS.JBPM_ID_MEMBERSHIP ADD (
                CONSTRAINT JBPM_ID_MEMBERSHIP#JBPM_ID_USR 
                        FOREIGN KEY (USER_) 
                        REFERENCES WFS.JBPM_ID_USER (ID_),
                CONSTRAINT JBPM_ID_MEMBERSHIP#JBPM_ID_GRP
                        FOREIGN KEY (GROUP_) 
                        REFERENCES WFS.JBPM_ID_GROUP (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_ID_MEMBERSHIP'); 

  
    -- Creating Foreign Key on JBPM_LOG
     vsql :=  'ALTER TABLE WFS.JBPM_LOG ADD (
                CONSTRAINT JBPM_LOG#TTV_PSTATUS1 
                        FOREIGN KEY (ADMINISTRATIVESTATUSID) 
                        REFERENCES WFS.TTV_PROCESSSTATUS (PROCESSSTATUSID),
                CONSTRAINT JBPM_LOG#TTV_PSTATUS2 
                        FOREIGN KEY (OPERATIONALSTATUSID) 
                        REFERENCES WFS.TTV_PROCESSSTATUS (PROCESSSTATUSID),
                CONSTRAINT JBPM_LOG#TTV_RESOURCE 
                        FOREIGN KEY (RESOURCEID) 
                        REFERENCES WFS.TTV_RESOURCE (RESOURCEID),
                CONSTRAINT JBPM_LOG#TTV_RESOURCEGROUP 
                        FOREIGN KEY (RESOURCEGROUPID) 
                        REFERENCES WFS.TTV_RESOURCEGROUP (RESOURCEGROUPID),
                CONSTRAINT JBPM_LOG#JBPM_VARIABLEINSTANCE 
                        FOREIGN KEY (VARIABLEINSTANCE_) 
                        REFERENCES WFS.JBPM_VARIABLEINSTANCE (ID_),
                CONSTRAINT JBPM_LOG#JBPM_TRANSITION 
                        FOREIGN KEY (TRANSITION_) 
                        REFERENCES WFS.JBPM_TRANSITION (ID_),
                CONSTRAINT JBPM_LOG#JBPM_TASKINSTANCE 
                        FOREIGN KEY (TASKINSTANCE_) 
                        REFERENCES WFS.JBPM_TASKINSTANCE (ID_),
                CONSTRAINT JBPM_LOG#JBPM_SWIMLANEINSTANCE 
                        FOREIGN KEY (SWIMLANEINSTANCE_) 
                        REFERENCES WFS.JBPM_SWIMLANEINSTANCE (ID_),
                CONSTRAINT JBPM_LOG#JBPM_LOG1 
                        FOREIGN KEY (PARENT_) 
                        REFERENCES WFS.JBPM_LOG (ID_),
                CONSTRAINT JBPM_LOG#JBPM_BYTEARRAY1 
                        FOREIGN KEY (OLDBYTEARRAY_) 
                        REFERENCES WFS.JBPM_BYTEARRAY (ID_),
                CONSTRAINT JBPM_LOG#JBPM_BYTEARRAY2 
                        FOREIGN KEY (NEWBYTEARRAY_) 
                        REFERENCES WFS.JBPM_BYTEARRAY (ID_),
                CONSTRAINT JBPM_LOG#JBPM_ACTION 
                        FOREIGN KEY (ACTION_) 
                        REFERENCES WFS.JBPM_ACTION (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_LOG'); 

  
    -- Creating Foreign Key on JBPM_MESSAGE
     vsql :=  'ALTER TABLE WFS.JBPM_MESSAGE ADD (
                CONSTRAINT JBPM_MESSAGE#JBPM_TASKINSTANCE 
                        FOREIGN KEY (TASKINSTANCE_) 
                        REFERENCES WFS.JBPM_TASKINSTANCE (ID_),
                CONSTRAINT JBPM_MESSAGE#JBPM_ACTION 
                        FOREIGN KEY (ACTION_) 
                        REFERENCES WFS.JBPM_ACTION (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_MESSAGE'); 

    -- Creating Foreign Key on JBPM_MODULEDEFINITION
     vsql :=      'ALTER TABLE WFS.JBPM_MODULEDEFINITION ADD (
                  CONSTRAINT JBPM_MDEFINITION#JBPM_TASK 
                          FOREIGN KEY (STARTTASK_) 
                          REFERENCES WFS.JBPM_TASK (ID_),
                  CONSTRAINT JBPM_MDEFINITION#JBPM_PDEF  
                          FOREIGN KEY (PROCESSDEFINITION_) 
                          REFERENCES WFS.JBPM_PROCESSDEFINITION (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_MODULEDEFINITION'); 
  
    -- Creating Foreign Key on JBPM_MODULEINSTANCE
     vsql :=      'ALTER TABLE WFS.JBPM_MODULEINSTANCE ADD (
                  CONSTRAINT JBPM_MINSTANCE#JBPM_MDEF
                          FOREIGN KEY (TASKMGMTDEFINITION_) 
                          REFERENCES WFS.JBPM_MODULEDEFINITION (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_MODULEINSTANCE'); 
  
    -- Creating Foreign Key on JBPM_NODE
     vsql :=      'ALTER TABLE WFS.JBPM_NODE ADD (
                  CONSTRAINT JBPM_NODE#JBPM_PDEFINITION1 
                          FOREIGN KEY (SUBPROCESSDEFINITION_) 
                          REFERENCES WFS.JBPM_PROCESSDEFINITION (ID_),
                  CONSTRAINT JBPM_NODE#JBPM_NODE 
                          FOREIGN KEY (SUPERSTATE_) 
                          REFERENCES WFS.JBPM_NODE (ID_),
                  CONSTRAINT JBPM_NODE#JBPM_PDEFINITION2 
                          FOREIGN KEY (PROCESSDEFINITION_) 
                          REFERENCES WFS.JBPM_PROCESSDEFINITION (ID_),
                  CONSTRAINT JBPM_NODE#JBPM_ACTION 
                          FOREIGN KEY (ACTION_) 
                          REFERENCES WFS.JBPM_ACTION (ID_),
                  CONSTRAINT JBPM_NODE#TTV_RESOURCEGROUP 
                          FOREIGN KEY (RESOURCEGROUPID) 
                          REFERENCES WFS.TTV_RESOURCEGROUP (RESOURCEGROUPID),
                  CONSTRAINT JBPM_NODE#JBPM_DELEGATION 
                          FOREIGN KEY (DECISIONDELEGATION) 
                          REFERENCES WFS.JBPM_DELEGATION (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_NODE'); 
  
    -- Creating Foreign Key on JBPM_POOLEDACTOR
     vsql :=     'ALTER TABLE WFS.JBPM_POOLEDACTOR ADD (
                  CONSTRAINT JBPM_POOLACTR#JBPM_SLINSTANCE 
                          FOREIGN KEY (SWIMLANEINSTANCE_) 
                          REFERENCES WFS.JBPM_SWIMLANEINSTANCE (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_POOLEDACTOR'); 

  
    -- Creating Foreign Key on JBPM_PROCESSDEFINITION
     vsql := 'ALTER TABLE WFS.JBPM_PROCESSDEFINITION ADD (CONSTRAINT JBPM_PDEFINITION#TTV_PDEFTYPE FOREIGN KEY (PROCESSDEFINITIONTYPEID) REFERENCES WFS.TTV_PROCESSDEFINITIONTYPE (PROCESSDEFINITIONTYPEID))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_PROCESSDEFINITION'); 
  
    -- Creating Foreign Key on JBPM_PROCESSINSTANCE
     vsql := 'ALTER TABLE WFS.JBPM_PROCESSINSTANCE ADD (
                CONSTRAINT JBPM_PINSTANCE#TTV_PPRIORITY
                        FOREIGN KEY (PROCESSPRIORITYID) 
                        REFERENCES WFS.TTV_PROCESSPRIORITY (PROCESSPRIORITYID),
                CONSTRAINT JBPM_PINSTANCE#JBPM_TOKEN1 
                        FOREIGN KEY (SUPERPROCESSTOKEN_) 
                        REFERENCES WFS.JBPM_TOKEN (ID_),
                CONSTRAINT JBPM_PINSTANCE#JBPM_TOKEN2 
                        FOREIGN KEY (ROOTTOKEN_) 
                        REFERENCES WFS.JBPM_TOKEN (ID_),
                CONSTRAINT JBPM_PINSTANCE#JBPM_PDEF 
                        FOREIGN KEY (PROCESSDEFINITION_) 
                        REFERENCES WFS.JBPM_PROCESSDEFINITION (ID_),
                CONSTRAINT JBPM_PINSTANCE#TTV_PSTATUS1 
                        FOREIGN KEY (OPERATIONALPROCESSSTATUSID) 
                        REFERENCES WFS.TTV_PROCESSSTATUS (PROCESSSTATUSID),
                CONSTRAINT JBPM_PINSTANCE#TTV_PSTATUS2 
                        FOREIGN KEY (ADMINISTRATIVEPROCESSSTATUSID) 
                        REFERENCES WFS.TTV_PROCESSSTATUS (PROCESSSTATUSID),
                CONSTRAINT JBPM_PINSTANCE#TTV_PINSTTYPE 
                        FOREIGN KEY (PROCESSINSTANCETYPEID) 
                        REFERENCES WFS.TTV_PROCESSINSTANCETYPE (PROCESSINSTANCETYPEID))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_PROCESSINSTANCE'); 
  
    -- Creating Foreign Key on JBPM_RUNTIMEACTION
     vsql := 'ALTER TABLE WFS.JBPM_RUNTIMEACTION ADD (
              CONSTRAINT JBPM_RUNTIMEACTION#JBPM_ACTION 
                      FOREIGN KEY (ACTION_) 
                      REFERENCES WFS.JBPM_ACTION (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_RUNTIMEACTION'); 

    -- Creating Foreign Key on JBPM_SWIMLANE
     vsql := 'ALTER TABLE WFS.JBPM_SWIMLANE ADD (
              CONSTRAINT JBPM_SWIMLANE#JBPM_MDEFINITION 
                      FOREIGN KEY (TASKMGMTDEFINITION_) 
                      REFERENCES WFS.JBPM_MODULEDEFINITION (ID_),
              CONSTRAINT JBPM_SWIMLANE#JBPM_DELEGATION
                      FOREIGN KEY (ASSIGNMENTDELEGATION_) 
                      REFERENCES WFS.JBPM_DELEGATION (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_SWIMLANE'); 
  
    -- Creating Foreign Key on JBPM_SWIMLANEINSTANCE
     vsql := 'ALTER TABLE WFS.JBPM_SWIMLANEINSTANCE ADD (
                CONSTRAINT JBPM_SLINSTANCE#JBPM_MINSTANCE 
                        FOREIGN KEY (TASKMGMTINSTANCE_) 
                        REFERENCES WFS.JBPM_MODULEINSTANCE (ID_),
                CONSTRAINT JBPM_SLINSTANCE#JBPM_SWIMLANE  
                        FOREIGN KEY (SWIMLANE_) 
                        REFERENCES WFS.JBPM_SWIMLANE (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_SWIMLANEINSTANCE'); 
  
    -- Creating Foreign Key on JBPM_TASK
     vsql := 'ALTER TABLE WFS.JBPM_TASK ADD (
                CONSTRAINT JBPM_TASK#JBPM_TASKCONTROLLER 
                        FOREIGN KEY (TASKCONTROLLER_) 
                        REFERENCES WFS.JBPM_TASKCONTROLLER (ID_),
                CONSTRAINT JBPM_TASK#JBPM_MDEFINITION 
                        FOREIGN KEY (TASKMGMTDEFINITION_) 
                        REFERENCES WFS.JBPM_MODULEDEFINITION (ID_),
                CONSTRAINT JBPM_TASK#JBPM_SWIMLANE 
                        FOREIGN KEY (SWIMLANE_) 
                        REFERENCES WFS.JBPM_SWIMLANE (ID_),
                CONSTRAINT JBPM_TASK#JBPM_PDEFINITION 
                        FOREIGN KEY (PROCESSDEFINITION_) 
                        REFERENCES WFS.JBPM_PROCESSDEFINITION (ID_),
                CONSTRAINT JBPM_TASK#JBPM_DELEGATION 
                        FOREIGN KEY (ASSIGNMENTDELEGATION_) 
                        REFERENCES WFS.JBPM_DELEGATION (ID_))';

    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_TASK'); 
  
    -- Creating Foreign Key on JBPM_TASKACTORPOOL
     vsql := 'ALTER TABLE WFS.JBPM_TASKACTORPOOL ADD (
              CONSTRAINT JBPM_TACTRPOOL#JBPM_POOLEDACTR 
                      FOREIGN KEY (POOLEDACTOR_) 
                      REFERENCES WFS.JBPM_POOLEDACTOR (ID_),
              CONSTRAINT JBPM_TACTRPOOL##JBPM_TINSTANCE 
                      FOREIGN KEY (TASKINSTANCE_) 
                      REFERENCES WFS.JBPM_TASKINSTANCE (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_TASKACTORPOOL'); 

    -- Creating Foreign Key on JBPM_TASKCONTROLLER
     vsql := 'ALTER TABLE WFS.JBPM_TASKCONTROLLER ADD (
              CONSTRAINT JBPM_TCONTROLR#JBPM_DELEGATION 
                      FOREIGN KEY (TASKCONTROLLERDELEGATION_) 
                      REFERENCES WFS.JBPM_DELEGATION (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_TASKCONTROLLER'); 

    -- Creating Foreign Key on JBPM_TASKINSTANCE
     vsql := 'ALTER TABLE WFS.JBPM_TASKINSTANCE ADD (
              CONSTRAINT JBPM_TINSTANCE#JBPM_MINSTANCE 
                      FOREIGN KEY (TASKMGMTINSTANCE_) 
                      REFERENCES WFS.JBPM_MODULEINSTANCE (ID_),
              CONSTRAINT JBPM_TINSTANCE#JBPM_TASK 
                      FOREIGN KEY (TASK_) 
                      REFERENCES WFS.JBPM_TASK (ID_),
              CONSTRAINT JBPM_TINSTANCE#JBPM_SLINSTANCE 
                      FOREIGN KEY (SWIMLANINSTANCE_) 
                      REFERENCES WFS.JBPM_SWIMLANEINSTANCE (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_TASKINSTANCE'); 

    -- Creating Foreign Key on JBPM_TIMER
     vsql := 'ALTER TABLE WFS.JBPM_TIMER ADD (
              CONSTRAINT JBPM_TIMER#JBPM_TINSTANCE 
                      FOREIGN KEY (TASKINSTANCE_) 
                      REFERENCES WFS.JBPM_TASKINSTANCE (ID_),
              CONSTRAINT JBPM_TIMER#JBPM_ACTION
                      FOREIGN KEY (ACTION_) 
                      REFERENCES WFS.JBPM_ACTION (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_TIMER'); 
  
  -- Creating Foreign Key on JBPM_TOKEN
     vsql := 'ALTER TABLE WFS.JBPM_TOKEN ADD ( 
                  CONSTRAINT FK_TOKEN_SUBPI
                      FOREIGN KEY(SUBPROCESSINSTANCE_)
                      REFERENCES WFS.JBPM_PROCESSINSTANCE(ID_),
                  CONSTRAINT FK_TOKEN_PROCINST
                      FOREIGN KEY(PROCESSINSTANCE_)
                      REFERENCES WFS.JBPM_PROCESSINSTANCE(ID_),
                  CONSTRAINT FK_TOKEN_PARENT
                      FOREIGN KEY(PARENT_)
                      REFERENCES WFS.JBPM_TOKEN(ID_),
                  CONSTRAINT FK_TOKEN_NODE
                      FOREIGN KEY(NODE_)
                      REFERENCES WFS.JBPM_NODE(ID_),
                  CONSTRAINT FK_JBPM_TOKEN_TTV_TOKENTYPE
                      FOREIGN KEY(TOKENTYPEID)
                      REFERENCES WFS.TTV_TOKENTYPE(TOKENTYPEID),
                 Constraint FK_TOKEN#PROCESSSTATUS_OPER
                      Foreign Key(OPERATIONALSTATUS)
                      References WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID),
                  Constraint FK_TOKEN#PROCESSSTATUS_ADMIN
                      Foreign Key(ADMINISTRATIVESTATUS)
                      References WFS.TTV_PROCESSSTATUS(PROCESSSTATUSID))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_TOKEN'); 

  -- Create Foreign Key on JBPM_TOKENVARIABLEMAP
     vsql := 'ALTER TABLE WFS.JBPM_TOKENVARIABLEMAP ADD ( 
              CONSTRAINT FK_TKVARMAP_CTXT
                  FOREIGN KEY(CONTEXTINSTANCE_)
                  REFERENCES WFS.JBPM_MODULEINSTANCE(ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_TOKENVARIABLEMAP'); 

  -- Creating Foreign Key on JBPM_TRANSITION
     vsql := 'ALTER TABLE WFS.JBPM_TRANSITION ADD (
              CONSTRAINT JBPM_TRANSITION#JBPM_PDEF 
                      FOREIGN KEY (PROCESSDEFINITION_) 
                      REFERENCES WFS.JBPM_PROCESSDEFINITION (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_TRANSITION'); 
  
  -- Creating Foreign Key on JBPM_VARIABLEACCESS
     vsql := 'ALTER TABLE WFS.JBPM_VARIABLEACCESS ADD ( 
              CONSTRAINT FK_VARACC_TSKCTRL
                  FOREIGN KEY(TASKCONTROLLER_)
                  REFERENCES WFS.JBPM_TASKCONTROLLER(ID_),
              CONSTRAINT FK_VARACC_SCRIPT
                  FOREIGN KEY(SCRIPT_)
                  REFERENCES WFS.JBPM_ACTION(ID_),
              CONSTRAINT FK_JBPM_VARIABLEACCESS_VATYPE
                  FOREIGN KEY(VARIABLEACCESSTYPEID)
                  REFERENCES WFS.TTV_VARIABLEACCESSTYPE(VARIABLEACCESSTYPEID),
              CONSTRAINT FK_JBPM_VARIABLEACCESS_TYPE
                  FOREIGN KEY(DATATYPEID)
                  REFERENCES WFS.TTV_DATATYPE(DATATYPEID))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_VARIABLEACCESS'); 

  -- Creating Foreign Key on JBPM_VARIABLEINSTANCE
     vsql := 'ALTER TABLE WFS.JBPM_VARIABLEINSTANCE ADD ( 
              CONSTRAINT FK_VAR_TSKINST
                  FOREIGN KEY(TASKINSTANCE_)
                  REFERENCES WFS.JBPM_TASKINSTANCE(ID_),
              CONSTRAINT FK_VARINST_TKVARMP
                  FOREIGN KEY(TOKENVARIABLEMAP_)
                  REFERENCES WFS.JBPM_TOKENVARIABLEMAP(ID_),
              CONSTRAINT FK_BYTEINST_ARRAY
                  FOREIGN KEY(BYTEARRAYVALUE_)
                  REFERENCES WFS.JBPM_BYTEARRAY(ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_VARIABLEINSTANCE'); 
  
    -- Creating Foreign Key on TTV_MESSAGELOG
     vsql := 'ALTER TABLE WFS.TTV_MESSAGELOG ADD (
              CONSTRAINT TTV_MESSAGELOG#TTV_RESOURCE
                      FOREIGN KEY (RESOURCEID) 
                      REFERENCES WFS.TTV_RESOURCE (RESOURCEID),
              CONSTRAINT TTV_MESSAGELOG#JBPM_LOG
                      FOREIGN KEY (LOGID) 
                      REFERENCES WFS.JBPM_LOG (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_MESSAGELOG'); 

    -- Creating Foreign Key on TTV_MONITOREDDRIVE
     vsql := 'ALTER TABLE WFS.TTV_MONITOREDDRIVE ADD (
              CONSTRAINT TTV_MDRIVE#TTV_MDRIVESTATUS
                      FOREIGN KEY (CURRENTDRIVESTATUSID) 
                      REFERENCES WFS.TTV_MONITOREDDRIVESTATUS (MONITOREDDRIVESTATUSID),
              CONSTRAINT TTV_MDRIVE#TTV_RESOURCE 
                      FOREIGN KEY (RESOURCEID) 
                      REFERENCES WFS.TTV_RESOURCE (RESOURCEID))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_MONITOREDDRIVE'); 

    -- Creating Foreign Key on TTV_MONITOREDDRIVEHISTORY
     vsql := 'ALTER TABLE WFS.TTV_MONITOREDDRIVEHISTORY ADD (
              CONSTRAINT TTV_MDRIVEHIST#TTV_MDRIVE
                      FOREIGN KEY (MONITOREDDRIVEID) 
                      REFERENCES WFS.TTV_MONITOREDDRIVE (MONITOREDDRIVEID))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_MONITOREDDRIVEHISTORY'); 

  
    -- Creating Foreign Key on TTV_PROCDEFACCESSLEVEL
     vsql :=     'ALTER TABLE WFS.TTV_PROCDEFACCESSLEVEL ADD (
                  CONSTRAINT TTV_PROCDEFALEVEL#TTV_ALEVEL 
                          FOREIGN KEY (ACCESSLEVELID) 
                          REFERENCES WFS.TTV_ACCESSLEVEL (ACCESSLEVELID),
                  CONSTRAINT TTV_PDEFALEVEL#JBPM_PDEF
                          FOREIGN KEY (PROCESSDEFINITIONID) 
                          REFERENCES WFS.JBPM_PROCESSDEFINITION (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_PROCDEFACCESSLEVEL');
  
    -- Creating Foreign Key on TTV_PROCESSINSTANCENOTE
     vsql :=     'ALTER TABLE WFS.TTV_PROCESSINSTANCENOTE ADD (
                  CONSTRAINT TTV_PINSTANCENOTE#JBPM_PINST
                          FOREIGN KEY (PROCESSINSTANCEID) 
                          REFERENCES WFS.JBPM_PROCESSINSTANCE (ID_))';
  CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_PROCESSINSTANCENOTE');

    -- Creating Foreign Key on TTV_RESOURCE
     vsql :=   'ALTER TABLE WFS.TTV_RESOURCE ADD (
                CONSTRAINT TTV_RESOURCE#TTV_RTYPE 
                        FOREIGN KEY (RESOURCETYPEID) 
                        REFERENCES WFS.TTV_RESOURCETYPE (RESOURCETYPEID),
                CONSTRAINT TTV_RESOURCE#TTV_RSTATUS1 
                        FOREIGN KEY (OPERATIONALRESOURCESTATUSID) 
                        REFERENCES WFS.TTV_RESOURCESTATUS (RESOURCESTATUSID),
                CONSTRAINT TTV_RESOURCE#TTV_RSTATUS2
                        FOREIGN KEY (ADMINISTRATIVERESOURCESTATUSID) 
                        REFERENCES WFS.TTV_RESOURCESTATUS (RESOURCESTATUSID))';
  CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_RESOURCE'); 
  
    -- Creating Foreign Key on TTV_RESOURCEGROUP
     vsql :=   'ALTER TABLE WFS.TTV_RESOURCEGROUP ADD (
                CONSTRAINT TTV_RESOURCEGROUP#TTV_ALEVEL 
                        FOREIGN KEY (ACCESSLEVELID) 
                        REFERENCES WFS.TTV_ACCESSLEVEL (ACCESSLEVELID),
                CONSTRAINT TTV_RESOURCEGROUP#TTV_SGYCLASS
                        FOREIGN KEY (ALLOCATIONSTRATEGYCLASSID) 
                        REFERENCES WFS.TTV_STRATEGYCLASS (STRATEGYCLASSID),
                CONSTRAINT TTV_RESOURCEGROUP#TTV_RTYPE
                        FOREIGN KEY (RESOURCETYPEID) 
                        REFERENCES WFS.TTV_RESOURCETYPE (RESOURCETYPEID))';
  CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_RESOURCEGROUP'); 

    -- Creating Foreign Key on TTV_RESOURCEGROUPMEMBERSHIP
     vsql :=   'ALTER TABLE WFS.TTV_RESOURCEGROUPMEMBERSHIP ADD (
                CONSTRAINT TTV_RGRPMBRSHIP#TTV_RGROUP 
                        FOREIGN KEY (RESOURCEGROUPID) 
                        REFERENCES WFS.TTV_RESOURCEGROUP (RESOURCEGROUPID),
                CONSTRAINT TTV_RGRPMBRSHIP#TTV_RESOURCE 
                        FOREIGN KEY (RESOURCEID) 
                        REFERENCES WFS.TTV_RESOURCE (RESOURCEID))';
  CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_RESOURCEGROUPMEMBERSHIP'); 

    -- Creating Foreign Key on TTV_RESOURCEGROUPQUEUEITEM
     vsql :=  'ALTER TABLE WFS.TTV_RESOURCEGROUPQUEUEITEM ADD (
                  CONSTRAINT TTV_RGROUPQITEM#TTV_RGROUP 
                          FOREIGN KEY (RESOURCEGROUPID) 
                          REFERENCES WFS.TTV_RESOURCEGROUP (RESOURCEGROUPID),
                  CONSTRAINT TTV_RGROUPQUEUEITEM#JBPM_TOKEN 
                          FOREIGN KEY (TOKENID) 
                          REFERENCES WFS.JBPM_TOKEN (ID_))';
  CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_RESOURCEGROUPQUEUEITEM'); 

    -- Creating Foreign Key on TTV_RESOURCETYPE
     vsql :=     'ALTER TABLE WFS.TTV_RESOURCETYPE ADD (
                  CONSTRAINT TTV_RESOURCETYPE#TTV_SGYCLASS1 
                          FOREIGN KEY (INITIALIZATIONSTRATEGYCLASSID) 
                          REFERENCES WFS.TTV_STRATEGYCLASS (STRATEGYCLASSID),
                  CONSTRAINT TTV_RESOURCETYPE#TTV_SGYCLASS2
                          FOREIGN KEY (HEARTBEATSTRATEGYCLASSID) 
                          REFERENCES WFS.TTV_STRATEGYCLASS (STRATEGYCLASSID),
                  CONSTRAINT TTV_RESOURCETYPE#TTV_CTYPE1
                          FOREIGN KEY (HEARTBEATCONNECTIONTYPEID) 
                          REFERENCES WFS.TTV_CONNECTIONTYPE (CONNECTIONTYPEID),
                  CONSTRAINT TTV_RESOURCETYPE#TTV_CTYPE2 
                          FOREIGN KEY (RESOURCECONNECTIONTYPEID) 
                          REFERENCES WFS.TTV_CONNECTIONTYPE (CONNECTIONTYPEID))';
  CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_RESOURCETYPE'); 

    -- Creating Foreign Key on TTV_RESOURCEUSAGEHISTORY
     vsql :=   'ALTER TABLE WFS.TTV_RESOURCEUSAGEHISTORY ADD (
                CONSTRAINT TTV_RUSAGEHIST#TTV_RGROUP 
                        FOREIGN KEY (RESOURCEGROUPID) 
                        REFERENCES WFS.TTV_RESOURCEGROUP (RESOURCEGROUPID),
                CONSTRAINT TTV_RUSAGEHIST#TTV_RESOURCE
                        FOREIGN KEY (RESOURCEID) 
                        REFERENCES WFS.TTV_RESOURCE (RESOURCEID),
                CONSTRAINT TTV_RUSAGEHIST#JBPM_PINSTANCE 
                        FOREIGN KEY (PROCESSINSTANCEID) 
                        REFERENCES WFS.JBPM_PROCESSINSTANCE (ID_),
                CONSTRAINT TTV_RUSAGEHIST#JBPM_NODE
                        FOREIGN KEY (NODEID) 
                        REFERENCES WFS.JBPM_NODE (ID_))';
  CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_RESOURCEUSAGEHISTORY'); 

    -- Creating Foreign Key on TTV_STRATEGYCLASS
     vsql :=   'ALTER TABLE WFS.TTV_STRATEGYCLASS ADD (
                CONSTRAINT TTV_SGYCLASS#TTV_SGYCLASSTYPE 
                        FOREIGN KEY (STRATEGYCLASSTYPEID) 
                        REFERENCES WFS.TTV_STRATEGYCLASSTYPE (STRATEGYCLASSTYPEID))';
  CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_STRATEGYCLASS'); 

 -- Creating Foreign Key on TTV_TOKENRESOURCE
     vsql :=   'ALTER TABLE WFS.TTV_TOKENRESOURCE ADD (
                CONSTRAINT TTV_TOKENRESOURCE#TTV_RGROUP 
                        FOREIGN KEY (RESOURCEGROUPID) 
                        REFERENCES WFS.TTV_RESOURCEGROUP (RESOURCEGROUPID),
                CONSTRAINT TTV_TOKENRESOURCE#TTV_RESOURCE 
                        FOREIGN KEY (RESOURCEID) 
                        REFERENCES WFS.TTV_RESOURCE (RESOURCEID),
                CONSTRAINT TTV_TOKENRESOURCE#JBPM_TOKEN 
                        FOREIGN KEY (TOKENID) 
                        REFERENCES WFS.JBPM_TOKEN (ID_))';
  CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_TOKENRESOURCE'); 

   -- Creating Foreign Key on TTV_SELECTOR
     vsql :=     'ALTER TABLE WFS.TTV_SELECTOR
                              ADD ( CONSTRAINT TTV_SELECTOR#JBPM_PROCESSDEF
                              FOREIGN KEY(PROCESSDEFINITIONID)
                              REFERENCES WFS.JBPM_PROCESSDEFINITION("ID_")
                              ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE VALIDATE )';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for TTV_SELECTOR'); 
      
      -- Create Foreign Key on JBPM_TRANSITION
     vsql := 'ALTER TABLE WFS.JBPM_TRANSITION
               ADD ( CONSTRAINT FK_JBPM_TRANS_TTV_TRANSTYPE
               FOREIGN KEY(TRANSITIONTYPEID)
               REFERENCES WFS.TTV_TRANSITIONTYPE(TRANSITIONTYPEID)
               ON DELETE SET NULL NOT DEFERRABLE INITIALLY IMMEDIATE VALIDATE )';
    CREATEOBJECT(vsql,'Unable to create foreign Keys for JBPM_TRANSITION'); 
                               
  /*
  ----------------------------------------
     ADD TABLE AND COLUMN COMMNETS
  ----------------------------------------
  */
  
  -- Adding Comment on the JBPM_PROCESSDEFINITION table
     vsql := 'COMMENT ON TABLE WFS.JBPM_PROCESSDEFINITION IS ''Stores general information about the process definition. Foreign Keys Node table - Start-state node in the process''';
    CREATEOBJECT(vsql,'Unable to add comment on the JBPM_PROCESSDEFINITION table'); 

  -- Adding comment on the JBPM_NODE table
     vsql := 'COMMENT ON TABLE WFS.JBPM_NODE IS ''Stores definition information about a node in a process definition.
                Foreign Keys
                Process Definition table - The process definition that the node belongs to 
                Process Definition table - Specify that this node calls a sub process. The sub process would complete execution before the parent process leaves this node
                Action table - Specify an action class to be executed for the node
                Node table - Specify that this node belongs to a superstate. Multiple nodes can belong to a superstate
                Delegation table - Specify that a decision has been delegated to a class''';
    CREATEOBJECT(vsql,'Unable to add comment on the JBPM_NODE table'); 
  
  -- Adding comment on the JBPM_TRANSITION table
     vsql :='COMMENT ON TABLE WFS.JBPM_TRANSITION IS ''Stores definition information about a transition in a process definition. 
              Foreign Keys
              Process Definition table - Specify the definition that the transition belongs to
              Node table - Specify the node that starts the transition
              Node table - Specify the node that the transition ends on''';
    CREATEOBJECT(vsql,'Unable to add comment on the JBPM_TRANSITION table'); 
 
  -- Adding comment on the JBPM_ACTION table
     vsql :='COMMENT ON TABLE WFS.JBPM_ACTION IS ''Stores definition information about an action in a process definition.
              Foreign Keys 
              Process Definition table - Specify the definition that the action belongs to
              Event table - Specify the event that triggers the action
              Delegation table - Specify the action is delegated to
              ExceptionHandler? table - Specify the exception handler class for this action
              Action table - Specify the action is referenced by another action and
              Action table - Specify if there is a timer action''';
    CREATEOBJECT(vsql,'Unable to add comment on the JBPM_ACTION table'); 
   
  -- Adding comment on the JBPM_DELEGATION table
     vsql :='COMMENT ON TABLE WFS.JBPM_DELEGATION IS ''Stores definition information about Java business classes that are specified in the process definition. 
              Foreign key
              Process Definition table - Specify the process definition that the delegation belongs to.''';
    CREATEOBJECT(vsql,'Unable to add comment on the JBPM_DELEGATION table'); 
 
  -- Adding comment on the JBPM_EVENT table
     vsql :='COMMENT ON TABLE WFS.JBPM_EVENT IS ''Stores definition information about an event that triggers an action in the process definition. 
              Foreign Keys Process Definition table - Specify the process definition that the event belongs to
              Node table - Specify the event belongs to a node
              Transition table - Specify the event belongs to a transition
              Task table - Specify the event belongs to a task''';
    CREATEOBJECT(vsql,'Unable to add comment on the JBPM_EVENT table'); 

  -- Adding comment on the JBPM_EXCEPTIONHANDLER table
     vsql :='COMMENT ON TABLE WFS.JBPM_EXCEPTIONHANDLER IS ''Stores definition information about an exception handler for an action.''';
    CREATEOBJECT(vsql,'Unable to add comment on the JBPM_EXEPTIONHANDLER table'); 

  -- Adding comment on the JBPM_DECISIONCONDITIONS table
     vsql :='COMMENT ON TABLE WFS.JBPM_DECISIONCONDITIONS IS ''Stores definition information about conditions specified in the process definition.''';
    CREATEOBJECT(vsql,'Unable to add comment on the JBPM_DECISIONCONDITIONS table'); 
  
  -- Adding comment on the JBPM_TASK table
     vsql :='COMMENT ON TABLE WFS.JBPM_TASK IS ''Stores definition information about tasks defined in the process definition. 
            Foreign Keys
            Process Definition table - Specify the process definition the task belongs to
            Module Definition table - Specify the TaskMgmtDefintion to be used for this task.
            Node table - Specify the node the task belongs to 
            Node table - Specify that this task belongs to the start-state of a process
            Delegation table - Specify the delegation of the task to a class
            Swimlane table - Specify the swimlane that the task uses for assignment
            Task Controller table - Specify the task assignment is delegated to a class''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_TASK table'); 
  
  -- Adding comment on the JBPM_TASKCONTROLLER table
     vsql :='COMMENT ON TABLE WFS.JBPM_TASKCONTROLLER IS ''Stores information that refers a task to a delegation class. 
              Foreign key
              Delegation table - Specify the class that is the controller for the task.''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_TASKCONTROLLER table'); 

  -- Adding comment on the JBPM_VARIABLEACCESS table
     vsql :='COMMENT ON TABLE WFS.JBPM_VARIABLEACCESS IS ''Stores information about the access levels for each variable associated to a particular node or task
            Foreign keys
            Node table - Specify the node that the variables belong to
            Task Controller table - Specify the task that the variables belong to
            Action table - Specify the action that the variables belong to''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_VARIABLEACCESS table'); 

  -- Adding comment on the JBPM_SWIMLANE table
     vsql :='COMMENT ON TABLE WFS.JBPM_SWIMLANE IS ''Stores information about the swimlanes defined in the process definition.
              Foreign Keys
              Delegation table - Specify the class that determines assignment for this swimlane
              Module Definition table - All of the swimlanes for a process definition belong to a TaskMgmtDefintion. This is specified in the Module Definition table.''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_SWIMLANE table'); 

  -- Adding comment on the JBPM_MODULEDEFINITION table
     vsql :='COMMENT ON TABLE WFS.JBPM_MODULEDEFINITION IS ''Stores information about modules used in the process definition
              Foreign Keys
              Process Definition table - Specify the process definition this module is used in
              Task table - Specify the task this module is used in''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_MODULEDEFINITION table'); 
  
  -- Adding comment on the JBPM_ID_USER table
     vsql :='COMMENT ON TABLE WFS.JBPM_ID_USER IS ''Stores information about users in jBPM''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_ID_USER table'); 
  
  -- Adding comment on the JBPM_ID_GROUP table
     vsql :='COMMENT ON TABLE WFS.JBPM_ID_GROUP IS ''Stores information about groups that users can belong to.
            Foreign Key
            ID Group - Parent/Child relationship between groups.''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_ID_GROUP table'); 
  
  -- Adding comment on the JBPM_ID_MEMBERSHIP
    vsql :='COMMENT ON TABLE WFS.JBPM_ID_MEMBERSHIP IS ''Cross reference table storing information about role and which groups a user belongs to.
        Foreign Keys
        ID Users table - Specify the user that belongs to the membership.
        ID Group table - Specify the group the membership belongs to.''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_ID_MEMBERSHIP table'); 
 
  -- Adding comment on the JBPM_ID_PERMISSIONS
    vsql :='COMMENT ON TABLE WFS.JBPM_ID_PERMISSIONS IS ''Defines permissions for a user''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_ID_PERMISSIONS table'); 
  
  -- Adding comment on the JBPM_PROCESSINSTANCE
    vsql :='COMMENT ON TABLE WFS.JBPM_PROCESSINSTANCE IS ''Stores runtime information about an instance of a process. 
              Foreign keys
              Process Definition table - the process definition to be followed for this process instance execution 
              Token table - the root token that follows where the process execution is currently
              Token table - the super process token (if this process instance was called from another process instance)''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_PROCESSINSTANCE table'); 

  -- Adding comment on the JBPM_TOKEN table
    vsql :='COMMENT ON TABLE WFS.JBPM_TOKEN IS ''Stores information about the token representing execution location in the process instance
            Foreign keys
            Process Instance table - the process instance this token belongs to.
            Process Instance table - the sub process instance that the token belongs to.
            Node table - the node that the token points to as the current location of execution.
            Token table - parent/child relationship between tokens for a fork or sub process.''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_TOKEN table'); 
  
  -- Adding comment on the JBPM_MESSAGE table
    vsql :='COMMENT ON TABLE WFS.JBPM_MESSAGE IS ''Stores messages to create asynchronous processing of nodes.
            Foreign keys
            Token table - token the message belongs to
            Action table - action the message belongs to
            Node table - node the message belongs to
            Task Instance table - task instance the message belongs to''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_MESSAGE table'); 
  
  -- Adding comment on JBPM_TASKINSTANCE
    vsql :='COMMENT ON TABLE WFS.JBPM_TASKINSTANCE IS ''Stores runtime information about an instance of a task
              Foreign keys
              Task table - the task that defines the instance
              Token table - the token the task belongs to
              Swimlane Instance table - the swimlane instance used to determine who works this task instance
              Module Instance table - the instance of the module to manage the task''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_TASKINSTANCE table'); 

  -- Adding comment on JBPM_SWIMLANEINSTANCE 
    vsql :='COMMENT ON TABLE WFS.JBPM_SWIMLANEINSTANCE IS ''Stores runtime information about an instance of a swimlane
            Foreign keys
            Swimlane table - the swimlane that defines the instance
            Module Instance table - the instance of the module to manage the task''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_SWIMLANEINSTANCE table'); 

  -- Adding comment JBPM_POOLEDACTOR table
    vsql :='COMMENT ON TABLE WFS.JBPM_POOLEDACTOR IS ''Stores a list of actors for a swimlane instance
            Foreign Key 
            Swimlane Instance table - the swimlane instance the actor belongs to''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_POOLEDACTOR table'); 
  
  -- Adding comment JBPM_TASKACTORPOOL table 
    vsql :='COMMENT ON TABLE WFS.JBPM_TASKACTORPOOL IS ''Cross reference table between Pooled Actor and Task Instance
              Foreign Keys
              Pooled Actor - Actors for a swimlane instance
              Task Instance - Task the pooled actor belongs to''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_TASKACTORPOOL table'); 

  -- Adding comment JBPM_COMMENT table 
    vsql :='COMMENT ON TABLE WFS.JBPM_COMMENT IS ''tores a comment message related to a token or task instance
              Foreign Keys
              Token table - the token the comment belongs to.
              Task Instance table - the task instance the comment belongs to.''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_COMMENT table'); 

  -- Adding comment to JBPM_TOKENVARIABLEMAP table
    vsql :='COMMENT ON TABLE WFS.JBPM_TOKENVARIABLEMAP IS ''Cross reference table between token and module instances for context
            Foreign Keys
            Token table - the token representing the process execution
            Module Instance table - the context module instance for the token''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_TOKENVARIABLEMAP table');

  -- Adding comment to JBPM_MODULEINSTANCE table
  
    vsql :='COMMENT ON TABLE WFS.JBPM_MODULEINSTANCE IS ''Stores runtime information about an instance of a module
            Foreign Keys
            Process Instance table - the process instance the module instance belongs to
            Module Definition table - the module definition that defines the module instance''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_MODULEINSTANCE table');

  -- Adding comment on JBPM_RUNTIMEACTION table
    vsql :='COMMENT ON TABLE WFS.JBPM_RUNTIMEACTION IS ''Stores information about actions that are created at runtime
              Foreign Keys
              Process Instance table - the process instance the action belongs to
              Action table - the action definition that defines the action instance''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_RUNTIMEACTION table');
 
  -- Adding comment on JBPM_TIME table
    vsql :='COMMENT ON TABLE WFS.JBPM_TIMER IS ''Stores information about instances of timers that are running
            Foreign Keys
            Action table - The action that the timer belongs to
            Token table - the token that the timer belongs to
            Process Instance table - the process instance the timer belongs to
            Task Instance table - the task instance the timer belongs to''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_TIMER table');
  
  -- Adding comment on JBPM_VARIABLEINSTANCE
    vsql :='COMMENT ON TABLE WFS.JBPM_VARIABLEINSTANCE IS ''Stores information about process variable instances
            Foreign Keys
            Token table - the token that the variables belong to
            Token Variable Map table - mapping to the module instance for the token
            Process Instance table - the process instance the variables belong to
            Byte Array table - the byte array stored for a serialized object process variable instance
            Task Instance table - the task instance the variables belong to''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_VARIABLEINSTANCE table');

  -- Adding comment on JBPM_LOG table
    vsql :='COMMENT ON TABLE WFS.JBPM_LOG IS ''Stores process logs created by jBPM or application code during process execution
              Foreign Keys
              Token table - the token that the logs belong to
              Token table - the child token that the logs belong to
              Log table - parent/child relationship between logs
              Transition table - the transition the logs belong to
              Node table - the source node the logs belong to
              Node table - the destination node the logs belong to
              Variable Instance table - the variable instance that is referred to in the log
              Byte Array table - the old value of the byte array
              Byte Array table - the new value of the byte array
              Task Instance table - The task instance that is referred to in the log
              Swim Lane Instance table - the swimlane instance that is referred to in the log''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_LOG table');
  
  -- Adding comment on JBPM_BYTEARRAY table
    vsql :='COMMENT ON TABLE WFS.JBPM_BYTEARRAY IS ''Specifies the file definition module for a serialized process instance variable
            Foreign Key
            Module Definition table - Specify the file definition module''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_BYTEARRAY table');

  -- Adding comment on JBPM_BYTEBLOCK table 
    vsql :='COMMENT ON TABLE WFS.JBPM_BYTEBLOCK IS ''Stores the serialized process instance variable
            Foreign Key
            Byte Array table - The byte array that the byte block belongs to''';
     CREATEOBJECT(vsql,'Unable to add comment on the JBPM_BYTEBLOCK table');
  
  -- Adding comment on the ALERTS table
     vsql :='COMMENT ON TABLE WFS.ALERTS IS ''List of alerts defined in the system''';
     CREATEOBJECT(vsql,'Unable to add comment on the ALERTS table');

  -- Adding comment on ALERTS_HIST table
     vsql :='COMMENT ON TABLE WFS.ALERTS_HIST IS ''Stores history for all the alerts occurred''';
     CREATEOBJECT(vsql,'Unable to add comment on the ALERTS_HIST table');

  -- Adding comment on ALERT_ACTIONS table
     vsql :='COMMENT ON TABLE WFS.ALERT_ACTIONS IS ''Stores action information for alerts defined. Current actions supported are email and snmp traps''';
     CREATEOBJECT(vsql,'Unable to add comment on the ALERT_ACTIONS table');

  -- Adding comment on ALERT_ACTIONS_HIST table
     vsql :='COMMENT ON TABLE WFS.ALERT_ACTIONS_HIST IS ''history for all the alert action taken''';
     CREATEOBJECT(vsql,'Unable to add comment on the ALERT_ACTIONS_HIST table');
  
  -- Adding comment on ALERT_NAMES table
     vsql :='COMMENT ON TABLE WFS.ALERT_NAMES IS ''Stores alert patterns''';
     CREATEOBJECT(vsql,'Unable to add comment on the ALERT_NAMES table');

  -- Adding comment on TTV_ACCESSLEVEL table
     vsql :='COMMENT ON TABLE WFS.TTV_ACCESSLEVEL IS ''Contains all the protection keys''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_ACCESSLEVEL table');
 
  -- Adding comment on TTV_CONNECTIONTYPE table
     vsql :='COMMENT ON TABLE WFS.TTV_CONNECTIONTYPE IS ''The different types of Connection String values supported by Resource Manager. Resource Type declares the Connection Type and it expects for Resource Connection String values and Resource Heartbeat Connection String values''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_CONNECTIONTYPE table');
 
  -- Adding comment on TTV_DATATYPE table
     vsql :='COMMENT ON TABLE WFS.TTV_DATATYPE IS ''Contains list of data type supported for variables defined in the template''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_DATATYPE table');
  
  -- Adding comment on TTV_MESSAGELOG table
     vsql :='COMMENT ON TABLE WFS.TTV_MESSAGELOG IS ''Stores messages for each node''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_MESSAGELOG table');

  -- Adding comment on TTV_MONITOREDDRIVE table
     vsql :='COMMENT ON TABLE WFS.TTV_MONITOREDDRIVE IS ''configuration information for san drives to be monitored''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_MONITOREDDRIVE table');
  
  -- Adding comment on TTV_MONITOREDDRIVEHISTORY table
     vsql :='COMMENT ON TABLE WFS.TTV_MONITOREDDRIVEHISTORY  IS ''Stores history for each of the drives configured in TTV_MONITORDRIVE''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_MONITOREDDRIVEHISTORY table');
  
  -- Adding comment on TTV_MONITOREDDRIVESTATUS table
     vsql :='COMMENT ON TABLE WFS.TTV_MONITOREDDRIVESTATUS IS ''Contains all possible status a drive can be in''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_MONITOREDDRIVESTATUS table');

  -- Adding comment on TTV_PROCDEFACCESSLEVEL table
      vsql := 'COMMENT ON TABLE WFS.TTV_PROCDEFACCESSLEVEL IS ''Mapping information between process definitions and access levels (protection keys)''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_PROCDEFACCESSLEVEL table');
  
  -- Adding comment on TTV_PROCESSDEFINITIONTYPE table
      vsql := 'COMMENT ON TABLE WFS.TTV_PROCESSDEFINITIONTYPE IS ''Required as a result of sub-classing JBPM_PROCESSDEFINITION entity''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_PROCESSDEFINITIONTYPE table');

  -- Adding comment on TTV_PROCESSINSTANCENOTE table
      vsql :='COMMENT ON TABLE WFS.TTV_PROCESSINSTANCENOTE IS ''Table to store notes attached to work orders while specifying reason for cancel, pause, e.t.c''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_PROCESSINSTANCENOTE table');
  
  -- Adding comment on TTV_PROCESSINSTANCETYPE table
      vsql :='COMMENT ON TABLE WFS.TTV_PROCESSINSTANCETYPE IS ''Required as a result of sub-classing JBPM_PROCESSINSTANCE entity''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_PROCESSINSTANCETYPE table');
  
  -- Adding comment on TTV_PROCESSPRIORITY table
      vsql :='COMMENT ON TABLE WFS.TTV_PROCESSPRIORITY IS ''Table contains the list of all possible Process Priorities available to the Workflow System.The process priority Ids assigned must be sorted from lowest priority to highest priority''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_PROCESSPRIORITY table');
  
  -- Adding comment on TTV_PROCESSSTATUS table ALERTS
      vsql :='COMMENT ON TABLE WFS.TTV_PROCESSSTATUS IS ''The different Work Order / Process Status values allowed for the Operational and Administrative Status of a Process''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_PROCESSSTATUS table');
  
  -- Adding comment on TTV_RESOURCE table
      vsql :='COMMENT ON TABLE WFS.TTV_RESOURCE IS ''The Resources used by the Workflow System''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_RESOURCE table');
  
  -- Adding comment on TTV_RESOURCEGROUP table
      vsql :='COMMENT ON TABLE WFS.TTV_RESOURCEGROUP IS ''The Resource Groups used by the Workflow System''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_RESOURCEGROUP table');
  
  -- Adding comment on TTV_RESOURCEGROUPMEMBERSHIP table
      vsql :='COMMENT ON TABLE WFS.TTV_RESOURCEGROUPMEMBERSHIP IS ''Table contains the many-to-many relationship between Resource Groups and Resources. The data shows the membership of each resource in a set of resource groups''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_RESOURCEGROUPMEMBERSHIP table');

  -- Adding comment to TTV_RESOURCEGROUPQUEITEM table
      vsql :='COMMENT ON TABLE WFS.TTV_RESOURCEGROUPQUEUEITEM IS ''Each Resource Group manages an ordered queue of Tokens. This table stores each of the queue items (with their order in the queue) for each resource group''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_RESOURCEGROUPQUEITEM table');
  
  -- Adding comment to TTV_RESOURCESTATUS table
      vsql :='COMMENT ON TABLE WFS.TTV_RESOURCESTATUS IS ''The different possible value for the Operational or Administrative Status of a Resource in the system''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_RESOURCESTATUS table');
  
  -- Adding comment to TTV_RESOURCETYPE table
      vsql :='COMMENT ON TABLE WFS.TTV_RESOURCETYPE IS ''The different Resource Types supported by the system''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_RESOURCETYPE table');
  
  -- Adding comment to TTV_RESOURCEUSAGEHISTORY table
      vsql :='COMMENT ON TABLE WFS.TTV_RESOURCEUSAGEHISTORY IS ''NOT USED - THIS TABLE IS NOT USED ANYMORE''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_RESOURCEUSAGEHISTORY table');
  
  -- Adding comment to TTV_STRATEGYCLASS table
      vsql :='COMMENT ON TABLE WFS.TTV_STRATEGYCLASS IS ''The Strategy class implementations used by the Resource Manager in different scenarios (heartbeat, initialization, allocation). Each Strategy class is also aware of its Strategy Class Type''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_STRATEGYCLASS table');

  -- Adding comment to TTV_STRATEGYCLASSTYPE table
      vsql :='COMMENT ON TABLE WFS.TTV_STRATEGYCLASSTYPE IS ''The different types of strategies that Resource Manager supports''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_STRATEGYCLASSTYPE table');
  
  -- Adding comment to TTV_TOKENRESOURCE table
      vsql :='COMMENT ON TABLE WFS.TTV_TOKENRESOURCE IS ''Maintains the relationship between tokens and the resource they use''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_TOKENRESOURCE table');

  -- Adding comment to TTV_TOKENTYPE table
      vsql :='COMMENT ON TABLE WFS.TTV_TOKENTYPE IS ''Required as a result of sub-classing JBPM_TOKEN entity''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_TOKENTYPE table');

  -- Adding comment to TTV_VARIABLEACCESSTYPE table ALERTS
      vsql :='COMMENT ON TABLE WFS.TTV_VARIABLEACCESSTYPE IS ''Required as a result of sub-classing JBPM_VARIABLEACCESS entity''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_VARIABLEACCESSYTPE table');
  
  -- Adding comment to UI_PROPERTIES table
      vsql :='COMMENT ON TABLE WFS.UI_PROPERTIES IS ''UNUSED TABLE''';
     CREATEOBJECT(vsql,'Unable to add comment on the UI_PROPERTIES table');

      -- Adding comment to TTV_TRANSITIONTYPE
      vsql :='COMMENT ON TABLE WFS.TTV_TRANSITIONTYPE IS ''Required as a result of sub-classing JBPM_TRANSITION entity''';
     CREATEOBJECT(vsql,'Unable to add comment on the TTV_TRANSITIONTYPE table');
  
  /*
  ----------------------------------------
    Creating indexes on FK of JBPM_LOG table
  ----------------------------------------
  */
  
   --Create indexes on all Foreign keys of JBPM_LOG to prevent it getting locked exclusively when deleting rows from JBPM_VARIABLEINSTANCE table
    declare
      cursor c1 is select 'CREATE INDEX '||vschema||'.IDX_JPLOG_'||substr(ucc.column_name,1,12)||'_'||ucc.position||' on '||vschema||'.JBPM_LOG('||ucc.column_name||')' as crindex
                        from dba_constraints uc, dba_cons_columns ucc , dba_constraints uc1
                        where uc.constraint_name = ucc.constraint_name
                        and uc.table_name = ucc.table_name
                        and uc.owner=ucc.owner
                        and uc.owner = upper(vschema)
                        and uc.constraint_type='R'
                        and uc.table_name = 'JBPM_LOG'
                        and uc.r_constraint_name = uc1.constraint_name
                        and uc.owner = uc1.owner;
    begin
      for r1 in c1 loop
          CREATEOBJECT(r1.crindex,'Unable to create index on JBPM_LOG table''Y');
      end loop;
    end;

  /*
  ----------------------------------------
     CREATING ALL PUBLIC SYNONYMS
  ----------------------------------------
  */
  
  /*
  ---------------------------------------------------
     GRANTING privileges to wfs_user_role
  ---------------------------------------------------
  */
  
          <<bypass_install>>
  
          COMMIT;
          
          IF wk_message = 'ERROR' THEN
          
          	--null;
            RAISE createWFSDB.INSTALL_FAILED;
             
          ELSE
          
             EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''Installation completed of WFS base objects SUCCESSFULLY'')';
             
          END IF;
          
    END CreateWFS;

	/***********************************************************************************************
	    ----------------------------------------CREATE QRTZ---------------------------------------------
	   *************************************************************************************************/
		PROCEDURE CreateQRTZ IS 
	        wk_message	varchar2(500);
	        wk_count		number;
	        err_msg		varchar2(500);
          vsql      varchar2(32000);
		BEGIN
			/*------------------------------------------------------------------
									CREATE QRTZ TABLES
			------------------------------------------------------------------*/
			-- CREATE TABLE WFS.qrtz_job_details
			vsql := 'CREATE TABLE WFS.qrtz_job_details
										  (
										    JOB_NAME  VARCHAR2(80) NOT NULL,
										    JOB_GROUP VARCHAR2(80) NOT NULL,
										    DESCRIPTION VARCHAR2(120) NULL,
										    JOB_CLASS_NAME   VARCHAR2(128) NOT NULL, 
										    IS_DURABLE VARCHAR2(1) NOT NULL,
										    IS_VOLATILE VARCHAR2(1) NOT NULL,
										    IS_STATEFUL VARCHAR2(1) NOT NULL,
										    REQUESTS_RECOVERY VARCHAR2(1) NOT NULL,
										    JOB_DATA BLOB NULL,
										    PRIMARY KEY (JOB_NAME,JOB_GROUP)
										)';
			CREATEOBJECT(vsql,'Unable to create table qrtz_job_details.');
			
			-- CREATE TABLE WFS.qrtz_job_listeners
      vsql := 'CREATE TABLE WFS.qrtz_job_listeners
										  (
										    JOB_NAME  VARCHAR2(80) NOT NULL, 
										    JOB_GROUP VARCHAR2(80) NOT NULL,
										    JOB_LISTENER VARCHAR2(80) NOT NULL,
										    PRIMARY KEY (JOB_NAME,JOB_GROUP,JOB_LISTENER) ,
										    FOREIGN KEY (JOB_NAME,JOB_GROUP) 
											REFERENCES WFS.QRTZ_JOB_DETAILS(JOB_NAME,JOB_GROUP)
										)';
      CREATEOBJECT(vsql,'Unable to create table qrtz_job_listeners.');
			
			-- CREATE TABLE WFS.qrtz_triggers
      vsql := 'CREATE TABLE WFS.qrtz_triggers
										  (
										    TRIGGER_NAME VARCHAR2(80) NOT NULL,
										    TRIGGER_GROUP VARCHAR2(80) NOT NULL,
										    JOB_NAME  VARCHAR2(80) NOT NULL, 
										    JOB_GROUP VARCHAR2(80) NOT NULL,
										    IS_VOLATILE VARCHAR2(1) NOT NULL,
										    DESCRIPTION VARCHAR2(120) NULL,
										    NEXT_FIRE_TIME NUMBER(13) NULL,
										    PREV_FIRE_TIME NUMBER(13) NULL,
										    PRIORITY NUMBER(13) NULL,
										    TRIGGER_STATE VARCHAR2(16) NOT NULL,
										    TRIGGER_TYPE VARCHAR2(8) NOT NULL,
										    START_TIME NUMBER(13) NOT NULL,
										    END_TIME NUMBER(13) NULL,
										    CALENDAR_NAME VARCHAR2(80) NULL,
										    MISFIRE_INSTR NUMBER(2) NULL,
										    JOB_DATA BLOB NULL,
										    PRIMARY KEY (TRIGGER_NAME,TRIGGER_GROUP) ,
										    FOREIGN KEY (JOB_NAME,JOB_GROUP) 
											REFERENCES WFS.QRTZ_JOB_DETAILS(JOB_NAME,JOB_GROUP) 
										)';
      CREATEOBJECT(vsql,'Unable to create table qrtz_triggers.');

			-- CREATE TABLE WFS.qrtz_simple_triggers
      vsql := 'CREATE TABLE WFS.qrtz_simple_triggers
										  (
										    TRIGGER_NAME VARCHAR2(80) NOT NULL,
										    TRIGGER_GROUP VARCHAR2(80) NOT NULL,
										    REPEAT_COUNT NUMBER(7) NOT NULL,
										    REPEAT_INTERVAL NUMBER(12) NOT NULL,
										    TIMES_TRIGGERED NUMBER(7) NOT NULL,
										    PRIMARY KEY (TRIGGER_NAME,TRIGGER_GROUP) ,
										    FOREIGN KEY (TRIGGER_NAME,TRIGGER_GROUP) 
											REFERENCES WFS.QRTZ_TRIGGERS(TRIGGER_NAME,TRIGGER_GROUP)
										)';
      CREATEOBJECT(vsql,'Unable to create table qrtz_simple_triggers.');
	
			-- CREATE TABLE WFS.qrtz_cron_triggers
      vsql := 'CREATE TABLE WFS.qrtz_cron_triggers
										  (TRIGGER_NAME VARCHAR2(80) NOT NULL,
										    TRIGGER_GROUP VARCHAR2(80) NOT NULL,
										    CRON_EXPRESSION VARCHAR2(80) NOT NULL,
										    TIME_ZONE_ID VARCHAR2(80),
										    PRIMARY KEY (TRIGGER_NAME,TRIGGER_GROUP) ,
										    FOREIGN KEY (TRIGGER_NAME,TRIGGER_GROUP) 
											REFERENCES WFS.QRTZ_TRIGGERS(TRIGGER_NAME,TRIGGER_GROUP)
										)';
      CREATEOBJECT(vsql,'Unable to create table qrtz_cron_triggers.');
			
			-- CREATE TABLE WFS.qrtz_blob_triggers
			vsql := 'CREATE TABLE WFS.qrtz_blob_triggers
										  (TRIGGER_NAME VARCHAR2(80) NOT NULL,
										    TRIGGER_GROUP VARCHAR2(80) NOT NULL,
										    BLOB_DATA BLOB NULL,
										    PRIMARY KEY (TRIGGER_NAME,TRIGGER_GROUP) ,
										    FOREIGN KEY (TRIGGER_NAME,TRIGGER_GROUP) 
										        REFERENCES WFS.QRTZ_TRIGGERS(TRIGGER_NAME,TRIGGER_GROUP)
										)';
      CREATEOBJECT(vsql,'Unable to create table qrtz_blob_triggers.');
	
			-- CREATE TABLE WFS.qrtz_trigger_listeners
			vsql :=  'CREATE TABLE WFS.qrtz_trigger_listeners
										  (
										    TRIGGER_NAME  VARCHAR2(80) NOT NULL, 
										    TRIGGER_GROUP VARCHAR2(80) NOT NULL,
										    TRIGGER_LISTENER VARCHAR2(80) NOT NULL,
										    PRIMARY KEY (TRIGGER_NAME,TRIGGER_GROUP,TRIGGER_LISTENER) ,
										    FOREIGN KEY (TRIGGER_NAME,TRIGGER_GROUP) 
											REFERENCES WFS.QRTZ_TRIGGERS(TRIGGER_NAME,TRIGGER_GROUP)
										)';
			CREATEOBJECT(vsql,'Unable to create table qrtz_trigger_listeners.');
	
			-- CREATE TABLE WFS.qrtz_calendars
			vsql := 'CREATE TABLE WFS.qrtz_calendars
										  (CALENDAR_NAME  VARCHAR2(80) NOT NULL, 
										    CALENDAR BLOB NOT NULL,
										    PRIMARY KEY (CALENDAR_NAME) 
										)';
			CREATEOBJECT(vsql,'Unable to create table qrtz_calendars.');
	
			-- CREATE TABLE WFS.qrtz_paused_trigger_grps
			vsql := 'CREATE TABLE WFS.qrtz_paused_trigger_grps
										  (TRIGGER_GROUP  VARCHAR2(80) NOT NULL, 
										    PRIMARY KEY (TRIGGER_GROUP) 
										)';
			CREATEOBJECT(vsql,'Unable to create table qrtz_paused_trigger_grps.');
	
			-- CREATE TABLE WFS.qrtz_fired_triggers
			vsql := 'CREATE TABLE WFS.qrtz_fired_triggers 
										  (ENTRY_ID VARCHAR2(95) NOT NULL,
										    TRIGGER_NAME VARCHAR2(80) NOT NULL,
										    TRIGGER_GROUP VARCHAR2(80) NOT NULL,
										    IS_VOLATILE VARCHAR2(1) NOT NULL,
										    INSTANCE_NAME VARCHAR2(80) NOT NULL,
										    FIRED_TIME NUMBER(13) NOT NULL,
										    PRIORITY NUMBER(13) NOT NULL,
										    STATE VARCHAR2(16) NOT NULL,
										    JOB_NAME VARCHAR2(80) NULL,
										    JOB_GROUP VARCHAR2(80) NULL,
										    IS_STATEFUL VARCHAR2(1) NULL,
										    REQUESTS_RECOVERY VARCHAR2(1) NULL,
										    PRIMARY KEY (ENTRY_ID) 
										)';
			CREATEOBJECT(vsql,'Unable to create table qrtz_fired_triggers.');
	
			-- CREATE TABLE WFS.qrtz_scheduler_state
			vsql := 'CREATE TABLE WFS.qrtz_scheduler_state 
										  (INSTANCE_NAME VARCHAR2(80) NOT NULL,
										    LAST_CHECKIN_TIME NUMBER(13) NOT NULL,
										    CHECKIN_INTERVAL NUMBER(13) NOT NULL,
										    PRIMARY KEY (INSTANCE_NAME) 
										)';
      CREATEOBJECT(vsql,'Unable to create table qrtz_scheduler_state.');
	
			-- CREATE TABLE WFS.qrtz_locks
			vsql := 'CREATE TABLE WFS.qrtz_locks
										  (LOCK_NAME  VARCHAR2(40) NOT NULL, 
										    PRIMARY KEY (LOCK_NAME) 
										)';
			CREATEOBJECT(vsql,'Unable to create table qrtz_locks.');
	
			/*------------------------------------------------------------------
									INSERT QRTZ Default Table Values
			------------------------------------------------------------------*/
			
			-- INSERTS FOR qrtz_locks
			BEGIN
				EXECUTE IMMEDIATE 'INSERT INTO WFS.qrtz_locks values(''TRIGGER_ACCESS'')';
				EXECUTE IMMEDIATE 'INSERT INTO WFS.qrtz_locks values(''JOB_ACCESS'')';
				EXECUTE IMMEDIATE 'INSERT INTO WFS.qrtz_locks values(''CALENDAR_ACCESS'')';
				EXECUTE IMMEDIATE 'INSERT INTO WFS.qrtz_locks values(''STATE_ACCESS'')';
				EXECUTE IMMEDIATE 'INSERT INTO WFS.qrtz_locks values(''MISFIRE_ACCESS'')';
			EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
					err_msg :=SUBSTR(SQLERRM, 1, 500);
					EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''error in installing of application database objects:'||
	            	 					'Unable to insert into qrtz_locks.'')';
	            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
	        GOTO bypass_install;
			
			END;
	
			/*------------------------------------------------------------------
									CREATE INDEXES FOR QRTZ
			------------------------------------------------------------------*/
	
			-- CREATEING INDEXES FOR QRTZ
			BEGIN
				EXECUTE IMMEDIATE 'create index idx_qrtz_j_req_recovery on WFS.qrtz_job_details(REQUESTS_RECOVERY)';
				EXECUTE IMMEDIATE 'create index idx_qrtz_t_next_fire_time ON WFS.qrtz_triggers(NEXT_FIRE_TIME)';
				EXECUTE IMMEDIATE 'create index idx_qrtz_t_state ON WFS.qrtz_triggers(TRIGGER_STATE)';
				EXECUTE IMMEDIATE 'create index idx_qrtz_t_nft_st ON WFS.qrtz_triggers(NEXT_FIRE_TIME,TRIGGER_STATE)';
				EXECUTE IMMEDIATE 'create index idx_qrtz_t_volatile ON WFS.qrtz_triggers(IS_VOLATILE)';
				EXECUTE IMMEDIATE 'create index idx_qrtz_ft_trig_name ON WFS.qrtz_fired_triggers(TRIGGER_NAME)';
				EXECUTE IMMEDIATE 'create index idx_qrtz_ft_trig_group ON WFS.qrtz_fired_triggers(TRIGGER_GROUP)';
				EXECUTE IMMEDIATE 'create index idx_qrtz_ft_trig_nm_gp ON WFS.qrtz_fired_triggers(TRIGGER_NAME,TRIGGER_GROUP)';
				EXECUTE IMMEDIATE 'create index idx_qrtz_ft_trig_volatile ON WFS.qrtz_fired_triggers(IS_VOLATILE)';
				EXECUTE IMMEDIATE 'create index idx_qrtz_ft_trig_inst_name ON WFS.qrtz_fired_triggers(INSTANCE_NAME)';
				EXECUTE IMMEDIATE 'create index idx_qrtz_ft_job_name ON WFS.qrtz_fired_triggers(JOB_NAME)';
				EXECUTE IMMEDIATE 'create index idx_qrtz_ft_job_group ON WFS.qrtz_fired_triggers(JOB_GROUP)';
				EXECUTE IMMEDIATE 'create index idx_qrtz_ft_job_stateful ON WFS.qrtz_fired_triggers(IS_STATEFUL)';
				EXECUTE IMMEDIATE 'create index idx_qrtz_ft_job_req_recovery ON WFS.qrtz_fired_triggers(REQUESTS_RECOVERY)';
			EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
					err_msg :=SUBSTR(SQLERRM, 1, 500);
					EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''error in installing of application database objects:'||
	            	 					'Unable to create qrtz indexes.'')';
	            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
	        GOTO bypass_install;
			
			END;
			
			 <<bypass_install>>
	  
	          COMMIT;
	          
	          IF wk_message = 'ERROR' THEN
	          
	          	--null;
	            RAISE createWFSDB.INSTALL_FAILED;
	             
	          ELSE
	          
	             EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
	           (''Installation of QRTZ COMPLETED SUCCESSFULLY'')';
	             
	          END IF;
			
		END CreateQRTZ;
   
   /***********************************************************************************************
    ----------------------------------------CREATE PMM---------------------------------------------
   *************************************************************************************************/
   --PROCEDURE CreatePMM(error out NUMBER(1,0)) IS 
   PROCEDURE CreatePMM IS 
        wk_message	varchar2(500);
        wk_count		number;
        err_msg		varchar2(500);
        vsql varchar2(32000);
	BEGIN
	
		wk_message := '';
		--DELETE FROM SYS.INSTALL_TABLE;
				
		/*------------------------------------------------------------------
								Create PMM Tables
		------------------------------------------------------------------*/
		
		-- CREATE TABLE PMM_TitleStatus
		vsql := 'CREATE TABLE WFS.PMM_TitleStatus (
										ID_			NUMBER 		NOT NULL,
										Description	VARCHAR(25)	NOT NULL,
										CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_TitleStatus PRIMARY KEY (ID_))';
    CREATEOBJECT(vsql,'Unable to create table PMM_TitleStatus.');
    CREATEUPDATETRG('PMM_TitleStatus');
		
		-- CREATE TABLE PMM_Title
    vsql := 'CREATE TABLE WFS.PMM_Title (
										ID_					NUMBER 			NOT NULL,
										TitleStatusID		NUMBER				 NULL,
										ProviderID			NUMBER				 NULL,
										EXTERNALLOCATION 	VARCHAR2(50)		 NULL,
                    ASSET_ID        NUMBER,
										CREATEDATE 			TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          					UPDATEDATE 			TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_Title PRIMARY KEY (ID_))';
    CREATEOBJECT(vsql,'Unable to create table PMM_Title.');
    CREATESEQ('PMM_Title');
    CREATEUPDATETRG('PMM_Title');
    
    vsql := 'CREATE INDEX WFS.IDX_PMMTITLE_ASSETID ON WFS.PMM_TITLE(ASSET_ID)';
    CREATEOBJECT(vsql,'Unable to create index PMM_Title asset_id.');		
    
		-- CREATE TABLE PMM_TitleListStatus
		vsql := 'CREATE TABLE WFS.PMM_TitleListStatus (
							ID_			NUMBER 		NOT NULL,
							Description	VARCHAR(25) NOT NULL,
							CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          		UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
              CONSTRAINT PK_PMM_TitleListStatus PRIMARY KEY (ID_))';
    CREATEOBJECT(vsql,'Unable to create table PMM_TitleListStatus.');
    CREATEUPDATETRG('PMM_TitleListStatus');
    
		-- CREATE TABLE PMM_LISTTYPE
    vsql := 'CREATE TABLE WFS.PMM_LISTTYPE (
										ID_			NUMBER 		NOT NULL,
										Description	VARCHAR(25) NOT NULL,
										CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_LISTTYPE PRIMARY KEY (ID_))';
    CREATEOBJECT(vsql,'Unable to create table PMM_LISTTYPE.');
		
		-- CREATE TABLE PMM_TitleList
    vsql := 'CREATE TABLE WFS.PMM_TitleList (
										ID_					NUMBER 		NOT NULL,
										NAME					VARCHAR2(50)	 NULL,
										DESCRIPTION 		VARCHAR2(255)	 NULL,
										TitleListTypeId	NUMBER		NOT NULL,
										TitleListStatusId NUMBER			 NULL,
										ProviderId			NUMBER			 NULL,
										ContextId			NUMBER			 NULL,
										PitchDate			DATE				 NULL,
										IsActive				NUMBER(1,0)	DEFAULT(1) NOT NULL,
										CREATEDATE 			TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE 			TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_TitleList PRIMARY KEY (ID_))';
    CREATEOBJECT(vsql,'Unable to create table PMM_TitleList.');
    CREATESEQ('PMM_TitleList');
    CREATEUPDATETRG('PMM_TitleList');
    
		-- CREATE TABLE PMM_Title_TitleListXREF
		vsql := 'CREATE TABLE WFS.PMM_Title_TitleListXREF (
										TitleListId	NUMBER NOT NULL,
										TitleId		NUMBER NOT NULL,
										CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    ORDER_ number default 0 not null,
                    CONSTRAINT PK_PMM_Title_TitleListXREF PRIMARY KEY (TitleListId, TitleId,Order_))';
    CREATEOBJECT(vsql,'Unable to create table PMM_Title_TitleListXREF.');
		
		-- CREATE TABLE PMM_ProgressItem
		vsql := 'CREATE TABLE WFS.PMM_ProgressItem (
										ID_				NUMBER 		NOT NULL,
										TitleID			NUMBER 		NOT NULL,
										TitleListID		NUMBER 			 NULL,
										NAME				VARCHAR2(255) NOT NULL,
										DESCRIPTION 	VARCHAR2(1000)	 NULL,
										ISSUCCESSFUL	NUMBER(1,0)	DEFAULT(1) NOT NULL,
										ACTIONDATE 		TIMESTAMP(6) NOT NULL,
                    TITLEVERSION VARCHAR2(25) NOT NULL,
                    SOURCECOMPONENTNAME VARCHAR2(25) NOT NULL,
                    SOURCEENTITYNAME VARCHAR2(25),
                    SOURCEID VARCHAR2(100) NOT NULL,
                    ISACTIVE NUMBER(1,0) DEFAULT (1) NOT NULL,
										CREATEDATE 		TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          					UPDATEDATE 		TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_ProgressItem PRIMARY KEY (ID_))';
    CREATEOBJECT(vsql,'Unable to create table PMM_ProgressItem.');
    CREATESEQ('PMM_ProgressItem');
    CREATEUPDATETRG('PMM_ProgressItem');
    
    -- Creating Index IDX_PMMPRGITEM_TITLEID
    vsql :=  'CREATE INDEX WFS.IDX_PMMPRGITEM_TITLEID ON WFS.PMM_ProgressItem(TITLEID)';
    CREATEOBJECT(vsql,'Unable to create index IDX_PMMPRGITEM_TITLEID');    
    
		-- CREATE TABLE PMM_TitleListDetails
		vsql := 'CREATE TABLE WFS.PMM_TitleListDetails (
										TitleListID		NUMBER NOT NULL,
										DetailTypeID	NUMBER NOT NULL,
										VALUE				VARCHAR2(255) NULL,
										CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          					UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_TitleListDetails PRIMARY KEY (TitleListID, DetailTypeID))';
    CREATEOBJECT(vsql,'Unable to create table PMM_TitleListDetails.');
    CREATEUPDATETRG('PMM_TitleListDetails');
    
		-- CREATE TABLE PMM_TitleListDetailsType

    vsql := 'CREATE TABLE WFS.PMM_TitleListDetailsType (
										ID_			NUMBER 		 NOT NULL,
										Name			VARCHAR2(25) NOT NULL,
										CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
       							UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_TitleListDetailsType PRIMARY KEY (ID_))';
    CREATEOBJECT(vsql,'Unable to create table PMM_TitleListDetailsType.');
    CREATEUPDATETRG('PMM_TitleListDetailsType');
    
		-- CREATE TABLE PMM_Partner
		vsql := 'CREATE TABLE WFS.PMM_Partner (
										ID_			NUMBER 		 NOT NULL,
										NAME			VARCHAR2(25) NOT NULL,
										PartnerType	NUMBER		 NOT NULL,
										ContextId	NUMBER			  NULL,
										ProviderId	VARCHAR2(25) NOT NULL,
										Notes			VARCHAR2(500)	  NULL,
										isactive 	NUMBER(1,0)  DEFAULT(1) NOT NULL,
                    lookupkey varchar(25 char) NULL,
										CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          					UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_Partner PRIMARY KEY (ID_))';
		CREATEOBJECT(vsql,'Unable to create table PMM_Partner.');
    CREATESEQ('PMM_Partner');
    CREATEUPDATETRG('PMM_Partner');
    
		-- CREATE TABLE PMM_PartnerType
		vsql :='CREATE TABLE WFS.PMM_PartnerType (
										ID_			NUMBER 		 NOT NULL,
										NAME			VARCHAR2(50) NOT NULL,
										CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_PartnerType PRIMARY KEY (ID_))';
		CREATEOBJECT(vsql,'Unable to create table PMM_PartnerType.');
    CREATEUPDATETRG('PMM_PartnerType');
    
		-- CREATE TABLE PMM_Context
		vsql := 'CREATE TABLE WFS.PMM_Context (
										ID_					NUMBER NOT NULL,
										ContainerTypeID	NUMBER NOT NULL,
										CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_Context PRIMARY KEY (ID_))';
		CREATEOBJECT(vsql,'Unable to create table PMM_Context.');
    CREATESEQ('PMM_Context');
    CREATEUPDATETRG('PMM_Context');
    
		-- CREATE TABLE PMM_ContainerType
		vsql := 'CREATE TABLE WFS.PMM_ContainerType (
              ID_			NUMBER 		 NOT NULL,
							Name			VARCHAR2(10) NOT NULL,
							CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          		UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
              CONSTRAINT PK_PMM_ContainerType PRIMARY KEY (ID_))';
		CREATEOBJECT(vsql,'Unable to create table PMM_ContainerType.');
    CREATEUPDATETRG('PMM_ContainerType');
    
		-- CREATE TABLE PMM_Contact
    vsql := 'CREATE TABLE WFS.PMM_Contact (
										ID_			NUMBER 		 NOT NULL,
										PartnerID	NUMBER 		 NOT NULL,
										FirstName	VARCHAR2(25) 	  NULL,
										LastName		VARCHAR2(25) 	  NULL,
										Email			VARCHAR2(50) NOT NULL,
										CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          					UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_Contact PRIMARY KEY (ID_))';
		CREATEOBJECT(vsql,'Unable to create table PMM_Contact.');
    CREATESEQ('PMM_Contact');
    CREATEUPDATETRG('PMM_Contact');
    
		-- CREATE TABLE PMM_RuleType
		vsql := 'CREATE TABLE WFS.PMM_RuleType (
										ID_							NUMBER 			NOT NULL,
										NAME							VARCHAR2(50)		 NULL,
										TitlesAssociated 			NUMBER(1,0) DEFAULT(0) 	NOT NULL,
										CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          					UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_RuleType PRIMARY KEY (ID_))';
		CREATEOBJECT(vsql,'Unable to create table PMM_RuleType.');
    CREATEUPDATETRG('PMM_RuleType');
    
		-- CREATE TABLE PMM_Rule
    vsql := 'CREATE TABLE WFS.PMM_Rule (
										ID_					NUMBER 		NOT NULL,
										RuleTypeId			NUMBER		NOT NULL,
										StartDate			TIMESTAMP 		 NULL,
										EndDate				TIMESTAMP 		 NULL,
										CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          					UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_Rule PRIMARY KEY (ID_))';
		CREATEOBJECT(vsql,'Unable to create table PMM_Rule.');
    CREATESEQ('PMM_Rule');
    CREATEUPDATETRG('PMM_Rule');
    
		-- CREATE TABLE PMM_RuleParameter
    vsql := 'CREATE TABLE WFS.PMM_RuleParameter (
										ID_			NUMBER 			NOT NULL,
										RuleID		NUMBER			NOT NULL,
										Value			varchar2(100)	NOT NULL,
										ORDER_		NUMBER			NOT NULL,
										CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          					UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_RuleParameter PRIMARY KEY (ID_))';
		CREATEOBJECT(vsql,'Unable to create table PMM_RuleParameter.');
    CREATESEQ('PMM_RuleParameter');
    CREATEUPDATETRG('PMM_RuleParameter');
    
		-- CREATE TABLE PMM_Service
    vsql := 'CREATE TABLE WFS.PMM_Service (
										ID_			NUMBER 		 NOT NULL,
										Name			varchar2(50) NOT NULL,
										Description varchar2(255)    NULL,
										ContextID	NUMBER			  NULL,
										isactive 	NUMBER(1,0)  DEFAULT (1) 				NOT NULL,
                    lookupkey varchar(25 char) NULL,
										CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          					UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_Service PRIMARY KEY (ID_))';
		CREATEOBJECT(vsql,'Unable to create table PMM_Service.');            	 					
    CREATESEQ('PMM_Service');
    CREATEUPDATETRG('PMM_Service');
    
		-- CREATE TABLE PMM_Service_PartnerXREF
    vsql := 'CREATE TABLE WFS.PMM_Service_PartnerXREF (
										PartnerID	NUMBER 		NOT NULL,
										ServiceID	NUMBER 		NOT NULL,
										CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_Service_PartnerXREF PRIMARY KEY (ServiceID, PartnerID))';
		CREATEOBJECT(vsql,'Unable to create table PMM_Service_PartnerXREF.');
		
		-- CREATE TABLE PMM_PitchFrequency
    vsql := 'CREATE TABLE WFS.PMM_PitchFrequency (
              ID_							NUMBER 		NOT NULL,
              DistributionPartnerId	NUMBER		NOT NULL,
              SourcePartnerId			NUMBER			 NULL,
              WeeksBetweenPitch			NUMBER DEFAULT(1) NOT NULL,
              PitchDay						NUMBER DEFAULT(0) NOT NULL,
              CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
              UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
              CONSTRAINT PK_PMM_PitchFrequency PRIMARY KEY (ID_),
              CONSTRAINT CK_PMM_PitchFreq_Unique UNIQUE (DistributionPartnerId,SourcePartnerId, PitchDay),
              CONSTRAINT CK_PMM_PitchFreq_WBP CHECK (WeeksBetweenPitch >= 0),
              CONSTRAINT CK_PMM_PitchFreq_PD CHECK (PitchDay >=0 and PitchDay < 7))';
		CREATEOBJECT(vsql,'Unable to create table PMM_PitchFrequency.');
    CREATESEQ('PMM_PitchFrequency');
    CREATEUPDATETRG('PMM_PitchFrequency');
    
		-- CREATE TABLE PMM_Job
		vsql := 'CREATE TABLE WFS.PMM_Job (
										ID_						NUMBER 				NOT NULL,
										ProcessPriorityID		NUMBER,
										Name						VARCHAR2(25) 		NOT NULL,
										ContextID				NUMBER 				NOT NULL,
										TEMPLATENAME			VARCHAR2(255) ,
										RuleID					NUMBER					 NULL,
										CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_Job PRIMARY KEY (ID_))';
		CREATEOBJECT(vsql,'Unable to create table PMM_Job.');
    CREATESEQ('PMM_Job');
    CREATEUPDATETRG('PMM_Job');
    
		-- CREATE TABLE PMM_WatchFolderConfiguration
    vsql := 'CREATE TABLE WFS.PMM_WatchFolderConfiguration (
										ID_					NUMBER	 		NOT NULL,
										NAME					VARCHAR2(25)	NOT NULL,
										ResourceID			NUMBER	 			 NULL,
										Location				VARCHAR2(25)		 NULL,
										FileTypes			VARCHAR2(25)		 NULL,
										ProcessingClass	VARCHAR2(25)		 NULL,
										Events				VARCHAR2(25)		 NULL,
										ThreadCount			NUMBER	 			 NULL,
										Frequency			NUMBER	 			 NULL,
										ContextID			NUMBER	 			 NULL,
										CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          					UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_WatchFolderConfig PRIMARY KEY (ID_))';
		CREATEOBJECT(vsql,'Unable to create table PMM_WatchFolderConfiguration.');
    
		-- CREATE TABLE PMM_JobParameter
    vsql := 'CREATE TABLE WFS.PMM_JobParameter (
										ID_			NUMBER 			NOT NULL,
										JobId			NUMBER 			NOT NULL,
										Name			VARCHAR2(50)	NOT NULL,
										Value			VARCHAR2(255)		 NULL,
										CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          					UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_JobParameter PRIMARY KEY (ID_))';
		CREATEOBJECT(vsql,'Unable to create table PMM_JobParameter.');
    CREATESEQ('PMM_JobParameter');
    CREATEUPDATETRG('PMM_JobParameter');
    
		-- CREATE TABLE PMM_RULETYPEPARAMETERDATATYPE
    vsql := 'CREATE TABLE WFS.PMM_RULETYPEPARAMETERDATATYPE (
										ID_			NUMBER 		NOT NULL,
										Value			VARCHAR2(255)   NULL,
										CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          					UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_RULETYPEPARAMDATATYPE PRIMARY KEY (ID_))';
		CREATEOBJECT(vsql,'Unable to create table PMM_RULETYPEPARAMETERDATATYPE.');
        
		-- CREATE TABLE PMM_RuleTypeParameter
		vsql := 'CREATE TABLE WFS.PMM_RuleTypeParameter (
										ID_			NUMBER 		NOT NULL,
										NAME 			VARCHAR2(50)    NULL,
										RULETYPEID	NUMBER 		NOT NULL,
										Order_		NUMBER		NOT NULL,
										ISREQUIRED	NUMBER(1,0)	NOT NULL,
										DataTypeID	NUMBER		NOT NULL,
										CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
          					UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_RuleTypeContent PRIMARY KEY (ID_))';
		CREATEOBJECT(vsql,'Unable to create table PMM_RuleTypeParameter.');
    CREATEUPDATETRG('PMM_RuleTypeParameter');
    
		-- CREATE TABLE PMM_PROPERTIES
    vsql := 'CREATE TABLE WFS.PMM_PROPERTIES (
										ID_			NUMBER 		NOT NULL,
										Name			VARCHAR2(32) NOT NULL,
										Value       VARCHAR2(256)	 NULL,
										TitleId		NUMBER 		NOT NULL,
										TitleListId NUMBER 			 NULL,
										ContextId	NUMBER 			 NULL,
										CREATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    UPDATEDATE 	TIMESTAMP(6) DEFAULT (SYSTIMESTAMP) NOT NULL,
                    CONSTRAINT PK_PMM_PROPERTIES PRIMARY KEY (ID_))';
		CREATEOBJECT(vsql,'Unable to create table PMM_PROPERTIES.');
    CREATESEQ('PMM_PROPERTIES');
    CREATEUPDATETRG('PMM_PROPERTIES');
    
      --create table PMM_TITLEASSETSTATUS. By Suneeta 05/14/09
      vsql := 'create table WFS.PMM_TITLEASSETSTATUS(
                id number,
                titleid number,
                assetVersion varchar2(10),
                titlestatus number,
                CREATEDATE TIMESTAMP (6) DEFAULT (SYSTIMESTAMP), 
                UPDATEDATE TIMESTAMP (6) DEFAULT (SYSTIMESTAMP),
                constraint pk_pmmtitleassetstation primary key (id),
                CONSTRAINT fk_pmmtas_titleSTATUS  FOREIGN KEY (titlestatus)  REFERENCES wfs.pmm_titlestatus(id_),
                CONSTRAINT fk_pmmtas_TITLEid  FOREIGN KEY (titleid) REFERENCES wfs.pmm_title(id_)            
                )';
      CREATEOBJECT(vsql,'Unable to create table PMM_TITLEASSETSTATUS');
      CREATESEQ('PMM_TITLEASSETSTATUS');
      CREATEUPDATETRG('PMM_TITLEASSETSTATUS');

      vsql := 'CREATE INDEX WFS.IDX_PMMTAS_TITLEID ON WFS.PMM_TITLEASSETSTATUS(titleid)';
      CREATEOBJECT(vsql,'Unable to create index on PMM_TITLEASSETSTATUS titleid');
      
      --create table PMM_CONTAINER_PROPERTIES. By Suneeta 07/06/09
      vsql := 'CREATE TABLE '||vschema||'.PMM_CONTAINER_PROPERTIES(
                id number PRIMARY KEY,
                contextid number,
                name varchar2(100),
                value varchar2(250),
                CREATEDATE TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL , 
                UPDATEDATE TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL, 
                CONSTRAINT CONTEXTID_FK FOREIGN KEY (contextid) REFERENCES '||vschema||'.PMM_CONTEXT(id_)
                )';
      CREATEOBJECT(vsql,'Unable to create table PMM_CONTAINER_PROPERTIES');
      CREATESEQ('PMM_CONTAINER_PROPERTIES');
      CREATEUPDATETRG('PMM_CONTAINER_PROPERTIES');


		/*------------------------------------------------------------------
								INSERT PMM Default Table Values
		------------------------------------------------------------------*/
		
		--Inserts for PMM_PartnerType
		BEGIN
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_PartnerType (ID_,Name,CreateDate, UpdateDate)
									 VALUES(0,''SELF'',TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''16/06/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_PartnerType (ID_,Name,CreateDate, UpdateDate)
									 VALUES(1,''DISTRIBUTION'',TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''16/06/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_PartnerType (ID_,Name,CreateDate, UpdateDate)
									 VALUES(2,''SOURCE'',TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''16/06/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
		EXCEPTION 
			WHEN OTHERS THEN
				wk_message := 'ERROR';
				err_msg :=SUBSTR(SQLERRM, 1, 500);
				EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''error in installing of application database objects:'||
            	 					'Unable to insert into PMM_PartnerType.'')';
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
        GOTO bypass_install;
		
		END;
		
		--Inserts for PMM_ContainerType
		BEGIN
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_ContainerType (ID_,Name,CreateDate, UpdateDate)
									 VALUES(1,''PARTNER'',TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_ContainerType (ID_,Name,CreateDate, UpdateDate)
									 VALUES(2,''SERVICE'',TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
		EXCEPTION 
			WHEN OTHERS THEN
				wk_message := 'ERROR';
				err_msg :=SUBSTR(SQLERRM, 1, 500);
				EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''error in installing of application database objects:'||
            	 					'Unable to insert into PMM_ContainerType.'')';
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
        GOTO bypass_install;
		
		END;

		--Inserts for PMM_RuleType
		BEGIN
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_RuleType (ID_, NAME, TitlesAssociated, CreateDate, UpdateDate)
									 VALUES(1,''NDaysFromMetadata'',1,TO_DATE(''03/06/2008 12:00:00 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''03/06/2008 12:00:00 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_RuleType (ID_, NAME, TitlesAssociated, CreateDate, UpdateDate)
									 VALUES(2,''OnDate'',0,TO_DATE(''30/07/2008 12:00:00 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''30/07/2008 12:00:00 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_RuleType (ID_, NAME, TitlesAssociated, CreateDate, UpdateDate)
									 VALUES(3,''EveryNDays'',0,TO_DATE(''30/07/2008 12:00:00 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''30/07/2008 12:00:00 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_RuleType (ID_, NAME, TitlesAssociated, CreateDate, UpdateDate)
									 VALUES(4,''OnDayEveryNWeeks'',0,TO_DATE(''30/07/2008 12:00:00 PM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''30/07/2008 12:00:00 PM'',''DD/MM/YYYY HH12:MI:SS PM''))';
		EXCEPTION 
			WHEN OTHERS THEN
				wk_message := 'ERROR';
				err_msg :=SUBSTR(SQLERRM, 1, 500);
				EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''error in installing of application database objects:'||
            	 					'Unable to insert into PMM_RuleType.'')';
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
        GOTO bypass_install;
		
		END;
		
		--Inserts for PMM_TITLESTATUS
		BEGIN
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_TITLESTATUS (ID_,Description,CreateDate, UpdateDate)
									 VALUES(0,''DRAFT'',sysdate, sysdate)';
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_TITLESTATUS (ID_,Description,CreateDate, UpdateDate)
									 VALUES(1,''COMMITTED'',sysdate, sysdate)';
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_TITLESTATUS (ID_,Description,CreateDate, UpdateDate)
									 VALUES(2,''READY'',sysdate, sysdate)';
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_TITLESTATUS (ID_,Description,CreateDate, UpdateDate)
									 VALUES(3,''APPROVED'',sysdate, sysdate)';
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_TITLESTATUS (ID_,Description,CreateDate, UpdateDate)
									 VALUES(4,''RETIRED'',sysdate, sysdate)';
		EXCEPTION 
			WHEN OTHERS THEN
				wk_message := 'ERROR';
				err_msg :=SUBSTR(SQLERRM, 1, 500);
				EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''error in installing of application database objects:'||
            	 					'Unable to insert into PMM_TITLESTATUS.'')';
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
        GOTO bypass_install;
		
		END;
		
		--Inserts for PMM_TITLELISTSTATUS
		BEGIN
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_TITLELISTSTATUS (ID_,Description,CreateDate, UpdateDate)
									 VALUES(0,''NEW'',TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_TITLELISTSTATUS (ID_,Description,CreateDate, UpdateDate)
									 VALUES(1,''READY'',TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_TITLELISTSTATUS (ID_,Description,CreateDate, UpdateDate)
									 VALUES(2,''APPROVED'',TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
		EXCEPTION 
			WHEN OTHERS THEN
				wk_message := 'ERROR';
				err_msg :=SUBSTR(SQLERRM, 1, 500);
				EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''error in installing of application database objects:'||
            	 					'Unable to insert into PMM_TITLELISTSTATUS.'')';
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
        GOTO bypass_install;
		
		END;
		
		--Inserts for PMM_LISTTYPE
		BEGIN
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_LISTTYPE (ID_,Description,CreateDate, UpdateDate)
									 VALUES(1,''Pitch Schedule'',TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_LISTTYPE (ID_,Description,CreateDate, UpdateDate)
									 VALUES(2,''Program List'',TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''16/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_LISTTYPE (ID_,Description,CreateDate, UpdateDate)
									 VALUES(3,''Planner'',TO_DATE(''09/06/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''09/06/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_LISTTYPE (ID_,Description,CreateDate, UpdateDate)
									 VALUES(4,''Title List'',sysdate,sysdate)';


		EXCEPTION 
			WHEN OTHERS THEN
				wk_message := 'ERROR';
				err_msg :=SUBSTR(SQLERRM, 1, 500);
				EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''error in installing of application database objects:'||
            	 					'Unable to insert into PMM_LISTTYPE.'')';
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
        GOTO bypass_install;
		
		END;
		
		--Inserts for PMM_RuleTypeParameter
		BEGIN
			EXECUTE IMMEDIATE ' INSERT INTO WFS.PMM_RuleTypeParameter (ID_, NAME ,RULETYPEID, Order_, DataTypeID, ISREQUIRED,CreateDate, UpdateDate)
				VALUES(1,''Number Of days'',1,1,3,1,TO_DATE(''30/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''30/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
			EXECUTE IMMEDIATE ' INSERT INTO WFS.PMM_RuleTypeParameter (ID_, NAME ,RULETYPEID, Order_, DataTypeID, ISREQUIRED,CreateDate, UpdateDate)
				VALUES(2,''TimeFrame'',1,2,4,1,TO_DATE(''30/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''30/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
			EXECUTE IMMEDIATE ' INSERT INTO WFS.PMM_RuleTypeParameter (ID_, NAME ,RULETYPEID, Order_, DataTypeID, ISREQUIRED,CreateDate, UpdateDate)
				VALUES(3,''Metadata reference'',1,3,5,1,TO_DATE(''30/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''30/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
			EXECUTE IMMEDIATE ' INSERT INTO WFS.PMM_RuleTypeParameter (ID_, NAME ,RULETYPEID, Order_, DataTypeID, ISREQUIRED,CreateDate, UpdateDate)
				VALUES(4,''Time'',1,4,2,0,TO_DATE(''30/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''30/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
			EXECUTE IMMEDIATE ' INSERT INTO WFS.PMM_RuleTypeParameter (ID_, NAME ,RULETYPEID, Order_, DataTypeID, ISREQUIRED,CreateDate, UpdateDate)
				VALUES(5,''Date'',2,1,1,1,TO_DATE(''30/07/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''30/07/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))'; 
			EXECUTE IMMEDIATE ' INSERT INTO WFS.PMM_RuleTypeParameter (ID_, NAME ,RULETYPEID, Order_, DataTypeID, ISREQUIRED,CreateDate, UpdateDate)
				VALUES(6,''Time'',2,2,2,0,TO_DATE(''30/07/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''30/07/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))'; 
			EXECUTE IMMEDIATE ' INSERT INTO WFS.PMM_RuleTypeParameter (ID_, NAME ,RULETYPEID, Order_, DataTypeID, ISREQUIRED,CreateDate, UpdateDate)
				VALUES(7,''Number of days'',3,1,3,1,TO_DATE(''30/07/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''30/07/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))'; 
			EXECUTE IMMEDIATE ' INSERT INTO WFS.PMM_RuleTypeParameter (ID_, NAME ,RULETYPEID, Order_, DataTypeID, ISREQUIRED,CreateDate, UpdateDate)
				VALUES(8,''Time'',3,2,2,0,TO_DATE(''30/07/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''30/07/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))'; 
			EXECUTE IMMEDIATE ' INSERT INTO WFS.PMM_RuleTypeParameter (ID_, NAME ,RULETYPEID, Order_, DataTypeID, ISREQUIRED,CreateDate, UpdateDate)
				VALUES(9,''Day'',4,1,6,1,TO_DATE(''30/07/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''30/07/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))'; 
			EXECUTE IMMEDIATE ' INSERT INTO WFS.PMM_RuleTypeParameter (ID_, NAME ,RULETYPEID, Order_, DataTypeID, ISREQUIRED,CreateDate, UpdateDate)
				VALUES(10,''Number of weeks'',4,2,3,1,TO_DATE(''30/07/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''30/07/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))'; 
			EXECUTE IMMEDIATE ' INSERT INTO WFS.PMM_RuleTypeParameter (ID_, NAME ,RULETYPEID, Order_, DataTypeID, ISREQUIRED,CreateDate, UpdateDate)
				VALUES(11,''Time'',4,3,2,0,TO_DATE(''30/07/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''30/07/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))'; 

		EXCEPTION 
			WHEN OTHERS THEN
				wk_message := 'ERROR';
				err_msg :=SUBSTR(SQLERRM, 1, 500);
				EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''error in installing of application database objects:'||
            	 					'Unable to insert into PMM_RuleTypeParameter.'')';
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
        GOTO bypass_install;
		
		END;
		
		--Inserts for PMM_RULETYPEPARAMETERDATATYPE
		BEGIN
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_RULETYPEPARAMETERDATATYPE (ID_,Value,CreateDate, UpdateDate)
									 VALUES(1,''DATE'',TO_DATE(''30/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''30/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_RULETYPEPARAMETERDATATYPE (ID_,Value,CreateDate, UpdateDate)
									 VALUES(2,''TIME'',TO_DATE(''30/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''30/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_RULETYPEPARAMETERDATATYPE (ID_,Value,CreateDate, UpdateDate)
									 VALUES(3,''INTEGER'',TO_DATE(''30/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''30/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_RULETYPEPARAMETERDATATYPE (ID_,Value,CreateDate, UpdateDate)
									 VALUES(4,''OPTIONS'',TO_DATE(''30/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''30/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_RULETYPEPARAMETERDATATYPE (ID_,Value,CreateDate, UpdateDate)
									 VALUES(5,''PARAMETERREF'',TO_DATE(''30/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''30/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
			EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_RULETYPEPARAMETERDATATYPE (ID_,Value,CreateDate, UpdateDate)
									 VALUES(6,''DAY'',TO_DATE(''30/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''30/04/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
		EXCEPTION 
			WHEN OTHERS THEN
				wk_message := 'ERROR';
				err_msg :=SUBSTR(SQLERRM, 1, 500);
				EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''error in installing of application database objects:'||
            	 					'Unable to insert into PMM_RULETYPEPARAMETERDATATYPE.'')';
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
        GOTO bypass_install;
		
		END;

		--PMM Inserts for WFS.ttv_MONITOREDDRIVE
		BEGIN
				EXECUTE IMMEDIATE 'INSERT INTO WFS.ttv_MONITOREDDRIVE (monitoreddriveid, name, description, path, internaldriveid, totalcapacity, warningthresholdpercent, errorthresholdpercent, currentbytesused, currentdrivestatusid,CreateDate, UpdateDate) 
					VALUES (WFS.ttv_MONITOREDDRIVE_SEQ.NEXTVAL, ''Content'', ''Drive for mapped and unmapped assets in PMM'', ''/content'', 1, 100000000000, 50, 75, 0, 0, TO_DATE(''30/07/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''), TO_DATE(''30/07/2008 11:00:00 AM'',''DD/MM/YYYY HH12:MI:SS PM''))';
		EXCEPTION 
			WHEN OTHERS THEN
				wk_message := 'ERROR';
				err_msg :=SUBSTR(SQLERRM, 1, 500);
				EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''error in installing of application database objects:'||
            	 					'Unable to insert into ttv_MONITOREDDRIVE.'')';
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('||err_msg||')';
        GOTO bypass_install;
		
		END;
    
-- PMM Inserts for mandatory TTV self partner    
		BEGIN
				EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_CONTEXT (id_, containertypeid)  
					    VALUES(WFS.PMM_CONTEXT_SEQ.nextval, 1)';
				EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_PARTNER (contextid, id_, isactive, name, partnertype, providerid)
					VALUES(WFS.PMM_CONTEXT_SEQ.currval, WFS.PMM_PARTNER_SEQ.nextval, 1, ''TTV'', 0, ''TTV.COM'')';
				EXECUTE IMMEDIATE 'INSERT INTO WFS.PMM_CONTACT (id_, email, firstname, lastname, partnerid)
                VALUES(WFS.PMM_CONTACT_SEQ.nextval, ''INFO@TTV.COM'', ''TTV'', ''TTV'', WFS.PMM_PARTNER_SEQ.currval)';
		EXCEPTION 
			WHEN OTHERS THEN
				wk_message := 'ERROR';
				err_msg :=SUBSTR(SQLERRM, 1, 500);
				EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''error in installing of application database objects:'||
            	 					'Unable to insert into ttv self partner data.'')';
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('||err_msg||')';
        GOTO bypass_install;
		END;
		
		--Create Sequence for PMM_WatchFolderConfiguration
		vsql := 'CREATE SEQUENCE WFS.PMM_WatchFlderConfig_SEQ
                              INCREMENT BY 1
                              START WITH 1
                              NOMAXVALUE
                              NOMINVALUE
                              NOCYCLE
                              NOCACHE
                              NOORDER';
		CREATEOBJECT(vsql,'Unable to create sequence PMM_WatchFolderConfiguration_SEQ.');
		/*------------------------------------------------------------------
								Create PMM Triggers
		------------------------------------------------------------------*/
		
		-- Update the UpdateDate for PMM_WatchFolderConfiguration
		BEGIN
			EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_PMM_WatchFolderConfig_UPD
                              BEFORE UPDATE
                              ON WFS.PMM_WatchFolderConfiguration
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              	SELECT  SYSTIMESTAMP
                              	INTO    updatedate
                              	FROM    DUAL;
                              	:NEW.UpdateDate := updatedate;
                              END;';
		EXCEPTION 
			WHEN OTHERS THEN
				wk_message := 'ERROR';
				err_msg :=SUBSTR(SQLERRM, 1, 500);
				EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''error in installing of application database objects:'||
            	 					'Unable to create trigger TRG_PMM_WatchFolderConfiguration_UPD.'')';
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
        GOTO bypass_install;
				
		END;
		
		-- Set ID_ for PMM_WatchFolderConfiguration
		BEGIN
			EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_PMM_WatchFolderConfig_SEQ
                           	BEFORE INSERT ON WFS.PMM_WatchFolderConfiguration
                           	FOR EACH ROW
                           	BEGIN
                           	    IF :NEW.ID_ IS NULL THEN
                           	        SELECT WFS.PMM_WatchFlderConfig_SEQ.NEXTVAL INTO :NEW.ID_ FROM DUAL;
                           	    END IF;
                           	END;';
		EXCEPTION 
			WHEN OTHERS THEN
				wk_message := 'ERROR';
				err_msg :=SUBSTR(SQLERRM, 1, 500);
				EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''error in installing of application database objects:'||
            	 					'Unable to create trigger TRG_PMM_WatchFolderConfiguration_SEQ.'')';
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
        GOTO bypass_install;
				
		END;
		
		-- Update the UpdateDate for PMM_RULETYPEPARAMETERDATATYPE
		BEGIN
			EXECUTE IMMEDIATE 'CREATE TRIGGER WFS.TRG_RleTypeParmDtaType_UPD
                              BEFORE UPDATE
                              ON WFS.PMM_RULETYPEPARAMETERDATATYPE
                              FOR EACH ROW
                              DECLARE updatedate      date;
                              BEGIN
                              	SELECT  SYSTIMESTAMP
                              	INTO    updatedate
                              	FROM    DUAL;
                              	:NEW.UpdateDate := updatedate;
                              END;';
		EXCEPTION 
			WHEN OTHERS THEN
				wk_message := 'ERROR';
				err_msg :=SUBSTR(SQLERRM, 1, 500);
				EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values (''error in installing of application database objects:'||
            	 					'Unable to create trigger TRG_PMM_RULETYPEPARAMETERDATATYPE_UPD.'')';
            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
        GOTO bypass_install;
				
		END;
		/*------------------------------------------------------------------
								Create Foreign Keys
		------------------------------------------------------------------*/
		
		-- CREATE FOREIGN KEYS FOR PMM_TITLE
    vsql := 'ALTER TABLE WFS.PMM_TITLE ADD (
                                  CONSTRAINT PMM_TITLE#PMM_Partner 
                                          FOREIGN KEY (ProviderID) 
                                          REFERENCES WFS.PMM_Partner (ID_),
                                  CONSTRAINT PMM_TITLE#PMM_TITLESTATUS
                                  			FOREIGN KEY (TitleStatusID) 
                                          REFERENCES WFS.PMM_TitleStatus (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign keys for PMM_TITLE.'); 
		
		-- CREATE FOREIGN KEYS FOR PMM_TITLELIST
    vsql := 'ALTER TABLE WFS.PMM_TITLELIST ADD (
                                  CONSTRAINT PMM_TITLELST#PMM_CONTEXT
                                          FOREIGN KEY (ContextID) 
                                          REFERENCES WFS.PMM_CONTEXT (ID_),
                                  CONSTRAINT PMM_TITLELST#PMM_TTLELSTSTATUS
                                          FOREIGN KEY (TitleListStatusID) 
                                          REFERENCES WFS.PMM_TITLELISTSTATUS (ID_),
                                  CONSTRAINT PMM_TITLELST#PMM_TITLELSTTYPE 
                                          FOREIGN KEY (TitleListTypeID) 
                                          REFERENCES WFS.PMM_LISTTYPE (ID_),
                                  CONSTRAINT PMM_TITLELST#PMM_Partner 
                                          FOREIGN KEY (ProviderID) 
                                          REFERENCES WFS.PMM_PARTNER (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign keys for PMM_TITLELIST.'); 
		
		-- CREATE FOREIGN KEYS FOR PMM_TITLE_TITLELISTXREF
		vsql := 'ALTER TABLE WFS.PMM_TITLE_TITLELISTXREF ADD (
                                  CONSTRAINT PMM_TTLE_TTLELSTXREF#PMM_TTLE
                                          FOREIGN KEY (TitleID) 
                                          REFERENCES WFS.PMM_TITLE (ID_),
                                  CONSTRAINT PMM_TTLE_TTLELSTX#PMM_TTLELST 
                                          FOREIGN KEY (TitleListID) 
                                          REFERENCES WFS.PMM_TITLELIST (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign keys for PMM_TITLE_TITLELISTXREF.'); 
		
		-- CREATE FOREIGN KEYS FOR PMM_PROGRESSITEM
		vsql := 'ALTER TABLE WFS.PMM_PROGRESSITEM ADD (
                                  CONSTRAINT PMM_PROGRESSITEM#PMM_TITLE
                                          FOREIGN KEY (TitleID) 
                                          REFERENCES WFS.PMM_TITLE (ID_),
                                  CONSTRAINT PMM_PRGRESSITEM#PMM_TTLELST 
                                          FOREIGN KEY (TitleListID) 
                                          REFERENCES WFS.PMM_TITLELIST (ID_))';
		    CREATEOBJECT(vsql,'Unable to create foreign keys for PMM_PROGRESSITEM.'); 
		
		-- CREATE FOREIGN KEYS FOR PMM_TITLELISTDETAILS
		vsql := 'ALTER TABLE WFS.PMM_TITLELISTDETAILS ADD (
                                  CONSTRAINT PMM_TTLEDTLS#PMM_TTLELSTDTLS
                                          FOREIGN KEY (DetailTypeID) 
                                          REFERENCES WFS.PMM_TITLELISTDETAILSTYPE (ID_),
                                  CONSTRAINT PMM_TTLELSTDETAILS#PMM_TTLELST
                                          FOREIGN KEY (TitleListID) 
                                          REFERENCES WFS.PMM_TITLELIST (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign keys for PMM_TITLELISTDETAILS.');
		
		-- CREATE FOREIGN KEYS FOR PMM_PARTNER
		vsql := 'ALTER TABLE WFS.PMM_PARTNER ADD (
                                  CONSTRAINT PMM_PARTNER#PMM_PARTNERTYPE
                                          FOREIGN KEY (PartnerType) 
                                          REFERENCES WFS.PMM_PARTNERTYPE (ID_),
                                  CONSTRAINT PMM_PARTNER#PMM_CONTEXT
                                          FOREIGN KEY (ContextID) 
                                          REFERENCES WFS.PMM_CONTEXT (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign keys for PMM_PARTNER.');
		
		-- CREATE FOREIGN KEYS FOR PMM_CONTEXT
		vsql := 'ALTER TABLE WFS.PMM_CONTEXT ADD (
                                  CONSTRAINT PMM_CONTEXT#PMM_CONTAINERTYPE
                                          FOREIGN KEY (ContainerTypeID) 
                                          REFERENCES WFS.PMM_CONTAINERTYPE (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign keys for PMM_CONTEXT.');
		
		-- CREATE FOREIGN KEYS FOR PMM_RULE
		vsql := 'ALTER TABLE WFS.PMM_RULE ADD (
                                  CONSTRAINT PMM_RULE#PMM_RULETYPE
                                          FOREIGN KEY (RULETYPEID) 
                                          REFERENCES WFS.PMM_RULETYPE (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign keys for PMM_RULE.');
		
		-- CREATE FOREIGN KEYS FOR PMM_RuleParameter
		vsql := 'ALTER TABLE WFS.PMM_RuleParameter ADD (
                                  CONSTRAINT PMM_RuleParameter#PMM_RULE
                                          FOREIGN KEY (RULEID) 
                                          REFERENCES WFS.PMM_RULE (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign keys for PMM_RuleParameter.');
		
		-- CREATE FOREIGN KEYS FOR PMM_Service
		vsql := 'ALTER TABLE WFS.PMM_Service ADD (
                                  CONSTRAINT PMM_Service#PMM_Context
                                          FOREIGN KEY (ContextID) 
                                          REFERENCES WFS.PMM_CONTEXT (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign keys for PMM_Service.');
	
		-- CREATE FOREIGN KEYS FOR PMM_Service_PartnerXREF
		vsql := 'ALTER TABLE WFS.PMM_Service_PartnerXREF ADD (
                                  CONSTRAINT PMM_Serv_PrtnrXREF#PMM_Service
                                          FOREIGN KEY (ServiceId) 
                                          REFERENCES WFS.PMM_Service (ID_),
                                  CONSTRAINT PMM_Serv_PrtnrXREF#PMM_Partner
                                          FOREIGN KEY (PartnerId) 
                                          REFERENCES WFS.PMM_Partner (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign keys for PMM_Service_PartnerXREF.');
		
		-- CREATE FOREIGN KEYS FOR PMM_PitchFrequency
		vsql := 'ALTER TABLE WFS.PMM_PitchFrequency ADD (
                                  CONSTRAINT PMM_PitchFreq#PMM_Partner1
                                          FOREIGN KEY (SourcePartnerId) 
                                          REFERENCES WFS.PMM_Partner (ID_),
                                  CONSTRAINT PMM_PitchFreq#PMM_Partner2
                                          FOREIGN KEY (DistributionPartnerId) 
                                          REFERENCES WFS.PMM_Partner (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign keys for PMM_PitchFrequency.');
		
		-- CREATE FOREIGN KEYS FOR PMM_Job
		vsql := 'ALTER TABLE WFS.PMM_Job ADD (
                                  CONSTRAINT PMM_Job#PMM_Context
                                          FOREIGN KEY (ContextID) 
                                          REFERENCES WFS.PMM_Context (ID_)
                                          ON DELETE CASCADE,
                                  CONSTRAINT PMM_Job#PMM_RULE
                                          FOREIGN KEY (RuleID) 
                                          REFERENCES WFS.PMM_RULE (ID_),
                                 CONSTRAINT PMM_Job#TTV_PROCESSPRIORITY
                                          FOREIGN KEY (PROCESSPRIORITYID) 
                                          REFERENCES WFS.TTV_PROCESSPRIORITY (PROCESSPRIORITYID))';
    CREATEOBJECT(vsql,'Unable to create foreign keys for PMM_Job.');
		
		-- CREATE FOREIGN KEYS FOR PMM_WatchFolderConfiguration
		vsql := 'ALTER TABLE WFS.PMM_WatchFolderConfiguration ADD (
                                  CONSTRAINT PMM_WtchFldCnfig#PMM_Context
                                          FOREIGN KEY (ContextID) 
                                          REFERENCES WFS.PMM_Context (ID_),
                                 CONSTRAINT PMM_WtchFldCnfig#TTV_RESRCE
                                          FOREIGN KEY (ResourceID) 
                                          REFERENCES WFS.TTV_Resource (ResourceID))';
    CREATEOBJECT(vsql,'Unable to create foreign keys for PMM_WatchFolderConfiguration.');
		
		-- CREATE FOREIGN KEYS FOR PMM_JobParameter
		vsql := 'ALTER TABLE WFS.PMM_JobParameter ADD (
                                  CONSTRAINT PMM_JobParam#PMM_Job
                                          FOREIGN KEY (JobID) 
                                          REFERENCES WFS.PMM_Job (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign keys for PMM_JobParameter.');
		
		-- CREATE FOREIGN KEYS FOR PMM_RuleTypeParameter
		vsql := 'ALTER TABLE WFS.PMM_RuleTypeParameter ADD (
                                  CONSTRAINT RulTypeParm#RulTypeParmDtaType
                                          FOREIGN KEY (DataTypeID) 
                                          REFERENCES WFS.PMM_RULETYPEPARAMETERDATATYPE (ID_),
                                   CONSTRAINT RulTypeParm#PMM_RULETYPE
                                          FOREIGN KEY (RULETYPEID ) 
                                          REFERENCES WFS.PMM_RULETYPE (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign keys for PMM_RuleTypeParameter.');
		
		-- CREATE FOREIGN KEYS FOR PMM_Contact 
		vsql := 'ALTER TABLE WFS.PMM_Contact ADD (
                                  CONSTRAINT PMM_Contact#PMM_Partner
                                          FOREIGN KEY (PARTNERID) 
                                          REFERENCES WFS.PMM_Partner (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign keys for PMM_Contact.');
		
		-- CREATE FOREIGN KEYS FOR PMM_PROPERTIES 
		vsql := 'ALTER TABLE WFS.PMM_PROPERTIES ADD (
                                  CONSTRAINT PMM_PROP#PMM_TITLE
                                          FOREIGN KEY (TITLEID) 
                                          REFERENCES WFS.PMM_Title (ID_),
                                  CONSTRAINT PMM_PROP#PMM_TitleList
                                          FOREIGN KEY (TitleListId) 
                                          REFERENCES WFS.PMM_TitleList (ID_),
                                  CONSTRAINT PMM_PROP#PMM_Context
                                          FOREIGN KEY (ContextId) 
                                          REFERENCES WFS.PMM_Context (ID_))';
    CREATEOBJECT(vsql,'Unable to create foreign keys for PMM_PROPERTIES.');
	
		<<bypass_install>>
  
          COMMIT;
          
          IF wk_message = 'ERROR' THEN
          
          	  --null;
             RAISE createWFSDB.INSTALL_FAILED;
             
          ELSE
          
             EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''Installation of PMM completed SUCCESSFULLY'')';
             
          END IF;
		
	END CreatePMM;
    
    --PROCEDURE ConvertWFS(error out NUMBER(1,0)) IS
    PROCEDURE ConvertWFS IS
		wk_message	varchar2(500);
		wk_release	varchar2 (25);	
		wk_count		number := 0;	
		err_msg		varchar2(500);
    vsql      varchar2(32767);
    BEGIN
	/*
    ---------------------------------------------------------------------------
            Start of Convert release 2.5.0.0 to 2.7.0.0
    ---------------------------------------------------------------------------
    */

        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_RELEASE
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;

        IF wk_release =  '2.5.0.0' THEN
    
	        BEGIN      
	        		EXECUTE IMMEDIATE 'UPDATE WFS.SYSTEM_SETTINGS SET setting_value=''2.7''     WHERE setting_type = ''RELEASE''';  
	        		EXECUTE IMMEDIATE 'UPDATE WFS.SYSTEM_RELEASE  SET setting_value=''2.7.0.0'' WHERE setting_type = ''RELEASE''';  
	        EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
					err_msg :=SUBSTR(SQLERRM, 1, 500);
					EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
	            	 					'Unable update WFS.SYSTEM_SETTINGS from 1.6 to 1.7.'')';
	            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
	        	GOTO bypass_install; 
	        END;
        END IF;

   /*
    ---------------------------------------------------------------------------
            Start of Convert release 2.6.0.0 to 2.7.0.0
    ---------------------------------------------------------------------------
    */

        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_RELEASE
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;

        IF wk_release =  '2.6.0.0' THEN
    		--TODO: call recreate authorization for 2.6
	        BEGIN      
	        		EXECUTE IMMEDIATE 'UPDATE WFS.SYSTEM_SETTINGS SET setting_value=''2.7''     WHERE setting_type = ''RELEASE''';  
	        		EXECUTE IMMEDIATE 'UPDATE WFS.SYSTEM_RELEASE  SET setting_value=''2.7.0.0'' WHERE setting_type = ''RELEASE''';  
	        EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
					err_msg :=SUBSTR(SQLERRM, 1, 500);
					EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
	            	 					'Unable update WFS.SYSTEM_SETTINGS from 1.6 to 1.7.'')';
	            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
	        	GOTO bypass_install; 
	        END;
        END IF;
        
   /*
    ---------------------------------------------------------------------------
            Start of Convert release 2.7.0.0 to 2.8.0.0
    ---------------------------------------------------------------------------
    */
 		
        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;
        
		  IF wk_release =  '2.7' THEN
		  	 BEGIN
				EXECUTE IMMEDIATE 'ALTER TABLE WFS.TTV_RESOURCEGROUPQUEUEITEM ADD (ALLOCATIONKEY VARCHAR2(255) NULL)';
			 EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
					err_msg :=SUBSTR(SQLERRM, 1, 500);
					EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
	            	 					'Unable ADD ALLOCATIONKEY to WFS.TTV_RESOURCEGROUPQUEUEITEM.'')';
	            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
	        	GOTO bypass_install;
			 END;
			 
			 --create objects associated with PMM
			 BEGIN
	        		CreatePMM(); 
	        EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
					err_msg :=SUBSTR(SQLERRM, 1, 500);
					EXECUTE IMMEDIATE '(''An error occured while running the CreatePMM procedure.'')';
	        	GOTO bypass_install; 
	       END;
	       
	       --Create the QRTZ objects
	       BEGIN
	        		CreateQRTZ(); 
	       EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
					err_msg :=SUBSTR(SQLERRM, 1, 500);
					EXECUTE IMMEDIATE '(''An error occured while running the CreateQRTZ procedure.'')';
	        	GOTO bypass_install; 
	       END;
	       
			 BEGIN
	        		EXECUTE IMMEDIATE 'UPDATE WFS.SYSTEM_SETTINGS SET setting_value=''2.8''     WHERE setting_type = ''RELEASE''';  
	        		EXECUTE IMMEDIATE 'UPDATE WFS.SYSTEM_RELEASE  SET setting_value=''2.8.0.0'' WHERE setting_type = ''RELEASE''';  
	        EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
					err_msg :=SUBSTR(SQLERRM, 1, 500);
					EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
	            	 					'Unable update WFS.SYSTEM_SETTINGS from 2.7 to 2.8.'')';
	            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
	        	GOTO bypass_install; 
	        END;

		  END IF;

   /*
    ---------------------------------------------------------------------------
            Start of Convert release 2.8.0.0 to 2.9.0.0 (Neptune)
    ---------------------------------------------------------------------------
    */
 		
        EXECUTE IMMEDIATE 'SELECT setting_value
        FROM WFS.SYSTEM_SETTINGS
        WHERE setting_type = ''RELEASE'''
        INTO wk_release;
        
		  IF wk_release =  '2.8' THEN
        vsql := 'alter table '||vschema||'.ttv_resource drop constraint FK_TTV_RESOURCE_USERDATA';
        CREATEOBJECT(vsql,'Unable to drop constraint FK_TTV_RESOURCE_USERDATA','Y');

        vsql := 'drop table '||vschema||'.TTV_MODULE cascade constraints';
        CREATEOBJECT(vsql,'Unable to drop table TTV_MODULE','Y');

        vsql := 'drop sequence '||vschema||'.TTV_MODULE_SEQ';
        CREATEOBJECT(vsql,'Warning: Unable to drop sequence TTV_MODULE_SEQ','Y');

        vsql := 'drop table '||vschema||'.TTV_PERMISSION cascade constraints';
        CREATEOBJECT(vsql,'Unable to drop table TTV_PERMISSION','Y');

        vsql := 'drop sequence '||vschema||'.TTV_PERMISSION_SEQ';
        CREATEOBJECT(vsql,'Warning: Unable to drop sequence TTV_PERMISSION_SEQ','Y');

        vsql := 'drop table '||vschema||'.TTV_ACTION cascade constraints';
        CREATEOBJECT(vsql,'Unable to drop table TTV_ACTION','Y');
			 
        vsql := 'drop sequence '||vschema||'.TTV_ACTION_SEQ';
        CREATEOBJECT(vsql,'Warning: Unable to drop sequence TTV_ACTION_SEQ','Y');

        vsql := 'drop table '||vschema||'.TTV_MENUITEM cascade constraints';
        CREATEOBJECT(vsql,'Unable to drop table TTV_MENUITEM','Y');

        vsql := 'drop sequence '||vschema||'.TTV_MENUITEM_SEQ';
        CREATEOBJECT(vsql,'Warning: Unable to drop sequence TTV_MENUITEM_SEQ','Y');

        vsql := 'drop table '||vschema||'.TTV_BIGROLEPERMISSION cascade constraints';
        CREATEOBJECT(vsql,'Unable to drop table TTV_BIGROLEPERMISSION','Y');

        vsql := 'drop sequence '||vschema||'.TTV_BIGROLEPERMISSION_SEQ';
        CREATEOBJECT(vsql,'Warning: Unable to drop sequence TTV_BIGROLEPERMISSION_SEQ','Y');

        vsql := 'drop table '||vschema||'.BIGROLEPERMISSION cascade constraints';
        CREATEOBJECT(vsql,'Unable to drop table BIGROLEPERMISSION','Y');

        vsql := 'drop table '||vschema||'.BIGROLE cascade constraints';
        CREATEOBJECT(vsql,'Unable to drop table BIGROLE','Y');

        vsql := 'drop table '||vschema||'.BIGROLE_ROLE cascade constraints';
        CREATEOBJECT(vsql,'Unable to drop table BIGROLE_ROLE','Y');

        vsql := 'drop table '||vschema||'.USER_BIGROLE cascade constraints';
        CREATEOBJECT(vsql,'Unable to drop table USER_BIGROLE','Y');

        vsql := 'drop table '||vschema||'.USER_DATA cascade constraints';
        CREATEOBJECT(vsql,'Unable to drop table USER_DATA','Y');

        vsql := 'drop table '||vschema||'.USERS_REALM cascade constraints';
        CREATEOBJECT(vsql,'Unable to drop table USERS_REALM','Y');
        
        /* Suneeta changes on 3/29/09 */
        vsql := 'alter table '||vschema||'.PMM_PROGRESSITEM add (titleRevision varchar2(25) not null, sourcecomponentname varchar2(25) not null,sourceEntityName varchar2(25),sourceId varchar2(100) not null)';
        CREATEOBJECT(vsql,'Add pmm_progressitem.titlerevision,sourcecomponentname,sourceEntityName,sourceId','Y');        

        vsql := 'alter table '||vschema||'.PMM_PROGRESSITEM drop (tokenid,processid) cascade constraints';
        CREATEOBJECT(vsql,'Drop pmm_progressitem (tokenid,processid) columns','Y');

        vsql := 'alter table '||vschema||'.PMM_PROGRESSITEM rename column TITLEREVISION to TITLEVERSION';
        CREATEOBJECT(vsql,'alter table PMM_PROGRESSITEM rename TITLEREVISION','Y');

        vsql := 'ALTER TABLE '||vschema||'.PMM_TITLE ADD ASSET_ID NUMBER';
        CREATEOBJECT(vsql,'alter table PMM_TITLE ADD ASSET_ID','Y');

/*      Cross Product dependency. Moved the constraint creation to Metadata create script.
        vsql := 'ALTER TABLE '||vschema||'.PMM_TITLE ADD CONSTRAINT PMM_TITLE_ASSET FOREIGN KEY (ASSET_ID) REFERENCES '||vschema||'.MDM_ASSET(ID)';
        CREATEOBJECT(vsql,'alter table PMM_TITLE FOREIGN KEY ASSET_ID','Y');
*/
        /* Raj changes on 3/29/09 */
        vsql := 'drop table '||vschema||'.PMM_TITLEMETADATA cascade constraints';
        CREATEOBJECT(vsql,'Drop table PMM_TITLEMETADATA','Y');

        vsql := 'alter table '||vschema||'.PMM_TITLE drop (TITLENAME,SPECIFICATION,PARENTID,ROOTTITLEID,INTERNALLOCATION,METADATALOCATION) cascade constraints';
        CREATEOBJECT(vsql,'alter table PMM_TITLE drop columns','Y');
        
        /* Suneeta changes on 5/12/2009 */
        vsql := 'alter table '||vschema||'.PMM_TITLE drop ISACTIVE cascade constraints';
        CREATEOBJECT(vsql,'alter table PMM_TITLE drop column ISACTIVE','Y');
        
        /* By Suneeta 05/14/09 */
         vsql := 'merge into '||vschema||'.PMM_TitleStatus p
          using (select 0 as id, ''DRAFT'' as descr from dual) a
          on (p.id_ = a.id)
          when matched then
          update set p.description = a.descr
          when not matched then
          insert (id_,description)
          values (a.id,a.descr)';
        CREATEOBJECT(vsql,'Merge into PMM_TitleStatus ID 0','Y');

        vsql := 'merge into '||vschema||'.PMM_TitleStatus p
        using (select 1 as id, ''COMMITTED'' as descr from dual) a
        on (p.id_ = a.id)
        when matched then
        update set p.description = a.descr
        when not matched then
        insert (id_,description)
        values (a.id,a.descr)';
        CREATEOBJECT(vsql,'Merge into PMM_TitleStatus ID 1','Y');

        vsql := 'merge into '||vschema||'.PMM_TitleStatus p
        using (select 2 as id, ''READY'' as descr from dual) a
        on (p.id_ = a.id)
        when matched then
        update set p.description = a.descr
        when not matched then
        insert (id_,description)
        values (a.id,a.descr)';
        CREATEOBJECT(vsql,'Merge into PMM_TitleStatus ID 2','Y');
        
        vsql := 'merge into '||vschema||'.PMM_TitleStatus p
        using (select 3 as id, ''APPROVED'' as descr from dual) a
        on (p.id_ = a.id)
        when matched then
        update set p.description = a.descr
        when not matched then
        insert (id_,description)
        values (a.id,a.descr)';
        CREATEOBJECT(vsql,'Merge into PMM_TitleStatus ID 3','Y');

        vsql := 'merge into '||vschema||'.PMM_TitleStatus p
        using (select 4 as id, ''RETIRED'' as descr from dual) a
        on (p.id_ = a.id)
        when matched then
        update set p.description = a.descr
        when not matched then
        insert (id_,description)
        values (a.id,a.descr)';
        CREATEOBJECT(vsql,'Merge into PMM_TitleStatus ID 4','Y');
       
        --create table PMM_TITLEASSETSTATUS. 
        vsql := 'create table '||vschema||'.PMM_TITLEASSETSTATUS(
                  id number,
                  titleid number,
                  assetVersion varchar2(10),
                  titlestatus number,
                  CREATEDATE TIMESTAMP (6) DEFAULT (SYSTIMESTAMP), 
                  UPDATEDATE TIMESTAMP (6) DEFAULT (SYSTIMESTAMP),
                  constraint pk_pmmtitleassetstation primary key (id),
                  CONSTRAINT fk_pmmtas_titleSTATUS  FOREIGN KEY (titlestatus)  REFERENCES '||vschema||'.pmm_titlestatus(id_),
                  CONSTRAINT fk_pmmtas_TITLEid  FOREIGN KEY (titleid) REFERENCES '||vschema||'.pmm_title(id_)            
                  )';
        CREATEOBJECT(vsql,'Unable to create table PMM_TITLEASSETSTATUS','Y');
        CREATESEQ('PMM_TITLEASSETSTATUS');
        CREATEUPDATETRG('PMM_TITLEASSETSTATUS');

        --alter table PMM_PROGRESSITEM. By QA/Dipti. 05/29/09
        vsql := 'alter table '||vschema||'.PMM_PROGRESSITEM modify (DESCRIPTION varchar2(1000))';
        CREATEOBJECT(vsql,'Unable to alter table PMM_PROGRESSITEM ','Y');
        
        --alter table PMM_JOB. By Suneeta. 06/08/09
        vsql := 'ALTER TABLE '||vschema||'.PMM_JOB MODIFY (TEMPLATENAME VARCHAR2(255) NULL)';
        CREATEOBJECT(vsql,'Unable to alter table PMM_JOB','Y');

        vsql := 'ALTER TABLE '||vschema||'.PMM_JOB MODIFY (PROCESSPRIORITYID NUMBER NULL)';
        CREATEOBJECT(vsql,'Unable to alter table PMM_JOB','Y');
        
        --alter table PMM_PROGRESSITEM . By Suneeta. 06/17/09
        vsql := 'ALTER TABLE '||vschema||'.PMM_PROGRESSITEM MODIFY (name varchar(50))';
        CREATEOBJECT(vsql,'Unable to alter table PMM_PROGRESSITEM','Y');

        --create table PMM_CONTAINER_PROPERTIES. By Suneeta 07/06/09
        vsql := 'CREATE TABLE '||vschema||'.PMM_CONTAINER_PROPERTIES(
                  id number PRIMARY KEY,
                  contextid number,
                  name varchar2(100),
                  value varchar2(250),
                  CREATEDATE TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL , 
                  UPDATEDATE TIMESTAMP(0) DEFAULT (SYSTIMESTAMP) NOT NULL, 
                  CONSTRAINT CONTEXTID_FK FOREIGN KEY (contextid) REFERENCES '||vschema||'.PMM_CONTEXT(id_)
                  )';
        CREATEOBJECT(vsql,'Unable to create table PMM_CONTAINER_PROPERTIES');
        CREATESEQ('PMM_CONTAINER_PROPERTIES');
        CREATEUPDATETRG('PMM_CONTAINER_PROPERTIES');
        
        --By Suneeta 07/29/09
        vsql := 'insert into '||vschema||'.pmm_listtype (id_, description) values(4, ''Title List'')';
        CREATEOBJECT(vsql,'Unable to insert into pmm_listtype','Y');

        vsql := 'alter table '||vschema||'.pmm_title_titlelistxref add ORDER_ number default 0 not null';
        CREATEOBJECT(vsql,'Unable to alter table pmm_title_titlelistxref','Y');
        
        --By Suneeta 08/04/09
        vsql := 'alter table '||vschema||'.PMM_PROGRESSITEM add ISACTIVE NUMBER(1,0) DEFAULT (1) not null';
        CREATEOBJECT(vsql,'Unable to alter table PMM_PROGRESSITEM','Y');
        
        vsql := 'alter table '||vschema||'.PMM_Title_TitleListXREF drop constraint PK_PMM_TITLE_TITLELISTXREF';
        CREATEOBJECT(vsql,'Unable to alter table PMM_Title_TitleListXREF','Y');
        
        vsql := 'alter table '||vschema||'.PMM_Title_TitleListXREF ADD (CONSTRAINT PK_PMM_Title_TitleListXREF PRIMARY KEY (TitleListId, TitleId,ORDER_))';
        CREATEOBJECT(vsql,'Unable to alter table PMM_Title_TitleListXREF','Y');

        vsql := 'alter table '||vschema||'.JBPM_VARIABLEINSTANCE modify (stringvalue_ varchar2(4000))';
        CREATEOBJECT(vsql,'Unable to alter table PMM_Title_TitleListXREF','Y');

        --By Sahil, 08/24/09
	      vsql := 'INSERT INTO '||vschema||'.ALERT_NAMES (ALERT_NAME,PATTERN) values (''Pitch Schedule Notification Pattern'',''.*titles did not achieve status.*'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERT_NAMES','Y');

        vsql := 'INSERT INTO '||vschema||'.ALERT_NAMES (ALERT_NAME,PATTERN) values (''Drive Status'',''.*drive status.*'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERT_NAMES','Y');

        vsql := 'INSERT INTO '||vschema||'.ALERT_NAMES (ALERT_NAME,PATTERN) values (''Planner Notification Pattern'',''.*assets for planner.*'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERT_NAMES','Y');

        vsql := 'INSERT INTO '||vschema||'.ALERTS(IDENTIFIER,ALERT_NAME,THRESH_COUNT,THRESH_SECS,FREQ_COUNT,FREQ_SECS,TYPE) VALUES (''Pitch Schedule Notification'',''Pitch Schedule Notification Pattern'',1,3600,1,3600,''LOG'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y');

        vsql := 'INSERT INTO '||vschema||'.ALERTS(IDENTIFIER,ALERT_NAME,THRESH_COUNT,THRESH_SECS,FREQ_COUNT,FREQ_SECS,TYPE) VALUES (''Drive Status'',''Drive Status'',1,3600,1,3600,''LOG'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y');

        vsql := 'INSERT INTO '||vschema||'.ALERTS(IDENTIFIER,ALERT_NAME,THRESH_COUNT,THRESH_SECS,FREQ_COUNT,FREQ_SECS,TYPE) VALUES (''Planner Notification'',''Planner Notification Pattern'',1,3600,1,3600,''LOG'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y');

        vsql := 'Insert into '||vschema||'.ALERT_ACTIONS (IDENTIFIER,ACTION_TYPE,DETAIL) values (''Planner Notification'',1,''13'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y');

        vsql := 'Insert into '||vschema||'.ALERT_ACTIONS (IDENTIFIER,ACTION_TYPE,DETAIL) values (''Drive Status'',1,''14'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y');

        vsql := 'Insert into '||vschema||'.ALERT_ACTIONS (IDENTIFIER,ACTION_TYPE,DETAIL) values (''Pitch Schedule Notification'',1,''13'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERT_ACTIONS','Y');

        vsql := 'DELETE FROM '||vschema||'.TTV_MONITOREDDRIVEHISTORY''';
        CREATEOBJECT(vsql,'Unable to delete from TTV_MONITOREDDRIVEHISTORY');
        
        vsql := 'DELETE FROM '||vschema||'.ttv_MONITOREDDRIVE''';
        CREATEOBJECT(vsql,'Unable to delete from ttv_MONITOREDDRIVE');
        
        vsql := 'INSERT INTO '||vschema||'.ttv_MONITOREDDRIVE (monitoreddriveid, name, description, path, internaldriveid, totalcapacity, warningthresholdpercent, errorthresholdpercent, currentbytesused, currentdrivestatusid,CreateDate, UpdateDate) 
					VALUES ('||vschema||'.ttv_MONITOREDDRIVE_SEQ.NEXTVAL, ''Content'', ''Drive for mapped and unmapped assets in PMM'', ''/content'', 1, 100000000000, 50, 75, 0, 0, sysdate,sysdate)';        
        CREATEOBJECT(vsql,'Unable to insert into ttv_MONITOREDDRIVE');

        vsql := 'ALTER TABLE '||vschema||'.pmm_progressitem modify (name varchar2(255))';        
        CREATEOBJECT(vsql,'Unable to alter table pmm_progressitem name column');

        vsql := 'ALTER TABLE '||vschema||'.alerts_hist modify (msg varchar2(4000))';        
        CREATEOBJECT(vsql,'Unable to alter table alerts_hist msg column');
        
        --Vlada on Oct 21 2009
        vsql := 'INSERT INTO '||vschema||'.ALERT_NAMES(ALERT_NAME, PATTERN) VALUES(''Login Failed Pattern'', ''.*Login failed for.*'')';
        CREATEOBJECT(vsql,'Unable to insert into alert_names','Y');
        
        vsql := 'INSERT INTO '||vschema||'.ALERTS(IDENTIFIER, ALERT_NAME, THRESH_COUNT, THRESH_SECS, FREQ_COUNT, FREQ_SECS, TYPE)
            VALUES(''Login Failed'', ''Login Failed Pattern'', 1, 3600, 1, 3600, ''LOG'')';
        CREATEOBJECT(vsql,'Unable to insert into ALERTS','Y');

        vsql := 'INSERT INTO '||vschema||'.ALERT_ACTIONS(IDENTIFIER, ACTION_TYPE, DETAIL) VALUES(''Login Failed'', 1, ''4'')';
        CREATEOBJECT(vsql,'Unable to insert into alert_actions','Y');

        --Create indexes on all Foreign keys of JBPM_LOG to prevent it getting locked exclusively when deleting rows from JBPM_VARIABLEINSTANCE table
        declare
          cursor c1 is select 'CREATE INDEX '||vschema||'.IDX_JPLOG_'||substr(ucc.column_name,1,12)||'_'||ucc.position||' on '||vschema||'.JBPM_LOG('||ucc.column_name||')' as crindex
                        from dba_constraints uc, dba_cons_columns ucc , dba_constraints uc1
                        where uc.constraint_name = ucc.constraint_name
                        and uc.table_name = ucc.table_name
                        and uc.owner=ucc.owner
                        and uc.owner = upper(vschema)
                        and uc.constraint_type='R'
                        and uc.table_name = 'JBPM_LOG'
                        and uc.r_constraint_name = uc1.constraint_name
                        and uc.owner = uc1.owner;
        begin
          for r1 in c1 loop
              CREATEOBJECT(r1.crindex,'Unable to create index on JBPM_LOG table','Y');
          end loop;
        end;

       BEGIN
	        		EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_SETTINGS SET setting_value=''2.9''     WHERE setting_type = ''RELEASE''';  
	        		EXECUTE IMMEDIATE 'UPDATE '||vschema||'.SYSTEM_RELEASE  SET setting_value=''2.9.0.0'' WHERE setting_type = ''RELEASE''';  
	        EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
					err_msg :=SUBSTR(SQLERRM, 1, 500);
          dbms_output.put_line('convertwfs error:'||err_msg);
					EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''error in upgrade of application database objects:'||
	            	 					'Unable update '||vschema||'.SYSTEM_SETTINGS from 2.8 to 2.9.'')';
	            EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values ('''||err_msg||''')';
	        	GOTO bypass_install; 
	        END;

		  END IF;
			<<bypass_install>>
  
          COMMIT;
          
          IF wk_message = 'ERROR' THEN
          	
          	 RAISE createWFSDB.INSTALL_FAILED;
             
          ELSE
          
             EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values
           (''Installation of PMM completed SUCCESSFULLY'')';
             
          END IF;
    END ConvertWFS;

    PROCEDURE INSTALL_WFS IS
		  error		number(1,0) := 0;
        wk_count	number;
        wk_message varchar2(255);
        err_msg		varchar2(500);
    BEGIN
    	  
		  SELECT COUNT(*) 
		  INTO 	wk_count 
		  FROM 	dba_tables 
		  WHERE	OWNER = 'WFS';

        IF wk_count < 20 THEN
        	  BEGIN
	        	  createWFS();
	        EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
					EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values('||sqlerrm||'An error occured while running the createWFS procedure.'')';
	        	GOTO bypass_install; 
	        END;
	        BEGIN
	        	  CreatePMM(); 
	        EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
					EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''An error occured while running the CreatePMM procedure.'')';
	        	GOTO bypass_install; 
	        END;
	        BEGIN
	        		CreateQRTZ(); 
	        EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
					EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''An error occured while running the CreateQRTZ procedure.'')';
	        	GOTO bypass_install; 
	        END;
        ELSE
          BEGIN
          		ConvertWFS();
	        EXCEPTION 
				WHEN OTHERS THEN
					wk_message := 'ERROR';
          err_msg := replace(SUBSTR(SQLERRM, 1, 500),'''','');
          dbms_output.put_line('Error Message:'||err_msg);
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values('''||err_msg||' An error occured while running the convertWFS procedure.'')';
	        	GOTO bypass_install; 
        END;
        END IF;
        
		  <<bypass_install>>
		  COMMIT;
        IF wk_message = 'ERROR' THEN        	
        	 null;
        ELSE
          EXECUTE IMMEDIATE 'INSERT INTO install_table(install_message) values(''Installation completed SUCCESSFULLY'')';
        END IF;
    END INSTALL_WFS;  
END createWFSDB;
/

begin
 createwfsdb.install_wfs();
end;
/

select * from install_table;

exit