set serveroutput on
set echo on

declare
	vcount number;
	vfilepath varchar2(4000);
begin
	select count(1) 
	into vcount
	from v$parameter
	where name='db_create_file_dest';

	if vcount = 0 then
		select substr(file_name,1,instr(file_name,'/',-1) -1)
		into vfilepath
		from dba_data_files
		where tablespace_name='SYSTEM';
		
		execute immediate 'alter system set db_create_file_dest='''||vfilepath||''' scope=both';
	end if;

	select count(1) 
	into vcount
	from dba_tablespaces
	where tablespace_name='TSTV_RCS';

	if vcount = 0 then
		execute immediate 'create tablespace tstv_rcs datafile size 500m autoextend on next 100m maxsize unlimited extent management local autoallocate segment space management auto';
	end if;
	
	select count(1) 
	into vcount
	from dba_directories
	where directory_name='TSTVXMLDIR';

	if vcount = 0 then
		execute immediate 'create directory tstvxmldir as ''/home/oracle/tstv''';
	end if;

	select count(1)
	into vcount
	from dba_users
	where username='RCS';

	if vcount = 1 then
		execute immediate 'drop user rcs cascade';
	end if;

end;
/

create user rcs identified by rcs default tablespace tstv_rcs;
grant all on directory tstvxmldir to public,rcs;
grant connect,resource,CREATE SESSION,create any view,CREATE TABLE,CREATE TRIGGER,CREATE TYPE,ALTER SESSION,xdbadmin,CREATE SEQUENCE to rcs;
grant all on dbms_xmlschema to rcs;
grant all on dbms_errlog to rcs;

conn rcs/rcs

BEGIN
      DBMS_XMLSCHEMA.registerSchema(
        SCHEMAURL => 'TTV_EPG.xsd',
        SCHEMADOC => bfilename('TSTVXMLDIR','TTV_EPG.xsd')
         ,CSID => nls_charset_id('AL32UTF8')
        );
END;
/

exit

