#! /usr/bin/ksh

# @version $Id: createWFS_DW.ksh,v 1.1 2009/10/22 22:33:42 dweiner Exp $

##
## create the data warehouse
##

export ORACLE_SID=$1
export log_directory=$2

echo "Creating the WatchPointDW database objects........"

sqlplus -s /nolog <<EOM5
   connect / as sysdba
   spool ${log_directory}/createWFSDW.log
   PROMPT creating the createWFSDW procedure PLEASE WAIT
   @createWFS_DW.sql
   PROMPT executing the createWFSDW procedure PLEASE WAIT
   set serveroutput on
   execute createWFSDWDB.createWFS_DW;
   select * From sys.install_table;
   select setting_value as "WatchPointDW Version"
     from wfsdw.system_settings 
     where setting_type = 'RELEASE';
   spool off
   exit
EOM5

sqlplus -s /nolog <<EOM6
   connect / as sysdba
   spool ${log_directory}/createWFSDWprocs.log
   PROMPT creating the WFSDW.PKG_METADATA package
   @createWFSmd_DW.sql
   PROMPT creating the WFSDW.PKG_DATALOAD package
   @createWFSload_DW.sql
   PROMPT creating the WFSDW.PKG_DATAAGG package
   @createWFSagg_DW.sql
   PROMPT creating the WFSDW.PKG_ADMIN package
   @createWFSadmin_DW.sql
   PROMPT creating the WFSDW.PKG_REPORTS
   @createWFSreport_DW.sql
   set define ~
   PROMPT loading date & time dimensions
   set define &
   @loadWFSdim_DW.sql
   spool off
   exit
EOM6
