#!/bin/sh

DB_INSTALL_LOG=cmsdwinstall.log
CREATE_WFS_DB_LOG=createWFSDW.log
INSTALL_DIR=/opt/oracle/admin/DWT1/scripts

grep -q DWT1 /etc/oratab
if [ $? -ne 0 ]; then
        echo "Adding DWT1 entry in /etc/oratab"
        echo "DWT1:/opt/oracle/product/11.2.0/dbhome_1:Y" >> /etc/oratab
fi

chown -R oracle:dba /opt/oracle/admin/DWT1
cd ${INSTALL_DIR}

su - oracle -c "sh ${INSTALL_DIR}/masterDW.sh 2>&1 | tee ${INSTALL_DIR}/${DB_INSTALL_LOG}"

echo "*********************************************************"
if  grep -q "ORA-\|SP2-\|Permission denied\|SQL-" "${INSTALL_DIR}/${CREATE_WFS_DB_LOG}" 
then
        echo "CMS DW Install script probably failed! Check ${INSTALL_DIR}/${CREATE_WFS_DB_LOG} file for any errors"
        exit 1
else
        echo "CMS DW INSTALL SCRIPT SUCCEEDED!"
fi
echo "*********************************************************"
exit 0
