#Master CMS Datawarehouse script to be executed as oracle user
#Make sure you are in the required directory
cd $ORACLE_BASE/admin/DWT1/scripts
#
HOST_NAME=`hostname`
CURRENT_PATH=`pwd`
#
#Create DW DB
echo "Creating DWT1 instance"
sh ${CURRENT_PATH}/DWT1.sh
#
#Change HOSTNAME to machine name
echo "Replacing hostname to machine name"
sed "s/HOSTNAME/$HOST_NAME/" < ${CURRENT_PATH}/netcabackup.rsp > ${CURRENT_PATH}/netca.rsp
#
echo "Invoking netca to create WFS_PRODUCTIONDB tnsnames entry"
netca /silent -responsefile ${CURRENT_PATH}/netca.rsp
#
echo "Creating DW Schema and Objects"
sh ${CURRENT_PATH}/createWFS_DW.ksh DWT1 ${CURRENT_PATH}
#
echo "Setting up cron job to refresh DW"
crontab ${CURRENT_PATH}/crontabwfsdw
