/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.LogModule;

import com.n2bb.LogModule.N2BB_LogMessage;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Calendar;

public class N2BB_LogManager {
    private static N2BB_LogManager instance_ = null;
    private String facility_;
    private String hostName_;
    private String ipAddress_;
    private boolean isReady_ = true;
    DatagramSocket dgSocket_ = null;
    int logServerPort_ = 0;
    InetAddress logServerAddress_ = null;

    public static N2BB_LogManager instance(String string) {
        if (instance_ == null) {
            instance_ = new N2BB_LogManager(string);
        } else if (instance_.getFacility() != string) {
            instance_.setFacility(string);
        }
        return instance_;
    }

    public static N2BB_LogManager instance() {
        return instance_;
    }

    public static void shutdown() {
        if (instance_ != null) {
            // empty if block
        }
        instance_ = null;
    }

    public boolean isReady() {
        return this.isReady_;
    }

    public String getFacility() {
        return this.facility_;
    }

    public boolean log(N2BB_LogMessage n2BB_LogMessage) {
        boolean bl = false;
        if (!this.isReady_) {
            this.isReady_ = this.establishConnections();
            if (this.logServerPort_ != 0) {
                this.logServerPort_ = this.getLogServerPort();
            }
        }
        if (this.isReady_) {
            int n;
            String string = n2BB_LogMessage.formatMessage();
            String string2 = new String("");
            if (string.length() >= 0) {
                String string3 = n2BB_LogMessage.getFacility();
                if (string3 == null) {
                    string3 = this.facility_;
                }
                string2 = string3 + " " + n2BB_LogMessage.getLogLevel() + " " + this.ipAddress_ + " " + string;
            }
            if ((n = string2.length()) > 0) {
                DatagramPacket datagramPacket = new DatagramPacket(string2.getBytes(), n, this.logServerAddress_, this.logServerPort_);
                try {
                    if (this.dgSocket_ != null) {
                        this.dgSocket_.send(datagramPacket);
                        bl = true;
                    }
                }
                catch (IOException iOException) {
                    System.out.println("N2BB_LogManager::log - Unable to send message to the log server. Exception caught");
                    System.out.println("Exception : " + iOException.toString());
                    bl = false;
                }
            }
        } else {
            System.out.println("N2BB_LogManager::log - Unable to log Messages. System is not ready to log messages");
        }
        return bl;
    }

    protected N2BB_LogManager(String string) {
        this.facility_ = string;
        this.isReady_ = this.establishConnections() && this.isReady_;
        this.logServerPort_ = this.getLogServerPort();
    }

    protected void setFacility(String string) {
        this.facility_ = string;
    }

    protected String getDateAndTime() {
        Calendar calendar = Calendar.getInstance();
        String string = calendar.get(2) + 1 + "/" + calendar.get(5) + "/" + calendar.get(1) + " " + calendar.get(11) + ":" + calendar.get(12) + ":" + calendar.get(13);
        return string;
    }

    private boolean establishConnections() {
        boolean bl = true;
        try {
            this.dgSocket_ = null;
            this.logServerAddress_ = null;
            this.dgSocket_ = new DatagramSocket();
            this.logServerAddress_ = InetAddress.getLocalHost();
            if (this.logServerAddress_ != null) {
                this.ipAddress_ = this.logServerAddress_.getHostAddress();
                this.hostName_ = this.logServerAddress_.getHostName();
                bl = true;
            }
        }
        catch (SocketException socketException) {
            System.out.println("N2BB_LogManager::establishConnections - Unable to create a new DatagramSocket. SocketException caught");
            System.out.println("Exception is : " + socketException.toString());
            bl = false;
        }
        catch (UnknownHostException unknownHostException) {
            System.out.print("N2BB_LogManager::establishConnections - Unable to get host information. Exception caught. ");
            System.out.println("Exception is " + unknownHostException.toString());
            bl = false;
        }
        return bl;
    }

    private int getLogServerPort() {
        return 60101;
    }
}

