/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.boot;

import com.tandbergtv.workflow.adaptor.AdaptorException;
import com.tandbergtv.workflow.adaptor.IAdaptor;
import com.tandbergtv.workflow.adaptor.conf.AdaptorConfigurationImpl;
import com.tandbergtv.workflow.adaptor.conf.IAdaptorConfiguration;
import com.tandbergtv.workflow.adaptor.conf.IMessageProcessorConfiguration;
import com.tandbergtv.workflow.adaptor.conf.PluginConfigurationLoader;
import com.tandbergtv.workflow.adaptor.internal.DefaultAdaptor;
import com.tandbergtv.workflow.adaptor.messageidentifier.IMessageIdentifier;
import com.tandbergtv.workflow.adaptor.registry.AdaptorRegistryImpl;
import com.tandbergtv.workflow.adaptor.registry.IAdaptorRegistry;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.queue.Queue;
import com.tandbergtv.workflow.core.queue.monitor.IQueueMonitor;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.command.internal.CommandExecutor;
import com.tandbergtv.workflow.message.queue.OffloadQueueProvider;
import com.tandbergtv.workflow.message.registry.IMessageRegistry;
import com.tandbergtv.workflow.message.registry.MessageRegistry;
import com.tandbergtv.workflow.pluginmanager.PluginManagement;
import com.tandbergtv.workflow.pluginmanager.WatchPointPluginManager;
import com.tandbergtv.workflow.pluginmanager.entities.AdaptorDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.MessageDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceTypeDescriptor;
import com.tandbergtv.workflow.util.ApplicationProperties;
import java.lang.management.ManagementFactory;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.log4j.Logger;
import org.java.plugin.PluginManager;

public class Activator {
    private static final String MQ_MBEAN_NAME = "com.tandbergtv.watchpoint:type=Queue,name=mq";
    private static final Logger logger = Logger.getLogger(Activator.class);

    public void start() {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        CommandExecutor executor = new CommandExecutor();
        this.addService(executor);
        String dir = this.getOffloadQueueDir();
        OffloadQueueProvider provider = new OffloadQueueProvider(executor, dir);
        Queue<WorkflowMessage> queue = provider.createQueue();
        Service service = (Service)queue;
        registry.register(service.getServiceName(), service);
        DefaultMediator.getInstance().register((IColleague)IColleague.class.cast(queue));
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            StandardMBean mbean = new StandardMBean((IQueueMonitor)queue, IQueueMonitor.class);
            server.registerMBean(mbean, new ObjectName(MQ_MBEAN_NAME));
        }
        catch (Exception e) {
            logger.warn((Object)"Message offload queue monitoring will not be available", (Throwable)e);
        }
        this.loadAdaptors();
    }

    public void stop() {
        this.removeService(PluginManagement.class);
        this.removeService(IMessageRegistry.class);
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            server.unregisterMBean(new ObjectName(MQ_MBEAN_NAME));
        }
        catch (Exception e) {
            logger.warn((Object)"Message offload queue MBean unregistration failed");
        }
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = registry.lookup("com.tandbergtv.workflow.mq");
        if (service != null) {
            DefaultMediator.getInstance().unregister((IColleague)IColleague.class.cast(service));
            service.stop();
            registry.unregister(service);
        }
        this.removeService(CommandExecutor.class);
    }

    private String getOffloadQueueDir() {
        String dir = null;
        try {
            dir = ApplicationProperties.getInstance().getProperty("install.dir");
        }
        catch (Exception e) {
            throw new RuntimeException("Application install directory is not configured", e);
        }
        return dir;
    }

    private void addService(Service service) {
        ServiceRegistry.getDefault().register(service.getServiceName(), service);
        service.start();
    }

    private void removeService(Class<? extends Service> clazz) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = (Service)registry.lookup(clazz);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }

    private void loadAdaptors() {
        Service service = ServiceRegistry.getDefault().lookup("WatchPointPlugin");
        PluginManager pm = PluginManager.lookup((Object)service);
        this.addService(new WatchPointPluginManager(pm));
        AdaptorRegistryImpl registry = new AdaptorRegistryImpl();
        this.addService(registry);
        MessageRegistry messages = MessageRegistry.getInstance();
        this.addService(messages);
        DefaultAdaptor adaptor = new DefaultAdaptor();
        adaptor.init((IAdaptorConfiguration)new AdaptorConfigurationImpl());
        registry.setDefaultAdaptor(adaptor);
        logger.debug((Object)"loading plugins...");
        PluginManagement pluginmanager = (PluginManagement)ServiceRegistry.getDefault().lookup(PluginManagement.class);
        for (ResourceTypeDescriptor rt : pluginmanager.getResourceTypeDescriptors()) {
            logger.debug((Object)("Descriptor : " + rt.getName()));
            for (String key : rt.getMessages().keySet()) {
                MessageDescriptor messageDesciptor = rt.getMessages().get(key);
                messages.addMessage(messageDesciptor.getUID(), messageDesciptor.getName());
            }
            AdaptorDescriptor descriptor = rt.getAdaptor();
            if (descriptor == null) continue;
            this.loadAdaptor(descriptor, rt, registry);
        }
    }

    private void loadAdaptor(AdaptorDescriptor descriptor, ResourceTypeDescriptor rt, IAdaptorRegistry registry) {
        String className = descriptor.getAdaptorClass();
        if (descriptor.isDefault()) {
            this.updateDefaultAdaptor(descriptor, rt, (DefaultAdaptor)registry.getDefaultAdaptor());
        } else {
            try {
                IAdaptor a = this.getAdaptor(className, rt.getClassLoader(), descriptor.getProperties());
                registry.registerAdaptor(className, a);
            }
            catch (AdaptorException e) {
                logger.error((Object)("Error registering adaptor class " + className), (Throwable)e);
            }
        }
    }

    private void updateDefaultAdaptor(AdaptorDescriptor descriptor, ResourceTypeDescriptor rt, DefaultAdaptor adaptor) {
        ClassLoader cl = rt.getClassLoader();
        String className = descriptor.getMessageIdentifierClass();
        if (className != null && className.length() > 0) {
            try {
                logger.debug((Object)("Adding message identifier class " + className));
                IMessageIdentifier id = this.getMessageIdentifier(className, cl);
                adaptor.addMessageIDClass(id);
            }
            catch (AdaptorException e) {
                logger.error((Object)("Error adding message identifier class " + className), (Throwable)e);
            }
        }
        Map<String, MessageDescriptor> messages = rt.getMessages();
        for (String key : messages.keySet()) {
            MessageDescriptor messageDesciptor = messages.get(key);
            MessageUIDImpl uid = new MessageUIDImpl(messageDesciptor.getUID());
            IMessageProcessorConfiguration conf = new PluginConfigurationLoader().getConfiguration(cl, (IMessageUID)uid);
            logger.debug((Object)("Adding configuration for UID " + uid));
            adaptor.addConfiguration((IMessageUID)uid, conf);
        }
    }

    private IAdaptor getAdaptor(String className, ClassLoader classLoader, Map<String, String> properties) throws AdaptorException {
        IAdaptor adaptor;
        try {
            logger.debug((Object)("Registering adaptor:" + className));
            Class<?> idClass = classLoader.loadClass(className);
            adaptor = (IAdaptor)idClass.newInstance();
            adaptor.init((IAdaptorConfiguration)new AdaptorConfigurationImpl(properties));
        }
        catch (ClassNotFoundException e) {
            throw new AdaptorException("Adaptor class " + className + " not found.", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new AdaptorException("Error instantiating an object of adaptor class " + className, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new AdaptorException("Error instantiating an object of adaptor " + className, (Throwable)e);
        }
        return adaptor;
    }

    private IMessageIdentifier getMessageIdentifier(String className, ClassLoader classLoader) throws AdaptorException {
        IMessageIdentifier id;
        try {
            Class<?> idClass = classLoader.loadClass(className);
            id = (IMessageIdentifier)idClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new AdaptorException("Message identifier class " + className + " not found.", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new AdaptorException("Error instantiating an object of message identifier class " + className, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new AdaptorException("Error instantiating an object of message identifier class " + className, (Throwable)e);
        }
        return id;
    }
}

