/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.licensing.generator;

import com.tandbergtv.workflow.core.licensing.generator.ILicenseGenerator;
import com.tandbergtv.workflow.core.licensing.generator.LicenseNotGeneratedException;
import com.tandbergtv.workflow.util.ApplicationProperties;
import com.tandbergtv.workflow.util.encryption.EncryptionUtil;
import java.io.File;

public class FileLicenseGenerator
implements ILicenseGenerator {
    private String licenseKeyFilePath;
    private static final String ENCRYPTED_FILE_NAME = "licensekey.lic";

    private String getConfigPath() throws LicenseNotGeneratedException {
        String configPath = null;
        try {
            ApplicationProperties properties = ApplicationProperties.getInstance();
            configPath = properties.getProperty("WorkflowApp.ConfigPath");
        }
        catch (Exception e) {
            throw new LicenseNotGeneratedException("Problems getting WorkflowApp.ConfigPath from application.properties file", e);
        }
        if (configPath == null || configPath.trim().length() == 0) {
            throw new LicenseNotGeneratedException("WorkflowApp.ConfigPath not specified in application.properties file");
        }
        return configPath;
    }

    public void setFileName(String fileName) throws LicenseNotGeneratedException {
        String configPath = this.getConfigPath();
        String filePath = null;
        this.licenseKeyFilePath = filePath = configPath.trim() + File.separator + fileName.trim();
    }

    @Override
    public void generateAndSave(String password) throws LicenseNotGeneratedException {
        EncryptionUtil encUtil = new EncryptionUtil();
        String configPath = this.getConfigPath();
        String encrFilePath = configPath.trim() + File.separator + ENCRYPTED_FILE_NAME;
        encUtil.encryptToFile(password, this.licenseKeyFilePath, encrFilePath);
    }
}

