/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.PathResolver;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.IntegrityCheckReport;
import org.java.plugin.registry.Library;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginElement;
import org.java.plugin.registry.PluginPrerequisite;
import org.java.plugin.registry.xml.ExtensionImpl;
import org.java.plugin.registry.xml.ExtensionPointImpl;
import org.java.plugin.registry.xml.LibraryImpl;
import org.java.plugin.registry.xml.PluginDescriptorImpl;
import org.java.plugin.registry.xml.PluginPrerequisiteImpl;
import org.java.plugin.registry.xml.PluginRegistryImpl;
import org.java.plugin.util.IoUtil;
import org.java.plugin.util.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IntegrityChecker
implements IntegrityCheckReport {
    private static Log log = LogFactory.getLog(IntegrityChecker.class);
    private final PluginRegistryImpl registry;
    private List<IntegrityCheckReport.ReportItem> items = new LinkedList<IntegrityCheckReport.ReportItem>();
    private int errorsCount;
    private int warningsCount;

    IntegrityChecker(PluginRegistryImpl pluginRegistryImpl, Collection<IntegrityCheckReport.ReportItem> collection) {
        this.registry = pluginRegistryImpl;
        for (IntegrityCheckReport.ReportItem reportItem : collection) {
            switch (reportItem.getSeverity()) {
                case ERROR: {
                    break;
                }
                case WARNING: {
                    ++this.warningsCount;
                    break;
                }
            }
            this.items.add(reportItem);
        }
    }

    void doCheck(PathResolver pathResolver) {
        int n = 0;
        this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "pluginsCheckStart", null));
        try {
            for (PluginDescriptor pluginDescriptor : this.registry.getPluginDescriptors()) {
                PluginDescriptorImpl pluginDescriptorImpl = (PluginDescriptorImpl)pluginDescriptor;
                ++n;
                this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, pluginDescriptorImpl, IntegrityCheckReport.Error.NO_ERROR, "pluginCheckStart", pluginDescriptorImpl.getUniqueId()));
                this.checkPlugin(pluginDescriptorImpl, pathResolver);
                this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, pluginDescriptorImpl, IntegrityCheckReport.Error.NO_ERROR, "pluginCheckFinish", pluginDescriptorImpl.getUniqueId()));
            }
        }
        catch (Exception exception) {
            log.error((Object)("integrity check failed for registry " + this.registry), (Throwable)exception);
            ++this.errorsCount;
            this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.ERROR, null, IntegrityCheckReport.Error.CHECKER_FAULT, "pluginsCheckError", exception));
        }
        this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "pluginsCheckFinish", n));
    }

    private void checkPlugin(PluginDescriptorImpl pluginDescriptorImpl, PathResolver pathResolver) {
        IntegrityCheckReport.ReportItem reportItem;
        Iterator<Object> iterator;
        Object object;
        PluginElement<PluginPrerequisite> pluginElement;
        int n = 0;
        this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, pluginDescriptorImpl, IntegrityCheckReport.Error.NO_ERROR, "prerequisitesCheckStart", pluginDescriptorImpl.getUniqueId()));
        for (PluginPrerequisite uniqueIdentity : pluginDescriptorImpl.getPrerequisites()) {
            pluginElement = (PluginPrerequisiteImpl)uniqueIdentity;
            ++n;
            if (((PluginPrerequisiteImpl)pluginElement).isOptional() || ((PluginPrerequisiteImpl)pluginElement).matches()) continue;
            ++this.errorsCount;
            this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.ERROR, pluginDescriptorImpl, IntegrityCheckReport.Error.UNSATISFIED_PREREQUISITE, "unsatisfiedPrerequisite", new Object[]{((PluginPrerequisiteImpl)pluginElement).getPluginId(), pluginDescriptorImpl.getUniqueId()}));
        }
        this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, pluginDescriptorImpl, IntegrityCheckReport.Error.NO_ERROR, "prerequisitesCheckFinish", new Object[]{n, pluginDescriptorImpl.getUniqueId()}));
        if (pathResolver != null) {
            n = 0;
            this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, pluginDescriptorImpl, IntegrityCheckReport.Error.NO_ERROR, "librariesCheckStart", pluginDescriptorImpl.getUniqueId()));
            for (Library library : pluginDescriptorImpl.getLibraries()) {
                pluginElement = (LibraryImpl)library;
                ++n;
                object = pathResolver.resolvePath(pluginElement, ((LibraryImpl)pluginElement).getPath());
                if (IoUtil.isResourceExists((URL)object)) continue;
                ++this.errorsCount;
                this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.ERROR, pluginElement, IntegrityCheckReport.Error.BAD_LIBRARY, "accesToResourceFailed", new Object[]{((LibraryImpl)pluginElement).getUniqueId(), pluginDescriptorImpl.getUniqueId(), object}));
            }
            this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, pluginDescriptorImpl, IntegrityCheckReport.Error.NO_ERROR, "librariesCheckFinish", new Object[]{n, pluginDescriptorImpl.getUniqueId()}));
        } else {
            this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, pluginDescriptorImpl, IntegrityCheckReport.Error.NO_ERROR, "librariesCheckSkip", pluginDescriptorImpl.getUniqueId()));
        }
        n = 0;
        this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, pluginDescriptorImpl, IntegrityCheckReport.Error.NO_ERROR, "extPointsCheckStart", null));
        for (ExtensionPoint extensionPoint : pluginDescriptorImpl.getExtensionPoints()) {
            ++n;
            pluginElement = (ExtensionPointImpl)extensionPoint;
            this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, pluginElement, IntegrityCheckReport.Error.NO_ERROR, "extPointCheckStart", ((ExtensionPointImpl)pluginElement).getUniqueId()));
            object = ((ExtensionPointImpl)pluginElement).validate();
            iterator = object.iterator();
            while (iterator.hasNext()) {
                reportItem = (IntegrityCheckReport.ReportItem)iterator.next();
                switch (reportItem.getSeverity()) {
                    case ERROR: {
                        ++this.errorsCount;
                        break;
                    }
                    case WARNING: {
                        ++this.warningsCount;
                        break;
                    }
                }
                this.items.add(reportItem);
            }
            this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, pluginElement, IntegrityCheckReport.Error.NO_ERROR, "extPointCheckFinish", ((ExtensionPointImpl)pluginElement).getUniqueId()));
        }
        this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, pluginDescriptorImpl, IntegrityCheckReport.Error.NO_ERROR, "extPointsCheckFinish", new Object[]{n, pluginDescriptorImpl.getUniqueId()}));
        n = 0;
        this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, pluginDescriptorImpl, IntegrityCheckReport.Error.NO_ERROR, "extsCheckStart", null));
        for (Extension extension : pluginDescriptorImpl.getExtensions()) {
            ++n;
            pluginElement = (ExtensionImpl)extension;
            this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, pluginElement, IntegrityCheckReport.Error.NO_ERROR, "extCheckStart", ((ExtensionImpl)pluginElement).getUniqueId()));
            object = ((ExtensionImpl)pluginElement).validate();
            iterator = object.iterator();
            while (iterator.hasNext()) {
                reportItem = (IntegrityCheckReport.ReportItem)iterator.next();
                switch (reportItem.getSeverity()) {
                    case ERROR: {
                        ++this.errorsCount;
                        break;
                    }
                    case WARNING: {
                        ++this.warningsCount;
                        break;
                    }
                }
                this.items.add(reportItem);
            }
            this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, pluginElement, IntegrityCheckReport.Error.NO_ERROR, "extCheckFinish", ((ExtensionImpl)pluginElement).getUniqueId()));
        }
        this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, pluginDescriptorImpl, IntegrityCheckReport.Error.NO_ERROR, "extsCheckFinish", new Object[]{n, pluginDescriptorImpl.getUniqueId()}));
    }

    @Override
    public int countErrors() {
        return this.errorsCount;
    }

    @Override
    public int countWarnings() {
        return this.warningsCount;
    }

    @Override
    public Collection<IntegrityCheckReport.ReportItem> getItems() {
        return this.items;
    }

    static class ReportItemImpl
    implements IntegrityCheckReport.ReportItem {
        private final IntegrityCheckReport.Severity severity;
        private final Identity source;
        private final IntegrityCheckReport.Error code;
        private final String msg;
        private final Object data;

        ReportItemImpl(IntegrityCheckReport.Severity severity, Identity identity, IntegrityCheckReport.Error error, String string, Object object) {
            this.severity = severity;
            this.source = identity;
            this.code = error;
            this.msg = string;
            this.data = object;
        }

        public IntegrityCheckReport.Error getCode() {
            return this.code;
        }

        public String getMessage() {
            return ResourceManager.getMessage("org.java.plugin.registry.xml", this.msg, this.data);
        }

        public String getMessage(Locale locale) {
            return ResourceManager.getMessage("org.java.plugin.registry.xml", this.msg, locale, this.data);
        }

        public IntegrityCheckReport.Severity getSeverity() {
            return this.severity;
        }

        public Identity getSource() {
            return this.source;
        }
    }
}

