/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.java.plugin.registry.Documentation;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.Library;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.PluginAttribute;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.registry.PluginPrerequisite;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.registry.Version;
import org.java.plugin.registry.xml.DocumentationImpl;
import org.java.plugin.registry.xml.ExtensionImpl;
import org.java.plugin.registry.xml.ExtensionPointImpl;
import org.java.plugin.registry.xml.IdentityImpl;
import org.java.plugin.registry.xml.LibraryImpl;
import org.java.plugin.registry.xml.ModelAttribute;
import org.java.plugin.registry.xml.ModelExtension;
import org.java.plugin.registry.xml.ModelExtensionPoint;
import org.java.plugin.registry.xml.ModelLibrary;
import org.java.plugin.registry.xml.ModelPluginDescriptor;
import org.java.plugin.registry.xml.ModelPluginManifest;
import org.java.plugin.registry.xml.ModelPrerequisite;
import org.java.plugin.registry.xml.PluginAttributeImpl;
import org.java.plugin.registry.xml.PluginFragmentImpl;
import org.java.plugin.registry.xml.PluginPrerequisiteImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PluginDescriptorImpl
extends IdentityImpl
implements PluginDescriptor {
    private final PluginRegistry registry;
    private final ModelPluginDescriptor model;
    private Map<String, PluginPrerequisite> pluginPrerequisites;
    private Map<String, Library> libraries;
    private Map<String, ExtensionPoint> extensionPoints;
    private Map<String, Extension> extensions;
    private Documentation<PluginDescriptor> doc;
    private List<PluginFragment> fragments;
    private List<PluginAttribute> attributes;

    PluginDescriptorImpl(PluginRegistry pluginRegistry, ModelPluginDescriptor modelPluginDescriptor) throws ManifestProcessingException {
        super(modelPluginDescriptor.getId());
        this.registry = pluginRegistry;
        this.model = modelPluginDescriptor;
        if (this.model.getVendor() == null) {
            this.model.setVendor("");
        }
        if (this.model.getClassName() != null && this.model.getClassName().trim().length() == 0) {
            this.model.setClassName(null);
        }
        if (this.model.getDocsPath() == null || this.model.getDocsPath().trim().length() == 0) {
            this.model.setDocsPath("docs");
        }
        if (this.model.getDocumentation() != null) {
            this.doc = new DocumentationImpl<PluginDescriptorImpl>(this, this.model.getDocumentation());
        }
        this.attributes = new LinkedList<PluginAttribute>();
        this.fragments = new LinkedList<PluginFragment>();
        this.pluginPrerequisites = new HashMap<String, PluginPrerequisite>();
        this.libraries = new HashMap<String, Library>();
        this.extensionPoints = new HashMap<String, ExtensionPoint>();
        this.extensions = new HashMap<String, Extension>();
        this.processAttributes(null, this.model);
        this.processPrerequisites(null, this.model);
        this.processLibraries(null, this.model);
        this.processExtensionPoints(null, this.model);
        this.processExtensions(null, this.model);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("object instantiated: " + this));
        }
    }

    void registerFragment(PluginFragmentImpl pluginFragmentImpl) throws ManifestProcessingException {
        this.fragments.add(pluginFragmentImpl);
        this.processAttributes(pluginFragmentImpl, pluginFragmentImpl.getModel());
        this.processPrerequisites(pluginFragmentImpl, pluginFragmentImpl.getModel());
        this.processLibraries(pluginFragmentImpl, pluginFragmentImpl.getModel());
        this.processExtensionPoints(pluginFragmentImpl, pluginFragmentImpl.getModel());
        this.processExtensions(pluginFragmentImpl, pluginFragmentImpl.getModel());
    }

    void unregisterFragment(PluginFragmentImpl pluginFragmentImpl) {
        Map.Entry entry;
        Iterator<Object> iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            if (!pluginFragmentImpl.equals(iterator.next().getDeclaringPluginFragment())) continue;
            iterator.remove();
        }
        iterator = this.pluginPrerequisites.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = (Map.Entry)iterator.next();
            if (!pluginFragmentImpl.equals(((PluginPrerequisite)entry.getValue()).getDeclaringPluginFragment())) continue;
            iterator.remove();
        }
        iterator = this.libraries.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = (Map.Entry)iterator.next();
            if (!pluginFragmentImpl.equals(((Library)entry.getValue()).getDeclaringPluginFragment())) continue;
            iterator.remove();
        }
        iterator = this.extensionPoints.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = (Map.Entry)iterator.next();
            if (!pluginFragmentImpl.equals(((ExtensionPoint)entry.getValue()).getDeclaringPluginFragment())) continue;
            iterator.remove();
        }
        iterator = this.extensions.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = (Map.Entry)iterator.next();
            if (!pluginFragmentImpl.equals(((Extension)entry.getValue()).getDeclaringPluginFragment())) continue;
            iterator.remove();
        }
        this.fragments.remove(pluginFragmentImpl);
    }

    private void processAttributes(PluginFragmentImpl pluginFragmentImpl, ModelPluginManifest modelPluginManifest) throws ManifestProcessingException {
        for (ModelAttribute modelAttribute : modelPluginManifest.getAttributes()) {
            this.attributes.add(new PluginAttributeImpl(this, pluginFragmentImpl, modelAttribute, null));
        }
    }

    private void processPrerequisites(PluginFragmentImpl pluginFragmentImpl, ModelPluginManifest modelPluginManifest) throws ManifestProcessingException {
        for (ModelPrerequisite modelPrerequisite : modelPluginManifest.getPrerequisites()) {
            PluginPrerequisiteImpl pluginPrerequisiteImpl = new PluginPrerequisiteImpl(this, pluginFragmentImpl, modelPrerequisite);
            if (this.pluginPrerequisites.containsKey(pluginPrerequisiteImpl.getPluginId())) {
                throw new ManifestProcessingException("org.java.plugin.registry.xml", "duplicateImports", new Object[]{pluginPrerequisiteImpl.getPluginId(), this.getId()});
            }
            this.pluginPrerequisites.put(pluginPrerequisiteImpl.getPluginId(), pluginPrerequisiteImpl);
        }
    }

    private void processLibraries(PluginFragmentImpl pluginFragmentImpl, ModelPluginManifest modelPluginManifest) throws ManifestProcessingException {
        for (ModelLibrary modelLibrary : modelPluginManifest.getLibraries()) {
            LibraryImpl libraryImpl = new LibraryImpl(this, pluginFragmentImpl, modelLibrary);
            if (this.libraries.containsKey(libraryImpl.getId())) {
                throw new ManifestProcessingException("org.java.plugin.registry.xml", "duplicateLibraries", new Object[]{libraryImpl.getId(), this.getId()});
            }
            this.libraries.put(libraryImpl.getId(), libraryImpl);
        }
    }

    private void processExtensionPoints(PluginFragmentImpl pluginFragmentImpl, ModelPluginManifest modelPluginManifest) throws ManifestProcessingException {
        for (ModelExtensionPoint modelExtensionPoint : modelPluginManifest.getExtensionPoints()) {
            ExtensionPointImpl extensionPointImpl = new ExtensionPointImpl(this, pluginFragmentImpl, modelExtensionPoint);
            if (this.extensionPoints.containsKey(extensionPointImpl.getId())) {
                throw new ManifestProcessingException("org.java.plugin.registry.xml", "duplicateExtensionPoints", new Object[]{extensionPointImpl.getId(), this.getId()});
            }
            this.extensionPoints.put(extensionPointImpl.getId(), extensionPointImpl);
        }
    }

    private void processExtensions(PluginFragmentImpl pluginFragmentImpl, ModelPluginManifest modelPluginManifest) throws ManifestProcessingException {
        for (ModelExtension modelExtension : modelPluginManifest.getExtensions()) {
            ExtensionImpl extensionImpl = new ExtensionImpl(this, pluginFragmentImpl, modelExtension);
            if (this.extensions.containsKey(extensionImpl.getId())) {
                throw new ManifestProcessingException("org.java.plugin.registry.xml", "duplicateExtensions", new Object[]{extensionImpl.getId(), this.getId()});
            }
            if (!this.getId().equals(extensionImpl.getExtendedPluginId()) && !this.pluginPrerequisites.containsKey(extensionImpl.getExtendedPluginId())) {
                throw new ManifestProcessingException("org.java.plugin.registry.xml", "pluginNotDeclaredInPrerequisites", new Object[]{extensionImpl.getExtendedPluginId(), extensionImpl.getId(), this.getId()});
            }
            this.extensions.put(extensionImpl.getId(), extensionImpl);
        }
    }

    @Override
    public String getUniqueId() {
        return this.registry.makeUniqueId(this.getId(), this.model.getVersion());
    }

    @Override
    public String getVendor() {
        return this.model.getVendor();
    }

    @Override
    public Version getVersion() {
        return this.model.getVersion();
    }

    @Override
    public Collection<PluginPrerequisite> getPrerequisites() {
        return Collections.unmodifiableCollection(this.pluginPrerequisites.values());
    }

    @Override
    public PluginPrerequisite getPrerequisite(String string) {
        return this.pluginPrerequisites.get(string);
    }

    @Override
    public Collection<ExtensionPoint> getExtensionPoints() {
        return Collections.unmodifiableCollection(this.extensionPoints.values());
    }

    @Override
    public ExtensionPoint getExtensionPoint(String string) {
        return this.extensionPoints.get(string);
    }

    @Override
    public Collection<Extension> getExtensions() {
        return Collections.unmodifiableCollection(this.extensions.values());
    }

    @Override
    public Extension getExtension(String string) {
        return this.extensions.get(string);
    }

    @Override
    public Collection<Library> getLibraries() {
        return Collections.unmodifiableCollection(this.libraries.values());
    }

    @Override
    public Library getLibrary(String string) {
        return this.libraries.get(string);
    }

    @Override
    public PluginRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public String getPluginClassName() {
        return this.model.getClassName();
    }

    public String toString() {
        return "{PluginDescriptor: uid=" + this.getUniqueId() + "}";
    }

    @Override
    public Documentation<PluginDescriptor> getDocumentation() {
        return this.doc;
    }

    @Override
    public Collection<PluginFragment> getFragments() {
        return Collections.unmodifiableCollection(this.fragments);
    }

    @Override
    public PluginAttribute getAttribute(String string) {
        PluginAttributeImpl pluginAttributeImpl = null;
        for (PluginAttribute pluginAttribute : this.attributes) {
            PluginAttributeImpl pluginAttributeImpl2 = (PluginAttributeImpl)pluginAttribute;
            if (!pluginAttributeImpl2.getId().equals(string)) continue;
            if (pluginAttributeImpl == null) {
                pluginAttributeImpl = pluginAttributeImpl2;
                continue;
            }
            throw new IllegalArgumentException("more than one attribute with ID " + string + " defined in plug-in " + this.getUniqueId());
        }
        return pluginAttributeImpl;
    }

    @Override
    public Collection<PluginAttribute> getAttributes() {
        return Collections.unmodifiableCollection(this.attributes);
    }

    @Override
    public Collection<PluginAttribute> getAttributes(String string) {
        LinkedList<PluginAttributeImpl> linkedList = new LinkedList<PluginAttributeImpl>();
        for (PluginAttribute pluginAttribute : this.attributes) {
            PluginAttributeImpl pluginAttributeImpl = (PluginAttributeImpl)pluginAttribute;
            if (!pluginAttributeImpl.getId().equals(string)) continue;
            linkedList.add(pluginAttributeImpl);
        }
        return Collections.unmodifiableList(linkedList);
    }

    @Override
    public String getDocsPath() {
        return this.model.getDocsPath();
    }

    @Override
    public URL getLocation() {
        return this.model.getLocation();
    }

    @Override
    protected boolean isEqualTo(Identity identity) {
        if (!(identity instanceof PluginDescriptorImpl)) {
            return false;
        }
        PluginDescriptorImpl pluginDescriptorImpl = (PluginDescriptorImpl)identity;
        return this.getUniqueId().equals(pluginDescriptorImpl.getUniqueId()) && this.getLocation().toExternalForm().equals(pluginDescriptorImpl.getLocation().toExternalForm());
    }
}

