/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.standard;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.Plugin;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginLifecycleException;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.standard.PluginLifecycleHandler;
import org.java.plugin.standard.StandardPluginClassLoader;
import org.java.plugin.util.ExtendedProperties;

public class StandardPluginLifecycleHandler
extends PluginLifecycleHandler {
    private final Log log = LogFactory.getLog(this.getClass());
    private boolean probeParentLoaderLast;

    protected PluginClassLoader createPluginClassLoader(final PluginDescriptor pluginDescriptor) {
        StandardPluginClassLoader standardPluginClassLoader = AccessController.doPrivileged(new PrivilegedAction<StandardPluginClassLoader>(){

            @Override
            public StandardPluginClassLoader run() {
                return new StandardPluginClassLoader(StandardPluginLifecycleHandler.this.getPluginManager(), pluginDescriptor, StandardPluginLifecycleHandler.this.getClass().getClassLoader());
            }
        });
        standardPluginClassLoader.setProbeParentLoaderLast(this.probeParentLoaderLast);
        return standardPluginClassLoader;
    }

    protected Plugin createPluginInstance(PluginDescriptor pluginDescriptor) throws PluginLifecycleException {
        Class<?> clazz;
        String string = pluginDescriptor.getPluginClassName();
        try {
            clazz = this.getPluginManager().getPluginClassLoader(pluginDescriptor).loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new PluginLifecycleException("org.java.plugin.standard", "pluginClassNotFound", string, classNotFoundException);
        }
        try {
            return (Plugin)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new PluginLifecycleException("org.java.plugin.standard", "pluginClassInstantiationFailed", pluginDescriptor.getId(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PluginLifecycleException("org.java.plugin.standard", "pluginClassInstantiationFailed", pluginDescriptor.getId(), illegalAccessException);
        }
    }

    protected void beforePluginStart(Plugin plugin) {
    }

    protected void afterPluginStop(Plugin plugin) {
    }

    protected void dispose() {
    }

    public void configure(ExtendedProperties extendedProperties) {
        this.probeParentLoaderLast = "true".equalsIgnoreCase(extendedProperties.getProperty("probeParentLoaderLast", "false"));
        this.log.debug((Object)("probeParentLoaderLast parameter value is " + this.probeParentLoaderLast));
    }
}

