/*
 * Decompiled with CFR 0.152.
 */
package com.lividblue.lib.butler.adapters;

import com.lividblue.lib.butler.Adapter;
import com.lividblue.lib.butler.Butler;
import com.lividblue.lib.butler.ButlerException;
import com.lividblue.lib.registry.RegistryEntry;
import java.io.File;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.PropertyConfigurator;

public class Log4jAdapter
extends Adapter {
    protected static String name = "log4j";
    public static final String CONFIGURATOR_KEY = "configurator";
    public static final String PROPERTY_FILE_KEY = "propertyFile";
    public static final String BASIC_CONFIGURATOR = "BasicConfigurator";
    public static final String PROPERTY_CONFIGURATOR = "PropertyConfigurator";
    protected Butler butler = null;

    public void initialize(Butler butler, RegistryEntry registryEntry) throws ButlerException {
        this.butler = butler;
        String configurator = registryEntry.getKeyValue(CONFIGURATOR_KEY);
        if (configurator != null) {
            if (configurator.equals(BASIC_CONFIGURATOR)) {
                this.initializeBasicConfigurator(registryEntry);
            } else if (configurator.equals(PROPERTY_CONFIGURATOR)) {
                this.initializePropertyConfigurator(registryEntry, butler.getRootDirectory());
            } else {
                throw new ButlerException("Unrecognized Logging configurator.");
            }
        }
    }

    private void initializeBasicConfigurator(RegistryEntry registryEntry) {
        BasicConfigurator.configure();
    }

    private void initializePropertyConfigurator(RegistryEntry registryEntry, File rootDirectory) throws ButlerException {
        String propertyFile = registryEntry.getKeyValue(PROPERTY_FILE_KEY);
        String path = rootDirectory.getAbsolutePath() + File.separator + propertyFile;
        if (propertyFile == null) {
            throw new ButlerException("Expecting property file name in property com.lividblue.lib.butler.adapter.log4j.propertyFile");
        }
        PropertyConfigurator.configure((String)path);
    }
}

