/*
 * Decompiled with CFR 0.152.
 */
package com.lividblue.lib.registry;

import com.lividblue.lib.registry.RegistryKeyMap;
import com.lividblue.lib.registry.RegistryKeyValue;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;

public class RegistryEntry {
    private static Category log = Category.getInstance((String)(class$com$lividblue$lib$registry$RegistryEntry == null ? (class$com$lividblue$lib$registry$RegistryEntry = RegistryEntry.class$("com.lividblue.lib.registry.RegistryEntry")) : class$com$lividblue$lib$registry$RegistryEntry).getName());
    protected RegistryKeyMap keyValueMap = new RegistryKeyMap();
    protected Map childRegistryEntryMap = new HashMap();
    protected List childRegistryEntryList = new ArrayList();
    protected String name = null;
    static /* synthetic */ Class class$com$lividblue$lib$registry$RegistryEntry;

    protected RegistryEntry(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public RegistryEntry getChildRegistryEntry(String name) {
        RegistryEntry result = null;
        int dotPos = name.indexOf(".");
        if (dotPos > 0) {
            String childName = name.substring(0, dotPos);
            String grandChildName = name.substring(dotPos + 1);
            RegistryEntry childRegistryEntry = (RegistryEntry)this.childRegistryEntryMap.get(childName);
            if (childRegistryEntry != null) {
                result = childRegistryEntry.getChildRegistryEntry(grandChildName);
            }
        } else {
            result = (RegistryEntry)this.childRegistryEntryMap.get(name);
        }
        return result;
    }

    public RegistryEntry createChildRegistryEntry(String name) {
        RegistryEntry childRegistryEntry = new RegistryEntry(name);
        this.childRegistryEntryMap.put(name, childRegistryEntry);
        this.childRegistryEntryList.add(childRegistryEntry);
        return childRegistryEntry;
    }

    public void removeChildRegistryEntry(RegistryEntry childRegistryEntry) {
        this.childRegistryEntryMap.remove(childRegistryEntry.getName());
        this.childRegistryEntryList.remove(childRegistryEntry);
    }

    public Iterator getChildRegistryEntryIterator() {
        return this.childRegistryEntryList.iterator();
    }

    public void removeKey(String key) {
        this.keyValueMap.removeKeyValue(key);
    }

    public String getKeyValue(String key) {
        String result = null;
        int dotPos = key.indexOf(".");
        if (dotPos > 0) {
            String childName = key.substring(0, dotPos);
            String childsKey = key.substring(dotPos + 1);
            RegistryEntry childRegistryEntry = (RegistryEntry)this.childRegistryEntryMap.get(childName);
            if (childRegistryEntry != null) {
                result = childRegistryEntry.getKeyValue(childsKey);
            }
        } else {
            RegistryKeyValue keyValue = (RegistryKeyValue)this.keyValueMap.getKeyValue(key);
            if (keyValue != null) {
                result = keyValue.getValue();
            }
        }
        return result;
    }

    public Iterator getKeyValues(String key) {
        Iterator result = null;
        int dotPos = key.indexOf(".");
        if (dotPos > 0) {
            String childName = key.substring(0, dotPos);
            String childsKey = key.substring(dotPos + 1);
            RegistryEntry childRegistryEntry = (RegistryEntry)this.childRegistryEntryMap.get(childName);
            if (childRegistryEntry != null) {
                result = childRegistryEntry.getKeyValues(childsKey);
            }
        } else {
            ArrayList<String> returnList = new ArrayList<String>();
            Iterator rkvs = this.keyValueMap.getKeyValues(key);
            if (rkvs != null) {
                while (rkvs.hasNext()) {
                    RegistryKeyValue keyValue = (RegistryKeyValue)rkvs.next();
                    returnList.add(keyValue.getValue());
                }
            }
            result = returnList.iterator();
        }
        return result;
    }

    public void setKeyValue(String key, String value) {
        int dotPos = key.indexOf(".");
        if (dotPos > 0) {
            String childName = key.substring(0, dotPos);
            String childsKey = key.substring(dotPos + 1);
            RegistryEntry childRegistryEntry = (RegistryEntry)this.childRegistryEntryMap.get(childName);
            if (childRegistryEntry == null) {
                childRegistryEntry = this.createChildRegistryEntry(childName);
            }
            childRegistryEntry.setKeyValue(childsKey, value);
        } else {
            RegistryKeyValue oldKeyValue = (RegistryKeyValue)this.keyValueMap.getKeyValue(key);
            String comment = null;
            if (oldKeyValue != null) {
                comment = oldKeyValue.getComment();
            }
            RegistryKeyValue keyValue = new RegistryKeyValue(key, value, comment);
            this.keyValueMap.setKeyValue(key, keyValue);
        }
    }

    public void setKeyValue(String key, String value, String comment) {
        int dotPos = key.indexOf(".");
        if (dotPos > 0) {
            String childName = key.substring(0, dotPos);
            String childsKey = key.substring(dotPos + 1);
            RegistryEntry childRegistryEntry = (RegistryEntry)this.childRegistryEntryMap.get(childName);
            if (childRegistryEntry == null) {
                childRegistryEntry = this.createChildRegistryEntry(childName);
            }
            childRegistryEntry.setKeyValue(childsKey, value, comment);
        } else {
            RegistryKeyValue keyValue = new RegistryKeyValue(key, value, comment);
            this.keyValueMap.setKeyValue(key, keyValue);
        }
    }

    public void addKeyValue(String key, String value) {
        this.addKeyValue(key, value, null);
    }

    public void addKeyValue(String key, String value, String comment) {
        int dotPos = key.indexOf(".");
        if (dotPos > 0) {
            String childName = key.substring(0, dotPos);
            String childsKey = key.substring(dotPos + 1);
            RegistryEntry childRegistryEntry = (RegistryEntry)this.childRegistryEntryMap.get(childName);
            if (childRegistryEntry == null) {
                childRegistryEntry = this.createChildRegistryEntry(childName);
            }
            childRegistryEntry.addKeyValue(childsKey, value, comment);
        } else {
            RegistryKeyValue keyValue = new RegistryKeyValue(key, value, comment);
            this.keyValueMap.addKeyValue(key, keyValue);
        }
    }

    public String getKeyComment(String key) {
        String result = null;
        int dotPos = key.indexOf(".");
        if (dotPos > 0) {
            String childName = key.substring(0, dotPos);
            String childsKey = key.substring(dotPos + 1);
            RegistryEntry childRegistryEntry = (RegistryEntry)this.childRegistryEntryMap.get(childName);
            if (childRegistryEntry != null) {
                result = childRegistryEntry.getKeyComment(childsKey);
            }
        } else {
            RegistryKeyValue keyValue = (RegistryKeyValue)this.keyValueMap.getKeyValue(key);
            result = keyValue.getComment();
        }
        return result;
    }

    public Iterator getKeyIterator() {
        return this.keyValueMap.getKeys();
    }

    public String toString() {
        String str = "\nbegin: " + this.name + "\n" + "KeyValue: ";
        Iterator keyItr = this.getKeyIterator();
        String key = null;
        while (keyItr.hasNext()) {
            key = (String)keyItr.next();
            Iterator valueItr = this.getKeyValues(key);
            if (valueItr == null) continue;
            while (valueItr.hasNext()) {
                str = str + key + "=" + valueItr.next() + ", ";
            }
        }
        int i = 0;
        while (i < this.childRegistryEntryList.size()) {
            RegistryEntry childRegistryEntry = (RegistryEntry)this.childRegistryEntryList.get(i);
            str = str + childRegistryEntry.toString();
            ++i;
        }
        str = str + "\nend: " + this.name;
        return str;
    }

    public void writeEntry(Writer writer, String absoluteName) throws IOException {
        if (absoluteName == null) {
            absoluteName = "";
        }
        if (this.name == null || this.name.equals("")) {
            if (!absoluteName.equals("")) {
                absoluteName = absoluteName + ".";
            }
        } else {
            absoluteName = absoluteName.equals("") ? this.name + "." : (absoluteName.endsWith(".") ? absoluteName + this.name + "." : absoluteName + "." + this.name + ".");
        }
        Iterator itr = this.getKeyIterator();
        String comment = null;
        String key = null;
        String value = null;
        while (itr.hasNext()) {
            key = (String)itr.next();
            Iterator kvs = this.keyValueMap.getKeyValues(key);
            if (kvs == null) continue;
            while (kvs.hasNext()) {
                RegistryKeyValue keyValue = (RegistryKeyValue)kvs.next();
                comment = keyValue.getComment();
                value = keyValue.getValue();
                if (comment != null) {
                    writer.write(comment);
                    if (!comment.endsWith("\n")) {
                        writer.write("\n");
                    }
                }
                writer.write(absoluteName + key + " = " + value + "\n");
            }
        }
        itr = this.getChildRegistryEntryIterator();
        RegistryEntry childEntry = null;
        while (itr.hasNext()) {
            childEntry = (RegistryEntry)itr.next();
            childEntry.writeEntry(writer, absoluteName);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

