/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.lib.butler;

import com.urbancode.lib.butler.Adapter;
import com.urbancode.lib.butler.ButlerException;
import com.urbancode.lib.registry.Registry;
import com.urbancode.lib.registry.RegistryEntry;
import com.urbancode.lib.version.VersionReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Butler {
    public static final String BUTLER_ROOT_PREFIX = "config.dir.";
    public static final String CONFIG_FILE_EXTENSION = ".registry";
    public static final String ADAPTER_PREFIX = "com.urbancode.lib.butler.adapter";
    public static final String ADAPTER_CLASS_KEY = "class";
    private static final String DEFAULT_REGISTRY_FILE = "default.registry";
    private static Map name2butler = new HashMap();
    private static String versionStr = null;
    private String name = null;
    private Registry registry = null;
    private File registryFile = null;
    private Map name2adapterMap = new HashMap();
    static /* synthetic */ Class class$com$urbancode$lib$butler$Butler;

    public static String getVersion() {
        if (versionStr == null) {
            ClassLoader loader = (class$com$urbancode$lib$butler$Butler == null ? (class$com$urbancode$lib$butler$Butler = Butler.class$("com.urbancode.lib.butler.Butler")) : class$com$urbancode$lib$butler$Butler).getClassLoader();
            InputStream in = loader.getResourceAsStream("Butler.version");
            versionStr = VersionReader.readVersionStr(in);
        }
        return versionStr;
    }

    public static Butler getButler(String name) throws ButlerException {
        Butler butler = (Butler)name2butler.get(name);
        try {
            if (butler == null) {
                String butlerRoot = System.getProperty(BUTLER_ROOT_PREFIX + name);
                File fh = null;
                if (butlerRoot != null && !butlerRoot.equals("")) {
                    System.out.println("ButlerRoot: " + butlerRoot);
                    fh = new File(butlerRoot, name + CONFIG_FILE_EXTENSION);
                    if (!fh.exists()) {
                        System.out.println("Can't find file " + name + CONFIG_FILE_EXTENSION + ".  Will " + "attempt to use the default registry.");
                        butler = Butler.getDefaultButler();
                    } else {
                        fh = fh.getCanonicalFile();
                        butler = new Butler(name, fh);
                    }
                } else {
                    System.out.println("Can't find system property config.dir." + name + ".  Will " + "look for the registry file in the " + "current working directory.");
                    fh = new File(name + CONFIG_FILE_EXTENSION);
                    if (!fh.exists()) {
                        System.out.println("Can't find system property config.dir." + name + ".  Will " + "attempt to use the default registry.");
                        butler = Butler.getDefaultButler();
                    } else {
                        fh = fh.getCanonicalFile();
                        butler = new Butler(name, fh);
                    }
                }
                name2butler.put(name, butler);
            }
        }
        catch (IOException ioe) {
            throw new ButlerException(ioe);
        }
        if (butler == null) {
            throw new ButlerException("Could not load Butler for application " + name + ".");
        }
        return butler;
    }

    protected static Butler getDefaultButler() throws ButlerException {
        Butler butler = null;
        try {
            File fh = new File(DEFAULT_REGISTRY_FILE);
            if (!fh.exists()) {
                throw new ButlerException("Could not locate any registry file.");
            }
            fh = fh.getCanonicalFile();
            butler = new Butler("default", fh);
        }
        catch (IOException ioe) {
            throw new ButlerException(ioe);
        }
        return butler;
    }

    protected Butler(String name, File registryFile) throws ButlerException {
        this.name = name;
        this.registryFile = registryFile;
        try {
            this.registry = Registry.loadFile(registryFile);
        }
        catch (Exception ioe) {
            throw new ButlerException(ioe);
        }
        RegistryEntry rootRE = this.registry.getRegistryEntry(ADAPTER_PREFIX);
        if (rootRE != null) {
            Iterator adapters = rootRE.getChildRegistryEntryIterator();
            RegistryEntry adapterRE = null;
            if (adapters != null) {
                while (adapters.hasNext()) {
                    adapterRE = (RegistryEntry)adapters.next();
                    this.initializeAdapter(adapterRE);
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public RegistryEntry getRegistryEntry(String entryName) {
        return this.registry.getRegistryEntry(entryName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateRegistry() throws ButlerException {
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(this.registryFile);
                this.registry.writeRegistry(out);
            }
            catch (Exception e) {
                throw new ButlerException(e);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            try {
                ((OutputStream)out).close();
                throw throwable;
            }
            catch (Exception e) {
                throw new ButlerException(e);
            }
        }
        try {}
        catch (Exception e) {
            throw new ButlerException(e);
        }
        ((OutputStream)out).close();
    }

    public File getRootDirectory() {
        return this.registryFile.getParentFile();
    }

    public Adapter getAdapter(String name) {
        return (Adapter)this.name2adapterMap.get(name);
    }

    private void initializeAdapter(RegistryEntry adapterRE) throws ButlerException {
        String adapterClassName = adapterRE.getKeyValue(ADAPTER_CLASS_KEY);
        Adapter adapter = null;
        if (adapterClassName != null) {
            try {
                adapter = (Adapter)Class.forName(adapterClassName).newInstance();
                adapter.initialize(this, adapterRE);
                this.name2adapterMap.put(Adapter.getName(), adapter);
            }
            catch (Exception e) {
                throw new ButlerException(e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        System.out.println("Butler version: " + Butler.getVersion() + " loaded.");
    }
}

