/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.lib.net;

import com.urbancode.lib.butler.Butler;
import com.urbancode.lib.net.ThreadedServer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import org.apache.log4j.Category;

public class EchoServer
extends ThreadedServer {
    private static Category log = Category.getInstance((String)(class$com$urbancode$lib$net$EchoServer == null ? (class$com$urbancode$lib$net$EchoServer = EchoServer.class$("com.urbancode.lib.net.EchoServer")) : class$com$urbancode$lib$net$EchoServer).getName());
    static /* synthetic */ Class class$com$urbancode$lib$net$EchoServer;

    public static void main(String[] args) throws Exception {
        if (args.length == 2) {
            Butler butler = Butler.getButler("EchoServer");
            InetAddress bindAddr = InetAddress.getByName(args[0]);
            int port = Integer.parseInt(args[1]);
            EchoServer server = new EchoServer(bindAddr, port);
            server.start();
        } else {
            EchoServer.printUsage();
        }
    }

    protected static void printUsage() {
        System.out.println("Usage:");
        System.out.println("\tjava threadedServer.EchoServer <host> <port>");
    }

    public EchoServer() {
    }

    public EchoServer(InetAddress bindAddr, int port) {
        super(bindAddr, port);
    }

    protected ThreadedServer.ConnectionHandler createNewConnectionHandler() {
        log.debug((Object)"EchoServer createNewConnectionHandler()");
        return new EchoHandler();
    }

    protected void expireConnectionHandler(ThreadedServer.ConnectionHandler connHandler) {
    }

    protected boolean isConnectionHandlerValid(ThreadedServer.ConnectionHandler connHandler) {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class EchoHandler
    extends ThreadedServer.ConnectionHandler {
        protected EchoHandler() {
            super(EchoServer.this);
        }

        protected void handleConnection(InputStream in, OutputStream out) throws IOException {
            log.debug((Object)"EchoHandler handling connection.");
            BufferedInputStream is = new BufferedInputStream(in);
            BufferedOutputStream os = new BufferedOutputStream(out);
            byte[] buffer = new byte[256];
            int total = 0;
            byte[] temp = null;
            int length = 0;
            log.debug((Object)("EchoHandler handleConnection bytes available: " + is.available()));
            while ((length = is.read(buffer, total, 256)) > 0 && !EchoServer.this.isShutdown()) {
                temp = new byte[(total += length) + 256];
                System.arraycopy(buffer, 0, temp, 0, buffer.length);
                buffer = temp;
                log.debug((Object)new String(buffer, total - length, length));
                os.write(buffer, 0, total);
            }
            os.flush();
        }
    }
}

