/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.lib.net;

import com.urbancode.lib.util.ObjectPool;
import com.urbancode.lib.util.ThreadPool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.Category;

public abstract class ThreadedServer {
    private static Category log = Category.getInstance((String)(class$com$urbancode$lib$net$ThreadedServer == null ? (class$com$urbancode$lib$net$ThreadedServer = ThreadedServer.class$("com.urbancode.lib.net.ThreadedServer")) : class$com$urbancode$lib$net$ThreadedServer).getName());
    private static String className = (class$com$urbancode$lib$net$ThreadedServer == null ? (class$com$urbancode$lib$net$ThreadedServer = ThreadedServer.class$("com.urbancode.lib.net.ThreadedServer")) : class$com$urbancode$lib$net$ThreadedServer).getName();
    private static int MIN_THREAD_COUNT = Integer.getInteger(className + ".MIN_THREAD_COUNT", 1);
    private static int MAX_THREAD_COUNT = Integer.getInteger(className + ".MAX_THREAD_COUNT", 5);
    private static int CLEAN_UP_INTERVAL = Integer.getInteger(className + ".CLEAN_UP_INTERVAL", 300);
    protected ThreadPool threadPool = null;
    protected HandlerPool handlerPool = null;
    protected Listener listener = null;
    protected InetAddress bindAddr = null;
    protected int port = 0;
    protected int backlog = 0;
    protected int cleanUpInterval = CLEAN_UP_INTERVAL;
    protected int minThreadCount = MIN_THREAD_COUNT;
    protected int maxThreadCount = MAX_THREAD_COUNT;
    protected boolean isShutdown = false;
    protected boolean isRunning = false;
    static /* synthetic */ Class class$com$urbancode$lib$net$ThreadedServer;

    public ThreadedServer() {
    }

    public ThreadedServer(InetAddress bindAddr, int port) {
        this.bindAddr = bindAddr;
        this.port = port;
    }

    public void setInetAddress(InetAddress bindAddr, int port) {
        if (this.isRunning) {
            throw new IllegalStateException("Con not change this parameter when the server is running.");
        }
        this.bindAddr = bindAddr;
        this.port = port;
    }

    public InetAddress getInetAddress() {
        return this.bindAddr;
    }

    public int getPort() {
        return this.port;
    }

    public void setMinThreadCount(int minThreadCount) {
        if (this.isRunning) {
            throw new IllegalStateException("Con not change this parameter when the server is running.");
        }
        this.minThreadCount = minThreadCount;
    }

    public int getMinThreadCount() {
        return this.minThreadCount;
    }

    public void setMaxThreadCount(int maxThreadCount) {
        if (this.isRunning) {
            throw new IllegalStateException("Con not change this parameter when the server is running.");
        }
        this.maxThreadCount = maxThreadCount;
    }

    public int getMaxThreadCount() {
        return this.maxThreadCount;
    }

    public synchronized void start() {
        if (this.isRunning) {
            throw new IllegalStateException("ThreadedServer is already running.");
        }
        if (this.bindAddr == null) {
            throw new IllegalStateException("Bind address is null.");
        }
        this.threadPool = new ThreadPool(this.bindAddr.getHostName() + ":" + this.port, this.minThreadCount + 1, this.maxThreadCount + 1, this.cleanUpInterval, this.cleanUpInterval);
        log.debug((Object)"ThreadPool created.");
        this.handlerPool = new HandlerPool();
        this.handlerPool.initialize(this.minThreadCount, this.maxThreadCount, this.cleanUpInterval, this.cleanUpInterval);
        log.debug((Object)"ConnectionHandlerFactory initialized.");
        this.listener = new Listener();
        log.debug((Object)"Listener created.");
        this.threadPool.run(this.listener);
        log.debug((Object)"Listener started.");
        this.isShutdown = false;
        this.isRunning = true;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void shutdown() {
        log.debug((Object)"ThreadedServer shutting down");
        this.isShutdown = true;
        this.isRunning = false;
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    protected void finalize() throws Throwable {
        this.shutdown();
    }

    protected abstract ConnectionHandler createNewConnectionHandler();

    protected abstract void expireConnectionHandler(ConnectionHandler var1);

    protected abstract boolean isConnectionHandlerValid(ConnectionHandler var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract class ConnectionHandler
    implements Runnable {
        protected Socket socket = null;

        protected ConnectionHandler() {
        }

        public void setSocket(Socket s) {
            log.debug((Object)("Socket set on handler." + s));
            this.socket = s;
        }

        public Socket getSocket() {
            return this.socket;
        }

        /*
         * Loose catch block
         */
        public void run() {
            block8: {
                log.debug((Object)"ConnectionHandler being run.");
                this.handleConnection(this.socket);
                Object var3_1 = null;
                try {
                    this.socket.close();
                }
                catch (IOException ioe) {}
                break block8;
                {
                    catch (IOException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        Object var3_2 = null;
                        try {
                            this.socket.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    try {
                        this.socket.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            ThreadedServer.this.handlerPool.checkIn(this);
        }

        protected void handleConnection(Socket socket) throws IOException {
            OutputStream out;
            block13: {
                InputStream in = socket.getInputStream();
                out = socket.getOutputStream();
                try {
                    this.handleConnection(in, out);
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    in = null;
                    try {
                        out.flush();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    try {
                        out.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    out = null;
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                in = null;
                try {
                    out.flush();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                try {
                    out.close();
                    break block13;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                {
                }
            }
            out = null;
        }

        protected void handleConnection(InputStream in, OutputStream out) throws IOException {
            throw new Error("Please override the handleConnection() method.");
        }
    }

    protected class HandlerPool
    extends ObjectPool {
        protected HandlerPool() {
        }

        ConnectionHandler getHandler(Socket socket) {
            ConnectionHandler handler = (ConnectionHandler)this.checkOut();
            handler.setSocket(socket);
            return handler;
        }

        protected final Object getNewInstance() {
            ObjectPool.log.debug((Object)"HandlerPool getNewInstance()");
            return ThreadedServer.this.createNewConnectionHandler();
        }

        protected final void expire(Object o) throws Exception {
            ConnectionHandler handler = (ConnectionHandler)o;
            ThreadedServer.this.expireConnectionHandler(handler);
        }

        protected final boolean isObjectValid(Object o) throws Exception {
            return ThreadedServer.this.isConnectionHandlerValid((ConnectionHandler)o);
        }
    }

    private class Listener
    implements Runnable {
        private Listener() {
        }

        public void run() {
            try {
                ConnectionHandler handler = null;
                ServerSocket serverSocket = new ServerSocket(ThreadedServer.this.port, ThreadedServer.this.backlog, ThreadedServer.this.bindAddr);
                Socket socket = null;
                while (!ThreadedServer.this.isShutdown()) {
                    Object var6_6;
                    try {
                        try {
                            socket = serverSocket.accept();
                            log.debug((Object)("Accepted connection from " + socket.getInetAddress().getHostName()));
                            handler = ThreadedServer.this.handlerPool.getHandler(socket);
                            ThreadedServer.this.threadPool.run(handler);
                        }
                        catch (Throwable t) {
                            log.error((Object)t.getMessage(), t);
                            var6_6 = null;
                            continue;
                        }
                        var6_6 = null;
                    }
                    catch (Throwable throwable) {
                        var6_6 = null;
                        throw throwable;
                    }
                }
            }
            catch (IOException ioe) {
                log.error((Object)ioe.getMessage(), (Throwable)ioe);
            }
        }
    }
}

