/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.lib.registry;

import com.urbancode.lib.registry.RegistryEntry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;

public class Registry {
    protected RegistryEntry rootRegistry = new RegistryEntry("");
    protected File file = null;

    public static Registry loadFile(String fileName) throws FileNotFoundException, IOException {
        return Registry.loadFile(new File(fileName));
    }

    public static Registry loadFile(File file) throws FileNotFoundException, IOException {
        Registry registry = new Registry(file);
        return registry;
    }

    public static Registry load(InputStream in) throws IOException {
        return new Registry(in);
    }

    public static Registry createRegistry() {
        return new Registry();
    }

    private Registry(File file) throws IOException {
        this.file = file;
        FileInputStream fin = new FileInputStream(file);
        this.loadHelper(fin);
        fin.close();
    }

    private Registry(InputStream in) throws IOException {
        this.loadHelper(in);
    }

    private Registry() {
    }

    private void loadHelper(InputStream in) throws IOException {
        LineNumberReader lin = new LineNumberReader(new InputStreamReader(in));
        try {
            String lnString = null;
            String comment = null;
            String propKey = "";
            String propValue = "";
            while ((lnString = lin.readLine()) != null) {
                if ((lnString = lnString.trim()).startsWith("#") || lnString.length() == 0) {
                    if (comment != null) {
                        comment = comment + lnString + "\n";
                        continue;
                    }
                    comment = lnString + "\n";
                    continue;
                }
                if (lnString.endsWith(" \\")) {
                    lnString = lnString.substring(0, lnString.length() - 1).trim();
                    if (propKey == null || propKey.length() < 1) {
                        propValue = lnString.substring(lnString.indexOf("=") + 1).trim();
                        propKey = lnString.substring(0, lnString.indexOf("=")).trim();
                        continue;
                    }
                    propValue = propValue + " " + lnString.trim();
                    continue;
                }
                if (propKey != null && propKey.length() > 0) {
                    propValue = propValue + " " + lnString;
                } else {
                    propKey = propKey + " " + lnString.substring(0, lnString.indexOf("=")).trim();
                    propValue = propValue + " " + lnString.substring(lnString.indexOf("=") + 1).trim();
                }
                this.parsePropertyName(this.rootRegistry, propKey.trim(), propValue.trim(), comment);
                comment = null;
                propKey = "";
                propValue = "";
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            e.printStackTrace();
            throw new IOException("Invallid registry file format.");
        }
    }

    public void updateRegistryFile() throws IOException {
        if (this.file == null) {
            throw new IllegalStateException("This registry was not loaded from a file so the updateRegistryFile() method can not be called.");
        }
        FileOutputStream fos = new FileOutputStream(this.file);
        this.writeRegistry(fos);
        fos.close();
    }

    public void setRegistryFile(File file) {
        this.file = file;
    }

    public File getRegistryFile() {
        return this.file;
    }

    public void writeRegistry(OutputStream out) throws IOException {
        BufferedWriter buf = new BufferedWriter(new PrintWriter(out));
        this.rootRegistry.writeEntry(buf, null);
        buf.flush();
    }

    public void clear() {
        this.rootRegistry.clear();
    }

    public RegistryEntry getRootRegistryEntry() {
        return this.rootRegistry;
    }

    public RegistryEntry getRegistryEntry(String name) {
        return this.rootRegistry.getChildRegistryEntry(name);
    }

    public Iterator getRegistryEntryIterator() {
        return this.rootRegistry.getChildRegistryEntryIterator();
    }

    private void parsePropertyName(RegistryEntry parentRegistry, String propKey, String propValue, String comment) {
        int dotPos = propKey.indexOf(".");
        if (dotPos > 0) {
            String nodeName = propKey.substring(0, dotPos);
            String newPropKey = propKey.substring(dotPos + 1);
            RegistryEntry childRegistry = parentRegistry.getChildRegistryEntryForCodedName(nodeName);
            if (childRegistry == null) {
                childRegistry = parentRegistry.createChildRegistryEntry(nodeName);
            }
            this.parsePropertyName(childRegistry, newPropKey, propValue, comment);
        } else {
            parentRegistry.addKeyValue(propKey, propValue, comment);
        }
    }

    public RegistryEntry createChildRegistryEntry(String name) {
        return this.rootRegistry.createChildRegistryEntry(name);
    }

    public RegistryEntry getChildRegistryEntry(String name) {
        return this.rootRegistry.getChildRegistryEntry(name);
    }

    public Iterator getChildRegistryEntries(String name) {
        return this.rootRegistry.getChildRegistryEntries(name);
    }

    public Iterator getChildRegistryEntryIterator() {
        return this.rootRegistry.getChildRegistryEntryIterator();
    }

    public void removeChildRegistryEntry(RegistryEntry childRegistryEntry) {
        this.rootRegistry.removeChildRegistryEntry(childRegistryEntry);
    }

    public String getKeyValue(String key) {
        return this.rootRegistry.getKeyValue(key);
    }

    public Iterator getKeyValues(String key) {
        return this.rootRegistry.getKeyValues(key);
    }

    public void setKeyValue(String key, String value) {
        this.rootRegistry.setKeyValue(key, value);
    }

    public void setKeyValue(String key, String value, String comment) {
        this.rootRegistry.setKeyValue(key, value, comment);
    }

    public void addKeyValue(String key, String value) {
        this.rootRegistry.addKeyValue(key, value);
    }

    public void addKeyValue(String key, String value, String comment) {
        this.rootRegistry.addKeyValue(key, value, comment);
    }

    public String getKeyComment(String key) {
        return this.rootRegistry.getKeyComment(key);
    }

    public Iterator getKeyIterator() {
        return this.rootRegistry.getKeyIterator();
    }

    public void removeKey(String key) {
        this.rootRegistry.removeKey(key);
    }
}

