/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.lib.registry;

import com.urbancode.lib.registry.RegistryEntryMap;
import com.urbancode.lib.registry.RegistryKeyMap;
import com.urbancode.lib.registry.RegistryKeyValue;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;

public class RegistryEntry {
    protected RegistryKeyMap keyValueMap = new RegistryKeyMap();
    protected RegistryEntryMap regEntryMap = new RegistryEntryMap();
    protected String codedName = null;
    protected String name = null;

    protected RegistryEntry(String codedName) {
        this.codedName = codedName;
        int pos = codedName.indexOf(36);
        this.name = pos > 0 ? codedName.substring(0, pos) : codedName;
    }

    public void clear() {
        this.keyValueMap = new RegistryKeyMap();
        this.regEntryMap = new RegistryEntryMap();
    }

    public String getName() {
        return this.name;
    }

    protected String getCodedName() {
        return this.codedName;
    }

    protected void setCodedName(String codedName) {
        this.codedName = codedName;
    }

    protected RegistryEntry getChildRegistryEntryForCodedName(String codedName) {
        return this.regEntryMap.getEntryForCodedName(codedName);
    }

    public RegistryEntry getChildRegistryEntry(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Attempting to obtain a child RegistryEntry with a null name. Called on RegistryEntry name: " + this.getName());
        }
        RegistryEntry result = this.getChildRegistryEntry0(name);
        return result;
    }

    protected RegistryEntry getChildRegistryEntry0(String name) {
        RegistryEntry result = null;
        int dotPos = name.indexOf(".");
        if (dotPos > 0) {
            String childName = name.substring(0, dotPos);
            String grandChildName = name.substring(dotPos + 1);
            RegistryEntry childRegistryEntry = this.regEntryMap.getEntry(childName);
            if (childRegistryEntry != null) {
                result = childRegistryEntry.getChildRegistryEntry(grandChildName);
            }
        } else {
            result = this.regEntryMap.getEntry(name);
        }
        return result;
    }

    public Iterator getChildRegistryEntries(String name) {
        return this.regEntryMap.getEntries(name);
    }

    public RegistryEntry createChildRegistryEntry(String name) {
        RegistryEntry childRegistryEntry = new RegistryEntry(name);
        this.regEntryMap.addEntry(childRegistryEntry);
        return childRegistryEntry;
    }

    public void removeChildRegistryEntry(RegistryEntry childRegistryEntry) {
        this.regEntryMap.removeEntry(childRegistryEntry);
    }

    public Iterator getChildRegistryEntryIterator() {
        return this.regEntryMap.getEntryIterator();
    }

    public void removeKey(String key) {
        int dotPos = key.indexOf(".");
        if (dotPos > 0) {
            String childName = key.substring(0, dotPos);
            String childsKey = key.substring(dotPos + 1);
            RegistryEntry childRegistryEntry = this.regEntryMap.getEntry(childName);
            if (childRegistryEntry != null) {
                childRegistryEntry.removeKey(childsKey);
            }
        } else {
            this.keyValueMap.removeKeyValue(key);
        }
    }

    public String getKeyValue(String key) {
        String result = null;
        int dotPos = key.indexOf(".");
        if (dotPos > 0) {
            String childName = key.substring(0, dotPos);
            String childsKey = key.substring(dotPos + 1);
            RegistryEntry childRegistryEntry = this.regEntryMap.getEntry(childName);
            if (childRegistryEntry != null) {
                result = childRegistryEntry.getKeyValue(childsKey);
            }
        } else {
            RegistryKeyValue keyValue = (RegistryKeyValue)this.keyValueMap.getKeyValue(key);
            if (keyValue != null) {
                result = keyValue.getValue();
            }
        }
        return result;
    }

    public Iterator getKeyValues(String key) {
        Iterator result = null;
        int dotPos = key.indexOf(".");
        if (dotPos > 0) {
            String childName = key.substring(0, dotPos);
            String childsKey = key.substring(dotPos + 1);
            RegistryEntry childRegistryEntry = this.regEntryMap.getEntry(childName);
            if (childRegistryEntry != null) {
                result = childRegistryEntry.getKeyValues(childsKey);
            }
        } else {
            ArrayList<String> returnList = new ArrayList<String>();
            Iterator rkvs = this.keyValueMap.getKeyValues(key);
            if (rkvs != null) {
                while (rkvs.hasNext()) {
                    RegistryKeyValue keyValue = (RegistryKeyValue)rkvs.next();
                    returnList.add(keyValue.getValue());
                }
            }
            result = returnList.iterator();
        }
        return result;
    }

    public RegistryEntry setKeyValue(String key, String value) {
        int dotPos = key.indexOf(".");
        if (dotPos > 0) {
            String childName = key.substring(0, dotPos);
            String childsKey = key.substring(dotPos + 1);
            RegistryEntry childRegistryEntry = this.regEntryMap.getEntry(childName);
            if (childRegistryEntry == null) {
                childRegistryEntry = this.createChildRegistryEntry(childName);
            }
            return childRegistryEntry.setKeyValue(childsKey, value);
        }
        RegistryKeyValue oldKeyValue = (RegistryKeyValue)this.keyValueMap.getKeyValue(key);
        String comment = null;
        if (oldKeyValue != null) {
            comment = oldKeyValue.getComment();
        }
        RegistryKeyValue keyValue = new RegistryKeyValue(key, value, comment);
        this.keyValueMap.setKeyValue(key, keyValue);
        return this;
    }

    public RegistryEntry setKeyValue(String key, String value, String comment) {
        int dotPos = key.indexOf(".");
        if (dotPos > 0) {
            String childName = key.substring(0, dotPos);
            String childsKey = key.substring(dotPos + 1);
            RegistryEntry childRegistryEntry = this.regEntryMap.getEntry(childName);
            if (childRegistryEntry == null) {
                childRegistryEntry = this.createChildRegistryEntry(childName);
            }
            return childRegistryEntry.setKeyValue(childsKey, value, comment);
        }
        RegistryKeyValue keyValue = new RegistryKeyValue(key, value, comment);
        this.keyValueMap.setKeyValue(key, keyValue);
        return this;
    }

    public RegistryEntry addKeyValue(String key, String value) {
        return this.addKeyValue(key, value, null);
    }

    public RegistryEntry addKeyValue(String key, String value, String comment) {
        int dotPos = key.indexOf(".");
        if (dotPos > 0) {
            String childName = key.substring(0, dotPos);
            String childsKey = key.substring(dotPos + 1);
            RegistryEntry childRegistryEntry = this.regEntryMap.getEntry(childName);
            if (childRegistryEntry == null) {
                childRegistryEntry = this.createChildRegistryEntry(childName);
            } else if (childsKey.indexOf(46) == -1 && childRegistryEntry.getKeyValue(childsKey) != null) {
                childRegistryEntry = this.createChildRegistryEntry(childName);
            }
            return childRegistryEntry.addKeyValue(childsKey, value, comment);
        }
        RegistryKeyValue keyValue = new RegistryKeyValue(key, value, comment);
        this.keyValueMap.addKeyValue(key, keyValue);
        return this;
    }

    public String getKeyComment(String key) {
        String result = null;
        int dotPos = key.indexOf(".");
        if (dotPos > 0) {
            String childName = key.substring(0, dotPos);
            String childsKey = key.substring(dotPos + 1);
            RegistryEntry childRegistryEntry = this.regEntryMap.getEntry(childName);
            if (childRegistryEntry != null) {
                result = childRegistryEntry.getKeyComment(childsKey);
            }
        } else {
            RegistryKeyValue keyValue = (RegistryKeyValue)this.keyValueMap.getKeyValue(key);
            result = keyValue.getComment();
        }
        return result;
    }

    public Iterator getKeyIterator() {
        return this.keyValueMap.getKeys();
    }

    public String toString() {
        String str = "\nbegin: " + this.name + "\n" + "KeyValue: ";
        Iterator keyItr = this.getKeyIterator();
        String key = null;
        while (keyItr.hasNext()) {
            key = (String)keyItr.next();
            Iterator valueItr = this.getKeyValues(key);
            if (valueItr == null) continue;
            while (valueItr.hasNext()) {
                str = str + key + "=" + valueItr.next() + ", ";
            }
        }
        RegistryEntry childRegistryEntry = null;
        Iterator entryItr = this.regEntryMap.getEntryIterator();
        while (entryItr.hasNext()) {
            childRegistryEntry = (RegistryEntry)entryItr.next();
            str = str + childRegistryEntry.toString();
        }
        str = str + "\nend: " + this.name;
        return str;
    }

    public void writeEntry(Writer writer, String absoluteName) throws IOException {
        if (absoluteName == null) {
            absoluteName = "";
        }
        if (this.codedName == null || this.codedName.equals("")) {
            if (!absoluteName.equals("")) {
                absoluteName = absoluteName + ".";
            }
        } else {
            absoluteName = absoluteName.equals("") ? this.codedName + "." : (absoluteName.endsWith(".") ? absoluteName + this.codedName + "." : absoluteName + "." + this.codedName + ".");
        }
        Iterator itr = this.getKeyIterator();
        String comment = null;
        String key = null;
        String value = null;
        while (itr.hasNext()) {
            key = (String)itr.next();
            Iterator kvs = this.keyValueMap.getKeyValues(key);
            if (kvs == null) continue;
            while (kvs.hasNext()) {
                RegistryKeyValue keyValue = (RegistryKeyValue)kvs.next();
                comment = keyValue.getComment();
                value = keyValue.getValue();
                if (comment != null) {
                    writer.write(comment);
                    if (!comment.endsWith("\n")) {
                        writer.write("\n");
                    }
                }
                writer.write(absoluteName + key + " = " + value + "\n");
            }
        }
        itr = this.getChildRegistryEntryIterator();
        RegistryEntry childEntry = null;
        while (itr.hasNext()) {
            childEntry = (RegistryEntry)itr.next();
            childEntry.writeEntry(writer, absoluteName);
        }
    }
}

