/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.lib.registry;

import com.urbancode.lib.registry.RegistryEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;

public class RegistryEntryMap {
    private static Category log = Category.getInstance((String)(class$com$urbancode$lib$registry$RegistryEntryMap == null ? (class$com$urbancode$lib$registry$RegistryEntryMap = RegistryEntryMap.class$("com.urbancode.lib.registry.RegistryEntryMap")) : class$com$urbancode$lib$registry$RegistryEntryMap).getName());
    protected Map name2entryArray = new HashMap();
    protected Map codedName2entry = new HashMap();
    protected List regEntryList = new ArrayList();
    static /* synthetic */ Class class$com$urbancode$lib$registry$RegistryEntryMap;

    protected RegistryEntryMap() {
    }

    public void addEntry(RegistryEntry entry) {
        if (entry == null) {
            throw new NullPointerException("Entry cannot be null.");
        }
        String key = entry.getName();
        ArrayList<RegistryEntry> entryList = new ArrayList<RegistryEntry>();
        if (this.name2entryArray.containsKey(key)) {
            RegistryEntry firstEntry;
            List oldEntryList = (List)this.name2entryArray.get(key);
            if (oldEntryList.size() == 1 && (firstEntry = (RegistryEntry)oldEntryList.get(0)).getCodedName().indexOf(36) == -1) {
                String codedName = this.generateCodedName(firstEntry.getName(), 1);
                firstEntry.setCodedName(codedName);
                this.codedName2entry.remove(firstEntry.getName());
                this.codedName2entry.put(codedName, firstEntry);
            }
            if (entry.getCodedName().indexOf(36) == -1) {
                entry.setCodedName(this.generateCodedName(entry.getName(), oldEntryList.size() + 1));
            }
            entryList.addAll(oldEntryList);
            entryList.add(entry);
        } else {
            entryList.add(entry);
        }
        this.name2entryArray.put(key, entryList);
        String codedName = entry.getCodedName();
        if (!this.codedName2entry.containsKey(codedName)) {
            this.regEntryList.add(entry);
        }
        this.codedName2entry.put(codedName, entry);
    }

    public RegistryEntry getEntryForCodedName(String codedName) {
        if (codedName == null) {
            throw new NullPointerException("CodedName cannot be null.");
        }
        return (RegistryEntry)this.codedName2entry.get(codedName);
    }

    public RegistryEntry getEntry(String name) {
        if (name == null) {
            throw new NullPointerException("Name cannot be null.");
        }
        RegistryEntry entry = null;
        List entryList = null;
        if (this.name2entryArray.containsKey(name) && (entryList = (List)this.name2entryArray.get(name)).size() > 0) {
            entry = (RegistryEntry)entryList.get(0);
        }
        return entry;
    }

    public Iterator getEntries(String name) {
        if (name == null) {
            throw new NullPointerException("Name cannot be null.");
        }
        List entryList = null;
        entryList = this.name2entryArray.containsKey(name) ? (List)this.name2entryArray.get(name) : new ArrayList();
        return entryList.iterator();
    }

    public Iterator getEntryIterator() {
        return this.regEntryList.iterator();
    }

    public void removeAllEntries() {
        this.name2entryArray.clear();
        this.codedName2entry.clear();
        this.regEntryList.clear();
    }

    public void removeEntry(RegistryEntry entry) {
        if (entry == null) {
            throw new NullPointerException("Entry cannot be null.");
        }
        this.codedName2entry.remove(entry.getCodedName());
        this.regEntryList.remove(entry);
        String key = entry.getName();
        List entryList = new ArrayList();
        if (this.name2entryArray.containsKey(key)) {
            entryList = (List)this.name2entryArray.get(key);
            entryList.remove(entry);
        }
    }

    private String generateCodedName(String entryName, int index) {
        String codedName = null;
        do {
            codedName = entryName + "$" + index;
            ++index;
        } while (this.codedName2entry.get(codedName) != null);
        return codedName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

