/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.lib.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RegistryKeyMap {
    protected Map keyvalues = new HashMap();
    protected List keyList = new ArrayList();

    protected RegistryKeyMap() {
    }

    public void addKeyValue(String key, Object value) {
        if (key == null) {
            throw new NullPointerException("Key key cannot be null.");
        }
        if (value == null) {
            value = "";
        }
        Object[] values = null;
        if (this.keyvalues.containsKey(key)) {
            Object[] oldValues = (Object[])this.keyvalues.get(key);
            values = new Object[oldValues.length + 1];
            System.arraycopy(oldValues, 0, values, 0, oldValues.length);
            values[oldValues.length] = value;
        } else {
            values = new Object[]{value};
            this.keyList.add(key);
        }
        this.keyvalues.put(key, values);
    }

    public void setKeyValue(String key, Object value) {
        if (key == null) {
            throw new NullPointerException("Key key cannot be null.");
        }
        if (value == null) {
            value = "";
        }
        Object[] values = null;
        values = new Object[]{value};
        if (!this.keyvalues.containsKey(key)) {
            this.keyList.add(key);
        }
        this.keyvalues.put(key, values);
    }

    public Object getKeyValue(String key) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null.");
        }
        if (this.keyvalues.containsKey(key)) {
            return ((Object[])this.keyvalues.get(key))[0];
        }
        return null;
    }

    public Iterator getKeyValues(String key) {
        if (key == null) {
            throw new NullPointerException("Attribute key cannot be null.");
        }
        Iterator<Object> itr = null;
        if (this.keyvalues.containsKey(key)) {
            Object[] temp = (Object[])this.keyvalues.get(key);
            itr = Arrays.asList(temp).iterator();
        }
        return itr;
    }

    public Iterator getKeys() {
        return this.keyList.iterator();
    }

    public void removeAllKeyValues() {
        this.keyvalues.clear();
        this.keyList.clear();
    }

    public void removeKeyValue(String key) {
        if (key == null) {
            throw new NullPointerException("Attribute key cannot be null.");
        }
        this.keyvalues.remove(key);
        this.keyList.remove(key);
    }
}

