/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.lib.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Category;

public abstract class ObjectPool {
    protected static Category log = Category.getInstance((String)(class$com$urbancode$lib$util$ObjectPool == null ? (class$com$urbancode$lib$util$ObjectPool = ObjectPool.class$("com.urbancode.lib.util.ObjectPool")) : class$com$urbancode$lib$util$ObjectPool).getName());
    public static final int NOLIMIT = -1;
    private static String className = (class$com$urbancode$lib$util$ObjectPool == null ? (class$com$urbancode$lib$util$ObjectPool = ObjectPool.class$("com.urbancode.lib.util.ObjectPool")) : class$com$urbancode$lib$util$ObjectPool).getName();
    private static int MIN_OBJECT_COUNT = Integer.getInteger(className + ".MIN_OBJECT_COUNT", 1);
    private static int MAX_OBJECT_COUNT = Integer.getInteger(className + ".MAX_OBJECT_COUNT", -1);
    private static int EXPIRATION_TIME = Integer.getInteger(className + ".EXPIRATION_TIME", 300);
    private static int CLEAN_UP_INTERVAL = Integer.getInteger(className + ".CLEAN_UP_INTERVAL", 300);
    private List ciObjectList = new ArrayList();
    private Set coObjectSet = new HashSet();
    private int objectCount = 0;
    private int minObjectCount = MIN_OBJECT_COUNT;
    private int maxObjectCount = MAX_OBJECT_COUNT;
    private long expirationTime = EXPIRATION_TIME;
    private long cleanUpInterval = CLEAN_UP_INTERVAL;
    private boolean initialized = false;
    private boolean isShutdown = false;
    static /* synthetic */ Class class$com$urbancode$lib$util$ObjectPool;

    public ObjectPool() {
    }

    public ObjectPool(int minObjectCount, int maxObjectCount, int cleanUpInterval, int expirationTime) {
        if (minObjectCount >= 0) {
            this.minObjectCount = minObjectCount;
        }
        if (maxObjectCount != 0) {
            this.maxObjectCount = maxObjectCount;
        }
        if (cleanUpInterval > 0) {
            this.cleanUpInterval = cleanUpInterval;
        }
        if (expirationTime > 0) {
            this.expirationTime = expirationTime;
        }
        this.start();
    }

    public void initialize(int minObjectCount, int maxObjectCount, int cleanUpInterval, int expirationTime) {
        if (this.initialized) {
            throw new IllegalStateException("The ObjectPool has already been initialized.");
        }
        if (minObjectCount >= 0) {
            this.minObjectCount = minObjectCount;
        }
        if (maxObjectCount != 0) {
            this.maxObjectCount = maxObjectCount;
        }
        if (cleanUpInterval > 0) {
            this.cleanUpInterval = cleanUpInterval;
        }
        if (expirationTime > 0) {
            this.expirationTime = expirationTime;
        }
        this.start();
    }

    protected synchronized void start() {
        if (this.initialized) {
            throw new IllegalStateException("The ObjectPool has already been initialized.");
        }
        Object o = null;
        Saddle s = null;
        int i = 0;
        while (i < this.minObjectCount) {
            o = this.myGetNewInstance();
            s = new Saddle(o);
            this.ciObjectList.add(s);
            ++i;
        }
        CleanUpThread cleaner = new CleanUpThread();
        cleaner.start();
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public int getMinObjectCount() {
        if (!this.initialized) {
            throw new IllegalStateException("The ObjectPool has not been initialized.");
        }
        return this.minObjectCount;
    }

    public int getMaxObjectCount() {
        if (!this.initialized) {
            throw new IllegalStateException("The ObjectPool has not been initialized.");
        }
        return this.maxObjectCount;
    }

    public int getObjectCount() {
        if (!this.initialized) {
            throw new IllegalStateException("The ObjectPool has not been initialized.");
        }
        return this.objectCount;
    }

    public int getCheckedOutObjectCount() {
        if (!this.initialized) {
            throw new IllegalStateException("The ObjectPool has not been initialized.");
        }
        return this.coObjectSet.size();
    }

    public int getAvailableObjectCount() {
        if (!this.initialized) {
            throw new IllegalStateException("The ObjectPool has not been initialized.");
        }
        return this.ciObjectList.size();
    }

    public boolean isAtMaxSize() {
        if (!this.initialized) {
            throw new IllegalStateException("The ObjectPool has not been initialized.");
        }
        if (this.maxObjectCount == -1) {
            return false;
        }
        return this.objectCount >= this.maxObjectCount;
    }

    public int getCleanUpInterval() {
        if (!this.initialized) {
            throw new IllegalStateException("The ObjectPool has not been initialized.");
        }
        return (int)(this.cleanUpInterval / 1000L);
    }

    public int getExpirationTime() {
        if (!this.initialized) {
            throw new IllegalStateException("The ObjectPool has not been initialized.");
        }
        return (int)(this.expirationTime / 1000L);
    }

    public synchronized void shutdown() {
        if (!this.initialized) {
            throw new IllegalStateException("The ObjectPool has not been initialized.");
        }
        if (this.isShutdown) {
            throw new IllegalStateException("The ObjectPool has been shutdown.");
        }
        this.isShutdown = true;
        Object o = null;
        while (!this.ciObjectList.isEmpty()) {
            o = this.ciObjectList.remove(0);
            try {
                this.myExpire(o);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.notify();
    }

    public boolean isShutdown() {
        if (!this.initialized) {
            throw new IllegalStateException("The ObjectPool has not been initialized.");
        }
        return this.isShutdown;
    }

    public synchronized Object checkOut() {
        if (!this.initialized) {
            throw new IllegalStateException("The ObjectPool has not been initialized.");
        }
        if (this.isShutdown) {
            throw new IllegalStateException("The ObjectPool has been shutdown.");
        }
        Saddle saddle = null;
        Object o = null;
        log.debug((Object)("ObjectPool: " + this));
        while (this.ciObjectList.isEmpty() && this.isAtMaxSize() && !this.isShutdown) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                break;
            }
        }
        if (this.isShutdown) {
            throw new IllegalStateException("The ObjectPool has been shutdown.");
        }
        if (!this.ciObjectList.isEmpty() && !this.myIsObjectValid(o = (saddle = (Saddle)this.ciObjectList.remove(0)).getRider())) {
            this.myExpire(o);
            o = null;
        }
        if (o == null && !this.isAtMaxSize() && !this.isShutdown) {
            o = this.myGetNewInstance();
        }
        if (o != null) {
            this.coObjectSet.add(o);
        }
        return o;
    }

    public synchronized void checkIn(Object o) {
        if (!this.initialized) {
            throw new IllegalStateException("The ObjectPool has not been initialized.");
        }
        if (!this.coObjectSet.contains(o)) {
            throw new IllegalArgumentException("The specified object does not belong to this ObjectPool.");
        }
        if (!this.isShutdown) {
            Saddle s = new Saddle(o);
            this.coObjectSet.remove(o);
            this.ciObjectList.add(s);
            this.notifyAll();
        } else {
            try {
                this.myExpire(o);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected synchronized void cleanUp() {
        long now = System.currentTimeMillis();
        int index = 0;
        while (index < this.ciObjectList.size()) {
            Saddle saddle = (Saddle)this.ciObjectList.get(index);
            if (now - saddle.getCreationTime() >= this.expirationTime * 1000L) {
                try {
                    this.myExpire(saddle.getRider());
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                this.ciObjectList.remove(index);
                saddle = null;
                continue;
            }
            ++index;
        }
        System.gc();
        this.notifyAll();
    }

    protected void waitForObject() throws InterruptedException {
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            this.wait();
        }
    }

    protected void notifyOfObject() {
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            this.notifyAll();
        }
    }

    protected final void myExpire(Object o) {
        --this.objectCount;
        try {
            this.expire(o);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void expire(Object o) throws Exception {
    }

    protected final Object myGetNewInstance() {
        Object o = this.getNewInstance();
        if (o != null) {
            ++this.objectCount;
        }
        return o;
    }

    protected abstract Object getNewInstance();

    protected final boolean myIsObjectValid(Object o) {
        boolean valid = false;
        try {
            valid = this.isObjectValid(o);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return valid;
    }

    protected boolean isObjectValid(Object o) throws Exception {
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ObjectPool: isInitialized=").append(this.initialized);
        sb.append(", isShutdown=").append(this.isShutdown);
        sb.append(", minObjCount=").append(this.minObjectCount);
        sb.append(", maxObjectCount=").append(this.maxObjectCount);
        sb.append(", objectCount=").append(this.objectCount);
        sb.append(", checkedOutCount=").append(this.coObjectSet.size());
        sb.append(", checkedInCount=").append(this.ciObjectList.size());
        sb.append(", objectCount=").append(this.objectCount);
        sb.append(", expirationTime=").append(this.expirationTime);
        sb.append(", cleanUpInterval=").append(this.cleanUpInterval);
        sb.append("]");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ReturnThread
    extends Thread {
        List objList = new ArrayList();

        ReturnThread() {
            this.setDaemon(true);
        }

        void addObject(Object o) {
            this.objList.add(o);
        }

        public void run() {
            Object o = this.objList.get(0);
            if (!ObjectPool.this.isShutdown()) {
                Saddle s = new Saddle(o);
                ObjectPool.this.coObjectSet.remove(o);
                ObjectPool.this.ciObjectList.add(s);
                this.notifyAll();
            } else {
                try {
                    ObjectPool.this.myExpire(o);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    class CleanUpThread
    extends Thread {
        CleanUpThread() {
            this.setPriority(1);
            this.setDaemon(true);
        }

        public void run() {
            while (!ObjectPool.this.isShutdown()) {
                try {
                    Thread.sleep(ObjectPool.this.cleanUpInterval * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ObjectPool.this.cleanUp();
            }
        }
    }

    class Saddle {
        private Object rider;
        private long creationTime;

        Saddle(Object rider) {
            this.rider = rider;
            this.creationTime = System.currentTimeMillis();
        }

        Object getRider() {
            return this.rider;
        }

        long getCreationTime() {
            return this.creationTime;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Saddle)) {
                return false;
            }
            Saddle s = (Saddle)o;
            return this.rider.equals(s.rider);
        }
    }
}

