/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.lib.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import sun.misc.BASE64Encoder;

public class UniqueIDGenerator {
    public static final int ID_LENGTH = 20;
    private static final String PAD_CHARS = "0123456789abcdefghijklmnopqrstuvwxyz";
    private static long nextID;
    private static Random random;
    private static BASE64Encoder encoder;
    private static MessageDigest messageDigest;

    public static String getNextID() {
        return UniqueIDGenerator.getNextID(20);
    }

    public static synchronized String getNextID(int length) {
        String ID = String.valueOf(nextID);
        int numPads = length - ID.length();
        if (numPads > 0) {
            char[] pads = new char[numPads];
            int i = 0;
            while (i < pads.length) {
                pads[i] = PAD_CHARS.charAt((int)(random.nextFloat() * (float)PAD_CHARS.length()));
                ++i;
            }
            ID = new String(pads) + ID;
        } else {
            ID = ID.substring(-numPads);
        }
        nextID += (long)((int)(Math.random() * ((double)random.nextFloat() * 10.0)));
        return encoder.encode(ID.getBytes());
    }

    public static String getNextSecureID(String key) throws NoSuchAlgorithmException {
        return UniqueIDGenerator.getNextSecureID(20, key);
    }

    public static String getNextSecureID(int idLength, String key) throws NoSuchAlgorithmException {
        if (messageDigest == null) {
            throw new NoSuchAlgorithmException("MD5 algorithm not found");
        }
        byte[] digest = messageDigest.digest(UniqueIDGenerator.getNextID(idLength).getBytes());
        digest = messageDigest.digest(new String(new String(digest) + key).getBytes());
        return new String(digest);
    }

    public static String getNextPrintableSecureID(String key) throws NoSuchAlgorithmException {
        String ID = UniqueIDGenerator.getNextSecureID(key);
        return encoder.encode(ID.getBytes());
    }

    static {
        random = new Random(System.currentTimeMillis());
        encoder = new BASE64Encoder();
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        nextID = (long)((double)random.nextFloat() * 10000.0);
    }
}

