/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.execute;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.execute.ExecuteInputStreamHandler;
import org.apache.commons.execute.ExecuteOutputStreamHandler;
import org.apache.commons.execute.ExecuteStreamHandler;

public class CompositeStreamHandler
implements ExecuteStreamHandler {
    private ExecuteOutputStreamHandler outHandler = null;
    private ExecuteOutputStreamHandler errHandler = null;
    private ExecuteInputStreamHandler inHandler = null;

    public CompositeStreamHandler(ExecuteOutputStreamHandler outHandler, ExecuteOutputStreamHandler errHandler, ExecuteInputStreamHandler inHandler) {
        this.outHandler = outHandler;
        this.errHandler = errHandler;
        this.inHandler = inHandler;
    }

    public void setProcessOutputStream(InputStream inputStream) throws IOException {
        if (this.outHandler != null) {
            this.outHandler.setOutputStream(inputStream);
        }
    }

    public void setProcessErrorStream(InputStream inputStream) throws IOException {
        if (this.errHandler != null) {
            this.errHandler.setOutputStream(inputStream);
        }
    }

    public void setProcessInputStream(OutputStream outputStream) throws IOException {
        if (this.inHandler != null) {
            this.inHandler.setInputStream(outputStream);
        }
    }

    public void start() throws IOException {
        if (this.errHandler != null) {
            this.errHandler.start();
        }
        if (this.outHandler != null) {
            this.outHandler.start();
        }
        if (this.inHandler != null) {
            this.inHandler.start();
        }
    }

    public void stop() {
        if (this.errHandler != null) {
            this.errHandler.stop();
        }
        if (this.inHandler != null) {
            this.inHandler.stop();
        }
        if (this.outHandler != null) {
            this.outHandler.stop();
        }
    }
}

