/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.execute;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import org.apache.commons.execute.Commandline;
import org.apache.commons.execute.ExecuteException;
import org.apache.commons.execute.ExecuteStreamHandler;
import org.apache.commons.execute.ExecuteWatchdog;
import org.apache.commons.execute.LogStreamHandler;
import org.apache.commons.execute.Os;
import org.apache.commons.execute.ProcessDestroyer;
import org.apache.commons.execute.ProcessThreadRegistry;
import org.apache.commons.execute.PumpStreamHandler;
import org.apache.commons.execute.VariableExpander;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Execute
implements Cloneable {
    public static final int INVALID = Integer.MAX_VALUE;
    private static String userDirectory = System.getProperty("user.dir");
    private static String executeHome = System.getProperty("org.apache.commons.execute.home");
    private static File executeHomeDir = null;
    private static CommandLauncher vmLauncher = null;
    private static CommandLauncher shellLauncher = null;
    private static Vector procEnvironment = null;
    private static ProcessDestroyer processDestroyer = new ProcessDestroyer();
    private String[] cmdl = null;
    private String[] env = null;
    private int exitValue = Integer.MAX_VALUE;
    private ExecuteStreamHandler streamHandler;
    private ExecuteWatchdog watchdog;
    private File workingDirectory = null;
    private boolean newEnvironment = false;
    private boolean waitFor = true;
    private Logger log = null;
    private VariableExpander.Callback varHandler = null;
    private Process process = null;
    private boolean useVMLauncher = true;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$Runtime;

    public static void runCommand(Logger log, String[] cmdline) throws ExecuteException {
        try {
            log.debug((Object)Commandline.describeCommand(cmdline));
            Execute exe = new Execute(new LogStreamHandler(log, Priority.INFO, Priority.ERROR));
            exe.setLogger(log);
            exe.setCommandline(cmdline);
            int retval = exe.execute();
            if (retval != 0) {
                throw new ExecuteException(cmdline[0] + " failed with return code " + retval);
            }
        }
        catch (IOException exc) {
            throw new ExecuteException("Could not launch " + cmdline[0] + ": " + exc);
        }
    }

    public static synchronized Vector getProcEnvironment() throws ExecuteException, IOException {
        if (procEnvironment != null) {
            return procEnvironment;
        }
        procEnvironment = new Vector();
        try {
            String line;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Execute exe = new Execute(new PumpStreamHandler(out));
            exe.setCommandline(Execute.getProcEnvCommand());
            exe.setNewenvironment(true);
            int retval = exe.execute();
            if (retval != 0) {
                // empty if block
            }
            BufferedReader in = new BufferedReader(new StringReader(Execute.toString(out)));
            String var = null;
            String lineSep = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                if (line.indexOf(61) == -1) {
                    if (var == null) {
                        var = lineSep + line;
                        continue;
                    }
                    var = var + lineSep + line;
                    continue;
                }
                if (var != null) {
                    procEnvironment.addElement(var);
                }
                var = line;
            }
            if (var != null) {
                procEnvironment.addElement(var);
            }
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        return procEnvironment;
    }

    protected static String[] getProcEnvCommand() {
        if (Os.isFamily("os/2")) {
            String[] cmd = new String[]{"cmd", "/c", "set"};
            return cmd;
        }
        if (Os.isFamily("windows")) {
            if (!Os.isFamily("win9x")) {
                String[] cmd = new String[]{"cmd", "/c", "set"};
                return cmd;
            }
            String[] cmd = new String[]{"command.com", "/c", "set"};
            return cmd;
        }
        if (Os.isFamily("z/os")) {
            String[] cmd = new String[]{"/bin/env"};
            return cmd;
        }
        if (Os.isFamily("unix")) {
            String[] cmd = new String[]{"/usr/bin/env"};
            return cmd;
        }
        if (Os.isFamily("netware")) {
            String[] cmd = new String[]{"env"};
            return cmd;
        }
        String[] cmd = null;
        return cmd;
    }

    public static String toString(ByteArrayOutputStream bos) {
        if (Os.isFamily("z/os")) {
            try {
                return bos.toString("Cp1047");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return bos.toString();
    }

    public Execute() {
        this(new PumpStreamHandler(), null);
    }

    public Execute(ExecuteStreamHandler streamHandler) {
        this(streamHandler, null);
    }

    public Execute(ExecuteStreamHandler streamHandler, ExecuteWatchdog watchdog) {
        this.streamHandler = streamHandler;
        this.watchdog = watchdog;
    }

    public String[] getCommandline() {
        return this.cmdl;
    }

    public void setCommandline(String[] commandline) {
        this.cmdl = commandline;
    }

    public void setCommandline(Commandline commandline) {
        this.cmdl = commandline.getCommandline();
    }

    public void setNewenvironment(boolean newenv) {
        this.newEnvironment = newenv;
    }

    public String[] getEnvironment() throws ExecuteException, IOException {
        if (this.env == null || this.newEnvironment) {
            return this.env;
        }
        return this.patchEnvironment();
    }

    public void setEnvironment(String[] env) {
        this.env = env;
    }

    public void setWaitFor(boolean wait) {
        this.waitFor = wait;
    }

    public void setWorkingDirectory(File wd) {
        this.workingDirectory = wd == null || wd.getAbsolutePath().equals(userDirectory) ? null : wd;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setVariableExpanderCallback(VariableExpander.Callback varHandler) {
        this.varHandler = varHandler;
    }

    public void setVMLauncher(boolean useVMLauncher) {
        this.useVMLauncher = useVMLauncher;
    }

    public void setLogger(Logger log) {
        this.log = log;
    }

    public void setWatchDog(ExecuteWatchdog watchdog) {
        this.watchdog = watchdog;
    }

    public int execute() throws ExecuteException, IOException {
        CommandLauncher launcher;
        CommandLauncher commandLauncher = launcher = vmLauncher != null ? vmLauncher : shellLauncher;
        if (!this.useVMLauncher) {
            launcher = shellLauncher;
        }
        this.exitValue = Integer.MAX_VALUE;
        this.process = launcher.exec(this);
        ProcessThreadRegistry.getInstance().registerProcessWithThread(Thread.currentThread(), this.process);
        try {
            this.streamHandler.setProcessInputStream(this.process.getOutputStream());
            this.streamHandler.setProcessOutputStream(this.process.getInputStream());
            this.streamHandler.setProcessErrorStream(this.process.getErrorStream());
        }
        catch (IOException e) {
            this.process.destroy();
            throw e;
        }
        this.streamHandler.start();
        processDestroyer.add(this.process);
        if (this.watchdog != null) {
            this.watchdog.start(this.process);
        }
        this.waitFor(this.process);
        processDestroyer.remove(this.process);
        ProcessThreadRegistry.getInstance().unregisterProcessFromThread(Thread.currentThread(), this.process);
        if (this.watchdog != null) {
            this.watchdog.stop();
        }
        this.streamHandler.stop();
        if (this.watchdog != null) {
            this.watchdog.checkException();
        }
        int exitValue = this.getExitValue();
        return exitValue;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public void killProcess() throws ExecuteException {
        try {
            try {
                this.process.exitValue();
            }
            catch (IllegalThreadStateException itse) {
                this.process.destroy();
            }
        }
        catch (Exception e) {
            throw new ExecuteException(e.getMessage(), e);
        }
    }

    public boolean killedProcess() {
        return this.watchdog != null && this.watchdog.killedProcess();
    }

    public Object clone() {
        Execute copy = null;
        try {
            copy = (Execute)super.clone();
            copy.cmdl = (String[])this.cmdl.clone();
            copy.env = (String[])this.env.clone();
            copy.streamHandler = this.streamHandler;
            copy.watchdog = this.watchdog;
            copy.workingDirectory = this.workingDirectory;
            copy.newEnvironment = this.newEnvironment;
            copy.waitFor = this.waitFor;
            copy.log = this.log;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return copy;
    }

    protected void waitFor(Process process) {
        if (this.waitFor) {
            try {
                process.waitFor();
                this.setExitValue(process.exitValue());
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.setExitValue(0);
        }
    }

    protected void setExitValue(int value) {
        this.exitValue = value;
    }

    private String[] patchEnvironment() throws ExecuteException, IOException {
        final Vector osEnv = (Vector)Execute.getProcEnvironment().clone();
        VariableExpander.Callback handler = this.varHandler;
        if (handler == null) {
            handler = new VariableExpander.Callback(){

                public String getVariableValue(String name) {
                    String varName = name;
                    if (name.startsWith("env.")) {
                        varName = name.substring(4);
                    }
                    String entry = null;
                    String value = null;
                    int size = osEnv.size();
                    for (int i = 0; i < size; ++i) {
                        entry = (String)osEnv.elementAt(i);
                        if (!entry.startsWith(varName)) continue;
                        value = entry.substring(entry.indexOf(61) + 1);
                        break;
                    }
                    return value;
                }
            };
        }
        VariableExpander parser = new VariableExpander(handler);
        String[] localEnvVars = parser.parse(this.env);
        if (this.log != null) {
            this.log.info((Object)"Explicity set environment variables:");
        }
        for (int i = 0; i < localEnvVars.length; ++i) {
            int pos = localEnvVars[i].indexOf(61);
            String key = localEnvVars[i].substring(0, pos + 1);
            String value = localEnvVars[i].substring(pos + 1);
            if (this.log != null) {
                this.log.info((Object)localEnvVars[i]);
            }
            int size = osEnv.size();
            for (int j = 0; j < size; ++j) {
                if (!((String)osEnv.elementAt(j)).startsWith(key)) continue;
                osEnv.removeElementAt(j);
                break;
            }
            osEnv.addElement(localEnvVars[i]);
        }
        Object[] result = new String[osEnv.size()];
        osEnv.copyInto(result);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            vmLauncher = new Java13CommandLauncher();
        }
        catch (NoSuchMethodException exc) {
            // empty catch block
        }
        if (Os.isFamily("mac")) {
            shellLauncher = new MacCommandLauncher(new CommandLauncher());
        } else if (Os.isFamily("os/2")) {
            shellLauncher = new WinNTCommandLauncher(new CommandLauncher());
        } else if (Os.isFamily("windows")) {
            CommandLauncher baseLauncher = System.getProperty("java.version").startsWith("1.1") ? new Java11CommandLauncher() : new CommandLauncher();
            shellLauncher = !Os.isFamily("win9x") ? new WinNTCommandLauncher(baseLauncher) : new ScriptCommandLauncher("bin/antRun.bat", baseLauncher);
        } else if (Os.isFamily("netware")) {
            CommandLauncher baseLauncher = System.getProperty("java.version").startsWith("1.1") ? new Java11CommandLauncher() : new CommandLauncher();
            shellLauncher = new PerlScriptCommandLauncher("bin/run.pl", baseLauncher);
        } else {
            shellLauncher = new ScriptCommandLauncher("bin/antRun", new CommandLauncher());
        }
        if (executeHome != null) {
            executeHomeDir = new File(executeHome);
        }
    }

    private static class PerlScriptCommandLauncher
    extends CommandLauncherProxy {
        private String _script;

        PerlScriptCommandLauncher(String script, CommandLauncher launcher) {
            super(launcher);
            this._script = script;
        }

        public Process exec(Execute exec) throws ExecuteException, IOException {
            Logger log = exec.log;
            String[] cmd = exec.getCommandline();
            String[] env = exec.getEnvironment();
            File workingDir = exec.getWorkingDirectory();
            if (executeHome == null) {
                if (workingDir == null) {
                    return this._launcher.exec(exec);
                }
                throw new IOException("Cannot locate run script: System Property 'EXECUTE_HOME' not found");
            }
            if (executeHome == null) {
                throw new IOException("Cannot locate run script: System Property 'EXECUTE_HOME' not found");
            }
            File runFile = new File(executeHomeDir, this._script);
            String run = runFile.getAbsolutePath();
            File commandDir = workingDir;
            if (workingDir == null && executeHome != null) {
                commandDir = executeHomeDir;
            }
            String[] newcmd = new String[cmd.length + 3];
            newcmd[0] = "perl";
            newcmd[1] = run;
            newcmd[2] = commandDir.getAbsolutePath();
            System.arraycopy(cmd, 0, newcmd, 3, cmd.length);
            Execute execCopy = (Execute)exec.clone();
            execCopy.setCommandline(newcmd);
            return this._launcher.exec(execCopy);
        }
    }

    private static class ScriptCommandLauncher
    extends CommandLauncherProxy {
        private String _script;

        ScriptCommandLauncher(String script, CommandLauncher launcher) {
            super(launcher);
            this._script = script;
        }

        public Process exec(Execute exec) throws ExecuteException, IOException {
            Logger log = exec.log;
            String[] cmd = exec.getCommandline();
            String[] env = exec.getEnvironment();
            File workingDir = exec.getWorkingDirectory();
            if (executeHome == null) {
                if (workingDir == null) {
                    return this._launcher.exec(exec);
                }
                throw new IOException("Cannot locate run script: EXECUTE_HOME System property not set.");
            }
            if (executeHome == null) {
                throw new IOException("Cannot locate run script: System Property 'EXECUTE_HOME' not found");
            }
            File runFile = new File(executeHomeDir, this._script);
            String run = runFile.getAbsolutePath();
            File commandDir = workingDir;
            if (workingDir == null && executeHome != null) {
                commandDir = executeHomeDir;
            }
            String[] newcmd = new String[cmd.length + 2];
            newcmd[0] = run;
            newcmd[1] = commandDir.getAbsolutePath();
            System.arraycopy(cmd, 0, newcmd, 2, cmd.length);
            Execute execCopy = (Execute)exec.clone();
            execCopy.setCommandline(newcmd);
            return this._launcher.exec(execCopy);
        }
    }

    private static class MacCommandLauncher
    extends CommandLauncherProxy {
        MacCommandLauncher(CommandLauncher launcher) {
            super(launcher);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Process exec(Execute exec) throws ExecuteException, IOException {
            Logger log = exec.log;
            String[] cmd = exec.getCommandline();
            String[] env = exec.getEnvironment();
            File workingDir = exec.getWorkingDirectory();
            if (workingDir == null) {
                return this._launcher.exec(exec);
            }
            System.getProperties().put("user.dir", workingDir.getAbsolutePath());
            try {
                Process process = this._launcher.exec(exec);
                return process;
            }
            finally {
                System.getProperties().put("user.dir", userDirectory);
            }
        }
    }

    private static class WinNTCommandLauncher
    extends CommandLauncherProxy {
        WinNTCommandLauncher(CommandLauncher launcher) {
            super(launcher);
        }

        public Process exec(Execute exec) throws ExecuteException, IOException {
            File workingDir;
            Logger log = exec.log;
            String[] cmd = exec.getCommandline();
            String[] env = exec.getEnvironment();
            File commandDir = workingDir = exec.getWorkingDirectory();
            if (workingDir == null) {
                return this._launcher.exec(exec);
            }
            int preCmdLength = 6;
            String[] newcmd = new String[cmd.length + 6];
            newcmd[0] = "cmd";
            newcmd[1] = "/c";
            newcmd[2] = "cd";
            newcmd[3] = "/d";
            newcmd[4] = commandDir.getAbsolutePath();
            newcmd[5] = "&&";
            System.arraycopy(cmd, 0, newcmd, 6, cmd.length);
            Execute execCopy = (Execute)exec.clone();
            execCopy.setCommandline(newcmd);
            return this._launcher.exec(execCopy);
        }
    }

    private static class CommandLauncherProxy
    extends CommandLauncher {
        protected CommandLauncher _launcher;

        CommandLauncherProxy(CommandLauncher launcher) {
            this._launcher = launcher;
        }

        public Process exec(Execute exec) throws ExecuteException, IOException {
            return this._launcher.exec(exec);
        }
    }

    private static class Java13CommandLauncher
    extends CommandLauncher {
        private Method _execWithCWD = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = Execute.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("exec", array$Ljava$lang$String == null ? (array$Ljava$lang$String = Execute.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, array$Ljava$lang$String == null ? (array$Ljava$lang$String = Execute.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, class$java$io$File == null ? (class$java$io$File = Execute.class$("java.io.File")) : class$java$io$File);

        public Process exec(Execute exec) throws ExecuteException, IOException {
            Logger log = exec.log;
            String[] cmd = exec.getCommandline();
            String[] env = exec.getEnvironment();
            File workingDir = exec.getWorkingDirectory();
            Process process = null;
            try {
                if (log != null) {
                    StringBuffer buf = new StringBuffer();
                    if (env != null && env.length > 0) {
                        for (int i = 0; i < env.length; ++i) {
                            buf.append("\n" + env[i]);
                        }
                    } else {
                        buf.append("none");
                    }
                    String workingDirName = "none";
                    if (workingDir != null) {
                        workingDirName = workingDir.getAbsolutePath();
                    }
                    log.info((Object)("Execute:Java13CommandLauncher: " + Commandline.describeCommand(cmd) + "\nWorkingDir: " + workingDirName + "\n"));
                    log.debug((Object)("\nEnvironment Variables: " + buf.toString()));
                }
                Object[] arguments = new Object[]{cmd, env, workingDir};
                process = (Process)this._execWithCWD.invoke((Object)Runtime.getRuntime(), arguments);
            }
            catch (InvocationTargetException exc) {
                Throwable realexc = exc.getTargetException();
                if (realexc instanceof ThreadDeath) {
                    throw (ThreadDeath)realexc;
                }
                if (realexc instanceof IOException) {
                    throw (IOException)realexc;
                }
                throw new ExecuteException("Unable to execute command", realexc);
            }
            catch (Exception exc) {
                throw new ExecuteException("Unable to execute command", exc);
            }
            return process;
        }
    }

    private static class Java11CommandLauncher
    extends CommandLauncher {
        private Java11CommandLauncher() {
        }

        public Process exec(Execute exec) throws ExecuteException, IOException {
            Logger log = exec.log;
            String[] cmd = exec.getCommandline();
            String[] env = exec.getEnvironment();
            File workingDir = exec.getWorkingDirectory();
            if (workingDir == null) {
                String[] newcmd = new String[cmd.length];
                for (int i = 0; i < cmd.length; ++i) {
                    newcmd[i] = Commandline.quoteArgument(cmd[i]);
                }
                if (log != null) {
                    log.info((Object)("Execute:Java11CommandLauncher: " + Commandline.describeCommand(newcmd)));
                }
                return Runtime.getRuntime().exec(newcmd, env);
            }
            throw new IOException("Cannot execute a process in different directory under this JVM");
        }
    }

    private static class CommandLauncher {
        private CommandLauncher() {
        }

        public Process exec(Execute exec) throws ExecuteException, IOException {
            Logger log = exec.log;
            String[] cmd = exec.getCommandline();
            String[] env = exec.getEnvironment();
            File workingDir = exec.getWorkingDirectory();
            if (workingDir == null) {
                if (log != null) {
                    log.debug((Object)("Execute:CommandLauncher: " + Commandline.describeCommand(cmd)));
                }
                return Runtime.getRuntime().exec(cmd, env);
            }
            throw new IOException("Cannot execute a process in different directory under this JVM");
        }
    }
}

